/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.feature;

import essentialaddons.feature.GameRuleNetworkHandler;
import java.util.function.BiFunction;
import me.senseiwells.essentialclient.EssentialClient;
import me.senseiwells.essentialclient.gui.RulesScreen;
import me.senseiwells.essentialclient.mixins.gameRuleSync.RuleInvoker;
import me.senseiwells.essentialclient.rule.game.GameRule;
import me.senseiwells.essentialclient.rule.game.VanillaGameRules;
import me.senseiwells.essentialclient.utils.EssentialUtils;
import me.senseiwells.essentialclient.utils.interfaces.IGameRule;
import me.senseiwells.essentialclient.utils.misc.Scheduler;
import me.senseiwells.essentialclient.utils.network.NetworkHandler;
import me.senseiwells.essentialclient.utils.render.Texts;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.minecraft.class_1928;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;

public class GameRuleNetworkHandler
extends NetworkHandler {
    public static final int VERSION = 101;
    private boolean canModifyRules = false;
    private final BiFunction<String, Integer, class_8710> helloFactory;
    private final BiFunction<String, String, class_8710> setFactory;

    public GameRuleNetworkHandler() {
        if (EssentialUtils.isModInstalled("essentialaddons")) {
            this.helloFactory = GameRuleNetworkHandler.GameRuleHelloPayload::new;
            this.setFactory = GameRuleNetworkHandler.SetGameRulePayload::new;
        } else {
            this.helloFactory = GameRuleHelloPayload::new;
            this.setFactory = SetGameRulePayload::new;
        }
    }

    public boolean canModifyRules() {
        return this.canModifyRules || EssentialUtils.getClient().method_1542();
    }

    @Override
    public int getVersion() {
        return 101;
    }

    @Override
    protected void onHelloSuccess() {
        EssentialClient.LOGGER.info("Game Rule data is available");
    }

    @Override
    protected void onHelloFail() {
        EssentialClient.LOGGER.info("Could not sync Game Rule data");
    }

    @Override
    public void onDisconnect() {
        VanillaGameRules.getGameRules().forEach(GameRule::reset);
        this.canModifyRules = false;
        super.onDisconnect();
    }

    public void processGamerules(class_2487 compound) {
        if (compound == null) {
            EssentialClient.LOGGER.warn("Received bad Game Rule packet");
            return;
        }
        for (String ruleKey : compound.method_10541()) {
            String ruleValue = compound.method_10558(ruleKey);
            GameRule<?> gameRule = VanillaGameRules.ruleFromString(ruleKey);
            if (gameRule == null) {
                EssentialClient.LOGGER.warn("Game Rule '{}' could not be synced", (Object)ruleKey);
                continue;
            }
            gameRule.setFromServer(ruleValue);
        }
        this.refreshScreen();
    }

    public void sendServerRuleChange(GameRule<?> gameRule, String newValue) {
        class_310 client = EssentialUtils.getClient();
        if (client.method_1576() != null) {
            if (gameRule.getKey() != null) {
                class_1928.class_4315 rule = client.method_1576().method_3767().method_20746(gameRule.getKey());
                ((RuleInvoker)rule).deserialize(newValue);
                ((IGameRule)rule).essentialclient$ruleChanged(gameRule.getName(), (MinecraftServer)client.method_1576());
                gameRule.setFromServer(newValue);
                this.refreshScreen();
            }
            return;
        }
        this.sendPayload(() -> this.setFactory.apply(gameRule.getName(), newValue));
    }

    @Override
    public void registerCustomPayloads() {
        if (!EssentialUtils.isModInstalled("essentialaddons")) {
            PayloadTypeRegistry.playC2S().register(GameRuleHelloPayload.ID, GameRuleHelloPayload.CODEC);
            PayloadTypeRegistry.playC2S().register(SetGameRulePayload.ID, SetGameRulePayload.CODEC);
            PayloadTypeRegistry.playS2C().register(GameRuleHelloPayload.ID, GameRuleHelloPayload.CODEC);
            PayloadTypeRegistry.playS2C().register(GameRulePermissionsPayload.ID, GameRulePermissionsPayload.CODEC);
            PayloadTypeRegistry.playS2C().register(GameRulesChangedPayload.ID, GameRulesChangedPayload.CODEC);
            ClientPlayNetworking.registerGlobalReceiver(GameRuleHelloPayload.ID, (payload, context) -> this.onHello(context.player().field_3944, (NetworkHandler.HelloPayload)payload));
            ClientPlayNetworking.registerGlobalReceiver(GameRulePermissionsPayload.ID, (payload, context) -> {
                this.canModifyRules = payload.canUpdateGamerules;
                this.refreshScreen();
            });
            ClientPlayNetworking.registerGlobalReceiver(GameRulesChangedPayload.ID, (payload, context) -> this.processGamerules(payload.compound));
        } else {
            Scheduler.schedule(0, () -> {
                ClientPlayNetworking.registerGlobalReceiver((class_8710.class_9154)GameRuleNetworkHandler.GameRuleHelloPayload.ID, (payload, context) -> this.onHello(context.player().field_3944, new GameRuleHelloPayload(payload.brand(), payload.version())));
                ClientPlayNetworking.registerGlobalReceiver((class_8710.class_9154)GameRuleNetworkHandler.GameRulePermissionsPayload.ID, (payload, context) -> {
                    this.canModifyRules = payload.canUpdateGamerules();
                    this.refreshScreen();
                });
                ClientPlayNetworking.registerGlobalReceiver((class_8710.class_9154)GameRuleNetworkHandler.GameRulesChangedPayload.ID, (payload, context) -> this.processGamerules(payload.compound()));
            });
        }
    }

    @Override
    protected class_8710 createHelloPayload(String brand, int version) {
        return this.helloFactory.apply(brand, version);
    }

    private void refreshScreen() {
        RulesScreen rulesScreen;
        class_437 class_4372 = EssentialUtils.getClient().field_1755;
        if (class_4372 instanceof RulesScreen && (rulesScreen = (RulesScreen)class_4372).method_25440() == Texts.GAME_RULE_SCREEN) {
            EssentialUtils.getClient().execute(() -> rulesScreen.refreshRules(rulesScreen.getSearchBoxText()));
        }
    }

    private static class GameRuleHelloPayload
    extends NetworkHandler.HelloPayload {
        public static final class_8710.class_9154<GameRuleHelloPayload> ID = new class_8710.class_9154(class_2960.method_60654((String)"essential:game_rule_hello"));
        public static final class_9139<class_2540, GameRuleHelloPayload> CODEC = class_9139.method_56438(NetworkHandler.HelloPayload::write, GameRuleHelloPayload::new);

        public GameRuleHelloPayload(String brand, int version) {
            super(brand, version);
        }

        public GameRuleHelloPayload(class_2540 buf) {
            super(buf);
        }

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return ID;
        }
    }

    private record SetGameRulePayload(String name, String value) implements class_8710
    {
        public static final class_8710.class_9154<SetGameRulePayload> ID = new class_8710.class_9154(class_2960.method_60654((String)"essential:set_game_rule"));
        public static final class_9139<class_2540, SetGameRulePayload> CODEC = class_9139.method_56438((payload, buf) -> buf.method_10814(payload.name).method_10814(payload.value), buf -> new SetGameRulePayload(buf.method_19772(), buf.method_19772()));

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return ID;
        }
    }

    private record GameRulePermissionsPayload(boolean canUpdateGamerules) implements class_8710
    {
        public static final class_8710.class_9154<GameRulePermissionsPayload> ID = new class_8710.class_9154(class_2960.method_60654((String)"essential:game_rule_permissions"));
        public static final class_9139<class_2540, GameRulePermissionsPayload> CODEC = class_9139.method_56438((payload, buf) -> buf.method_52964(payload.canUpdateGamerules), buf -> new GameRulePermissionsPayload(buf.readBoolean()));

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return ID;
        }
    }

    private record GameRulesChangedPayload(class_2487 compound) implements class_8710
    {
        public static final class_8710.class_9154<GameRulesChangedPayload> ID = new class_8710.class_9154(class_2960.method_60654((String)"essential:game_rules_changed"));
        public static final class_9139<class_2540, GameRulesChangedPayload> CODEC = class_9139.method_56438((payload, buf) -> buf.method_10794((class_2520)payload.compound), buf -> new GameRulesChangedPayload(buf.method_10798()));

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return ID;
        }
    }
}

