/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.feature;

import carpet.CarpetExtension;
import carpet.api.settings.CarpetRule;
import carpet.api.settings.SettingsManager;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import me.senseiwells.arucas.utils.NetworkUtils;
import me.senseiwells.essentialclient.EssentialClient;
import me.senseiwells.essentialclient.gui.RulesScreen;
import me.senseiwells.essentialclient.rule.carpet.BooleanCarpetRule;
import me.senseiwells.essentialclient.rule.carpet.CarpetClientRule;
import me.senseiwells.essentialclient.rule.carpet.CycleCarpetRule;
import me.senseiwells.essentialclient.rule.carpet.DoubleCarpetRule;
import me.senseiwells.essentialclient.rule.carpet.IntegerCarpetRule;
import me.senseiwells.essentialclient.rule.carpet.StringCarpetRule;
import me.senseiwells.essentialclient.rule.impl.SimpleRule;
import me.senseiwells.essentialclient.utils.EssentialUtils;
import me.senseiwells.essentialclient.utils.carpet.CarpetUtils;
import me.senseiwells.essentialclient.utils.config.Config;
import me.senseiwells.essentialclient.utils.interfaces.Rule;
import me.senseiwells.essentialclient.utils.misc.Scheduler;
import me.senseiwells.essentialclient.utils.render.Texts;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_437;

public class CarpetClient
implements CarpetExtension,
Config.CList {
    public static final CarpetClient INSTANCE = new CarpetClient();
    private final Map<String, CarpetClientRule<?>> ALL_RULES = new HashMap();
    private final Map<String, CarpetClientRule<?>> CURRENT_RULES = new HashMap();
    private final Set<String> MANAGERS = new HashSet<String>();
    private final String LOADNT;
    private final String DATA_URL;
    private final JsonElement COMMAND = new JsonPrimitive("COMMAND");
    private final AtomicBoolean HANDLING_DATA = new AtomicBoolean(false);
    private boolean isServerCarpet = false;

    private CarpetClient() {
        this.LOADNT = "Could not load rule data";
        this.DATA_URL = "https://raw.githubusercontent.com/Crec0/carpet-rules-database/main/data/parsed_data.json";
    }

    public void onGameStarted() {
        EssentialClient.CONFIG_SET.add(INSTANCE);
        Scheduler.schedule(0, () -> this.readConfig());
    }

    public boolean isServerCarpet() {
        return this.isServerCarpet || EssentialUtils.getClient().method_1542();
    }

    public boolean isCarpetManager(String name) {
        return this.MANAGERS.contains(name);
    }

    public CarpetClientRule<?> getRule(String name) {
        if (this.CURRENT_RULES.isEmpty() && EssentialUtils.getClient().method_1542()) {
            this.loadSinglePlayerRules();
        }
        return this.CURRENT_RULES.get(name);
    }

    public void onDisconnect() {
        this.isServerCarpet = false;
        this.CURRENT_RULES.clear();
        this.MANAGERS.clear();
    }

    public Collection<CarpetClientRule<?>> getCurrentCarpetRules() {
        class_310 client = EssentialUtils.getClient();
        if (client.method_1542()) {
            this.loadSinglePlayerRules();
            return this.CURRENT_RULES.values();
        }
        if (client.method_1558() != null && this.isServerCarpet) {
            return this.CURRENT_RULES.values();
        }
        return this.ALL_RULES.values();
    }

    public void syncCarpetRule(class_2487 compound) {
        this.isServerCarpet = true;
        EssentialUtils.getClient().execute(() -> {
            RulesScreen rulesScreen;
            String name = compound.method_10558("Rule");
            String value = compound.method_10558("Value");
            String manager = compound.method_10558("Manager");
            Rule<Object> wrapped = this.CURRENT_RULES.get(name);
            if (wrapped == null) {
                CarpetRule<?> rule = CarpetUtils.getCarpetRule(name);
                wrapped = this.ALL_RULES.get(name);
                wrapped = rule != null ? (wrapped == null ? this.parseRuleToClientRule(rule, manager) : this.parseRuleToClientRule(rule, ((SimpleRule)wrapped).getDescription(), ((SimpleRule)wrapped).getOptionalInfo(), manager)) : (wrapped != null ? ((CarpetClientRule)wrapped).shallowCopy() : new StringCarpetRule(name, this.LOADNT, value));
                this.CURRENT_RULES.put(name, (CarpetClientRule<?>)wrapped);
            }
            this.HANDLING_DATA.set(true);
            ((CarpetClientRule)wrapped).setFromServer(value);
            this.HANDLING_DATA.set(false);
            class_437 patt0$temp = EssentialUtils.getClient().field_1755;
            if (patt0$temp instanceof RulesScreen && (rulesScreen = (RulesScreen)patt0$temp).method_25440() == Texts.SERVER_SCREEN) {
                rulesScreen.refreshRules(rulesScreen.getSearchBoxText());
            }
        });
    }

    private void loadSinglePlayerRules() {
        if (this.CURRENT_RULES.isEmpty() && EssentialUtils.getClient().method_1542()) {
            this.HANDLING_DATA.set(true);
            CarpetUtils.forEachCarpetRule((rule, managerId) -> {
                CarpetClientRule<?> clientRule = this.ALL_RULES.get(rule.name());
                clientRule = clientRule == null ? this.parseRuleToClientRule((CarpetRule<?>)rule, (String)managerId) : this.parseRuleToClientRule((CarpetRule<?>)rule, clientRule.getDescription(), clientRule.getOptionalInfo(), (String)managerId);
                clientRule.setFromServer(CarpetUtils.getRuleValueAsString(rule));
                this.CURRENT_RULES.put(clientRule.getName(), clientRule);
            });
            this.HANDLING_DATA.set(false);
        }
    }

    private CarpetClientRule<?> jsonToClientRule(JsonElement jsonElement) {
        if (!jsonElement.isJsonObject()) {
            EssentialClient.LOGGER.error("Failed to load Carpet Rule (Not JSON Object!):\n{}", (Object)jsonElement);
            return null;
        }
        JsonObject ruleObject = jsonElement.getAsJsonObject();
        JsonElement nameElement = ruleObject.get("name");
        if (nameElement == null || !nameElement.isJsonPrimitive()) {
            EssentialClient.LOGGER.error("Failed to load Carpet Rule (No Valid Name!):\n{}", (Object)ruleObject);
            return null;
        }
        String name = nameElement.getAsString();
        CarpetRule<?> rule = CarpetUtils.getCarpetRule(name);
        try {
            JsonElement categories;
            Object description = ruleObject.get("description").getAsString();
            JsonElement repo = ruleObject.get("repo");
            if (repo != null) {
                String repoString = repo.getAsString();
                description = (String)description + "\n\u00a73From: " + repoString;
            }
            String optionalInfo = null;
            JsonElement extraInfo = ruleObject.get("extras");
            if (extraInfo != null) {
                if (extraInfo.isJsonArray()) {
                    StringBuilder builder = new StringBuilder();
                    extraInfo.getAsJsonArray().forEach(element -> {
                        if (element.isJsonPrimitive()) {
                            builder.append(element.getAsString()).append(" ");
                        }
                    });
                    optionalInfo = builder.toString();
                }
                if (extraInfo.isJsonPrimitive()) {
                    optionalInfo = extraInfo.getAsString();
                }
            }
            if (rule != null) {
                return this.parseRuleToClientRule(rule, (String)description, optionalInfo, rule.settingsManager().identifier());
            }
            Rule.Type type = Rule.Type.fromString(ruleObject.get("type").getAsString());
            JsonElement defaultValue = ruleObject.get("default");
            if (defaultValue == null) {
                defaultValue = ruleObject.get("value");
            }
            if ((categories = ruleObject.get("categories")) != null && categories.getAsJsonArray().contains(this.COMMAND) && type != Rule.Type.BOOLEAN) {
                CycleCarpetRule wrapped = CycleCarpetRule.commandOf(name, (String)description, defaultValue.getAsString());
                wrapped.setOptionalInfo(optionalInfo);
                return wrapped;
            }
            JsonElement isStrict = ruleObject.get("strict");
            if (isStrict != null && isStrict.getAsBoolean() && type != Rule.Type.BOOLEAN) {
                ArrayList<String> validValues = new ArrayList<String>();
                JsonElement options = ruleObject.get("options");
                if (options.isJsonArray()) {
                    JsonArray values = options.getAsJsonArray();
                    values.forEach(element -> validValues.add(element.getAsString()));
                    CycleCarpetRule wrapped = new CycleCarpetRule(name, (String)description, validValues, defaultValue.getAsString());
                    wrapped.setOptionalInfo(optionalInfo);
                    return wrapped;
                }
            }
            CarpetClientRule wrapped = switch (type) {
                case Rule.Type.CYCLE -> {
                    JsonArray validCycles = ruleObject.get("cycles").getAsJsonArray();
                    ArrayList<String> cycles = new ArrayList<String>();
                    validCycles.forEach(element -> cycles.add(element.getAsString()));
                    yield new CycleCarpetRule(name, (String)description, cycles, defaultValue.getAsString());
                }
                case Rule.Type.BOOLEAN -> new BooleanCarpetRule(name, (String)description, defaultValue.getAsBoolean());
                case Rule.Type.INTEGER -> new IntegerCarpetRule(name, (String)description, defaultValue.getAsInt());
                case Rule.Type.DOUBLE -> new DoubleCarpetRule(name, (String)description, defaultValue.getAsDouble());
                default -> new StringCarpetRule(name, (String)description, defaultValue.getAsString());
            };
            wrapped.setOptionalInfo(optionalInfo);
            return wrapped;
        }
        catch (Exception e) {
            if (rule != null) {
                return this.parseRuleToClientRule(rule, CarpetUtils.getRuleSettingsManagerId(rule));
            }
            return null;
        }
    }

    private CarpetClientRule<?> parseRuleToClientRule(CarpetRule<?> rule, String manager) {
        return this.parseRuleToClientRule(rule, null, null, manager);
    }

    private CarpetClientRule<?> parseRuleToClientRule(CarpetRule<?> rule, String description, String optionalInfo, String manager) {
        CarpetClientRule wrapped;
        String name = rule.name();
        Rule.Type type = Rule.Type.fromClass(rule.type());
        String defaultValue = CarpetUtils.getRuleDefaultValueAsString(rule);
        if (description == null) {
            description = CarpetUtils.getRuleDescription(rule);
        }
        if (optionalInfo == null && (optionalInfo = CarpetUtils.getRuleExtraInfo(rule)).isBlank()) {
            optionalInfo = null;
        }
        if (CarpetUtils.isRuleCommand(rule)) {
            CycleCarpetRule wrapped2 = CycleCarpetRule.commandOf(name, description, defaultValue);
            wrapped2.setOptionalInfo(optionalInfo);
            return wrapped2;
        }
        if (rule.strict() && type != Rule.Type.BOOLEAN) {
            CycleCarpetRule wrapped3 = new CycleCarpetRule(name, description, new ArrayList<String>(rule.suggestions()), defaultValue);
            wrapped3.setOptionalInfo(optionalInfo);
            return wrapped3;
        }
        switch (type) {
            case BOOLEAN: {
                CarpetClientRule carpetClientRule;
                CarpetClientRule carpetClientRule2 = carpetClientRule = new BooleanCarpetRule(name, description, "true".equals(defaultValue));
                break;
            }
            case INTEGER: {
                Integer integer;
                CarpetClientRule carpetClientRule;
                try {
                    integer = Integer.parseInt(defaultValue);
                }
                catch (NumberFormatException e) {
                    integer = null;
                }
                CarpetClientRule carpetClientRule2 = carpetClientRule = integer == null ? null : new IntegerCarpetRule(name, description, integer);
                break;
            }
            case DOUBLE: {
                Double doubleValue;
                CarpetClientRule carpetClientRule;
                try {
                    doubleValue = Double.parseDouble(defaultValue);
                }
                catch (NumberFormatException e) {
                    doubleValue = null;
                }
                CarpetClientRule carpetClientRule2 = carpetClientRule = doubleValue == null ? null : new DoubleCarpetRule(name, description, doubleValue);
                break;
            }
            default: {
                CarpetClientRule carpetClientRule;
                CarpetClientRule carpetClientRule2 = wrapped = (carpetClientRule = null);
            }
        }
        if (wrapped == null) {
            wrapped = new StringCarpetRule(name, description, defaultValue);
        }
        this.MANAGERS.add(manager);
        wrapped.setCustomManager(manager);
        wrapped.setOptionalInfo(optionalInfo);
        return wrapped;
    }

    private JsonArray getData(JsonArray fallback) {
        String content = NetworkUtils.getStringFromUrl((String)this.DATA_URL);
        if (content == null) {
            EssentialClient.LOGGER.error("Failed to fetch rule data");
            return fallback;
        }
        return (JsonArray)GSON.fromJson(content, JsonArray.class);
    }

    @Override
    public String getConfigName() {
        return "CarpetClient";
    }

    @Override
    public JsonElement getSaveData() {
        JsonArray ruleData = new JsonArray();
        this.ALL_RULES.forEach((name, rule) -> {
            JsonObject ruleObject = new JsonObject();
            ruleObject.addProperty("name", name);
            ruleObject.addProperty("type", rule.getType().toString());
            ruleObject.addProperty("description", rule.getDescription());
            ruleObject.addProperty("extras", rule.getOptionalInfo());
            ruleObject.add("default", rule.getDefaultValueAsJson());
            if (rule instanceof CycleCarpetRule) {
                CycleCarpetRule cycleRule = (CycleCarpetRule)rule;
                JsonArray validCycles = new JsonArray();
                cycleRule.getCycleValues().forEach(arg_0 -> ((JsonArray)validCycles).add(arg_0));
                ruleObject.add("cycles", (JsonElement)validCycles);
            }
            ruleData.add((JsonElement)ruleObject);
        });
        return ruleData;
    }

    @Override
    public void readConfig(JsonArray jsonElement) {
        JsonArray jsonArray = this.getData(jsonElement);
        jsonArray.forEach(element -> {
            CarpetClientRule<?> rule = this.jsonToClientRule((JsonElement)element);
            if (rule != null) {
                this.ALL_RULES.put(rule.getName(), rule);
            }
        });
    }

    static {
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> INSTANCE.onDisconnect());
        SettingsManager.registerGlobalRuleObserver((source, rule, value) -> {
            INSTANCE.loadSinglePlayerRules();
            CarpetClientRule<?> clientRule = CarpetClient.INSTANCE.CURRENT_RULES.get(rule.name());
            if (clientRule != null) {
                clientRule.setFromServer(value);
            }
        });
    }
}

