/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.ArrayList;
import java.util.List;
import me.senseiwells.essentialclient.commands.PlayerClientCommand;
import me.senseiwells.essentialclient.rule.ClientRules;
import me.senseiwells.essentialclient.utils.EssentialUtils;
import me.senseiwells.essentialclient.utils.command.CommandHelper;
import me.senseiwells.essentialclient.utils.command.PlayerData;
import me.senseiwells.essentialclient.utils.config.ConfigPlayerClient;
import me.senseiwells.essentialclient.utils.config.ConfigPlayerList;
import me.senseiwells.essentialclient.utils.render.Texts;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;

public class PlayerListCommand {
    public static final DynamicCommandExceptionType EXISTS = new DynamicCommandExceptionType(xva$0 -> Texts.LIST_EXISTS.generate(xva$0));
    public static final DynamicCommandExceptionType NOT_EXIST = new DynamicCommandExceptionType(xva$0 -> Texts.LIST_NOT_EXISTS.generate(xva$0));
    public static final DynamicCommandExceptionType EMPTY = new DynamicCommandExceptionType(xva$0 -> Texts.LIST_EMPTY.generate(xva$0));
    public static final Dynamic2CommandExceptionType HAS_PLAYER = new Dynamic2CommandExceptionType((xva$0, xva$1) -> Texts.LIST_HAS_PLAYER.generate(xva$0, xva$1));

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        if (!((Boolean)ClientRules.COMMAND_PLAYER_LIST.getValue()).booleanValue() || !((Boolean)ClientRules.COMMAND_PLAYER_CLIENT.getValue()).booleanValue()) {
            return;
        }
        CommandHelper.CLIENT_COMMANDS.add("pl");
        CommandHelper.CLIENT_COMMANDS.add("playerlist");
        LiteralCommandNode playerListNode = class_2170.method_9247((String)"playerlist").build();
        LiteralCommandNode plNode = class_2170.method_9247((String)"pl").build();
        LiteralCommandNode createListNode = ((LiteralArgumentBuilder)class_2170.method_9247((String)"createlist").then(class_2170.method_9244((String)"listname", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> class_2172.method_9265(List.of("mobswitches", "allplayers"), (SuggestionsBuilder)builder)).executes(PlayerListCommand::createList))).build();
        LiteralCommandNode deleteListNode = ((LiteralArgumentBuilder)class_2170.method_9247((String)"deletelist").then(class_2170.method_9244((String)"listname", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> ConfigPlayerList.INSTANCE.suggestList(builder)).executes(PlayerListCommand::deleteList))).build();
        LiteralCommandNode spawnListNode = ((LiteralArgumentBuilder)class_2170.method_9247((String)"spawnlist").then(class_2170.method_9244((String)"listname", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> ConfigPlayerList.INSTANCE.suggestList(builder)).executes(PlayerListCommand::spawnFromList))).build();
        LiteralCommandNode playerNode = ((LiteralArgumentBuilder)class_2170.method_9247((String)"addplayer").then(class_2170.method_9244((String)"listname", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> ConfigPlayerList.INSTANCE.suggestList(builder)).then(class_2170.method_9244((String)"playername", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> ConfigPlayerClient.INSTANCE.suggestPlayer(builder)).executes(PlayerListCommand::addToList)))).build();
        dispatcher.getRoot().addChild((CommandNode)playerListNode);
        playerListNode.addChild((CommandNode)createListNode);
        playerListNode.addChild((CommandNode)deleteListNode);
        playerListNode.addChild((CommandNode)spawnListNode);
        playerListNode.addChild((CommandNode)playerNode);
        dispatcher.getRoot().addChild((CommandNode)plNode);
        plNode.addChild((CommandNode)createListNode);
        plNode.addChild((CommandNode)deleteListNode);
        plNode.addChild((CommandNode)spawnListNode);
        plNode.addChild((CommandNode)playerNode);
    }

    public static int createList(CommandContext<class_2168> context) throws CommandSyntaxException {
        String listName = (String)context.getArgument("listname", String.class);
        List players = (List)ConfigPlayerList.INSTANCE.get(listName);
        if (players != null) {
            throw EXISTS.create((Object)listName);
        }
        ConfigPlayerList.INSTANCE.set(listName, new ArrayList());
        EssentialUtils.sendMessage((class_2561)Texts.LIST_CREATED.generate(listName).method_27692(class_124.field_1060));
        return 1;
    }

    public static int deleteList(CommandContext<class_2168> context) throws CommandSyntaxException {
        String listName = (String)context.getArgument("listname", String.class);
        List players = (List)ConfigPlayerList.INSTANCE.remove(listName);
        if (players == null) {
            throw NOT_EXIST.create((Object)listName);
        }
        EssentialUtils.sendMessage((class_2561)Texts.LIST_DELETED.generate(listName).method_27692(class_124.field_1061));
        return 1;
    }

    public static int addToList(CommandContext<class_2168> context) throws CommandSyntaxException {
        String listName = (String)context.getArgument("listname", String.class);
        List players = (List)ConfigPlayerList.INSTANCE.get(listName);
        if (players == null) {
            throw NOT_EXIST.create((Object)listName);
        }
        String playerName = (String)context.getArgument("playername", String.class);
        PlayerData playerData = (PlayerData)ConfigPlayerClient.INSTANCE.get(playerName);
        if (playerData == null) {
            throw PlayerClientCommand.NO_PLAYER.create((Object)playerName);
        }
        if (players.contains(playerName)) {
            throw HAS_PLAYER.create((Object)playerName, (Object)listName);
        }
        players.add(playerName);
        EssentialUtils.sendMessage((class_2561)Texts.LIST_PLAYER_ADDED.generate(playerName, listName).method_27692(class_124.field_1065));
        return 1;
    }

    public static int spawnFromList(CommandContext<class_2168> context) throws CommandSyntaxException {
        String listName = (String)context.getArgument("listname", String.class);
        List players = (List)ConfigPlayerList.INSTANCE.get(listName);
        if (players == null) {
            throw NOT_EXIST.create((Object)listName);
        }
        if (players.isEmpty()) {
            throw EMPTY.create((Object)listName);
        }
        for (String playerName : players) {
            PlayerData playerData = (PlayerData)ConfigPlayerClient.INSTANCE.get(playerName);
            PlayerClientCommand.sendCommand(playerName, playerData);
        }
        return 1;
    }
}

