/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.List;
import me.senseiwells.essentialclient.rule.ClientRules;
import me.senseiwells.essentialclient.utils.EssentialUtils;
import me.senseiwells.essentialclient.utils.command.CommandHelper;
import me.senseiwells.essentialclient.utils.command.EnumArgumentType;
import me.senseiwells.essentialclient.utils.command.PlayerData;
import me.senseiwells.essentialclient.utils.command.WorldEnum;
import me.senseiwells.essentialclient.utils.config.ConfigPlayerClient;
import me.senseiwells.essentialclient.utils.render.Texts;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2270;
import net.minecraft.class_2277;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_5321;
import net.minecraft.class_746;

public class PlayerClientCommand {
    public static final DynamicCommandExceptionType NO_PLAYER = new DynamicCommandExceptionType(xva$0 -> Texts.NO_CONFIG.generate(xva$0));
    public static final Dynamic2CommandExceptionType WRONG_GAMEMODE = new Dynamic2CommandExceptionType((xva$0, xva$1) -> Texts.WRONG_GAMEMODE.generate(xva$0, xva$1));

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        if (!((Boolean)ClientRules.COMMAND_PLAYER_CLIENT.getValue()).booleanValue()) {
            return;
        }
        CommandHelper.CLIENT_COMMANDS.add("playerclient");
        CommandHelper.CLIENT_COMMANDS.add("pc");
        LiteralCommandNode playerclientNode = class_2170.method_9247((String)"playerclient").build();
        LiteralCommandNode pcNode = class_2170.method_9247((String)"pc").build();
        LiteralCommandNode spawnNode = ((LiteralArgumentBuilder)class_2170.method_9247((String)"spawn").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"playername", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> ConfigPlayerClient.INSTANCE.suggestPlayer(builder)).executes(context -> PlayerClientCommand.spawnPlayer((CommandContext<class_2168>)context, false))).then(class_2170.method_9247((String)"offset").then(class_2170.method_9244((String)"x-axis", (ArgumentType)DoubleArgumentType.doubleArg()).suggests((context, builder) -> class_2172.method_9265(List.of("0", "160", "-160", "256", "-256"), (SuggestionsBuilder)builder)).then(class_2170.method_9244((String)"y-axis", (ArgumentType)DoubleArgumentType.doubleArg()).suggests((context, builder) -> class_2172.method_9265(List.of("0", "128"), (SuggestionsBuilder)builder)).then(class_2170.method_9244((String)"z-axis", (ArgumentType)DoubleArgumentType.doubleArg()).suggests((context, builder) -> class_2172.method_9265(List.of("0", "160", "-160", "256", "-256"), (SuggestionsBuilder)builder)).executes(context -> PlayerClientCommand.spawnPlayer((CommandContext<class_2168>)context, true)))))))).build();
        LiteralCommandNode addNode = ((LiteralArgumentBuilder)class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"playername", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> ConfigPlayerClient.INSTANCE.suggestPlayer(builder)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"spawn").then(class_2170.method_9247((String)"at").then(class_2170.method_9244((String)"pos", (ArgumentType)class_2277.method_9737()).then(class_2170.method_9247((String)"facing").then(class_2170.method_9244((String)"rotation", (ArgumentType)class_2270.method_9717()).then(class_2170.method_9247((String)"in").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"dimension", EnumArgumentType.enumeration(WorldEnum.class)).executes(context -> PlayerClientCommand.constructPlayer((CommandContext<class_2168>)context, false, false))).then(class_2170.method_9247((String)"in").then(class_2170.method_9244((String)"gamemode", EnumArgumentType.enumeration(class_1934.class)).executes(context -> PlayerClientCommand.constructPlayer((CommandContext<class_2168>)context, false, true))))))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"here").executes(context -> PlayerClientCommand.constructPlayer((CommandContext<class_2168>)context, true, false))).then(class_2170.method_9247((String)"in").then(class_2170.method_9244((String)"gamemode", EnumArgumentType.enumeration(class_1934.class)).executes(context -> PlayerClientCommand.constructPlayer((CommandContext<class_2168>)context, true, true)))))))).build();
        LiteralCommandNode removeNode = ((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"playername", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> ConfigPlayerClient.INSTANCE.suggestPlayer(builder)).executes(context -> {
            String playerName = (String)context.getArgument("playername", String.class);
            if (ConfigPlayerClient.INSTANCE.remove(playerName) == null) {
                throw NO_PLAYER.create((Object)playerName);
            }
            EssentialUtils.sendMessage((class_2561)Texts.REMOVED_CONFIG.generate(playerName).method_27692(class_124.field_1065));
            return 0;
        }))).build();
        dispatcher.getRoot().addChild((CommandNode)playerclientNode);
        playerclientNode.addChild((CommandNode)spawnNode);
        playerclientNode.addChild((CommandNode)addNode);
        playerclientNode.addChild((CommandNode)removeNode);
        dispatcher.getRoot().addChild((CommandNode)pcNode);
        pcNode.addChild((CommandNode)spawnNode);
        pcNode.addChild((CommandNode)addNode);
        pcNode.addChild((CommandNode)removeNode);
    }

    public static int constructPlayer(CommandContext<class_2168> context, boolean isHere, boolean hasGamemode) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_1297 class_12972 = source.method_9228();
        if (!(class_12972 instanceof class_746)) {
            return 0;
        }
        class_746 player = (class_746)class_12972;
        String playerName = (String)context.getArgument("playername", String.class);
        class_243 playerPos = isHere ? source.method_9222() : class_2277.method_9736(context, (String)"pos");
        class_241 playerRotation = isHere ? source.method_9210() : class_2270.method_9716(context, (String)"rotation").method_9709(source);
        WorldEnum playerWorld = isHere ? WorldEnum.fromRegistryKey((class_5321<class_1937>)player.method_5770().method_27983()) : EnumArgumentType.getEnumeration(context, "dimension", WorldEnum.class);
        class_1934 playerGamemode = !hasGamemode ? null : EnumArgumentType.getEnumeration(context, "gamemode", class_1934.class);
        PlayerData playerData = new PlayerData(playerPos, playerRotation, playerWorld, playerGamemode);
        ConfigPlayerClient.INSTANCE.set(playerName, playerData);
        return 1;
    }

    public static int spawnPlayer(CommandContext<class_2168> context, boolean hasOffset) throws CommandSyntaxException {
        String playerName = (String)context.getArgument("playername", String.class);
        PlayerData playerData = (PlayerData)ConfigPlayerClient.INSTANCE.get(playerName);
        return !hasOffset ? PlayerClientCommand.sendCommand(playerName, playerData) : PlayerClientCommand.sendCommand(playerName, playerData, (Double)context.getArgument("x-axis", Double.class), (Double)context.getArgument("y-axis", Double.class), (Double)context.getArgument("z-axis", Double.class));
    }

    public static int sendCommand(String playerName, PlayerData playerData) throws CommandSyntaxException {
        return PlayerClientCommand.sendCommand(playerName, playerData, 0.0, 0.0, 0.0);
    }

    private static int sendCommand(String playerName, PlayerData playerData, double x, double y, double z) throws CommandSyntaxException {
        if (playerData == null) {
            throw NO_PLAYER.create((Object)playerName);
        }
        class_1934 playerGameMode = EssentialUtils.getInteractionManager().method_2920();
        if (playerData.gamemode() != null && playerGameMode != playerData.gamemode()) {
            throw WRONG_GAMEMODE.create((Object)playerGameMode, (Object)playerData.gamemode());
        }
        EssentialUtils.sendChatMessage("/player %s spawn at %s %s %s facing %s %s in %s".formatted(playerName, playerData.pos().field_1352 + x, playerData.pos().field_1351 + y, playerData.pos().field_1350 + z, Float.valueOf(playerData.rotation().field_1342), Float.valueOf(playerData.rotation().field_1343), playerData.world().name().toLowerCase()));
        return 1;
    }
}

