/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import me.senseiwells.essentialclient.clientscript.core.ClientScript;
import me.senseiwells.essentialclient.clientscript.core.ClientScriptInstance;
import me.senseiwells.essentialclient.utils.EssentialUtils;
import me.senseiwells.essentialclient.utils.clientscript.ScriptRepositoryManager;
import me.senseiwells.essentialclient.utils.command.CommandHelper;
import me.senseiwells.essentialclient.utils.command.EnumArgumentType;
import me.senseiwells.essentialclient.utils.render.Texts;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;

public class ClientScriptCommand {
    private static final DynamicCommandExceptionType NO_SUCH_SCRIPT = new DynamicCommandExceptionType(xva$0 -> Texts.NO_SCRIPT.generate(xva$0));

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        CommandHelper.CLIENT_COMMANDS.add("clientscript");
        LiteralArgumentBuilder root = class_2170.method_9247((String)"clientscript");
        LiteralArgumentBuilder download = class_2170.method_9247((String)"download");
        LiteralArgumentBuilder runFromWeb = class_2170.method_9247((String)"runfromweb");
        root.then(class_2170.method_9247((String)"run").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"scriptName", (ArgumentType)StringArgumentType.string()).suggests((c, b) -> class_2172.method_9265(ClientScript.INSTANCE.getScriptInstanceNames(), (SuggestionsBuilder)b)).executes(context -> {
            String scriptName = StringArgumentType.getString((CommandContext)context, (String)"scriptName");
            ClientScriptInstance instance = ClientScript.INSTANCE.getScriptInstance(scriptName);
            if (instance == null) {
                throw NO_SUCH_SCRIPT.create((Object)scriptName);
            }
            instance.stopScript();
            instance.toggleScript();
            return 1;
        })).then(class_2170.method_9244((String)"script", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            String scriptName = StringArgumentType.getString((CommandContext)context, (String)"scriptName");
            String scriptContent = StringArgumentType.getString((CommandContext)context, (String)"script");
            ClientScriptInstance.runFromContent(scriptName, scriptContent);
            return 1;
        }))));
        root.then(class_2170.method_9247((String)"stopall").executes(context -> {
            ClientScript.INSTANCE.stopAllInstances();
            return 1;
        }));
        download.then(class_2170.method_9244((String)"category", EnumArgumentType.enumeration(ScriptRepositoryManager.Category.class)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"scriptname", (ArgumentType)StringArgumentType.string()).suggests((c, b) -> class_2172.method_9265(ScriptRepositoryManager.INSTANCE.getChildrenNames(EnumArgumentType.getEnumeration((CommandContext<class_2168>)c, "category", ScriptRepositoryManager.Category.class)), (SuggestionsBuilder)b)).executes(context -> {
            String scriptName;
            ScriptRepositoryManager.Category category = EnumArgumentType.getEnumeration((CommandContext<class_2168>)context, "category", ScriptRepositoryManager.Category.class);
            if (ScriptRepositoryManager.INSTANCE.downloadScript(category, scriptName = StringArgumentType.getString((CommandContext)context, (String)"scriptname"), false)) {
                throw NO_SUCH_SCRIPT.create((Object)scriptName);
            }
            EssentialUtils.sendMessage((class_2561)Texts.DOWNLOAD_SUCCESS.generate(scriptName).method_27692(class_124.field_1065));
            return 1;
        })).then(class_2170.method_9244((String)"shouldoverwrite", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            boolean shouldOverwrite;
            String scriptName;
            ScriptRepositoryManager.Category category = EnumArgumentType.getEnumeration((CommandContext<class_2168>)context, "category", ScriptRepositoryManager.Category.class);
            if (ScriptRepositoryManager.INSTANCE.downloadScript(category, scriptName = StringArgumentType.getString((CommandContext)context, (String)"scriptname"), shouldOverwrite = BoolArgumentType.getBool((CommandContext)context, (String)"shouldoverwrite"))) {
                throw NO_SUCH_SCRIPT.create((Object)scriptName);
            }
            EssentialUtils.sendMessage((class_2561)Texts.DOWNLOAD_SUCCESS.generate(scriptName).method_27692(class_124.field_1065));
            return 1;
        }))));
        runFromWeb.then(class_2170.method_9244((String)"category", EnumArgumentType.enumeration(ScriptRepositoryManager.Category.class)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"scriptname", (ArgumentType)StringArgumentType.string()).suggests((c, b) -> class_2172.method_9265(ScriptRepositoryManager.INSTANCE.getChildrenNames(EnumArgumentType.getEnumeration((CommandContext<class_2168>)c, "category", ScriptRepositoryManager.Category.class)), (SuggestionsBuilder)b)).executes(context -> {
            String scriptName;
            ScriptRepositoryManager.Category category = EnumArgumentType.getEnumeration((CommandContext<class_2168>)context, "category", ScriptRepositoryManager.Category.class);
            String scriptContent = ScriptRepositoryManager.INSTANCE.getScriptFromWeb(category, scriptName = StringArgumentType.getString((CommandContext)context, (String)"scriptname"), true);
            if (scriptContent == null) {
                throw NO_SUCH_SCRIPT.create((Object)scriptName);
            }
            ClientScriptInstance.runFromContent(scriptName, scriptContent);
            return 1;
        })).then(class_2170.method_9244((String)"fromcache", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            boolean fromCache;
            String scriptName;
            ScriptRepositoryManager.Category category = EnumArgumentType.getEnumeration((CommandContext<class_2168>)context, "category", ScriptRepositoryManager.Category.class);
            String scriptContent = ScriptRepositoryManager.INSTANCE.getScriptFromWeb(category, scriptName = StringArgumentType.getString((CommandContext)context, (String)"scriptname"), fromCache = BoolArgumentType.getBool((CommandContext)context, (String)"fromcache"));
            if (scriptContent == null) {
                throw NO_SUCH_SCRIPT.create((Object)scriptName);
            }
            ClientScriptInstance.runFromContent(scriptName, scriptContent);
            return 1;
        }))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)root.then((ArgumentBuilder)download)).then((ArgumentBuilder)runFromWeb));
    }
}

