/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.clientscript.events;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import me.senseiwells.essentialclient.clientscript.events.MinecraftScriptEvent;

public class MinecraftScriptEvents {
    private static final Map<String, MinecraftScriptEvent> EVENT_MAP = new HashMap<String, MinecraftScriptEvent>();
    public static final MinecraftScriptEvent ON_CLIENT_TICK = MinecraftScriptEvents.register("onClientTick", "The event is fired on every client tick", new String[0]);
    public static final MinecraftScriptEvent ON_HEALTH_UPDATE = MinecraftScriptEvents.register("onHealthUpdate", "This event is fired when the player's health changes", "Number", "health", "the new health");
    public static final MinecraftScriptEvent ON_BLOCK_UPDATE = MinecraftScriptEvents.register("onBlockUpdate", "This event is fired when a block update is recieved on the client", "Block", "block", "the block that was updated");
    public static final MinecraftScriptEvent ON_TOTEM = MinecraftScriptEvents.register("onTotem", "This event is fired when the player uses a totem", new String[0]);
    public static final MinecraftScriptEvent ON_CLOSE_SCREEN = MinecraftScriptEvents.register("onCloseScreen", "This event is fired when the player closes a screen", "Screen", "screen", "the screen that was just closed");
    public static final MinecraftScriptEvent ON_CONNECT = MinecraftScriptEvents.register("onConnect", "The event is fired when the player connects to a server", "Player", "player", "the player entity", "World", "world", "the world the player joined");
    public static final MinecraftScriptEvent ON_DISCONNECT = MinecraftScriptEvents.register("onDisconnect", "This event is fired when the player disconnects from a server", new String[0]);
    public static final MinecraftScriptEvent ON_OPEN_SCREEN = MinecraftScriptEvents.register("onOpenScreen", "This event is fired when the player opens a screen", "Screen", "screen", "the screen that was just opened");
    public static final MinecraftScriptEvent ON_PICK_UP_ITEM = MinecraftScriptEvents.register("onPickUpItem", "This event is fired when the player picks up an item", "ItemStack", "itemStack", "the item");
    public static final MinecraftScriptEvent ON_ANVIL = MinecraftScriptEvents.register("onAnvil", "This event is fired when the player anvils an item", "ItemStack", "first", "the first input", "ItemStack", "second", "the second input", "ItemStack", "result", "the result of the first and second input", "String", "newName", "the new name of the item stack", "Number", "levelCost", "the amount of xp required");
    public static final MinecraftScriptEvent ON_FISH_BITE = MinecraftScriptEvents.register("onFishBite", "This event is fired when a fish bites the player's fishing rod", "Entity", "entity", "the fishing bobber entity");
    public static final MinecraftScriptEvent ON_DEATH = MinecraftScriptEvents.register("onDeath", "This event is fired when the player dies", "Entity", "entity", "the entity that killed the player, may be null", "Text", "message", "the death message");
    public static final MinecraftScriptEvent ON_RESPAWN = MinecraftScriptEvents.register("onRespawn", "This event is fired when the player respawns", "Player", "player", "the respawned player entity");
    public static final MinecraftScriptEvent ON_EAT = MinecraftScriptEvents.register("onEat", "This event is fired when the player eats something", "ItemStack", "food", "the item stack that was eaten");
    public static final MinecraftScriptEvent ON_GAMEMODE_CHANGE = MinecraftScriptEvents.register("onGamemodeChange", "This event is fired when the player changes their gamemode", "String", "gamemode", "the new gamemode");
    public static final MinecraftScriptEvent ON_BLOCK_BROKEN = MinecraftScriptEvents.register("onBlockBroken", "This event is fired when the player breaks a new block", "Block", "block", "the block that was broken");
    public static final MinecraftScriptEvent ON_BLOCK_PLACED = MinecraftScriptEvents.register("onBlockPlaced", "This event is fired when the player places a block", "Block", "block", "the block that was placed");
    public static final MinecraftScriptEvent ON_DIMENSION_CHANGE = MinecraftScriptEvents.register("onDimensionChange", "This event is fired when the player changes their dimension", "World", "world", "the new world");
    public static final MinecraftScriptEvent ON_PLAYER_JOIN = MinecraftScriptEvents.register("onPlayerJoin", "This event is fired when a player joins the server", "String", "name", "the player's name", "String", "uuid", "the player's uuid");
    public static final MinecraftScriptEvent ON_PLAYER_LEAVE = MinecraftScriptEvents.register("onPlayerLeave", "This event is fired when a player leaves the server", "String", "name", "the player's name", "String", "uuid", "the player's uuid");
    public static final MinecraftScriptEvent ON_ENTITY_SPAWN = MinecraftScriptEvents.register("onEntitySpawn", "This event is fired when an entity spawns, this doesn't include mobs", "Entity", "entity", "the entity that was spawned");
    public static final MinecraftScriptEvent ON_MOB_SPAWN = MinecraftScriptEvents.register("onMobSpawn", "This event is fired when a mob spawns", "LivingEntity", "mob", "the mob that was spawned");
    public static final MinecraftScriptEvent ON_ENTITY_REMOVED = MinecraftScriptEvents.register("onEntityRemoved", "This event is fired when an entity is removed", "Entity", "entity", "the entity that was removed");
    public static final MinecraftScriptEvent ON_SCRIPT_PACKET = MinecraftScriptEvents.register("onScriptPacket", "This event is fired when a script packet is received from scarpet on the server", "List", "packet", "a list of data that was received");
    public static final MinecraftScriptEvent ON_PLAYER_LOOK = MinecraftScriptEvents.registerCancellable("onPlayerLook", "This event is fired when the player changes their yaw and/or pitch", "Number", "yaw", "the player's yaw", "Number", "pitch", "the player's pitch");
    public static final MinecraftScriptEvent ON_PICK_BLOCK = MinecraftScriptEvents.registerCancellable("onPickBlock", "This event is fired when the player picks a block with middle mouse", "ItemStack", "itemStack", "the item stack that was picked");
    public static final MinecraftScriptEvent ON_ATTACK = MinecraftScriptEvents.registerCancellable("onAttack", "This event is fired when the player attacks", new String[0]);
    public static final MinecraftScriptEvent ON_USE = MinecraftScriptEvents.registerCancellable("onUse", "This event is fired when the player uses", new String[0]);
    public static final MinecraftScriptEvent ON_MOUSE_SCROLL = MinecraftScriptEvents.registerCancellable("onMouseScroll", "This event is fired when the player scrolls", "Number", "direction", "either -1 or 1 depending on the scroll direction");
    public static final MinecraftScriptEvent ON_KEY_PRESS = MinecraftScriptEvents.registerCancellable("onKeyPress", "This event is fired when a key is pressed", "String", "key", "the key that was pressed");
    public static final MinecraftScriptEvent ON_KEY_RELEASE = MinecraftScriptEvents.registerCancellable("onKeyRelease", "This event is fired when a key is released", "String", "key", "the key that was released");
    public static final MinecraftScriptEvent ON_DROP_ITEM = MinecraftScriptEvents.registerCancellable("onDropItem", "This event is fired when the player tries to drop an item", "ItemStack", "itemStack", "the item that is trying to be dropped");
    public static final MinecraftScriptEvent ON_INTERACT_ITEM = MinecraftScriptEvents.registerCancellable("onInteractItem", "This event is fired when the player interacts with an item", "ItemStack", "itemStack", "the item stack that was interacted with");
    public static final MinecraftScriptEvent ON_INTERACT_BLOCK = MinecraftScriptEvents.registerCancellable("onInteractBlock", "This event is fired when the player interacts with a block", "Block", "block", "the block the player is interacting with", "ItemStack", "itemStack", "the item stack that was interacted with");
    public static final MinecraftScriptEvent ON_INTERACT_ENTITY = MinecraftScriptEvents.registerCancellable("onInteractEntity", "This event is fired when the player interacts with an entity", "Entity", "entity", "the entity that was interacted with", "ItemStack", "itemStack", "the item stack that was interacted with");
    public static final MinecraftScriptEvent ON_SEND_MESSAGE = MinecraftScriptEvents.registerCancellable("onSendMessage", "This event is fired when the player sends a message in chat", "String", "message", "the message that was sent");
    public static final MinecraftScriptEvent ON_RECEIVE_MESSAGE = MinecraftScriptEvents.registerCancellable("onReceiveMessage", "This event is fired when the player receives a message in chat", "String", "uuid", "the sender's UUID", "String", "message", "the message that was received", "String", "type", "the type of message that was received; 'chat', 'say_command', 'msg_command_incoming', 'msg_command_outgoing', 'team_msg_command_incoming', 'team_msg_command_outgoing', and 'emote_command'");
    public static final MinecraftScriptEvent ON_CLICK_SLOT = MinecraftScriptEvents.registerCancellable("onClickSlot", "This event is fired when the player clicks on a slot in their inventory", "Number", "slot", "the slot number that was clicked", "String", "action", "ths action that was used");
    public static final MinecraftScriptEvent ON_CLICK_RECIPE = MinecraftScriptEvents.registerCancellable("onClickRecipe", "This event is fired when the player clicks on a recipe in the recipe book", "Recipe", "recipe", "the recipe that was clicked");
    public static final MinecraftScriptEvent ON_ATTACK_BLOCK = MinecraftScriptEvents.registerCancellable("onAttackBlock", "This event is fired when the player attacks a block", "Block", "block", "the block that was attacked");
    public static final MinecraftScriptEvent ON_ATTACK_ENTITY = MinecraftScriptEvents.registerCancellable("onAttackEntity", "This event is fired when the player attacks an entity", "Entity", "entity", "the entity that was attacked");
    public static final MinecraftScriptEvent ON_CLICK_TRADE = MinecraftScriptEvents.register("onClickTrade", "This event is fired when trade is clicked", "Number", "index", "the trade index that was clicked");
    public static final MinecraftScriptEvent ON_CLICK_STONECUTTER_RECIPE = MinecraftScriptEvents.register("onClickStonecutterRecipe", "This event is fired when the player clicks on a recipe in the stonecutter", "Recipe", "recipe", "the recipe that was clicked");
    public static final MinecraftScriptEvent.Unique ON_SCRIPT_END = MinecraftScriptEvents.registerUnique("onScriptEnd", "This event is fired when the script is ends", new String[0]);

    protected static void addEventToMap(String name, MinecraftScriptEvent minecraftScriptEvent) {
        EVENT_MAP.put(name.toLowerCase(), minecraftScriptEvent);
    }

    public static MinecraftScriptEvent getEvent(String name) {
        return EVENT_MAP.get(name.toLowerCase());
    }

    public static void clearEventFunctions(UUID id) {
        MinecraftScriptEvents.forEachEvent(e -> e.clearRegisteredEvents(id));
    }

    public static void forEachEvent(Consumer<MinecraftScriptEvent> consumer) {
        EVENT_MAP.values().forEach(consumer);
    }

    private static MinecraftScriptEvent register(String name, String description, String ... parameters) {
        return new MinecraftScriptEvent(name, description, parameters);
    }

    private static MinecraftScriptEvent registerCancellable(String name, String description, String ... parameters) {
        return new MinecraftScriptEvent(name, description, parameters, true);
    }

    private static MinecraftScriptEvent.Unique registerUnique(String name, String description, String ... parameters) {
        return new MinecraftScriptEvent.Unique(name, description, parameters);
    }
}

