/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.clientscript.events;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Function;
import me.senseiwells.arucas.builtin.ListDef;
import me.senseiwells.arucas.classes.instance.ClassInstance;
import me.senseiwells.arucas.interpreter.Interpreter;
import me.senseiwells.arucas.utils.impl.ArucasList;
import me.senseiwells.essentialclient.clientscript.core.ClientScript;
import me.senseiwells.essentialclient.clientscript.events.MinecraftScriptEvents;
import me.senseiwells.essentialclient.rule.ClientRules;
import me.senseiwells.essentialclient.utils.clientscript.impl.ScriptEvent;
import me.senseiwells.essentialclient.utils.clientscript.impl.WaitingEvent;

public class MinecraftScriptEvent {
    private final String name;
    private final String description;
    private final String[] parameters;
    private final boolean isCancellable;
    protected final Map<UUID, Set<ScriptEvent>> REGISTERED_EVENTS = new HashMap<UUID, Set<ScriptEvent>>();
    protected final Map<UUID, Set<WaitingEvent>> WAITING_EVENTS = new HashMap<UUID, Set<WaitingEvent>>();

    public MinecraftScriptEvent(String eventName, String description, String[] parameters, boolean isCancellable) {
        this.name = eventName;
        this.description = description;
        this.parameters = parameters;
        this.isCancellable = isCancellable;
        MinecraftScriptEvents.addEventToMap(eventName, this);
    }

    public MinecraftScriptEvent(String eventName, String description, String ... parameters) {
        this(eventName, description, parameters, false);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String[] getParameters() {
        return this.parameters;
    }

    public boolean canCancel() {
        return this.isCancellable;
    }

    public boolean isThreadDefinable() {
        return true;
    }

    public synchronized void registerEvent(ScriptEvent gameEvent) {
        if (gameEvent.getInterpreter().isRunning()) {
            Set gameEventWrappers = this.REGISTERED_EVENTS.computeIfAbsent(gameEvent.getId(), id -> {
                gameEvent.getInterpreter().addStopEvent(() -> this.REGISTERED_EVENTS.remove(id));
                return new LinkedHashSet();
            });
            gameEventWrappers.add(gameEvent);
        }
    }

    public synchronized boolean unregisterEvent(ScriptEvent gameEvent) {
        Set<ScriptEvent> gameEventWrappers = this.REGISTERED_EVENTS.get(gameEvent.getId());
        return gameEventWrappers != null && gameEventWrappers.remove(gameEvent);
    }

    public synchronized boolean isEventRegistered(ScriptEvent gameEvent) {
        Set<ScriptEvent> gameEventWrappers = this.REGISTERED_EVENTS.get(gameEvent.getId());
        return gameEventWrappers != null && gameEventWrappers.contains(gameEvent);
    }

    public synchronized void clearRegisteredEvents(UUID uuid) {
        Set<ScriptEvent> gameEventWrappers = this.REGISTERED_EVENTS.get(uuid);
        if (gameEventWrappers != null) {
            gameEventWrappers.clear();
        }
    }

    public synchronized Future<ClassInstance> registerWaitingEvent(Interpreter interpreter) {
        CompletableFuture<ClassInstance> future = new CompletableFuture<ClassInstance>();
        Set futures = this.WAITING_EVENTS.computeIfAbsent(interpreter.getProperties().getId(), id -> {
            interpreter.addStopEvent(() -> this.WAITING_EVENTS.remove(id));
            return new LinkedHashSet();
        });
        futures.add(new WaitingEvent(interpreter, future));
        return future;
    }

    public synchronized boolean run(Object ... args) {
        return this.run((Interpreter interpreter) -> {
            ArrayList<ClassInstance> eventArgs = new ArrayList<ClassInstance>();
            for (Object arg : args) {
                eventArgs.add(interpreter.convertValue(arg));
            }
            return eventArgs;
        });
    }

    public synchronized boolean run(Function<Interpreter, List<ClassInstance>> argumentSupplier) {
        List<ClassInstance> eventArguments;
        boolean shouldCancel = false;
        for (Set<ScriptEvent> set : this.REGISTERED_EVENTS.values()) {
            eventArguments = null;
            for (ScriptEvent scriptEvent : set) {
                if (eventArguments == null) {
                    eventArguments = argumentSupplier.apply(scriptEvent.getInterpreter());
                }
                if (!scriptEvent.invoke(eventArguments)) continue;
                shouldCancel = true;
            }
        }
        for (Set<Object> set : this.WAITING_EVENTS.values()) {
            eventArguments = null;
            for (WaitingEvent waitingEvent : set) {
                if (eventArguments == null) {
                    eventArguments = argumentSupplier.apply(waitingEvent.interpreter());
                }
                waitingEvent.future().complete(waitingEvent.interpreter().create(ListDef.class, (Object)new ArucasList(eventArguments)));
            }
        }
        this.WAITING_EVENTS.clear();
        if (shouldCancel && ((Boolean)ClientRules.CLIENTSCRIPT_DEBUGGER.getValue()).booleanValue()) {
            ClientScript.LOGGER.info("Event '{}' was cancelled", (Object)this.name);
        }
        return shouldCancel;
    }

    public String toString() {
        return this.name;
    }

    public static class Unique
    extends MinecraftScriptEvent {
        private final boolean isThreadDefinable;

        public Unique(String name, String description, String[] parameters, boolean isThreadDefinable) {
            super(name, description, parameters);
            this.isThreadDefinable = isThreadDefinable;
        }

        public Unique(String name, String description, String ... parameters) {
            this(name, description, parameters, false);
        }

        @Override
        public boolean isThreadDefinable() {
            return this.isThreadDefinable;
        }

        public synchronized boolean run(UUID uuid, ClassInstance ... arguments) {
            boolean shouldCancel = false;
            Set gameEventWrappers = (Set)this.REGISTERED_EVENTS.get(uuid);
            if (gameEventWrappers == null) {
                return false;
            }
            for (ScriptEvent gameEvent : gameEventWrappers) {
                if (!gameEvent.invoke(Arrays.asList(arguments))) continue;
                shouldCancel = true;
            }
            if (shouldCancel && ((Boolean)ClientRules.CLIENTSCRIPT_DEBUGGER.getValue()).booleanValue()) {
                ClientScript.LOGGER.info("Event '{}' was cancelled", (Object)this.getName());
            }
            return shouldCancel;
        }

        @Override
        @Deprecated
        public synchronized boolean run(Object ... arguments) {
            return false;
        }
    }
}

