/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.clientscript.definitions.shapes;

import java.util.List;
import me.senseiwells.arucas.api.docs.annotations.ClassDoc;
import me.senseiwells.arucas.api.docs.annotations.FunctionDoc;
import me.senseiwells.arucas.api.docs.annotations.ParameterDoc;
import me.senseiwells.arucas.api.docs.annotations.ReturnDoc;
import me.senseiwells.arucas.builtin.NumberDef;
import me.senseiwells.arucas.classes.PrimitiveDefinition;
import me.senseiwells.arucas.functions.builtin.Arguments;
import me.senseiwells.arucas.functions.builtin.MemberFunction;
import me.senseiwells.arucas.interpreter.Interpreter;
import me.senseiwells.arucas.utils.misc.Language;
import me.senseiwells.essentialclient.clientscript.definitions.shapes.ShapeDef;
import me.senseiwells.essentialclient.utils.clientscript.impl.ScriptShape;
import org.jetbrains.annotations.NotNull;

@ClassDoc(name="OutlinedShape", desc={"This class represents all shapes that can be outlined"}, superclass=ShapeDef.class, language=Language.Java)
public class OutlinedShapeDef
extends PrimitiveDefinition<ScriptShape.Outlined> {
    public OutlinedShapeDef(Interpreter interpreter) {
        super("OutlinedShape", interpreter);
    }

    @NotNull
    public PrimitiveDefinition<? super ScriptShape.Outlined> superclass() {
        return this.getPrimitiveDef(ShapeDef.class);
    }

    public List<MemberFunction> defineMethods() {
        return List.of(MemberFunction.of((String)"setOutlineColour", (int)1, this::setOutlineColour1), MemberFunction.of((String)"setOutlineColor", (int)1, this::setOutlineColour1), MemberFunction.of((String)"setOutlineColour", (int)3, this::setOutlineColour3), MemberFunction.of((String)"setOutlineColor", (int)3, this::setOutlineColour3), MemberFunction.of((String)"setOutlineRed", (int)1, this::setOutlineRed), MemberFunction.of((String)"setOutlineGreen", (int)1, this::setOutlineGreen), MemberFunction.of((String)"setOutlineBlue", (int)1, this::setOutlineBlue), MemberFunction.of((String)"setOutlinePixelWidth", (int)1, this::setOutlineWidth, (String)"Use <Shape>.setOutlineWidth(width) instead"), MemberFunction.of((String)"setOutlineWidth", (int)1, this::setOutlineWidth), MemberFunction.of((String)"getOutlineRed", this::getOutlineRed), MemberFunction.of((String)"getOutlineGreen", this::getOutlineGreen), MemberFunction.of((String)"getOutlineBlue", this::getOutlineBlue), MemberFunction.of((String)"getOutlinePixelWidth", this::getOutlineWidth));
    }

    @FunctionDoc(name="setOutlineColour", desc={"This sets the width of the shape, using a single value, this function", "also has a sibling named `setOutlineColor()` that has the same functionality.", "The colour generally should be hexadecimal in the form 0xRRGGBB"}, params={@ParameterDoc(type=NumberDef.class, name="colour", desc={"the colour you want to set"})}, examples={"shape.setOutlineColour(0xFF00FF);"})
    private Void setOutlineColour1(Arguments arguments) {
        ScriptShape.Outlined shape = (ScriptShape.Outlined)arguments.nextPrimitive((PrimitiveDefinition)this);
        int colour = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        shape.setOutlineColour(colour);
        return null;
    }

    @FunctionDoc(name="setOutlineColour", desc={"This sets the outline colour of the shape, using three values, this function", "also has a sibling named `setOutlineColor()` that has the same functionality.", "If the colours are not between 0 and 255 an error will be thrown"}, params={@ParameterDoc(type=NumberDef.class, name="red", desc={"the amount of red 0 - 255"}), @ParameterDoc(type=NumberDef.class, name="green", desc={"the amount of green 0 - 255"}), @ParameterDoc(type=NumberDef.class, name="blue", desc={"the amount of blue 0 - 255"})}, examples={"shape.setOutlineColour(255, 0, 255);"})
    private Void setOutlineColour3(Arguments arguments) {
        ScriptShape.Outlined shape = (ScriptShape.Outlined)arguments.nextPrimitive((PrimitiveDefinition)this);
        int red = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        int green = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        int blue = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        shape.setOutlineRed(red);
        shape.setOutlineGreen(green);
        shape.setOutlineBlue(blue);
        return null;
    }

    @FunctionDoc(name="setOutlineRed", desc={"This sets the outline red value of the shape, using a single value"}, params={@ParameterDoc(type=NumberDef.class, name="red", desc={"the amount of red between 0 - 255"})}, examples={"shape.setOutlineRed(34);"})
    private Void setOutlineRed(Arguments arguments) {
        ScriptShape.Outlined shape = (ScriptShape.Outlined)arguments.nextPrimitive((PrimitiveDefinition)this);
        int red = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        shape.setOutlineRed(red);
        return null;
    }

    @FunctionDoc(name="setOutlineGreen", desc={"This sets the outline green value of the shape, using a single value"}, params={@ParameterDoc(type=NumberDef.class, name="green", desc={"the amount of green between 0 - 255"})}, examples={"shape.setOutlineGreen(34);"})
    private Void setOutlineGreen(Arguments arguments) {
        ScriptShape.Outlined shape = (ScriptShape.Outlined)arguments.nextPrimitive((PrimitiveDefinition)this);
        int green = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        shape.setOutlineGreen(green);
        return null;
    }

    @FunctionDoc(name="setOutlineBlue", desc={"This sets the outline blue value of the shape, using a single value"}, params={@ParameterDoc(type=NumberDef.class, name="blue", desc={"the amount of blue between 0 - 255"})}, examples={"shape.setOutlineBlue(34);"})
    private Void setOutlineBlue(Arguments arguments) {
        ScriptShape.Outlined shape = (ScriptShape.Outlined)arguments.nextPrimitive((PrimitiveDefinition)this);
        int blue = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        shape.setOutlineBlue(blue);
        return null;
    }

    @FunctionDoc(name="setOutlineWidth", desc={"This sets the outline width of the shape, this should not be negative"}, params={@ParameterDoc(type=NumberDef.class, name="width", desc={"the width of the outline"})}, examples={"shape.setOutlineWidth(2);"})
    private Void setOutlineWidth(Arguments arguments) {
        ScriptShape.Outlined shape = (ScriptShape.Outlined)arguments.nextPrimitive((PrimitiveDefinition)this);
        int width = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        shape.setOutlineWidth(width);
        return null;
    }

    @FunctionDoc(name="getOutlineRed", desc={"This gets the outline red value of the shape"}, returns=@ReturnDoc(type=NumberDef.class, desc={"the red value of the outline"}), examples={"shape.getOutlineRed();"})
    private Number getOutlineRed(Arguments arguments) {
        return ((ScriptShape.Outlined)arguments.nextPrimitive((PrimitiveDefinition)this)).getRed();
    }

    @FunctionDoc(name="getOutlineGreen", desc={"This gets the outline green value of the shape"}, returns=@ReturnDoc(type=NumberDef.class, desc={"the green value of the outline"}), examples={"shape.getOutlineGreen();"})
    private Number getOutlineGreen(Arguments arguments) {
        return ((ScriptShape.Outlined)arguments.nextPrimitive((PrimitiveDefinition)this)).getGreen();
    }

    @FunctionDoc(name="getOutlineBlue", desc={"This gets the outline blue value of the shape"}, returns=@ReturnDoc(type=NumberDef.class, desc={"the blue value of the outline"}), examples={"shape.getOutlineBlue();"})
    private Number getOutlineBlue(Arguments arguments) {
        return ((ScriptShape.Outlined)arguments.nextPrimitive((PrimitiveDefinition)this)).getBlue();
    }

    @FunctionDoc(name="getOutlineWidth", desc={"This gets the outline width of the shape"}, returns=@ReturnDoc(type=NumberDef.class, desc={"the width of the outline"}), examples={"shape.getOutlineWidth();"})
    private Number getOutlineWidth(Arguments arguments) {
        return ((ScriptShape.Outlined)arguments.nextPrimitive((PrimitiveDefinition)this)).getOutlineWidth();
    }
}

