/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.clientscript.definitions.shapes;

import java.util.List;
import kotlin.Unit;
import me.senseiwells.arucas.api.docs.annotations.ClassDoc;
import me.senseiwells.arucas.api.docs.annotations.ConstructorDoc;
import me.senseiwells.arucas.api.docs.annotations.ParameterDoc;
import me.senseiwells.arucas.builtin.NumberDef;
import me.senseiwells.arucas.classes.CreatableDefinition;
import me.senseiwells.arucas.classes.PrimitiveDefinition;
import me.senseiwells.arucas.classes.instance.ClassInstance;
import me.senseiwells.arucas.functions.builtin.Arguments;
import me.senseiwells.arucas.functions.builtin.ConstructorFunction;
import me.senseiwells.arucas.interpreter.Interpreter;
import me.senseiwells.arucas.utils.misc.Language;
import me.senseiwells.essentialclient.clientscript.definitions.PosDef;
import me.senseiwells.essentialclient.clientscript.definitions.shapes.CorneredShapeDef;
import me.senseiwells.essentialclient.utils.clientscript.impl.ScriptLine;
import me.senseiwells.essentialclient.utils.clientscript.impl.ScriptPos;
import net.minecraft.class_243;
import org.jetbrains.annotations.NotNull;

@ClassDoc(name="LineShape", desc={"This class allows you to create a line shape which can be used to draw lines in the world."}, superclass=CorneredShapeDef.class, language=Language.Java)
public class LineShapeDef
extends CreatableDefinition<ScriptLine> {
    public LineShapeDef(Interpreter interpreter) {
        super("LineShape", interpreter);
    }

    @NotNull
    public PrimitiveDefinition<? super ScriptLine> superclass() {
        return this.getPrimitiveDef(CorneredShapeDef.class);
    }

    public List<ConstructorFunction> defineConstructors() {
        return List.of(ConstructorFunction.of((int)2, this::construct2), ConstructorFunction.of((int)6, this::construct6));
    }

    @ConstructorDoc(desc={"Creates a new line shape"}, params={@ParameterDoc(type=PosDef.class, name="pos1", desc={"The starting position of the line"}), @ParameterDoc(type=PosDef.class, name="pos2", desc={"The ending position of the line"})}, examples={"new LineShape(new Pos(0, 0, 0), new Pos(1, 1, 1));"})
    private Unit construct2(Arguments arguments) {
        ClassInstance instance = arguments.next();
        ScriptPos pos1 = (ScriptPos)arguments.nextPrimitive(PosDef.class);
        ScriptPos pos2 = (ScriptPos)arguments.nextPrimitive(PosDef.class);
        instance.setPrimitive((PrimitiveDefinition)this, (Object)new ScriptLine(arguments.getInterpreter(), pos1.getVec3d(), pos2.getVec3d()));
        return null;
    }

    @ConstructorDoc(desc={"Creates a new line shape"}, params={@ParameterDoc(type=NumberDef.class, name="x1", desc={"The x position of the starting position of the line"}), @ParameterDoc(type=NumberDef.class, name="y1", desc={"The y position of the starting position of the line"}), @ParameterDoc(type=NumberDef.class, name="z1", desc={"The z position of the starting position of the line"}), @ParameterDoc(type=NumberDef.class, name="x2", desc={"The x position of the ending position of the line"}), @ParameterDoc(type=NumberDef.class, name="y2", desc={"The y position of the ending position of the line"}), @ParameterDoc(type=NumberDef.class, name="z2", desc={"The z position of the ending position of the line"})}, examples={"new LineShape(0, 0, 0, 1, 1, 1);"})
    private Unit construct6(Arguments arguments) {
        ClassInstance instance = arguments.next();
        double x1 = (Double)arguments.nextPrimitive(NumberDef.class);
        double y1 = (Double)arguments.nextPrimitive(NumberDef.class);
        double z1 = (Double)arguments.nextPrimitive(NumberDef.class);
        double x2 = (Double)arguments.nextPrimitive(NumberDef.class);
        double y2 = (Double)arguments.nextPrimitive(NumberDef.class);
        double z2 = (Double)arguments.nextPrimitive(NumberDef.class);
        class_243 first = new class_243(x1, y1, z1);
        class_243 second = new class_243(x2, y2, z2);
        instance.setPrimitive((PrimitiveDefinition)this, (Object)new ScriptLine(arguments.getInterpreter(), first, second));
        return null;
    }
}

