/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.clientscript.definitions.shapes;

import java.util.EnumSet;
import java.util.List;
import me.senseiwells.arucas.api.docs.annotations.ClassDoc;
import me.senseiwells.arucas.api.docs.annotations.FunctionDoc;
import me.senseiwells.arucas.api.docs.annotations.ParameterDoc;
import me.senseiwells.arucas.api.docs.annotations.ReturnDoc;
import me.senseiwells.arucas.classes.PrimitiveDefinition;
import me.senseiwells.arucas.functions.builtin.Arguments;
import me.senseiwells.arucas.functions.builtin.MemberFunction;
import me.senseiwells.arucas.interpreter.Interpreter;
import me.senseiwells.arucas.utils.misc.Language;
import me.senseiwells.essentialclient.clientscript.definitions.PosDef;
import me.senseiwells.essentialclient.clientscript.definitions.shapes.OutlinedShapeDef;
import me.senseiwells.essentialclient.utils.clientscript.impl.ScriptPos;
import me.senseiwells.essentialclient.utils.clientscript.impl.ScriptShape;
import net.minecraft.class_2350;
import org.jetbrains.annotations.NotNull;

@ClassDoc(name="CorneredShape", desc={"This class represents all shapes that use 2 corners to dictate their position"}, superclass=OutlinedShapeDef.class, language=Language.Java)
public class CorneredShapeDef
extends PrimitiveDefinition<ScriptShape.Cornered> {
    public CorneredShapeDef(Interpreter interpreter) {
        super("CorneredShape", interpreter);
    }

    @NotNull
    public PrimitiveDefinition<? super ScriptShape.Cornered> superclass() {
        return this.getPrimitiveDef(OutlinedShapeDef.class);
    }

    public List<MemberFunction> defineMethods() {
        return List.of(MemberFunction.of((String)"setPos1", (int)1, this::setPos1), MemberFunction.of((String)"setPos2", (int)1, this::setPos2), MemberFunction.of((String)"getPos1", this::getPos1), MemberFunction.of((String)"getPos2", this::getPos2), MemberFunction.of((String)"centrePositions", this::centrePositions));
    }

    @FunctionDoc(name="setPos1", desc={"This sets the first position of the shape"}, params={@ParameterDoc(type=PosDef.class, name="pos1", desc={"the first position of the shape"})}, examples={"shape.setPos1(new Pos(1, 0, 100));"})
    private Void setPos1(Arguments arguments) {
        ScriptShape.Cornered shape = (ScriptShape.Cornered)arguments.nextPrimitive((PrimitiveDefinition)this);
        ScriptPos pos = (ScriptPos)arguments.nextPrimitive(PosDef.class);
        shape.setCornerA(pos.getVec3d());
        return null;
    }

    @FunctionDoc(name="setPos2", desc={"This sets the second position of the shape"}, params={@ParameterDoc(type=PosDef.class, name="pos2", desc={"the second position of the shape"})}, examples={"shape.setPos2(new Pos(1, 0, 100));"})
    private Void setPos2(Arguments arguments) {
        ScriptShape.Cornered shape = (ScriptShape.Cornered)arguments.nextPrimitive((PrimitiveDefinition)this);
        ScriptPos pos = (ScriptPos)arguments.nextPrimitive(PosDef.class);
        shape.setCornerB(pos.getVec3d());
        return null;
    }

    @FunctionDoc(name="getPos1", desc={"This gets the first position of the shape"}, returns=@ReturnDoc(type=PosDef.class, desc={"the first position of the shape"}), examples={"shape.getPos1();"})
    private ScriptPos getPos1(Arguments arguments) {
        ScriptShape.Cornered shape = (ScriptShape.Cornered)arguments.nextPrimitive((PrimitiveDefinition)this);
        return new ScriptPos(shape.getCornerA());
    }

    @FunctionDoc(name="getPos2", desc={"This gets the second position of the shape"}, returns=@ReturnDoc(type=PosDef.class, desc={"the second position of the shape"}), examples={"shape.getPos2();"})
    private ScriptPos getPos2(Arguments arguments) {
        ScriptShape.Cornered shape = (ScriptShape.Cornered)arguments.nextPrimitive((PrimitiveDefinition)this);
        return new ScriptPos(shape.getCornerB());
    }

    @FunctionDoc(name="centrePositions", desc={"This centres the positions of the shape"}, examples={"shape.centrePositions();"})
    private Void centrePositions(Arguments arguments) {
        ScriptShape.Cornered shape = (ScriptShape.Cornered)arguments.nextPrimitive((PrimitiveDefinition)this);
        shape.setCornerA(shape.getCornerA().method_1032(EnumSet.of(class_2350.class_2351.field_11048, class_2350.class_2351.field_11052, class_2350.class_2351.field_11051)));
        return null;
    }
}

