/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.clientscript.definitions.shapes;

import java.util.EnumSet;
import java.util.List;
import me.senseiwells.arucas.api.docs.annotations.ClassDoc;
import me.senseiwells.arucas.api.docs.annotations.FunctionDoc;
import me.senseiwells.arucas.api.docs.annotations.ParameterDoc;
import me.senseiwells.arucas.api.docs.annotations.ReturnDoc;
import me.senseiwells.arucas.builtin.NumberDef;
import me.senseiwells.arucas.classes.PrimitiveDefinition;
import me.senseiwells.arucas.functions.builtin.Arguments;
import me.senseiwells.arucas.functions.builtin.MemberFunction;
import me.senseiwells.arucas.interpreter.Interpreter;
import me.senseiwells.arucas.utils.misc.Language;
import me.senseiwells.essentialclient.clientscript.definitions.PosDef;
import me.senseiwells.essentialclient.clientscript.definitions.shapes.OutlinedShapeDef;
import me.senseiwells.essentialclient.utils.clientscript.impl.ScriptPos;
import me.senseiwells.essentialclient.utils.clientscript.impl.ScriptShape;
import net.minecraft.class_2350;
import org.jetbrains.annotations.NotNull;

@ClassDoc(name="CentredShape", desc={"This class represents shapes that are positioned centrally with a width"}, superclass=OutlinedShapeDef.class, language=Language.Java)
public class CentredShapeDef
extends PrimitiveDefinition<ScriptShape.Centred> {
    public CentredShapeDef(Interpreter interpreter) {
        super("CentredShape", interpreter);
    }

    @NotNull
    public PrimitiveDefinition<? super ScriptShape.Centred> superclass() {
        return this.getPrimitiveDef(OutlinedShapeDef.class);
    }

    public List<MemberFunction> defineMethods() {
        return List.of(MemberFunction.of((String)"setPos", (int)1, this::setPos), MemberFunction.of((String)"setWidth", (int)1, this::setWidth), MemberFunction.of((String)"getPos", this::getPos), MemberFunction.of((String)"getWidth", this::getWidth), MemberFunction.of((String)"centrePositions", this::centrePositions));
    }

    @FunctionDoc(name="setPos", desc={"This sets the central position of the shape"}, params={@ParameterDoc(type=PosDef.class, name="pos", desc={"the central position of the shape"})}, examples={"shape.setPos(new Pos(1, 0, 100));"})
    private Void setPos(Arguments arguments) {
        ScriptShape.Centred shape = (ScriptShape.Centred)arguments.nextPrimitive((PrimitiveDefinition)this);
        ScriptPos pos = (ScriptPos)arguments.nextPrimitive(PosDef.class);
        shape.setPosition(pos.getVec3d());
        return null;
    }

    @FunctionDoc(name="setWidth", desc={"This sets the width of the shape"}, params={@ParameterDoc(type=NumberDef.class, name="width", desc={"the width of the shape"})}, examples={"shape.setWidth(10.5);"})
    private Void setWidth(Arguments arguments) {
        ScriptShape.Centred shape = (ScriptShape.Centred)arguments.nextPrimitive((PrimitiveDefinition)this);
        float width = ((Double)arguments.nextPrimitive(NumberDef.class)).floatValue();
        shape.setWidth(width);
        return null;
    }

    @FunctionDoc(name="getPos", desc={"This gets the central position of the shape"}, returns=@ReturnDoc(type=PosDef.class, desc={"the central position of the shape"}), examples={"shape.getPos();"})
    private ScriptPos getPos(Arguments arguments) {
        ScriptShape.Centred shape = (ScriptShape.Centred)arguments.nextPrimitive((PrimitiveDefinition)this);
        return new ScriptPos(shape.getPosition());
    }

    @FunctionDoc(name="getWidth", desc={"This gets the width of the shape"}, returns=@ReturnDoc(type=NumberDef.class, desc={"the width of the shape"}), examples={"shape.getWidth();"})
    private float getWidth(Arguments arguments) {
        ScriptShape.Centred shape = (ScriptShape.Centred)arguments.nextPrimitive((PrimitiveDefinition)this);
        return shape.getWidth();
    }

    @FunctionDoc(name="centrePositions", desc={"This centres the positions of the shape"}, examples={"shape.centrePositions();"})
    private Void centrePositions(Arguments arguments) {
        ScriptShape.Centred shape = (ScriptShape.Centred)arguments.nextPrimitive((PrimitiveDefinition)this);
        shape.setPosition(shape.getPosition().method_1032(EnumSet.of(class_2350.class_2351.field_11048, class_2350.class_2351.field_11052, class_2350.class_2351.field_11051)));
        return null;
    }
}

