/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.clientscript.definitions.shapes;

import java.util.List;
import kotlin.Unit;
import me.senseiwells.arucas.api.docs.annotations.ClassDoc;
import me.senseiwells.arucas.api.docs.annotations.ConstructorDoc;
import me.senseiwells.arucas.api.docs.annotations.ParameterDoc;
import me.senseiwells.arucas.builtin.NumberDef;
import me.senseiwells.arucas.classes.CreatableDefinition;
import me.senseiwells.arucas.classes.PrimitiveDefinition;
import me.senseiwells.arucas.classes.instance.ClassInstance;
import me.senseiwells.arucas.functions.builtin.Arguments;
import me.senseiwells.arucas.functions.builtin.ConstructorFunction;
import me.senseiwells.arucas.interpreter.Interpreter;
import me.senseiwells.arucas.utils.misc.Language;
import me.senseiwells.essentialclient.clientscript.definitions.PosDef;
import me.senseiwells.essentialclient.clientscript.definitions.shapes.CorneredShapeDef;
import me.senseiwells.essentialclient.utils.clientscript.impl.ScriptBox;
import me.senseiwells.essentialclient.utils.clientscript.impl.ScriptPos;
import net.minecraft.class_243;
import org.jetbrains.annotations.NotNull;

@ClassDoc(name="BoxShape", desc={"This class allows you to create box shapes that can be rendered in the world."}, superclass=CorneredShapeDef.class, language=Language.Java)
public class BoxShapeDef
extends CreatableDefinition<ScriptBox> {
    public BoxShapeDef(Interpreter interpreter) {
        super("BoxShape", interpreter);
    }

    @NotNull
    public PrimitiveDefinition<? super ScriptBox> superclass() {
        return this.getPrimitiveDef(CorneredShapeDef.class);
    }

    public List<ConstructorFunction> defineConstructors() {
        return List.of(ConstructorFunction.of((int)1, this::construct1), ConstructorFunction.of((int)2, this::construct2), ConstructorFunction.of((int)3, this::construct3), ConstructorFunction.of((int)6, this::construct6));
    }

    @ConstructorDoc(desc={"Creates a new box shape, this is used to render boxes"}, params={@ParameterDoc(type=PosDef.class, name="pos", desc={"The position which will be used for the first and second corner of the box"})}, examples={"new BoxShape(new Pos(0, 0, 0));"})
    private Unit construct1(Arguments arguments) {
        ClassInstance instance = arguments.next();
        ScriptPos pos = (ScriptPos)arguments.nextPrimitive(PosDef.class);
        instance.setPrimitive((PrimitiveDefinition)this, (Object)new ScriptBox(arguments.getInterpreter(), pos.getVec3d(), pos.getVec3d()));
        return null;
    }

    @ConstructorDoc(desc={"Creates a new box shape, this is used to render boxes"}, params={@ParameterDoc(type=PosDef.class, name="pos1", desc={"The position of the first corner of the box"}), @ParameterDoc(type=PosDef.class, name="pos2", desc={"The position of the second corner of the box"})}, examples={"new BoxShape(new Pos(0, 0, 0), new Pos(10, 10, 10));"})
    private Unit construct2(Arguments arguments) {
        ClassInstance instance = arguments.next();
        ScriptPos pos1 = (ScriptPos)arguments.nextPrimitive(PosDef.class);
        ScriptPos pos2 = (ScriptPos)arguments.nextPrimitive(PosDef.class);
        instance.setPrimitive((PrimitiveDefinition)this, (Object)new ScriptBox(arguments.getInterpreter(), pos1.getVec3d(), pos2.getVec3d()));
        return null;
    }

    @ConstructorDoc(desc={"Creates a new box shape, this is used to render boxes"}, params={@ParameterDoc(type=NumberDef.class, name="x", desc={"The x position which will be used for the first and second corner of the box"}), @ParameterDoc(type=NumberDef.class, name="y", desc={"The y position which will be used for the first and second corner of the box"}), @ParameterDoc(type=NumberDef.class, name="z", desc={"The z position which will be used for the first and second corner of the box"})}, examples={"new BoxShape(0, 0, 0);"})
    private Unit construct3(Arguments arguments) {
        ClassInstance instance = arguments.next();
        double x = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        double y = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        double z = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        class_243 pos = new class_243(x, y, z);
        instance.setPrimitive((PrimitiveDefinition)this, (Object)new ScriptBox(arguments.getInterpreter(), pos, pos));
        return null;
    }

    @ConstructorDoc(desc={"Creates a new box shape, this is used to render boxes"}, params={@ParameterDoc(type=NumberDef.class, name="x1", desc={"The x position of the first corner of the box"}), @ParameterDoc(type=NumberDef.class, name="y1", desc={"The y position of the first corner of the box"}), @ParameterDoc(type=NumberDef.class, name="z1", desc={"The z position of the first corner of the box"}), @ParameterDoc(type=NumberDef.class, name="x2", desc={"The x position of the second corner of the box"}), @ParameterDoc(type=NumberDef.class, name="y2", desc={"The y position of the second corner of the box"}), @ParameterDoc(type=NumberDef.class, name="z2", desc={"The z position of the second corner of the box"})}, examples={"new BoxShape(0, 0, 0, 10, 10, 10);"})
    private Unit construct6(Arguments arguments) {
        ClassInstance instance = arguments.next();
        double x1 = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        double y1 = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        double z1 = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        double x2 = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        double y2 = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        double z2 = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        instance.setPrimitive((PrimitiveDefinition)this, (Object)new ScriptBox(arguments.getInterpreter(), new class_243(x1, y1, z1), new class_243(x2, y2, z2)));
        return null;
    }
}

