/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.clientscript.definitions;

import java.util.List;
import me.senseiwells.arucas.api.docs.annotations.ClassDoc;
import me.senseiwells.arucas.api.docs.annotations.FunctionDoc;
import me.senseiwells.arucas.api.docs.annotations.ParameterDoc;
import me.senseiwells.arucas.api.docs.annotations.ReturnDoc;
import me.senseiwells.arucas.builtin.BooleanDef;
import me.senseiwells.arucas.builtin.IterableDef;
import me.senseiwells.arucas.builtin.ListDef;
import me.senseiwells.arucas.builtin.NumberDef;
import me.senseiwells.arucas.builtin.StringDef;
import me.senseiwells.arucas.classes.CreatableDefinition;
import me.senseiwells.arucas.classes.PrimitiveDefinition;
import me.senseiwells.arucas.classes.instance.ClassInstance;
import me.senseiwells.arucas.compiler.LocatableTrace;
import me.senseiwells.arucas.exceptions.RuntimeError;
import me.senseiwells.arucas.functions.builtin.Arguments;
import me.senseiwells.arucas.functions.builtin.MemberFunction;
import me.senseiwells.arucas.interpreter.Interpreter;
import me.senseiwells.arucas.utils.impl.ArucasIterable;
import me.senseiwells.arucas.utils.impl.ArucasList;
import me.senseiwells.arucas.utils.misc.Language;
import me.senseiwells.essentialclient.clientscript.definitions.BiomeDef;
import me.senseiwells.essentialclient.clientscript.definitions.BlockDef;
import me.senseiwells.essentialclient.clientscript.definitions.EntityDef;
import me.senseiwells.essentialclient.clientscript.definitions.PlayerDef;
import me.senseiwells.essentialclient.clientscript.definitions.PosDef;
import me.senseiwells.essentialclient.utils.EssentialUtils;
import me.senseiwells.essentialclient.utils.clientscript.ClientScriptUtils;
import me.senseiwells.essentialclient.utils.clientscript.PosIterator;
import me.senseiwells.essentialclient.utils.clientscript.ThreadSafeUtils;
import me.senseiwells.essentialclient.utils.clientscript.impl.ScriptBlockState;
import me.senseiwells.essentialclient.utils.clientscript.impl.ScriptPos;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2400;
import net.minecraft.class_2680;
import net.minecraft.class_638;
import net.minecraft.class_640;
import net.minecraft.class_745;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

@ClassDoc(name="World", desc={"This class represents worlds, and allows you to interact with things inside of them."}, language=Language.Java)
public class WorldDef
extends CreatableDefinition<class_1937> {
    public WorldDef(Interpreter interpreter) {
        super("World", interpreter);
    }

    @NotNull
    public String toString(@NotNull ClassInstance instance, @NotNull Interpreter interpreter, @NotNull LocatableTrace trace) {
        class_1937 world = (class_1937)instance.asPrimitive((PrimitiveDefinition)this);
        return "World{level=" + String.valueOf(world) + "dimension=" + world.method_27983().method_29177().method_12832() + "}";
    }

    public List<MemberFunction> defineMethods() {
        return List.of(MemberFunction.of((String)"getBlockAt", (int)3, this::getBlockAt), MemberFunction.of((String)"getBlockAt", (int)1, this::getBlockAtPos), MemberFunction.of((String)"isLoaded", (int)1, this::isLoaded), MemberFunction.of((String)"getBiomeAt", (int)3, this::getBiomeAt), MemberFunction.of((String)"getBiomeAt", (int)1, this::getBiomeAtPos), MemberFunction.of((String)"getPlayer", (int)1, this::getPlayer), MemberFunction.of((String)"getAllPlayers", this::getAllPlayers), MemberFunction.of((String)"getOtherPlayer", (int)1, this::getOtherPlayer, (String)"Use '<World>.getPlayer(<String>)' instead"), MemberFunction.of((String)"getAllOtherPlayers", this::getAllOtherPlayers, (String)"Use '<World>.getAllPlayers()' instead"), MemberFunction.of((String)"getClosestPlayer", (int)2, this::getClosestPlayer), MemberFunction.of((String)"getAllEntities", this::getAllEntities), MemberFunction.of((String)"getEntityFromId", (int)1, this::getEntityFromId), MemberFunction.of((String)"getFullId", this::getFullId), MemberFunction.of((String)"getId", this::getId), MemberFunction.of((String)"getDimensionName", this::getDimensionName), MemberFunction.of((String)"isRaining", this::isRaining), MemberFunction.of((String)"isThundering", this::isThundering), MemberFunction.of((String)"getTimeOfDay", this::getTimeOfDay), MemberFunction.of((String)"renderParticle", (int)4, this::renderParticle), MemberFunction.of((String)"renderParticle", (int)2, this::renderParticlePos), MemberFunction.of((String)"renderParticle", (int)5, this::renderParticleVel), MemberFunction.of((String)"setGhostBlock", (int)4, this::setGhostBlock, (String)"This function is dangerous, be careful!"), MemberFunction.of((String)"setGhostBlock", (int)2, this::setGhostBlockPos, (String)"This function is dangerous, be careful!"), MemberFunction.of((String)"isAir", (int)3, this::isAir), MemberFunction.of((String)"isAir", (int)1, this::isAirPos), MemberFunction.of((String)"getEmittedRedstonePower", (int)4, this::getEmittedRedstonePower), MemberFunction.of((String)"getEmittedRedstonePower", (int)2, this::getEmittedRedstonePowerPos), MemberFunction.of((String)"getLight", (int)3, this::getLight), MemberFunction.of((String)"getLight", (int)1, this::getLightPos), MemberFunction.of((String)"getSkyLight", (int)1, this::getSkyLight), MemberFunction.of((String)"getBlockLight", (int)1, this::getBlockLight), MemberFunction.of((String)"getArea", (int)2, this::getArea, (String)"This function is memory intensive, use '<World>'.getPositions(pos1, pos2)"), MemberFunction.of((String)"getAreaOfBlocks", (int)2, this::getAreaOfBlocks, (String)"This function is memory intensive, use '<World>.getBlocks(pos1, pos2)'"), MemberFunction.of((String)"getPositions", (int)2, this::getPositions), MemberFunction.of((String)"getBlocks", (int)2, this::getBlocks), MemberFunction.of((String)"getPositionsFromCentre", (int)4, this::getPositionsFromCentre), MemberFunction.of((String)"getBlocksFromCentre", (int)4, this::getBlocksFromCentre), MemberFunction.of((String)"reloadChunks", this::reloadChunks));
    }

    @FunctionDoc(name="getBlockAt", desc={"This function gets the block at the given coordinates"}, params={@ParameterDoc(type=NumberDef.class, name="x", desc={"the x coordinate"}), @ParameterDoc(type=NumberDef.class, name="y", desc={"the y coordinate"}), @ParameterDoc(type=NumberDef.class, name="z", desc={"the z coordinate"})}, returns=@ReturnDoc(type=BlockDef.class, desc={"the block at the given coordinates"}), examples={"world.getBlockAt(0, 100, 0);"})
    private ScriptBlockState getBlockAt(Arguments arguments) {
        ClientScriptUtils.warnMainThread("getBlockAt", arguments.getInterpreter());
        class_1937 world = (class_1937)arguments.nextPrimitive((PrimitiveDefinition)this);
        int x = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        int y = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        int z = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        class_2338 blockPos = new class_2338(x, y, z);
        return new ScriptBlockState(world.method_8320(blockPos), blockPos);
    }

    @FunctionDoc(name="getBlockAt", desc={"This function gets the block at the given coordinates"}, params={@ParameterDoc(type=PosDef.class, name="pos", desc={"the position"})}, returns=@ReturnDoc(type=BlockDef.class, desc={"the block at the given coordinates"}), examples={"world.getBlockAt(new Pos(0, 100, 0));"})
    private ScriptBlockState getBlockAtPos(Arguments arguments) {
        ClientScriptUtils.warnMainThread("getBlockAt", arguments.getInterpreter());
        class_1937 world = (class_1937)arguments.nextPrimitive((PrimitiveDefinition)this);
        ScriptPos pos = (ScriptPos)arguments.nextPrimitive(PosDef.class);
        class_2338 blockPos = pos.getBlockPos();
        return new ScriptBlockState(world.method_8320(blockPos), blockPos);
    }

    @FunctionDoc(name="isLoaded", desc={"This function returns loaded state of given coordinates(client side)"}, params={@ParameterDoc(type=PosDef.class, name="pos", desc={"the position"})}, returns=@ReturnDoc(type=BooleanDef.class, desc={"whether the block is loaded at the given coordinates"}), examples={"world.isLoaded(new Pos(0, 100, 0));"})
    private boolean isLoaded(Arguments arguments) {
        ClientScriptUtils.warnMainThread("isLoaded", arguments.getInterpreter());
        class_1937 world = (class_1937)arguments.nextPrimitive((PrimitiveDefinition)this);
        ScriptPos pos = (ScriptPos)arguments.nextPrimitive(PosDef.class);
        class_2338 blockPos = pos.getBlockPos();
        return world.method_8398().method_12123(blockPos.method_10263() >> 4, blockPos.method_10260() >> 4);
    }

    @FunctionDoc(name="getBiomeAt", desc={"This function gets the biome at the given coordinates"}, params={@ParameterDoc(type=NumberDef.class, name="x", desc={"the x coordinate"}), @ParameterDoc(type=NumberDef.class, name="y", desc={"the y coordinate"}), @ParameterDoc(type=NumberDef.class, name="z", desc={"the z coordinate"})}, returns=@ReturnDoc(type=BiomeDef.class, desc={"the biome at the given coordinates"}), examples={"world.getBiomeAt(0, 100, 0);"})
    private class_1959 getBiomeAt(Arguments arguments) {
        ClientScriptUtils.warnMainThread("getBiomeAt", arguments.getInterpreter());
        class_1937 world = (class_1937)arguments.nextPrimitive((PrimitiveDefinition)this);
        int x = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        int y = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        int z = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        class_2338 blockPos = new class_2338(x, y, z);
        return (class_1959)world.method_23753(blockPos).comp_349();
    }

    @FunctionDoc(name="getBiomeAt", desc={"This function gets the biome at the given coordinates"}, params={@ParameterDoc(type=PosDef.class, name="pos", desc={"the position"})}, returns=@ReturnDoc(type=BiomeDef.class, desc={"the biome at the given coordinates"}), examples={"world.getBiomeAt(new Pos(0, 100, 0));"})
    private class_1959 getBiomeAtPos(Arguments arguments) {
        ClientScriptUtils.warnMainThread("getBiomeAt", arguments.getInterpreter());
        class_1937 world = (class_1937)arguments.nextPrimitive((PrimitiveDefinition)this);
        ScriptPos pos = (ScriptPos)arguments.nextPrimitive(PosDef.class);
        class_2338 blockPos = pos.getBlockPos();
        return (class_1959)world.method_23753(blockPos).comp_349();
    }

    @FunctionDoc(name="getPlayer", desc={"This function gets the player with the given name"}, params={@ParameterDoc(type=StringDef.class, name="name", desc={"the name of the player"})}, returns=@ReturnDoc(type=PlayerDef.class, desc={"the player with the given name"}), examples={"world.getPlayer('player');"})
    private class_1657 getPlayer(Arguments arguments) {
        ClientScriptUtils.warnMainThread("getPlayer", arguments.getInterpreter());
        class_1937 world = (class_1937)arguments.nextPrimitive((PrimitiveDefinition)this);
        String playerName = (String)arguments.nextPrimitive(StringDef.class);
        class_640 playerInfo = EssentialUtils.getNetworkHandler().method_2874(playerName);
        if (playerInfo != null) {
            return ThreadSafeUtils.getPlayerByUuid(world, playerInfo.method_2966().getId());
        }
        return null;
    }

    @FunctionDoc(name="getAllPlayers", desc={"This function gets all players in the world that are loaded"}, returns=@ReturnDoc(type=ListDef.class, desc={"all players in the world"}), examples={"world.getAllPlayers();"})
    private ArucasList getAllPlayers(Arguments arguments) {
        ClientScriptUtils.warnMainThread("getAllPlayers", arguments.getInterpreter());
        class_1937 world = (class_1937)arguments.nextPrimitive((PrimitiveDefinition)this);
        ArucasList players = new ArucasList();
        for (class_1657 playerEntity : ThreadSafeUtils.getPlayersSafe(world)) {
            players.add(arguments.getInterpreter().convertValue((Object)playerEntity));
        }
        return players;
    }

    @FunctionDoc(deprecated={"Use '<World>.getPlayer(name)' instead"}, name="getOtherPlayer", desc={"This gets another player from the given username"}, params={@ParameterDoc(type=StringDef.class, name="username", desc={"the username of the other player"})}, returns=@ReturnDoc(type=PlayerDef.class, desc={"the other player, null if not found"}), examples={"world.getOtherPlayer('senseiwells');"})
    private class_1657 getOtherPlayer(Arguments arguments) {
        class_1657 player;
        ClientScriptUtils.warnMainThread("getOtherPlayer", arguments.getInterpreter());
        class_1937 world = (class_1937)arguments.nextPrimitive((PrimitiveDefinition)this);
        String playerName = (String)arguments.nextPrimitive(StringDef.class);
        class_640 playerInfo = EssentialUtils.getNetworkHandler().method_2874(playerName);
        if (playerInfo != null && (player = ThreadSafeUtils.getPlayerByUuid(world, playerInfo.method_2966().getId())) instanceof class_745) {
            class_745 otherClientPlayerEntity = (class_745)player;
            return otherClientPlayerEntity;
        }
        return null;
    }

    @FunctionDoc(deprecated={"Use '<World>.getAllPlayers()' instead"}, name="getAllOtherPlayers", desc={"This will get all other players in the world"}, returns=@ReturnDoc(type=ListDef.class, desc={"a list of all other players"}), examples={"world.getAllOtherPlayers();"})
    private ArucasList getAllOtherPlayers(Arguments arguments) {
        ClientScriptUtils.warnMainThread("getAllOtherPlayers", arguments.getInterpreter());
        class_1937 world = (class_1937)arguments.nextPrimitive((PrimitiveDefinition)this);
        ArucasList otherPlayerValueList = new ArucasList();
        for (class_1657 playerEntity : ThreadSafeUtils.getPlayersSafe(world)) {
            if (!(playerEntity instanceof class_745)) continue;
            class_745 otherClientPlayerEntity = (class_745)playerEntity;
            otherPlayerValueList.add(arguments.getInterpreter().convertValue((Object)otherClientPlayerEntity));
        }
        return otherPlayerValueList;
    }

    @FunctionDoc(name="getClosestPlayer", desc={"This will get the closest player to another entity in the world"}, params={@ParameterDoc(type=EntityDef.class, name="entity", desc={"the entity to get the closest player to"}), @ParameterDoc(type=NumberDef.class, name="maxDistance", desc={"the maximum distance to search for a player in blocks"})}, returns=@ReturnDoc(type=PlayerDef.class, desc={"the closest player, null if not found"}), examples={"world.getClosestPlayer(Player.get(), 100);"})
    private class_1657 getClosestPlayer(Arguments arguments) {
        ClientScriptUtils.warnMainThread("getClosestPlayer", arguments.getInterpreter());
        class_1937 world = (class_1937)arguments.nextPrimitive((PrimitiveDefinition)this);
        class_1297 entity = (class_1297)arguments.nextPrimitive(EntityDef.class);
        double distance = (Double)arguments.nextPrimitive(NumberDef.class);
        return ThreadSafeUtils.getClosestPlayer(world, entity, distance);
    }

    @FunctionDoc(name="getAllEntities", desc={"This will get all entities in the world"}, returns=@ReturnDoc(type=ListDef.class, desc={"a list of all entities"}), examples={"world.getAllEntities();"})
    private ArucasList getAllEntities(Arguments arguments) {
        ClientScriptUtils.warnMainThread("getAllEntities", arguments.getInterpreter());
        class_1937 world = (class_1937)arguments.nextPrimitive((PrimitiveDefinition)this);
        ArucasList valueList = new ArucasList();
        if (world instanceof class_638) {
            class_638 clientWorld = (class_638)world;
            for (class_1297 entity : ThreadSafeUtils.getEntitiesSafe(clientWorld)) {
                valueList.add(arguments.getInterpreter().convertValue((Object)entity));
            }
        }
        return valueList;
    }

    @FunctionDoc(name="getEntityFromId", desc={"This will get an entity from the given entity id"}, params={@ParameterDoc(type=NumberDef.class, name="entityId", desc={"the entity id"})}, returns=@ReturnDoc(type=EntityDef.class, desc={"the entity, null if not found"}), examples={"world.getEntityFromId(1);"})
    private Object getEntityFromId(Arguments arguments) {
        class_1937 world = (class_1937)arguments.nextPrimitive((PrimitiveDefinition)this);
        int id = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        return world.method_8469(id);
    }

    @FunctionDoc(name="getFullId", desc={"This will get the full id of the world"}, returns=@ReturnDoc(type=StringDef.class, desc={"the full id of the world, for example: 'minecraft:overworld'"}), examples={"world.getFullId();"})
    private String getFullId(Arguments arguments) {
        return ((class_1937)arguments.nextPrimitive((PrimitiveDefinition)this)).method_27983().method_29177().toString();
    }

    @FunctionDoc(name="getId", desc={"This will get the id of the world"}, returns=@ReturnDoc(type=StringDef.class, desc={"the id of the world, for example: 'overworld'"}), examples={"world.getId();"})
    private String getId(Arguments arguments) {
        return ((class_1937)arguments.nextPrimitive((PrimitiveDefinition)this)).method_27983().method_29177().method_12832();
    }

    @FunctionDoc(deprecated={"You should use 'world.getId()' instead"}, name="getDimensionName", desc={"This will get the id of the world"}, returns=@ReturnDoc(type=StringDef.class, desc={"the id of the world, for example: 'overworld'"}), examples={"world.getDimensionName();"})
    private String getDimensionName(Arguments arguments) {
        return ((class_1937)arguments.nextPrimitive((PrimitiveDefinition)this)).method_27983().method_29177().method_12832();
    }

    @FunctionDoc(name="isRaining", desc={"This will check if the world is currently raining"}, returns=@ReturnDoc(type=BooleanDef.class, desc={"true if the world is currently raining"}), examples={"world.isRaining();"})
    private boolean isRaining(Arguments arguments) {
        return ((class_1937)arguments.nextPrimitive((PrimitiveDefinition)this)).method_8419();
    }

    @FunctionDoc(name="isThundering", desc={"This will check if the world is currently thundering"}, returns=@ReturnDoc(type=BooleanDef.class, desc={"true if the world is currently thundering"}), examples={"world.isThundering();"})
    private boolean isThundering(Arguments arguments) {
        return ((class_1937)arguments.nextPrimitive((PrimitiveDefinition)this)).method_8546();
    }

    @FunctionDoc(name="getTimeOfDay", desc={"This will get the time of day of the world", "info on the time of day [here](https://minecraft.fandom.com/wiki/Daylight_cycle)"}, returns=@ReturnDoc(type=NumberDef.class, desc={"the time of day of the world, between 0 and 24000"}), examples={"world.getTimeOfDay();"})
    private long getTimeOfDay(Arguments arguments) {
        return ((class_1937)arguments.nextPrimitive((PrimitiveDefinition)this)).method_8532();
    }

    @FunctionDoc(name="renderParticle", desc={"This will render a particle in the world, you can find a list of all", "the particle ids [here](https://minecraft.fandom.com/wiki/Java_Edition_data_values#Particles),", "if the id is invalid it will throw an error"}, params={@ParameterDoc(type=StringDef.class, name="particleId", desc={"the id of the particle"}), @ParameterDoc(type=NumberDef.class, name="x", desc={"the x position of the particle"}), @ParameterDoc(type=NumberDef.class, name="y", desc={"the y position of the particle"}), @ParameterDoc(type=NumberDef.class, name="z", desc={"the z position of the particle"})}, examples={"world.renderParticle('end_rod', 10, 10, 10);"})
    private Void renderParticle(Arguments arguments) {
        class_1937 world = (class_1937)arguments.nextPrimitive((PrimitiveDefinition)this);
        String particleName = (String)arguments.nextPrimitive(StringDef.class);
        class_2396 particleType = (class_2396)class_7923.field_41180.method_10223(ClientScriptUtils.stringToIdentifier(particleName));
        if (!(particleType instanceof class_2400)) {
            throw new RuntimeError("Particle Invalid");
        }
        class_2400 defaultParticleType = (class_2400)particleType;
        double x = (Double)arguments.nextPrimitive(NumberDef.class);
        double y = (Double)arguments.nextPrimitive(NumberDef.class);
        double z = (Double)arguments.nextPrimitive(NumberDef.class);
        ClientScriptUtils.ensureMainThread("renderParticle", arguments.getInterpreter(), () -> world.method_8406((class_2394)defaultParticleType, x, y, z, 0.0, 0.0, 0.0));
        return null;
    }

    @FunctionDoc(name="renderParticle", desc={"This will render a particle in the world, you can find a list of all", "the particle ids [here](https://minecraft.fandom.com/wiki/Java_Edition_data_values#Particles),", "this will throw an error if the id is invalid"}, params={@ParameterDoc(type=StringDef.class, name="particleId", desc={"the id of the particle"}), @ParameterDoc(type=PosDef.class, name="pos", desc={"the position of the particle"})}, examples={"world.renderParticle('end_rod', pos);"})
    private Void renderParticlePos(Arguments arguments) {
        class_1937 world = (class_1937)arguments.nextPrimitive((PrimitiveDefinition)this);
        String particleName = (String)arguments.nextPrimitive(StringDef.class);
        class_2396 particleType = (class_2396)class_7923.field_41180.method_10223(ClientScriptUtils.stringToIdentifier(particleName));
        if (!(particleType instanceof class_2400)) {
            throw new RuntimeError("Particle Invalid");
        }
        class_2400 defaultParticleType = (class_2400)particleType;
        ScriptPos pos = (ScriptPos)arguments.nextPrimitive(PosDef.class);
        ClientScriptUtils.ensureMainThread("renderParticle", arguments.getInterpreter(), () -> world.method_8406((class_2394)defaultParticleType, pos.getX(), pos.getY(), pos.getZ(), 0.0, 0.0, 0.0));
        return null;
    }

    @FunctionDoc(name="renderParticle", desc={"This will render a particle in the world with a velocity, you can find a list of all", "the particle ids [here](https://minecraft.fandom.com/wiki/Java_Edition_data_values#Particles),", "this will throw an error if the id is invalid"}, params={@ParameterDoc(type=StringDef.class, name="particleId", desc={"the id of the particle"}), @ParameterDoc(type=PosDef.class, name="pos", desc={"the position of the particle"}), @ParameterDoc(type=NumberDef.class, name="velX", desc={"the velocity of the particle on the x axis"}), @ParameterDoc(type=NumberDef.class, name="velY", desc={"the velocity of the particle on the y axis"}), @ParameterDoc(type=NumberDef.class, name="velZ", desc={"the velocity of the particle on the z axis"})}, examples={"world.renderParticle('end_rod', pos, 0.5, 0.5, 0.5);"})
    private Void renderParticleVel(Arguments arguments) {
        class_1937 world = (class_1937)arguments.nextPrimitive((PrimitiveDefinition)this);
        String particleName = (String)arguments.nextPrimitive(StringDef.class);
        class_2396 particleType = (class_2396)class_7923.field_41180.method_10223(ClientScriptUtils.stringToIdentifier(particleName));
        if (!(particleType instanceof class_2400)) {
            throw new RuntimeError("Particle Invalid");
        }
        class_2400 defaultParticleType = (class_2400)particleType;
        ScriptPos pos = (ScriptPos)arguments.nextPrimitive(PosDef.class);
        double velX = (Double)arguments.nextPrimitive(NumberDef.class);
        double velY = (Double)arguments.nextPrimitive(NumberDef.class);
        double velZ = (Double)arguments.nextPrimitive(NumberDef.class);
        ClientScriptUtils.ensureMainThread("renderParticle", arguments.getInterpreter(), () -> world.method_8406((class_2394)defaultParticleType, pos.getX(), pos.getY(), pos.getZ(), velX, velY, velZ));
        return null;
    }

    @FunctionDoc(deprecated={"This function is dangerous, use at your own risk"}, name="setGhostBlock", desc={"This sets a ghost block in the world as if it were a real block, may cause issues"}, params={@ParameterDoc(type=BlockDef.class, name="block", desc={"the block to set"}), @ParameterDoc(type=NumberDef.class, name="x", desc={"the x position of the block"}), @ParameterDoc(type=NumberDef.class, name="y", desc={"the y position of the block"}), @ParameterDoc(type=NumberDef.class, name="z", desc={"the z position of the block"})}, examples={"world.setGhostBlock(Material.BEDROCK.asBlock(), 0, 100, 0);"})
    private Void setGhostBlock(Arguments arguments) {
        class_1937 world = (class_1937)arguments.nextPrimitive((PrimitiveDefinition)this);
        ScriptBlockState blockState = (ScriptBlockState)arguments.nextPrimitive(BlockDef.class);
        int x = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        int y = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        int z = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        class_2338 blockPos = new class_2338(x, y, z);
        ClientScriptUtils.ensureMainThread("setGhostBlock", arguments.getInterpreter(), () -> world.method_8501(blockPos, blockState.state));
        return null;
    }

    @FunctionDoc(deprecated={"This function is dangerous, use at your own risk"}, name="setGhostBlock", desc={"This sets a ghost block in the world as if it were a real block, may cause issues"}, params={@ParameterDoc(type=BlockDef.class, name="block", desc={"the block to set"}), @ParameterDoc(type=PosDef.class, name="pos", desc={"the position of the block"})}, examples={"world.setGhostBlock(Material.BEDROCK.asBlock(), new Pos(0, 100, 0));"})
    private Void setGhostBlockPos(Arguments arguments) {
        class_1937 world = (class_1937)arguments.nextPrimitive((PrimitiveDefinition)this);
        ScriptBlockState blockState = (ScriptBlockState)arguments.nextPrimitive(BlockDef.class);
        ScriptPos pos = (ScriptPos)arguments.nextPrimitive(PosDef.class);
        ClientScriptUtils.ensureMainThread("setGhostBlock", arguments.getInterpreter(), () -> world.method_8501(pos.getBlockPos(), blockState.state));
        return null;
    }

    @FunctionDoc(name="isAir", desc={"Returns true if the block at the given position is air"}, params={@ParameterDoc(type=NumberDef.class, name="x", desc={"the x position of the block"}), @ParameterDoc(type=NumberDef.class, name="y", desc={"the y position of the block"}), @ParameterDoc(type=NumberDef.class, name="z", desc={"the z position of the block"})}, returns=@ReturnDoc(type=BooleanDef.class, desc={"true if the block is air"}), examples={"world.isAir(0, 100, 0);"})
    private boolean isAir(Arguments arguments) {
        ClientScriptUtils.warnMainThread("isAir", arguments.getInterpreter());
        class_1937 world = (class_1937)arguments.nextPrimitive((PrimitiveDefinition)this);
        int x = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        int y = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        int z = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        return world.method_22347(new class_2338(x, y, z));
    }

    @FunctionDoc(name="isAir", desc={"Returns true if the block at the given position is air"}, params={@ParameterDoc(type=PosDef.class, name="pos", desc={"the position of the block"})}, returns=@ReturnDoc(type=BooleanDef.class, desc={"true if the block is air"}), examples={"world.isAir(new Pos(0, 100, 0));"})
    private boolean isAirPos(Arguments arguments) {
        ClientScriptUtils.warnMainThread("isAir", arguments.getInterpreter());
        class_1937 world = (class_1937)arguments.nextPrimitive((PrimitiveDefinition)this);
        ScriptPos pos = (ScriptPos)arguments.nextPrimitive(PosDef.class);
        return world.method_22347(pos.getBlockPos());
    }

    @FunctionDoc(name="getEmittedRedstonePower", desc={"Gets the emitted restone power at the given position and direction"}, params={@ParameterDoc(type=NumberDef.class, name="x", desc={"the x position of the block"}), @ParameterDoc(type=NumberDef.class, name="y", desc={"the y position of the block"}), @ParameterDoc(type=NumberDef.class, name="z", desc={"the z position of the block"}), @ParameterDoc(type=StringDef.class, name="direction", desc={"the direction to check, for example 'north', 'east', 'up', etc."})}, returns=@ReturnDoc(type=NumberDef.class, desc={"the emitted redstone power"}), examples={"world.getEmittedRedstonePower(0, 100, 0, 'north');"})
    private int getEmittedRedstonePower(Arguments arguments) {
        ClientScriptUtils.warnMainThread("getEmittedRedstonePower", arguments.getInterpreter());
        class_1937 world = (class_1937)arguments.nextPrimitive((PrimitiveDefinition)this);
        int x = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        int y = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        int z = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        String stringDirection = arguments.nextConstant();
        class_2338 blockPos = new class_2338(x, y, z);
        class_2350 direction = ClientScriptUtils.stringToDirection(stringDirection, class_2350.field_11033);
        return world.method_49808(blockPos, direction);
    }

    @FunctionDoc(name="getEmittedRedstonePower", desc={"Gets the emitted restone power at the given position and direction"}, params={@ParameterDoc(type=PosDef.class, name="pos", desc={"the position of the block"}), @ParameterDoc(type=StringDef.class, name="direction", desc={"the direction to check, for example 'north', 'east', 'up', etc."})}, returns=@ReturnDoc(type=NumberDef.class, desc={"the emitted redstone power"}), examples={"world.getEmittedRedstonePower(new Pos(0, 100, 0), 'north');"})
    private int getEmittedRedstonePowerPos(Arguments arguments) {
        ClientScriptUtils.warnMainThread("getEmittedRedstonePower", arguments.getInterpreter());
        class_1937 world = (class_1937)arguments.nextPrimitive((PrimitiveDefinition)this);
        ScriptPos pos = (ScriptPos)arguments.nextPrimitive(PosDef.class);
        String stringDirection = arguments.nextConstant();
        class_2350 direction = ClientScriptUtils.stringToDirection(stringDirection, class_2350.field_11033);
        return world.method_49808(pos.getBlockPos(), direction);
    }

    @FunctionDoc(name="getLight", desc={"Gets the light level at the given position, takes the max of either sky light of block light"}, params={@ParameterDoc(type=NumberDef.class, name="x", desc={"the x position of the block"}), @ParameterDoc(type=NumberDef.class, name="y", desc={"the y position of the block"}), @ParameterDoc(type=NumberDef.class, name="z", desc={"the z position of the block"})}, returns=@ReturnDoc(type=NumberDef.class, desc={"the light level between 0 - 15"}), examples={"world.getLight(0, 100, 0);"})
    private int getLight(Arguments arguments) {
        ClientScriptUtils.warnMainThread("getLight", arguments.getInterpreter());
        class_1937 world = (class_1937)arguments.nextPrimitive((PrimitiveDefinition)this);
        int x = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        int y = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        int z = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        return world.method_22339(new class_2338(x, y, z));
    }

    @FunctionDoc(name="getLight", desc={"Gets the light level at the given position, takes the max of either sky light of block light"}, params={@ParameterDoc(type=PosDef.class, name="pos", desc={"the position of the block"})}, returns=@ReturnDoc(type=NumberDef.class, desc={"the light level between 0 - 15"}), examples={"world.getLight(new Pos(0, 100, 0));"})
    private int getLightPos(Arguments arguments) {
        ClientScriptUtils.warnMainThread("getLight", arguments.getInterpreter());
        class_1937 world = (class_1937)arguments.nextPrimitive((PrimitiveDefinition)this);
        ScriptPos pos = (ScriptPos)arguments.nextPrimitive(PosDef.class);
        return world.method_22339(pos.getBlockPos());
    }

    @FunctionDoc(name="getSkyLight", desc={"Gets the sky light at the given position ignoring block light"}, params={@ParameterDoc(type=PosDef.class, name="pos", desc={"the position of the block"})}, returns=@ReturnDoc(type=NumberDef.class, desc={"the light level between 0 - 15"}), examples={"world.getSkyLight(new Pos(0, 0, 0));"})
    private int getSkyLight(Arguments arguments) {
        ClientScriptUtils.warnMainThread("getSkyLight", arguments.getInterpreter());
        class_1937 world = (class_1937)arguments.nextPrimitive((PrimitiveDefinition)this);
        ScriptPos pos = (ScriptPos)arguments.nextPrimitive(PosDef.class);
        return world.method_8314(class_1944.field_9284, pos.getBlockPos());
    }

    @FunctionDoc(name="getBlockLight", desc={"Gets the block light at the given position ignoring sky light"}, params={@ParameterDoc(type=PosDef.class, name="pos", desc={"the position of the block"})}, returns=@ReturnDoc(type=NumberDef.class, desc={"the light level between 0 - 15"}), examples={"world.getBlockLight(new Pos(0, 0, 0));"})
    private int getBlockLight(Arguments arguments) {
        ClientScriptUtils.warnMainThread("getBlockLight", arguments.getInterpreter());
        class_1937 world = (class_1937)arguments.nextPrimitive((PrimitiveDefinition)this);
        ScriptPos pos = (ScriptPos)arguments.nextPrimitive(PosDef.class);
        return world.method_8314(class_1944.field_9282, pos.getBlockPos());
    }

    @FunctionDoc(deprecated={"This function is memory intensive, you should use `<World>.getPositions(pos1, pos2)`"}, name="getArea", desc={"This gets a list of all block positions between the two positions"}, params={@ParameterDoc(type=PosDef.class, name="pos1", desc={"the first position"}), @ParameterDoc(type=PosDef.class, name="pos2", desc={"the second position"})}, returns=@ReturnDoc(type=ListDef.class, desc={"the list of positions"}), examples={"world.getArea(new Pos(0, 100, 0), new Pos(0, 100, 0));"})
    private ArucasList getArea(Arguments arguments) {
        ClientScriptUtils.warnMainThread("getArea", arguments.getInterpreter());
        class_2338 posA = ((ScriptPos)arguments.skip().nextPrimitive(PosDef.class)).getBlockPos();
        class_2338 posB = ((ScriptPos)arguments.nextPrimitive(PosDef.class)).getBlockPos();
        ArucasList list = new ArucasList();
        Interpreter interpreter = arguments.getInterpreter();
        for (class_2338 pos : class_2338.method_10097((class_2338)posA, (class_2338)posB)) {
            list.add(interpreter.create(PosDef.class, (Object)new ScriptPos(pos)));
        }
        return list;
    }

    @FunctionDoc(deprecated={"This function is memory intensive, you should use `<World>.getBlocks(pos1, pos2)`"}, name="getAreaOfBlocks", desc={"This gets a list of all blocks (with positions) between the two positions"}, params={@ParameterDoc(type=PosDef.class, name="pos1", desc={"the first position"}), @ParameterDoc(type=PosDef.class, name="pos2", desc={"the second position"})}, returns=@ReturnDoc(type=ListDef.class, desc={"the list of blocks"}), examples={"world.getAreaOfBlocks(new Pos(0, 100, 0), new Pos(0, 100, 0));"})
    private Object getAreaOfBlocks(Arguments arguments) {
        ClientScriptUtils.warnMainThread("getAreaOfBlocks", arguments.getInterpreter());
        class_1937 world = (class_1937)arguments.nextPrimitive((PrimitiveDefinition)this);
        class_2338 posA = ((ScriptPos)arguments.nextPrimitive(PosDef.class)).getBlockPos();
        class_2338 posB = ((ScriptPos)arguments.nextPrimitive(PosDef.class)).getBlockPos();
        ArucasList list = new ArucasList();
        Interpreter interpreter = arguments.getInterpreter();
        for (class_2338 pos : class_2338.method_10097((class_2338)posA, (class_2338)posB)) {
            class_2680 state = world.method_8320(pos);
            list.add(interpreter.create(BlockDef.class, (Object)new ScriptBlockState(state, pos)));
        }
        return list;
    }

    @FunctionDoc(name="getPositions", desc={"This gets an iterator for all positions between two positions"}, params={@ParameterDoc(type=PosDef.class, name="pos1", desc={"the first position"}), @ParameterDoc(type=PosDef.class, name="pos2", desc={"the second position"})}, returns=@ReturnDoc(type=IterableDef.class, desc={"the iterator for the positions"}), examples={"foreach (pos : world.getPositions(new Pos(0, 100, 100), new Pos(0, 100, 0)));"})
    private ArucasIterable getPositions(Arguments arguments) {
        class_2338 posA = ((ScriptPos)arguments.skip().nextPrimitive(PosDef.class)).getBlockPos();
        class_2338 posB = ((ScriptPos)arguments.nextPrimitive(PosDef.class)).getBlockPos();
        Iterable posIterable = class_2338.method_10097((class_2338)posA, (class_2338)posB);
        return () -> new PosIterator(posIterable.iterator(), o -> arguments.getInterpreter().convertValue(o));
    }

    @FunctionDoc(name="getBlocks", desc={"This gets an iterator for all blocks (and positions) between two positions"}, params={@ParameterDoc(type=PosDef.class, name="pos1", desc={"the first position"}), @ParameterDoc(type=PosDef.class, name="pos2", desc={"the second position"})}, returns=@ReturnDoc(type=IterableDef.class, desc={"the iterator for the blocks"}), examples={"foreach (block : world.getBlocks(new Pos(0, 100, 100), new Pos(0, 100, 0)));"})
    private ArucasIterable getBlocks(Arguments arguments) {
        class_1937 world = (class_1937)arguments.nextPrimitive((PrimitiveDefinition)this);
        class_2338 posA = ((ScriptPos)arguments.nextPrimitive(PosDef.class)).getBlockPos();
        class_2338 posB = ((ScriptPos)arguments.nextPrimitive(PosDef.class)).getBlockPos();
        Iterable posIterable = class_2338.method_10097((class_2338)posA, (class_2338)posB);
        return () -> new PosIterator.Block(world, posIterable.iterator(), o -> arguments.getInterpreter().convertValue(o));
    }

    @FunctionDoc(name="getPositionsFromCentre", desc={"This gets an iterator for all positions between two positions.", "The iterator iterates from the centre outwards"}, params={@ParameterDoc(type=PosDef.class, name="centre", desc={"the central position"}), @ParameterDoc(type=NumberDef.class, name="xRange", desc={"how far to iterate on the x axis"}), @ParameterDoc(type=NumberDef.class, name="yRange", desc={"how far to iterate on the y axis"}), @ParameterDoc(type=NumberDef.class, name="zRange", desc={"how far to iterate on the z axis"})}, returns=@ReturnDoc(type=IterableDef.class, desc={"the iterator for the positions"}), examples={"foreach (pos : world.getPositionsFromCentre(new Pos(0, 100, 100), 10, 10, 10));"})
    private ArucasIterable getPositionsFromCentre(Arguments arguments) {
        class_2338 posA = ((ScriptPos)arguments.skip().nextPrimitive(PosDef.class)).getBlockPos();
        int x = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        int y = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        int z = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        Iterable posIterable = class_2338.method_25996((class_2338)posA, (int)x, (int)y, (int)z);
        return () -> new PosIterator(posIterable.iterator(), o -> arguments.getInterpreter().convertValue(o));
    }

    @FunctionDoc(name="getBlocksFromCentre", desc={"This gets an iterator for all blocks (and positions) between two positions.", "The iterator iterates from the centre outwards"}, params={@ParameterDoc(type=PosDef.class, name="centre", desc={"the central position"}), @ParameterDoc(type=NumberDef.class, name="xRange", desc={"how far to iterate on the x axis"}), @ParameterDoc(type=NumberDef.class, name="yRange", desc={"how far to iterate on the y axis"}), @ParameterDoc(type=NumberDef.class, name="zRange", desc={"how far to iterate on the z axis"})}, returns=@ReturnDoc(type=IterableDef.class, desc={"the iterator for the blocks"}), examples={"foreach (block : world.getBlocksFromCentre(new Pos(0, 100, 100), 10, 5, 60));"})
    private ArucasIterable getBlocksFromCentre(Arguments arguments) {
        class_1937 world = (class_1937)arguments.nextPrimitive((PrimitiveDefinition)this);
        class_2338 posA = ((ScriptPos)arguments.nextPrimitive(PosDef.class)).getBlockPos();
        int x = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        int y = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        int z = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        Iterable posIterable = class_2338.method_25996((class_2338)posA, (int)x, (int)y, (int)z);
        return () -> new PosIterator.Block(world, posIterable.iterator(), o -> arguments.getInterpreter().convertValue(o));
    }

    @FunctionDoc(name="reloadChunks", desc={"This reloads all the chunks, as if you were to press F3 + A."}, examples={"world.reloadChunks();"})
    private Void reloadChunks(Arguments arguments) {
        ClientScriptUtils.ensureMainThread("reloadChunks", arguments.getInterpreter(), () -> EssentialUtils.getClient().field_1769.method_3279());
        return null;
    }
}

