/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.clientscript.definitions;

import java.util.List;
import java.util.Optional;
import me.senseiwells.arucas.api.docs.annotations.ClassDoc;
import me.senseiwells.arucas.api.docs.annotations.FunctionDoc;
import me.senseiwells.arucas.api.docs.annotations.ReturnDoc;
import me.senseiwells.arucas.builtin.NumberDef;
import me.senseiwells.arucas.classes.CreatableDefinition;
import me.senseiwells.arucas.classes.PrimitiveDefinition;
import me.senseiwells.arucas.classes.instance.ClassInstance;
import me.senseiwells.arucas.compiler.LocatableTrace;
import me.senseiwells.arucas.functions.builtin.Arguments;
import me.senseiwells.arucas.functions.builtin.MemberFunction;
import me.senseiwells.arucas.interpreter.Interpreter;
import me.senseiwells.arucas.utils.misc.Language;
import me.senseiwells.essentialclient.clientscript.definitions.ItemStackDef;
import me.senseiwells.essentialclient.utils.clientscript.impl.ScriptItemStack;
import me.senseiwells.essentialclient.utils.inventory.InventoryUtils;
import net.minecraft.class_1799;
import net.minecraft.class_1914;
import org.jetbrains.annotations.NotNull;

@ClassDoc(name="Trade", desc={"This class represents a trade offer, and allows you to get information about it."}, language=Language.Java)
public class TradeDef
extends CreatableDefinition<class_1914> {
    public TradeDef(Interpreter interpreter) {
        super("Trade", interpreter);
    }

    public boolean equals(@NotNull ClassInstance instance, @NotNull Interpreter interpreter, @NotNull ClassInstance other, @NotNull LocatableTrace trace) {
        class_1914 otherOffer = (class_1914)other.getPrimitive((PrimitiveDefinition)this);
        return otherOffer != null && InventoryUtils.areTradesEqual((class_1914)instance.asPrimitive((PrimitiveDefinition)this), otherOffer);
    }

    public List<MemberFunction> defineMethods() {
        return List.of(MemberFunction.of((String)"getSellItem", this::getSellItem), MemberFunction.of((String)"getFirstBuyItem", this::getFirstBuyItem), MemberFunction.of((String)"getAdjustedFirstBuyItem", this::getAdjustedFirstBuyItem), MemberFunction.of((String)"getSecondBuyItem", this::getSecondBuyItem), MemberFunction.of((String)"getMaxUses", this::getMaxUses), MemberFunction.of((String)"getUses", this::getUses), MemberFunction.of((String)"getSpecialPrice", this::getSpecialPrice), MemberFunction.of((String)"getPriceMultiplier", this::getPriceMultiplier), MemberFunction.of((String)"getXpReward", this::getXpReward));
    }

    @FunctionDoc(name="getSellItem", desc={"Gets the item that is being sold by the merchant"}, returns=@ReturnDoc(type=ItemStackDef.class, desc={"the item for sale"}), examples={"trade.getSellItem();"})
    public ScriptItemStack getSellItem(Arguments arguments) {
        class_1914 offer = (class_1914)arguments.nextPrimitive((PrimitiveDefinition)this);
        return new ScriptItemStack(offer.method_8250());
    }

    @FunctionDoc(name="getFirstBuyItem", desc={"Gets the first item that the merchant will buy"}, returns=@ReturnDoc(type=ItemStackDef.class, desc={"the first item to buy"}), examples={"trade.getFirstBuyItem();"})
    public ScriptItemStack getFirstBuyItem(Arguments arguments) {
        class_1914 offer = (class_1914)arguments.nextPrimitive((PrimitiveDefinition)this);
        return new ScriptItemStack(offer.method_8246());
    }

    @FunctionDoc(name="getAdjustedFirstBuyItem", desc={"Gets the first item that the merchant will buy, adjusted by the price multiplier"}, returns=@ReturnDoc(type=ItemStackDef.class, desc={"the first item to buy"}), examples={"trade.getAdjustedFirstBuyItem();"})
    public ScriptItemStack getAdjustedFirstBuyItem(Arguments arguments) {
        class_1914 offer = (class_1914)arguments.nextPrimitive((PrimitiveDefinition)this);
        return new ScriptItemStack(offer.method_19272());
    }

    @FunctionDoc(name="getSecondBuyItem", desc={"Gets the second item that the merchant will buy"}, returns=@ReturnDoc(type=ItemStackDef.class, desc={"the second item to buy"}), examples={"trade.getSecondBuyItem();"})
    public ScriptItemStack getSecondBuyItem(Arguments arguments) {
        class_1914 offer = (class_1914)arguments.nextPrimitive((PrimitiveDefinition)this);
        Optional traded = offer.method_57557();
        return traded.map(item -> new ScriptItemStack(item.comp_2427())).orElseGet(() -> new ScriptItemStack(class_1799.field_8037));
    }

    @FunctionDoc(name="getMaxUses", desc={"Gets the maximum number of times the trade can be used"}, returns=@ReturnDoc(type=NumberDef.class, desc={"the maximum number of uses"}), examples={"trade.getMaxUses();"})
    public int getMaxUses(Arguments arguments) {
        class_1914 offer = (class_1914)arguments.nextPrimitive((PrimitiveDefinition)this);
        return offer.method_8248();
    }

    @FunctionDoc(name="getUses", desc={"Gets the number of times the trade has been used"}, returns=@ReturnDoc(type=NumberDef.class, desc={"the number of uses"}), examples={"trade.getUses();"})
    public int getUses(Arguments arguments) {
        class_1914 offer = (class_1914)arguments.nextPrimitive((PrimitiveDefinition)this);
        return offer.method_8249();
    }

    @FunctionDoc(name="getSpecialPrice", desc={"This gets the special price which is used to adjust the price of the first buy item"}, returns=@ReturnDoc(type=NumberDef.class, desc={"the special price"}), examples={"trade.getSpecialPrice();"})
    public int getSpecialPrice(Arguments arguments) {
        class_1914 offer = (class_1914)arguments.nextPrimitive((PrimitiveDefinition)this);
        return offer.method_19277();
    }

    @FunctionDoc(name="getPriceMultiplier", desc={"Gets the price multiplier which is used to adjust the price of the first buy item"}, returns=@ReturnDoc(type=NumberDef.class, desc={"the price multiplier"}), examples={"trade.getPriceMultiplier();"})
    public float getPriceMultiplier(Arguments arguments) {
        class_1914 offer = (class_1914)arguments.nextPrimitive((PrimitiveDefinition)this);
        return offer.method_19278();
    }

    @FunctionDoc(name="getXpReward", desc={"Returns the amount of xp the villager will get, which", "goes towards them levelling up, from trading this offer"}, returns=@ReturnDoc(type=NumberDef.class, desc={"the amount of xp"}), examples={"trade.getXpReward"})
    private int getXpReward(Arguments arguments) {
        class_1914 offer = (class_1914)arguments.nextPrimitive((PrimitiveDefinition)this);
        return offer.method_19279();
    }
}

