/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.clientscript.definitions;

import com.google.gson.JsonElement;
import java.util.List;
import me.senseiwells.arucas.api.docs.annotations.ClassDoc;
import me.senseiwells.arucas.api.docs.annotations.FunctionDoc;
import me.senseiwells.arucas.api.docs.annotations.ParameterDoc;
import me.senseiwells.arucas.api.docs.annotations.ReturnDoc;
import me.senseiwells.arucas.builtin.ObjectDef;
import me.senseiwells.arucas.builtin.StringDef;
import me.senseiwells.arucas.classes.ClassDefinition;
import me.senseiwells.arucas.classes.CreatableDefinition;
import me.senseiwells.arucas.classes.PrimitiveDefinition;
import me.senseiwells.arucas.classes.instance.ClassInstance;
import me.senseiwells.arucas.compiler.LocatableTrace;
import me.senseiwells.arucas.extensions.JsonDef;
import me.senseiwells.arucas.functions.builtin.Arguments;
import me.senseiwells.arucas.functions.builtin.BuiltInFunction;
import me.senseiwells.arucas.functions.builtin.MemberFunction;
import me.senseiwells.arucas.interpreter.Interpreter;
import me.senseiwells.arucas.utils.JsonUtils;
import me.senseiwells.arucas.utils.misc.Language;
import me.senseiwells.essentialclient.utils.clientscript.ClientScriptUtils;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_7887;
import org.jetbrains.annotations.NotNull;

@ClassDoc(name="Text", desc={"This class is used to create formatted strings used inside Minecraft."}, language=Language.Java)
public class TextDef
extends CreatableDefinition<class_5250> {
    public TextDef(Interpreter interpreter) {
        super("Text", interpreter);
    }

    @NotNull
    public String toString(@NotNull ClassInstance instance, @NotNull Interpreter interpreter, @NotNull LocatableTrace trace) {
        return "Text{text=" + ((class_5250)instance.asPrimitive((PrimitiveDefinition)this)).getString() + "}";
    }

    public List<BuiltInFunction> defineStaticMethods() {
        return List.of(BuiltInFunction.of((String)"of", (int)1, this::of), BuiltInFunction.of((String)"parse", (int)1, this::parse));
    }

    @FunctionDoc(isStatic=true, name="of", desc={"This converts a string into a text instance"}, params={@ParameterDoc(type=StringDef.class, name="string", desc={"The string to convert into a text instance"})}, returns=@ReturnDoc(type=TextDef.class, desc={"the text instance from the string"}), examples={"Text.of('Hello World!');"})
    private class_2561 of(Arguments arguments) {
        return class_2561.method_43470((String)((String)arguments.nextPrimitive(StringDef.class)));
    }

    @FunctionDoc(isStatic=true, name="parse", desc={"This converts a text json into a text instance"}, params={@ParameterDoc(type=StringDef.class, name="textJson", desc={"The string in json format, or a Json value itself"})}, returns=@ReturnDoc(type=TextDef.class, desc={"the text instance from the json"}), examples={"Text.parse('{\"text\":\"Hello World!\",\"color\":\"white\",\"italic\":\"true\"}');"})
    private Object parse(Arguments arguments) {
        if (arguments.isNext(JsonDef.class)) {
            return class_2561.class_2562.method_10877((String)JsonUtils.GSON.toJson((JsonElement)arguments.nextPrimitive(JsonDef.class)), (class_7225.class_7874)class_7887.method_46817());
        }
        return class_2561.class_2562.method_10877((String)((String)arguments.nextPrimitive(StringDef.class)), (class_7225.class_7874)class_7887.method_46817());
    }

    public List<MemberFunction> defineMethods() {
        return List.of(MemberFunction.of((String)"withClickEvent", (int)2, this::withClickEvent), MemberFunction.of((String)"withHoverEvent", (int)2, this::withHoverEvent), MemberFunction.of((String)"format", (int)1, this::formatText), MemberFunction.of((String)"append", (int)1, this::appendText));
    }

    @FunctionDoc(name="withClickEvent", desc={"This allows you to add a click event to a text instance.", "The possible events are: 'open_url', 'open_file', 'run_command', 'suggest_command', 'copy_to_clipboard', 'run_function'.", "This will throw an error if the action is invalid"}, params={@ParameterDoc(type=StringDef.class, name="event", desc={"the name of the event"}), @ParameterDoc(type=StringDef.class, name="value", desc={"the value associated with the event"})}, returns=@ReturnDoc(type=TextDef.class, desc={"the text instance with the click event"}), examples={"text = Text.of(\"Hello World!\");\n\n// Examples of click events\ntext.withClickEvent(\"open_url\", \"https://youtu.be/dQw4w9WgXcQ\");\ntext.withClickEvent(\"open_file\", \"C:/Users/user/Desktop/thing.txt\");\ntext.withClickEvent(\"run_command\", \"/gamemode creative\");\ntext.withClickEvent(\"suggest_command\", \"/gamemode survival\");\ntext.withClickEvent(\"copy_to_clipboard\", \"Ooops!\");\ntext.withClickEvent(\"run_function\", fun() {\n\tprint(\"Text was clicked!\");\n});\n"})
    private ClassInstance withClickEvent(Arguments arguments) {
        ClassInstance instance = arguments.next((ClassDefinition)this);
        class_5250 text = (class_5250)instance.asPrimitive((PrimitiveDefinition)this);
        String actionAsString = arguments.nextConstant();
        class_2558 clickEvent = ClientScriptUtils.stringToClickEvent(arguments.getInterpreter(), actionAsString, arguments.next());
        text.method_27694(style -> style.method_10958(clickEvent));
        return instance;
    }

    @FunctionDoc(name="withHoverEvent", desc={"This allows you to add a hover event to a text instance.", "The possible events are: 'show_text', 'show_item', 'show_entity'.", "This will throw an error if the event is invalid"}, params={@ParameterDoc(type=StringDef.class, name="event", desc={"the name of the event"}), @ParameterDoc(type=ObjectDef.class, name="value", desc={"the value associated with the event"})}, returns=@ReturnDoc(type=TextDef.class, desc={"the text instance with the hover event"}), examples={"text = Text.of(\"Hello World!\");\n\n// Examples of hover events\ntext.withHoverEvent(\"show_text\", Text.of(\"Hello world!\"));\ntext.withHoverEvent(\"show_item\", Material.DIAMOND_SWORD.asItemStack());\ntext.withHoverEvent(\"show_entity\", Player.get());\n"})
    private ClassInstance withHoverEvent(Arguments arguments) {
        ClassInstance instance = arguments.next((ClassDefinition)this);
        class_5250 text = (class_5250)instance.asPrimitive((PrimitiveDefinition)this);
        String action = arguments.nextConstant();
        class_2568 hoverEvent = ClientScriptUtils.stringToHoverEvent(action, arguments.next());
        text.method_27694(style -> style.method_10949(hoverEvent));
        return instance;
    }

    @FunctionDoc(name="format", desc={"This allows you to add a formatting to a text instance.", "A list of formatting names can be found [here](https://minecraft.fandom.com/wiki/Formatting_codes).", "This will throw an error if the formatting is invalid"}, params={@ParameterDoc(type=StringDef.class, name="formatting", desc={"the name of the formatting"})}, returns=@ReturnDoc(type=TextDef.class, desc={"the text instance with the formatting added"}), examples={"text.format('DARK_RED').format('BOLD');"})
    private ClassInstance formatText(Arguments arguments) {
        ClassInstance instance = arguments.next((ClassDefinition)this);
        class_5250 text = (class_5250)instance.asPrimitive((PrimitiveDefinition)this);
        String string = arguments.nextConstant();
        class_124 formatting = ClientScriptUtils.stringToFormatting(string);
        text.method_27692(formatting);
        return instance;
    }

    @FunctionDoc(name="append", desc={"This allows you to append a text instance to another text instance"}, params={@ParameterDoc(type=TextDef.class, name="otherText", desc={"the text instance to append to"})}, returns=@ReturnDoc(type=TextDef.class, desc={"the text instance with the appended text"}), examples={"Text.of('Hello').append(Text.of(' world!'));"})
    private ClassInstance appendText(Arguments arguments) {
        ClassInstance instance = arguments.next((ClassDefinition)this);
        class_5250 text = (class_5250)instance.asPrimitive((PrimitiveDefinition)this);
        class_5250 other = (class_5250)arguments.nextPrimitive((PrimitiveDefinition)this);
        text.method_10852((class_2561)other);
        return instance;
    }
}

