/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.clientscript.definitions;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import me.senseiwells.arucas.api.docs.annotations.ClassDoc;
import me.senseiwells.arucas.api.docs.annotations.FunctionDoc;
import me.senseiwells.arucas.api.docs.annotations.ParameterDoc;
import me.senseiwells.arucas.api.docs.annotations.ReturnDoc;
import me.senseiwells.arucas.builtin.ListDef;
import me.senseiwells.arucas.builtin.StringDef;
import me.senseiwells.arucas.classes.CreatableDefinition;
import me.senseiwells.arucas.classes.PrimitiveDefinition;
import me.senseiwells.arucas.classes.instance.ClassInstance;
import me.senseiwells.arucas.compiler.LocatableTrace;
import me.senseiwells.arucas.exceptions.RuntimeError;
import me.senseiwells.arucas.functions.builtin.Arguments;
import me.senseiwells.arucas.functions.builtin.BuiltInFunction;
import me.senseiwells.arucas.functions.builtin.MemberFunction;
import me.senseiwells.arucas.interpreter.Interpreter;
import me.senseiwells.arucas.utils.impl.ArucasList;
import me.senseiwells.arucas.utils.misc.Language;
import me.senseiwells.essentialclient.clientscript.definitions.ItemStackDef;
import me.senseiwells.essentialclient.utils.EssentialUtils;
import me.senseiwells.essentialclient.utils.clientscript.ClientScriptUtils;
import me.senseiwells.essentialclient.utils.clientscript.impl.ScriptItemStack;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_2960;
import net.minecraft.class_634;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import org.jetbrains.annotations.NotNull;

@ClassDoc(name="Recipe", desc={"This class represents recipes in Minecraft."}, language=Language.Java)
public class RecipeDef
extends CreatableDefinition<class_8786<class_1860<?>>> {
    public RecipeDef(Interpreter interpreter) {
        super("Recipe", interpreter);
    }

    @NotNull
    public String toString(@NotNull ClassInstance instance, @NotNull Interpreter interpreter, @NotNull LocatableTrace trace) {
        return "Recipe{id=" + String.valueOf(((class_8786)instance.asPrimitive((PrimitiveDefinition)this)).comp_1932()) + "}";
    }

    public List<PrimitiveDefinition.PrimitiveField> defineStaticFields() {
        class_634 networkHandler = EssentialUtils.getNetworkHandler();
        if (networkHandler == null) {
            return super.defineStaticFields();
        }
        TreeMap<String, ClassInstance> map = new TreeMap<String, ClassInstance>();
        for (class_8786 recipe : networkHandler.method_2877().method_8126()) {
            ClassInstance instance = this.create(recipe);
            map.put(recipe.toString().toUpperCase(), instance);
        }
        ArucasList list = new ArucasList();
        ArrayList<PrimitiveDefinition.PrimitiveField> fields = new ArrayList<PrimitiveDefinition.PrimitiveField>(map.size());
        map.forEach((key, value) -> {
            list.add(value);
            fields.add(new PrimitiveDefinition.PrimitiveField(key, value, false));
        });
        fields.add(new PrimitiveDefinition.PrimitiveField("ALL", (Object)list, false));
        return fields;
    }

    public List<BuiltInFunction> defineStaticMethods() {
        return List.of(BuiltInFunction.of((String)"of", (int)1, this::of));
    }

    @FunctionDoc(isStatic=true, name="of", desc={"This converts a recipe id into a Recipe if it's valid,", "otherwise an error will be thrown"}, params={@ParameterDoc(type=StringDef.class, name="recipeId", desc={"the id of the recipe to convert to a Recipe"})}, returns=@ReturnDoc(type=RecipeDef.class, desc={"the recipe instance from the id"}), examples={"Recipe.of('redstone_block')"})
    private class_8786<?> of(Arguments arguments) {
        String id = (String)arguments.nextPrimitive(StringDef.class);
        class_634 networkHandler = EssentialUtils.getNetworkHandler();
        class_2960 identifier = ClientScriptUtils.stringToIdentifier(id);
        Optional recipe = networkHandler.method_2877().method_8130(identifier);
        if (recipe.isEmpty()) {
            throw new RuntimeError("Recipe with id '%s' doesn't exist".formatted(id));
        }
        return (class_8786)recipe.get();
    }

    public List<MemberFunction> defineMethods() {
        return List.of(MemberFunction.of((String)"getFullId", this::getFullId), MemberFunction.of((String)"getId", this::getId), MemberFunction.of((String)"getCraftingType", this::getCraftingType), MemberFunction.of((String)"getOutput", this::getOutput), MemberFunction.of((String)"getIngredients", this::getIngredients));
    }

    @FunctionDoc(name="getFullId", desc={"This returns the full id of the recipe"}, returns=@ReturnDoc(type=StringDef.class, desc={"the full id of the recipe"}), examples={"recipe.getFullId()"})
    private String getFullId(Arguments arguments) {
        class_8786 recipe = (class_8786)arguments.nextPrimitive((PrimitiveDefinition)this);
        return recipe.comp_1932().toString();
    }

    @FunctionDoc(name="getId", desc={"This returns the id of the recipe"}, returns=@ReturnDoc(type=StringDef.class, desc={"the id of the recipe"}), examples={"recipe.getId()"})
    private String getId(Arguments arguments) {
        class_8786 recipe = (class_8786)arguments.nextPrimitive((PrimitiveDefinition)this);
        return recipe.comp_1932().toString();
    }

    @FunctionDoc(name="getCraftingType", desc={"This returns the crafting type of the recipe"}, returns=@ReturnDoc(type=StringDef.class, desc={"the crafting type of the recipe, for example: 'crafting', 'smelting', 'blasting'"}), examples={"recipe.getCraftingType()"})
    private String getCraftingType(Arguments arguments) {
        class_8786 recipe = (class_8786)arguments.nextPrimitive((PrimitiveDefinition)this);
        class_2960 identifier = class_7923.field_41188.method_10221((Object)recipe.comp_1933().method_17716());
        return identifier == null ? null : identifier.method_12832();
    }

    @FunctionDoc(name="getOutput", desc={"This returns the output of the recipe"}, returns=@ReturnDoc(type=ItemStackDef.class, desc={"the output of the recipe"}), examples={"recipe.getOutput()"})
    private ScriptItemStack getOutput(Arguments arguments) {
        class_8786 recipe = (class_8786)arguments.nextPrimitive((PrimitiveDefinition)this);
        return new ScriptItemStack(recipe.comp_1933().method_8110((class_7225.class_7874)EssentialUtils.getRegistryManager()));
    }

    @FunctionDoc(name="getIngredients", desc={"This returns all the possible ingredients of the recipe"}, returns=@ReturnDoc(type=ListDef.class, desc={"list of lists, each inner lists contains possible recipe items"}), examples={"recipe.getIngredients()"})
    private ArucasList getIngredients(Arguments arguments) {
        class_8786 recipe = (class_8786)arguments.nextPrimitive((PrimitiveDefinition)this);
        ArucasList recipeIngredients = new ArucasList();
        Interpreter interpreter = arguments.getInterpreter();
        for (class_1856 ingredient : recipe.comp_1933().method_8117()) {
            ArucasList slotIngredients = new ArucasList();
            for (class_1799 itemStack : ingredient.method_8105()) {
                slotIngredients.add(interpreter.create(ItemStackDef.class, (Object)new ScriptItemStack(itemStack)));
            }
            recipeIngredients.add(interpreter.create(ListDef.class, (Object)slotIngredients));
        }
        return recipeIngredients;
    }
}

