/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.clientscript.definitions;

import java.util.List;
import kotlin.Unit;
import me.senseiwells.arucas.api.docs.annotations.ClassDoc;
import me.senseiwells.arucas.api.docs.annotations.ConstructorDoc;
import me.senseiwells.arucas.api.docs.annotations.FunctionDoc;
import me.senseiwells.arucas.api.docs.annotations.ParameterDoc;
import me.senseiwells.arucas.api.docs.annotations.ReturnDoc;
import me.senseiwells.arucas.builtin.BooleanDef;
import me.senseiwells.arucas.builtin.ListDef;
import me.senseiwells.arucas.builtin.NumberDef;
import me.senseiwells.arucas.builtin.StringDef;
import me.senseiwells.arucas.classes.CreatableDefinition;
import me.senseiwells.arucas.classes.PrimitiveDefinition;
import me.senseiwells.arucas.classes.instance.ClassInstance;
import me.senseiwells.arucas.compiler.LocatableTrace;
import me.senseiwells.arucas.exceptions.RuntimeError;
import me.senseiwells.arucas.functions.builtin.Arguments;
import me.senseiwells.arucas.functions.builtin.ConstructorFunction;
import me.senseiwells.arucas.functions.builtin.MemberFunction;
import me.senseiwells.arucas.interpreter.Interpreter;
import me.senseiwells.arucas.utils.impl.ArucasList;
import me.senseiwells.arucas.utils.misc.Language;
import me.senseiwells.essentialclient.clientscript.definitions.EntityDef;
import me.senseiwells.essentialclient.utils.clientscript.ClientScriptUtils;
import me.senseiwells.essentialclient.utils.clientscript.impl.ScriptPos;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import org.jetbrains.annotations.NotNull;

@ClassDoc(name="Pos", desc={"This class is a wrapper for 3 coordinate points in Minecraft"}, language=Language.Java)
public class PosDef
extends CreatableDefinition<ScriptPos> {
    public PosDef(Interpreter interpreter) {
        super("Pos", interpreter);
    }

    public Object asJavaValue(ClassInstance instance) {
        return ((ScriptPos)instance.asPrimitive((PrimitiveDefinition)this)).getVec3d();
    }

    public boolean equals(@NotNull ClassInstance instance, @NotNull Interpreter interpreter, @NotNull ClassInstance other, @NotNull LocatableTrace trace) {
        ScriptPos pos = (ScriptPos)other.getPrimitive((PrimitiveDefinition)this);
        return pos != null && ((ScriptPos)instance.asPrimitive((PrimitiveDefinition)this)).getVec3d().equals((Object)pos.getVec3d());
    }

    public int hashCode(@NotNull ClassInstance instance, @NotNull Interpreter interpreter, @NotNull LocatableTrace trace) {
        return ((ScriptPos)instance.asPrimitive((PrimitiveDefinition)this)).getVec3d().hashCode();
    }

    @NotNull
    public String toString(@NotNull ClassInstance instance, @NotNull Interpreter interpreter, @NotNull LocatableTrace trace) {
        return ((ScriptPos)instance.asPrimitive((PrimitiveDefinition)this)).getVec3d().toString();
    }

    public List<ConstructorFunction> defineConstructors() {
        return List.of(ConstructorFunction.of((int)1, this::construct1), ConstructorFunction.of((int)3, this::construct3));
    }

    @ConstructorDoc(desc={"Creates a new Pos object with the given coordinates in a list"}, params={@ParameterDoc(type=ListDef.class, name="list", desc={"the list containing three coordinates"})}, examples={"new Pos([1, 2, 3])"})
    private Unit construct1(Arguments arguments) {
        ClassInstance instance = arguments.next();
        ArucasList list = (ArucasList)arguments.nextPrimitive(ListDef.class);
        if (list.size() != 3) {
            throw new RuntimeError("Expected a list with 3 coordinates");
        }
        double[] coords = new double[3];
        for (int i = 0; i < 3; ++i) {
            Double value = (Double)list.get(i).getPrimitive(NumberDef.class);
            if (value == null) {
                throw new RuntimeError("Expected a number at index " + i);
            }
            coords[i] = value;
        }
        instance.setPrimitive((PrimitiveDefinition)this, (Object)new ScriptPos(coords[0], coords[1], coords[2]));
        return null;
    }

    @ConstructorDoc(desc={"This creates a new Pos with the given x, y, and z"}, params={@ParameterDoc(type=NumberDef.class, name="x", desc={"the x position"}), @ParameterDoc(type=NumberDef.class, name="y", desc={"the y position"}), @ParameterDoc(type=NumberDef.class, name="z", desc={"the z position"})}, examples={"new Pos(100, 0, 96);"})
    private Unit construct3(Arguments arguments) {
        ClassInstance instance = arguments.next();
        double x = (Double)arguments.nextPrimitive(NumberDef.class);
        double y = (Double)arguments.nextPrimitive(NumberDef.class);
        double z = (Double)arguments.nextPrimitive(NumberDef.class);
        instance.setPrimitive((PrimitiveDefinition)this, (Object)new ScriptPos(x, y, z));
        return null;
    }

    public List<MemberFunction> defineMethods() {
        return List.of(MemberFunction.of((String)"getX", this::getX), MemberFunction.of((String)"getY", this::getY), MemberFunction.of((String)"getZ", this::getZ), MemberFunction.of((String)"multiply", (int)3, this::multiply), MemberFunction.of((String)"multiply", (int)1, this::multiply1), MemberFunction.of((String)"add", (int)3, this::add), MemberFunction.of((String)"add", (int)1, this::add1), MemberFunction.of((String)"subtract", (int)3, this::subtract), MemberFunction.of((String)"subtract", (int)1, this::subtract1), MemberFunction.of((String)"dotProduct", (int)1, this::dotProduct), MemberFunction.of((String)"crossProduct", (int)1, this::crossProduct), MemberFunction.of((String)"toBlockPos", this::toBlockPos), MemberFunction.of((String)"toList", this::toList), MemberFunction.of((String)"offset", (int)1, this::offset), MemberFunction.of((String)"offset", (int)2, this::offset1), MemberFunction.of((String)"up", this::up), MemberFunction.of((String)"up", (int)1, this::up1), MemberFunction.of((String)"down", this::down), MemberFunction.of((String)"down", (int)1, this::down1), MemberFunction.of((String)"north", this::north), MemberFunction.of((String)"north", (int)1, this::north1), MemberFunction.of((String)"south", this::south), MemberFunction.of((String)"south", (int)1, this::south1), MemberFunction.of((String)"east", this::east), MemberFunction.of((String)"east", (int)1, this::east1), MemberFunction.of((String)"west", this::west), MemberFunction.of((String)"west", (int)1, this::west1), MemberFunction.of((String)"getSidePos", (int)1, this::getSidePos), MemberFunction.of((String)"asCentre", this::asCentre), MemberFunction.of((String)"isNear", (int)1, this::isNear), MemberFunction.of((String)"isWithin", (int)2, this::isWithin), MemberFunction.of((String)"distanceTo", (int)1, this::distanceTo), MemberFunction.of((String)"distanceTo", (int)3, this::distanceTo1), MemberFunction.of((String)"normalize", (int)0, this::normalize));
    }

    @FunctionDoc(name="getX", desc={"This returns the x position of the Pos"}, returns=@ReturnDoc(type=NumberDef.class, desc={"the x position"}), examples={"pos.getX();"})
    private double getX(Arguments arguments) {
        return ((ScriptPos)arguments.nextPrimitive((PrimitiveDefinition)this)).getX();
    }

    @FunctionDoc(name="getY", desc={"This returns the y position of the Pos"}, returns=@ReturnDoc(type=NumberDef.class, desc={"the y position"}), examples={"pos.getY();"})
    private double getY(Arguments arguments) {
        return ((ScriptPos)arguments.nextPrimitive((PrimitiveDefinition)this)).getY();
    }

    @FunctionDoc(name="getZ", desc={"This returns the z position of the Pos"}, returns=@ReturnDoc(type=NumberDef.class, desc={"the z position"}), examples={"pos.getZ();"})
    private double getZ(Arguments arguments) {
        return ((ScriptPos)arguments.nextPrimitive((PrimitiveDefinition)this)).getZ();
    }

    @FunctionDoc(name="multiply", desc={"This returns a new Pos with the current pos x, y, and z multiplied by the given x, y, and z"}, params={@ParameterDoc(type=NumberDef.class, name="x", desc={"the x multiplier"}), @ParameterDoc(type=NumberDef.class, name="y", desc={"the y multiplier"}), @ParameterDoc(type=NumberDef.class, name="z", desc={"the z multiplier"})}, returns=@ReturnDoc(type=PosDef.class, desc={"the new Pos"}), examples={"pos.multiply(2, 3, 5);"})
    private class_243 multiply(Arguments arguments) {
        ScriptPos pos = (ScriptPos)arguments.nextPrimitive((PrimitiveDefinition)this);
        double x = (Double)arguments.nextPrimitive(NumberDef.class);
        double y = (Double)arguments.nextPrimitive(NumberDef.class);
        double z = (Double)arguments.nextPrimitive(NumberDef.class);
        return pos.getVec3d().method_18805(x, y, z);
    }

    @FunctionDoc(name="multiply", desc={"This returns a new Pos with the current pos x, y, and z multiplied by the given pos x, y, and z"}, params={@ParameterDoc(type=PosDef.class, name="pos", desc={"the Pos to multiply by"})}, returns=@ReturnDoc(type=PosDef.class, desc={"the new Pos"}), examples={"pos.multiply(new Pos(2, 3, 5));"})
    private class_243 multiply1(Arguments arguments) {
        ScriptPos pos = (ScriptPos)arguments.nextPrimitive((PrimitiveDefinition)this);
        ScriptPos other = (ScriptPos)arguments.nextPrimitive((PrimitiveDefinition)this);
        return pos.getVec3d().method_18806(other.getVec3d());
    }

    @FunctionDoc(name="subtract", desc={"This returns a new Pos with the current pos x, y, and z subtracted by the given x, y, and z"}, params={@ParameterDoc(type=NumberDef.class, name="x", desc={"the x subtractor"}), @ParameterDoc(type=NumberDef.class, name="y", desc={"the y subtractor"}), @ParameterDoc(type=NumberDef.class, name="z", desc={"the z subtractor"})}, returns=@ReturnDoc(type=PosDef.class, desc={"the new Pos"}), examples={"pos.subtract(2, 3, 5);"})
    private class_243 subtract(Arguments arguments) {
        ScriptPos pos = (ScriptPos)arguments.nextPrimitive((PrimitiveDefinition)this);
        double x = (Double)arguments.nextPrimitive(NumberDef.class);
        double y = (Double)arguments.nextPrimitive(NumberDef.class);
        double z = (Double)arguments.nextPrimitive(NumberDef.class);
        return pos.getVec3d().method_1023(x, y, z);
    }

    @FunctionDoc(name="subtract", desc={"This returns a new Pos with the current pos x, y, and z subtracted by the given pos x, y, and z"}, params={@ParameterDoc(type=PosDef.class, name="pos", desc={"the Pos to subtract by"})}, returns=@ReturnDoc(type=PosDef.class, desc={"the new Pos"}), examples={"pos.subtract(new Pos(2, 3, 5));"})
    private class_243 subtract1(Arguments arguments) {
        ScriptPos pos = (ScriptPos)arguments.nextPrimitive((PrimitiveDefinition)this);
        ScriptPos other = (ScriptPos)arguments.nextPrimitive((PrimitiveDefinition)this);
        return pos.getVec3d().method_1020(other.getVec3d());
    }

    @FunctionDoc(name="add", desc={"This returns a new Pos with the current pos x, y, and z added by the given x, y, and z"}, params={@ParameterDoc(type=NumberDef.class, name="x", desc={"the x adder"}), @ParameterDoc(type=NumberDef.class, name="y", desc={"the y adder"}), @ParameterDoc(type=NumberDef.class, name="z", desc={"the z adder"})}, returns=@ReturnDoc(type=PosDef.class, desc={"the new Pos"}), examples={"pos.add(2, 3, 5);"})
    private class_243 add(Arguments arguments) {
        ScriptPos pos = (ScriptPos)arguments.nextPrimitive((PrimitiveDefinition)this);
        double x = (Double)arguments.nextPrimitive(NumberDef.class);
        double y = (Double)arguments.nextPrimitive(NumberDef.class);
        double z = (Double)arguments.nextPrimitive(NumberDef.class);
        return pos.getVec3d().method_1031(x, y, z);
    }

    @FunctionDoc(name="add", desc={"This returns a new Pos with the current pos x, y, and z added by the given pos x, y, and z"}, params={@ParameterDoc(type=PosDef.class, name="pos", desc={"the Pos to add by"})}, returns=@ReturnDoc(type=PosDef.class, desc={"the new Pos"}), examples={"pos.add(new Pos(2, 3, 5));"})
    private class_243 add1(Arguments arguments) {
        ScriptPos pos = (ScriptPos)arguments.nextPrimitive((PrimitiveDefinition)this);
        ScriptPos other = (ScriptPos)arguments.nextPrimitive((PrimitiveDefinition)this);
        return pos.getVec3d().method_1019(other.getVec3d());
    }

    @FunctionDoc(name="dotProduct", desc={"This returns the dot product of the current pos and the given pos"}, params={@ParameterDoc(type=PosDef.class, name="pos", desc={"the Pos to dot product with"})}, returns=@ReturnDoc(type=NumberDef.class, desc={"the dot product"}), examples={"pos.dotProduct(new Pos(2, 3, 5));"})
    private double dotProduct(Arguments arguments) {
        ScriptPos pos = (ScriptPos)arguments.nextPrimitive((PrimitiveDefinition)this);
        ScriptPos other = (ScriptPos)arguments.nextPrimitive((PrimitiveDefinition)this);
        return pos.getVec3d().method_1026(other.getVec3d());
    }

    @FunctionDoc(name="crossProduct", desc={"This returns the cross product of the current pos and the given pos"}, params={@ParameterDoc(type=PosDef.class, name="pos", desc={"the Pos to cross product with"})}, returns=@ReturnDoc(type=PosDef.class, desc={"the cross product"}), examples={"pos.crossProduct(new Pos(2, 3, 5));"})
    private class_243 crossProduct(Arguments arguments) {
        ScriptPos pos = (ScriptPos)arguments.nextPrimitive((PrimitiveDefinition)this);
        ScriptPos other = (ScriptPos)arguments.nextPrimitive((PrimitiveDefinition)this);
        return pos.getVec3d().method_1036(other.getVec3d());
    }

    @FunctionDoc(name="toBlockPos", desc={"This floors all of the positions values to the nearest block"}, returns=@ReturnDoc(type=PosDef.class, desc={"the new Pos"}), examples={"pos.toBlockPos();"})
    private class_2338 toBlockPos(Arguments arguments) {
        return ((ScriptPos)arguments.nextPrimitive((PrimitiveDefinition)this)).getBlockPos();
    }

    @FunctionDoc(name="toList", desc={"This returns the Pos as a List containing the x, y, and z positions in order"}, returns=@ReturnDoc(type=ListDef.class, desc={"the Pos as a List"}), examples={"x, y, z = pos.toList();"})
    private ArucasList toList(Arguments arguments) {
        ScriptPos pos = (ScriptPos)arguments.nextPrimitive((PrimitiveDefinition)this);
        NumberDef numberDef = (NumberDef)arguments.getInterpreter().getPrimitive(NumberDef.class);
        return ArucasList.of((ClassInstance[])new ClassInstance[]{numberDef.create((Object)pos.getX()), numberDef.create((Object)pos.getY()), numberDef.create((Object)pos.getZ())});
    }

    @FunctionDoc(name="offset", desc={"This returns a new Pos with the current pos x, y, and z offset by a direction"}, params={@ParameterDoc(type=StringDef.class, name="direction", desc={"the direction to offset by, must be one of: north, south, east, west, up, down"})}, returns=@ReturnDoc(type=PosDef.class, desc={"the new Pos"}), examples={"pos.offset('north');"})
    private class_243 offset(Arguments arguments) {
        ScriptPos pos = (ScriptPos)arguments.nextPrimitive((PrimitiveDefinition)this);
        String string = arguments.nextConstant();
        class_2350 direction = ClientScriptUtils.stringToDirection(string, null);
        return pos.getVec3d().method_1031((double)direction.method_10148(), (double)direction.method_10164(), (double)direction.method_10165());
    }

    @FunctionDoc(name="offset", desc={"This returns a new Pos with the current pos x, y, and z offset by a direction and a distance"}, params={@ParameterDoc(type=StringDef.class, name="direction", desc={"the direction to offset by, must be one of: north, south, east, west, up, down"}), @ParameterDoc(type=NumberDef.class, name="distance", desc={"the distance to offset by"})}, returns=@ReturnDoc(type=PosDef.class, desc={"the new Pos"}), examples={"pos.offset('north', 2);"})
    private class_243 offset1(Arguments arguments) {
        ScriptPos pos = (ScriptPos)arguments.nextPrimitive((PrimitiveDefinition)this);
        String string = arguments.nextConstant();
        double distance = (Double)arguments.nextPrimitive(NumberDef.class);
        class_2350 direction = ClientScriptUtils.stringToDirection(string, null);
        return pos.getVec3d().method_1031((double)direction.method_10148() * distance, (double)direction.method_10164() * distance, (double)direction.method_10165() * distance);
    }

    @FunctionDoc(name="up", desc={"This returns a new Pos with the current pos y incremented by 1"}, returns=@ReturnDoc(type=PosDef.class, desc={"the new Pos"}), examples={"pos.up();"})
    private class_243 up(Arguments arguments) {
        ScriptPos pos = (ScriptPos)arguments.nextPrimitive((PrimitiveDefinition)this);
        return pos.getVec3d().method_1031(0.0, 1.0, 0.0);
    }

    @FunctionDoc(name="up", desc={"This returns a new Pos with the current pos y incremented by the given number"}, params={@ParameterDoc(type=NumberDef.class, name="number", desc={"the number to increment by"})}, returns=@ReturnDoc(type=PosDef.class, desc={"the new Pos"}), examples={"pos.up(2);"})
    private class_243 up1(Arguments arguments) {
        ScriptPos pos = (ScriptPos)arguments.nextPrimitive((PrimitiveDefinition)this);
        double number = (Double)arguments.nextPrimitive(NumberDef.class);
        return pos.getVec3d().method_1031(0.0, number, 0.0);
    }

    @FunctionDoc(name="down", desc={"This returns a new Pos with the current pos y decremented by 1"}, returns=@ReturnDoc(type=PosDef.class, desc={"the new Pos"}), examples={"pos.down();"})
    private class_243 down(Arguments arguments) {
        ScriptPos pos = (ScriptPos)arguments.nextPrimitive((PrimitiveDefinition)this);
        return pos.getVec3d().method_1031(0.0, -1.0, 0.0);
    }

    @FunctionDoc(name="down", desc={"This returns a new Pos with the current pos y decremented by the given number"}, params={@ParameterDoc(type=NumberDef.class, name="number", desc={"the number to decrement by"})}, returns=@ReturnDoc(type=PosDef.class, desc={"the new Pos"}), examples={"pos.down(2);"})
    private class_243 down1(Arguments arguments) {
        ScriptPos pos = (ScriptPos)arguments.nextPrimitive((PrimitiveDefinition)this);
        double number = (Double)arguments.nextPrimitive(NumberDef.class);
        return pos.getVec3d().method_1031(0.0, -number, 0.0);
    }

    @FunctionDoc(name="north", desc={"This returns a new Pos with the current pos z incremented by 1"}, returns=@ReturnDoc(type=PosDef.class, desc={"the new Pos"}), examples={"pos.north();"})
    private class_243 north(Arguments arguments) {
        ScriptPos pos = (ScriptPos)arguments.nextPrimitive((PrimitiveDefinition)this);
        return pos.getVec3d().method_1031(0.0, 0.0, -1.0);
    }

    @FunctionDoc(name="north", desc={"This returns a new Pos with the current pos z incremented by the given number"}, params={@ParameterDoc(type=NumberDef.class, name="number", desc={"the number to increment by"})}, returns=@ReturnDoc(type=PosDef.class, desc={"the new Pos"}), examples={"pos.north(2);"})
    private class_243 north1(Arguments arguments) {
        ScriptPos pos = (ScriptPos)arguments.nextPrimitive((PrimitiveDefinition)this);
        double number = (Double)arguments.nextPrimitive(NumberDef.class);
        return pos.getVec3d().method_1031(0.0, 0.0, -number);
    }

    @FunctionDoc(name="south", desc={"This returns a new Pos with the current pos z decremented by 1"}, returns=@ReturnDoc(type=PosDef.class, desc={"the new Pos"}), examples={"pos.south();"})
    private class_243 south(Arguments arguments) {
        ScriptPos pos = (ScriptPos)arguments.nextPrimitive((PrimitiveDefinition)this);
        return pos.getVec3d().method_1031(0.0, 0.0, 1.0);
    }

    @FunctionDoc(name="south", desc={"This returns a new Pos with the current pos z decremented by the given number"}, params={@ParameterDoc(type=NumberDef.class, name="number", desc={"the number to decrement by"})}, returns=@ReturnDoc(type=PosDef.class, desc={"the new Pos"}), examples={"pos.south(2);"})
    private class_243 south1(Arguments arguments) {
        ScriptPos pos = (ScriptPos)arguments.nextPrimitive((PrimitiveDefinition)this);
        double number = (Double)arguments.nextPrimitive(NumberDef.class);
        return pos.getVec3d().method_1031(0.0, 0.0, number);
    }

    @FunctionDoc(name="east", desc={"This returns a new Pos with the current pos x incremented by 1"}, returns=@ReturnDoc(type=PosDef.class, desc={"the new Pos"}), examples={"pos.east();"})
    private class_243 east(Arguments arguments) {
        ScriptPos pos = (ScriptPos)arguments.nextPrimitive((PrimitiveDefinition)this);
        return pos.getVec3d().method_1031(1.0, 0.0, 0.0);
    }

    @FunctionDoc(name="east", desc={"This returns a new Pos with the current pos x incremented by the given number"}, params={@ParameterDoc(type=NumberDef.class, name="number", desc={"the number to increment by"})}, returns=@ReturnDoc(type=PosDef.class, desc={"the new Pos"}), examples={"pos.east(2);"})
    private class_243 east1(Arguments arguments) {
        ScriptPos pos = (ScriptPos)arguments.nextPrimitive((PrimitiveDefinition)this);
        double number = (Double)arguments.nextPrimitive(NumberDef.class);
        return pos.getVec3d().method_1031(number, 0.0, 0.0);
    }

    @FunctionDoc(name="west", desc={"This returns a new Pos with the current pos x decremented by 1"}, returns=@ReturnDoc(type=PosDef.class, desc={"the new Pos"}), examples={"pos.west();"})
    private class_243 west(Arguments arguments) {
        ScriptPos pos = (ScriptPos)arguments.nextPrimitive((PrimitiveDefinition)this);
        return pos.getVec3d().method_1031(-1.0, 0.0, 0.0);
    }

    @FunctionDoc(name="west", desc={"This returns a new Pos with the current pos x decremented by the given number"}, params={@ParameterDoc(type=NumberDef.class, name="number", desc={"the number to decrement by"})}, returns=@ReturnDoc(type=PosDef.class, desc={"the new Pos"}), examples={"pos.west(2);"})
    private class_243 west1(Arguments arguments) {
        ScriptPos pos = (ScriptPos)arguments.nextPrimitive((PrimitiveDefinition)this);
        double number = (Double)arguments.nextPrimitive(NumberDef.class);
        return pos.getVec3d().method_1031(-number, 0.0, 0.0);
    }

    @FunctionDoc(name="getSidePos", desc={"This returns side position value of position"}, params={@ParameterDoc(type=StringDef.class, name="direction", desc={"the direction, can be: north, south, east, west, up, down"})}, returns=@ReturnDoc(type=PosDef.class, desc={"the side of the position"}), examples={"pos.getSidePos('east');"})
    private class_243 getSidePos(Arguments arguments) {
        ScriptPos pos = (ScriptPos)arguments.nextPrimitive((PrimitiveDefinition)this);
        String string = arguments.nextConstant();
        class_2350 direction = ClientScriptUtils.stringToDirection(string, null);
        return class_243.method_24953((class_2382)pos.getBlockPos()).method_1019(class_243.method_24954((class_2382)direction.method_10163()).method_1021(0.5));
    }

    @FunctionDoc(name="asCentre", desc={"This returns center value of the position"}, returns=@ReturnDoc(type=PosDef.class, desc={"the center of the position"}), examples={"pos.asCentre();"})
    private class_243 asCentre(Arguments arguments) {
        ScriptPos pos = (ScriptPos)arguments.nextPrimitive((PrimitiveDefinition)this);
        return class_243.method_24953((class_2382)pos.getBlockPos());
    }

    @FunctionDoc(name="isNear", desc={"This returns whether position to entity is less than 4.5"}, params={@ParameterDoc(type=EntityDef.class, name="entity", desc={"the entity you want to check"})}, returns=@ReturnDoc(type=BooleanDef.class, desc={"whether entity is within 4.5 block distance"}), examples={"pos.isNear(Player.get());"})
    private boolean isNear(Arguments arguments) {
        ScriptPos pos = (ScriptPos)arguments.nextPrimitive((PrimitiveDefinition)this);
        class_1297 entity = (class_1297)arguments.nextPrimitive(EntityDef.class);
        return entity.method_5707(pos.getVec3d()) <= 20.25;
    }

    @FunctionDoc(name="isWithin", desc={"This returns whether position to entity is less than given distance"}, params={@ParameterDoc(type=EntityDef.class, name="entity", desc={"the entity you want to check"}), @ParameterDoc(type=NumberDef.class, name="distance", desc={"the distance you want to check"})}, returns=@ReturnDoc(type=BooleanDef.class, desc={"whether entity is within given distance"}), examples={"pos.isNear(player, 8);"})
    private boolean isWithin(Arguments arguments) {
        ScriptPos pos = (ScriptPos)arguments.nextPrimitive((PrimitiveDefinition)this);
        class_1297 entity = (class_1297)arguments.nextPrimitive(EntityDef.class);
        double distance = (Double)arguments.nextPrimitive(NumberDef.class);
        return entity.method_5707(pos.getVec3d()) <= distance * distance;
    }

    @FunctionDoc(name="distanceTo", desc={"This returns distance to other position"}, params={@ParameterDoc(type=PosDef.class, name="other", desc={"other position"})}, returns=@ReturnDoc(type=NumberDef.class, desc={"distance to other position"}), examples={"pos.distanceTo(new Pos(0, 0, 0));"})
    private double distanceTo(Arguments arguments) {
        ScriptPos pos = (ScriptPos)arguments.nextPrimitive((PrimitiveDefinition)this);
        ScriptPos other = (ScriptPos)arguments.nextPrimitive((PrimitiveDefinition)this);
        return pos.getVec3d().method_1022(other.getVec3d());
    }

    @FunctionDoc(name="distanceTo", desc={"This returns distance to other x, y, z position"}, params={@ParameterDoc(type=NumberDef.class, name="x", desc={"other position x"}), @ParameterDoc(type=NumberDef.class, name="y", desc={"other position y"}), @ParameterDoc(type=NumberDef.class, name="z", desc={"other position z"})}, returns=@ReturnDoc(type=NumberDef.class, desc={"distance to other position"}), examples={"pos.distanceTo(0, 0, 0);"})
    private double distanceTo1(Arguments arguments) {
        ScriptPos pos = (ScriptPos)arguments.nextPrimitive((PrimitiveDefinition)this);
        double x = (Double)arguments.nextPrimitive(NumberDef.class);
        double y = (Double)arguments.nextPrimitive(NumberDef.class);
        double z = (Double)arguments.nextPrimitive(NumberDef.class);
        return pos.getVec3d().method_1022(new class_243(x, y, z));
    }

    @FunctionDoc(name="normalize", desc={"Normalizes the vector to have a magnitude of 1"}, returns=@ReturnDoc(type=PosDef.class, desc={"the normalized position"}), examples={"pos.normalize();"})
    private class_243 normalize(Arguments arguments) {
        ScriptPos pos = (ScriptPos)arguments.nextPrimitive((PrimitiveDefinition)this);
        return pos.getVec3d().method_1029();
    }
}

