/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.clientscript.definitions;

import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import me.senseiwells.arucas.api.docs.annotations.ClassDoc;
import me.senseiwells.arucas.api.docs.annotations.FunctionDoc;
import me.senseiwells.arucas.api.docs.annotations.ParameterDoc;
import me.senseiwells.arucas.api.docs.annotations.ReturnDoc;
import me.senseiwells.arucas.builtin.BooleanDef;
import me.senseiwells.arucas.builtin.FunctionDef;
import me.senseiwells.arucas.builtin.FutureDef;
import me.senseiwells.arucas.builtin.ListDef;
import me.senseiwells.arucas.builtin.NumberDef;
import me.senseiwells.arucas.builtin.StringDef;
import me.senseiwells.arucas.classes.CreatableDefinition;
import me.senseiwells.arucas.classes.PrimitiveDefinition;
import me.senseiwells.arucas.classes.instance.ClassInstance;
import me.senseiwells.arucas.compiler.LocatableTrace;
import me.senseiwells.arucas.exceptions.RuntimeError;
import me.senseiwells.arucas.functions.ArucasFunction;
import me.senseiwells.arucas.functions.builtin.Arguments;
import me.senseiwells.arucas.functions.builtin.BuiltInFunction;
import me.senseiwells.arucas.functions.builtin.MemberFunction;
import me.senseiwells.arucas.interpreter.Interpreter;
import me.senseiwells.arucas.utils.impl.ArucasList;
import me.senseiwells.arucas.utils.misc.Language;
import me.senseiwells.essentialclient.clientscript.definitions.BlockDef;
import me.senseiwells.essentialclient.clientscript.definitions.EntityDef;
import me.senseiwells.essentialclient.clientscript.definitions.ItemStackDef;
import me.senseiwells.essentialclient.clientscript.definitions.MaterialDef;
import me.senseiwells.essentialclient.clientscript.definitions.OtherPlayerDef;
import me.senseiwells.essentialclient.clientscript.definitions.PosDef;
import me.senseiwells.essentialclient.clientscript.definitions.RecipeDef;
import me.senseiwells.essentialclient.clientscript.definitions.ScreenDef;
import me.senseiwells.essentialclient.clientscript.definitions.TextDef;
import me.senseiwells.essentialclient.feature.BetterAccurateBlockPlacement;
import me.senseiwells.essentialclient.utils.EssentialUtils;
import me.senseiwells.essentialclient.utils.clientscript.ClientScriptUtils;
import me.senseiwells.essentialclient.utils.clientscript.impl.ScriptBlockState;
import me.senseiwells.essentialclient.utils.clientscript.impl.ScriptItemStack;
import me.senseiwells.essentialclient.utils.clientscript.impl.ScriptMaterial;
import me.senseiwells.essentialclient.utils.clientscript.impl.ScriptPos;
import me.senseiwells.essentialclient.utils.interfaces.MinecraftClientInvoker;
import me.senseiwells.essentialclient.utils.inventory.InventoryUtils;
import me.senseiwells.essentialclient.utils.render.FakeInventoryScreen;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_2183;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2838;
import net.minecraft.class_2846;
import net.minecraft.class_2868;
import net.minecraft.class_2884;
import net.minecraft.class_310;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_3975;
import net.minecraft.class_437;
import net.minecraft.class_4538;
import net.minecraft.class_465;
import net.minecraft.class_479;
import net.minecraft.class_490;
import net.minecraft.class_634;
import net.minecraft.class_636;
import net.minecraft.class_746;
import net.minecraft.class_8786;
import net.minecraft.class_9812;
import org.jetbrains.annotations.NotNull;

@ClassDoc(name="Player", desc={"This class is used to interact with the main player, this extends OtherPlayer", "and so inherits all methods from that class."}, superclass=OtherPlayerDef.class, language=Language.Java)
public class PlayerDef
extends CreatableDefinition<class_746> {
    public PlayerDef(Interpreter interpreter) {
        super("Player", interpreter);
    }

    @NotNull
    public PrimitiveDefinition<? super class_746> superclass() {
        return this.getPrimitiveDef(OtherPlayerDef.class);
    }

    @NotNull
    public String toString(@NotNull ClassInstance instance, @NotNull Interpreter interpreter, @NotNull LocatableTrace trace) {
        return "Player{name=" + ((class_746)instance.asPrimitive((PrimitiveDefinition)this)).method_5820() + "}";
    }

    public List<BuiltInFunction> defineStaticMethods() {
        return List.of(BuiltInFunction.of((String)"get", this::get));
    }

    @FunctionDoc(isStatic=true, name="get", desc={"This gets the main player"}, returns=@ReturnDoc(type=PlayerDef.class, desc={"The main player"}), examples={"player = Player.get();"})
    private ClassInstance get(Arguments arguments) {
        return this.create(EssentialUtils.getPlayer());
    }

    public List<MemberFunction> defineMethods() {
        return List.of(MemberFunction.of((String)"use", (int)1, this::use), MemberFunction.of((String)"attack", (int)1, this::attack), MemberFunction.of((String)"setSelectedSlot", (int)1, this::setSelectedSlot), MemberFunction.of((String)"getSelectedSlot", this::getSelectedSlot), MemberFunction.of((String)"say", (int)1, this::say), MemberFunction.of((String)"message", (int)1, this::message), MemberFunction.of((String)"messageActionBar", (int)1, this::messageActionBar), MemberFunction.of((String)"showTitle", (int)2, this::showTitle), MemberFunction.of((String)"openInventory", this::openInventory), MemberFunction.of((String)"openScreen", (int)1, this::openScreen), MemberFunction.of((String)"closeScreen", this::closeScreen), MemberFunction.of((String)"setWalking", (int)1, this::setWalking), MemberFunction.of((String)"setSneaking", (int)1, this::setSneaking), MemberFunction.of((String)"setSprinting", (int)1, this::setSprinting), MemberFunction.of((String)"dropItemInHand", (int)1, this::dropItemInHand), MemberFunction.of((String)"dropAll", (int)1, this::dropAll), MemberFunction.of((String)"dropAllExact", (int)1, this::dropAllExact), MemberFunction.of((String)"look", (int)2, this::look), MemberFunction.of((String)"lookAtPos", (int)3, this::lookAtPos), MemberFunction.of((String)"lookAtPos", (int)1, this::lookAtPosPos), MemberFunction.of((String)"jump", this::jump), MemberFunction.of((String)"getLookingAtEntity", this::getLookingAtEntity), MemberFunction.of((String)"swapSlots", (int)2, this::swapSlots), MemberFunction.of((String)"shiftClickSlot", (int)1, this::shiftClickSlot), MemberFunction.of((String)"dropSlot", (int)1, this::dropSlot), MemberFunction.of((String)"getCurrentScreen", this::getCurrentScreen), MemberFunction.of((String)"craft", (int)1, this::craft), MemberFunction.of((String)"craftRecipe", (int)1, this::craftRecipe), MemberFunction.of((String)"craftRecipe", (int)2, this::craftRecipeDrop), MemberFunction.of((String)"craftRecipe", (int)3, this::craftRecipeDropAll), MemberFunction.of((String)"clickRecipe", (int)1, this::clickRecipe1), MemberFunction.of((String)"clickRecipe", (int)2, this::clickRecipe2), MemberFunction.of((String)"clickStonecuttingRecipe", (int)1, this::clickCuttingRecipe), MemberFunction.of((String)"clickStonecuttingRecipe", (int)2, this::clickCuttingRecipe2), MemberFunction.of((String)"logout", (int)1, this::logout), MemberFunction.of((String)"attackEntity", (int)1, this::attackEntity), MemberFunction.of((String)"interactWithEntity", (int)1, this::interactWithEntity), MemberFunction.of((String)"anvil", (int)2, this::anvil2), MemberFunction.of((String)"anvil", (int)3, this::anvil3), MemberFunction.of((String)"anvilRename", (int)2, this::anvilRename), MemberFunction.of((String)"stonecutter", (int)2, this::stonecutter), MemberFunction.of((String)"fakeLook", (int)4, this::fakeLook), MemberFunction.of((String)"swapPlayerSlotWithHotbar", (int)1, this::swapPlayerSlotWithHotbar), MemberFunction.of((String)"breakBlock", (int)1, this::breakBlock), MemberFunction.of((String)"updateBreakingBlock", (int)3, this::updateBreakingBlock, (String)"Use <Player>.breakBlock(pos)"), MemberFunction.of((String)"updateBreakingBlock", (int)1, this::updateBreakingBlockPos, (String)"Use <Player>.breakBlock(pos)"), MemberFunction.of((String)"attackBlock", (int)4, this::attackBlock), MemberFunction.of((String)"attackBlock", (int)2, this::attackBlockPos), MemberFunction.of((String)"interactItem", (int)2, this::interactItem), MemberFunction.of((String)"interactBlock", (int)2, this::interactBlockPos), MemberFunction.of((String)"interactBlock", (int)3, this::interactBlockPosHand), MemberFunction.of((String)"interactBlock", (int)8, this::interactBlockFull), MemberFunction.of((String)"interactBlock", (int)4, this::interactBlockFullPos), MemberFunction.of((String)"interactBlock", (int)5, this::interactBlockFullPosHand), MemberFunction.of((String)"getBlockBreakingSpeed", (int)2, this::getBlockBreakingSpeed), MemberFunction.of((String)"swapHands", this::swapHands), MemberFunction.of((String)"swingHand", (int)1, this::swingHand), MemberFunction.of((String)"clickSlot", (int)3, this::clickSlot), MemberFunction.of((String)"clickCreativeStack", (int)2, this::clickCreativeStack), MemberFunction.of((String)"getSwappableHotbarSlot", this::getSwappableHotbarSlot), MemberFunction.of((String)"spectatorTeleport", (int)1, this::spectatorTeleport), MemberFunction.of((String)"canPlaceBlockAt", (int)2, this::canPlaceBlockAtPos), MemberFunction.of((String)"canPlaceBlockAt", (int)4, this::canPlaceBlockAtPos1));
    }

    @FunctionDoc(name="use", desc={"This allows you to make your player use, you must", "pass 'hold', 'stop', or 'once' otherwise an error will be thrown"}, params={@ParameterDoc(type=StringDef.class, name="action", desc={"the type of action, either 'hold', 'stop', or 'once'"})}, examples={"player.use('hold');"})
    private Void use(Arguments arguments) {
        String action = (String)arguments.skip().nextPrimitive(StringDef.class);
        class_310 client = EssentialUtils.getClient();
        switch (action.toLowerCase()) {
            case "hold": {
                ClientScriptUtils.holdKey(arguments.getInterpreter(), client.field_1690.field_1904, 3);
                break;
            }
            case "stop": {
                ClientScriptUtils.releaseKey(client.field_1690.field_1904);
                break;
            }
            case "once": {
                ((MinecraftClientInvoker)client).essentialclient$rightClick();
                break;
            }
            default: {
                throw new RuntimeError("Must pass 'hold', 'stop' or 'once' into use()");
            }
        }
        return null;
    }

    @FunctionDoc(name="attack", desc={"This allows you to make your player attack, you must", "pass 'hold', 'stop', or 'once' otherwise an error will be thrown"}, params={@ParameterDoc(type=StringDef.class, name="action", desc={"the type of action, either 'hold', 'stop', or 'once'"})}, examples={"player.attack('once');"})
    private Void attack(Arguments arguments) {
        String action = (String)arguments.skip().nextPrimitive(StringDef.class);
        class_310 client = EssentialUtils.getClient();
        switch (action.toLowerCase()) {
            case "hold": {
                ClientScriptUtils.holdKey(arguments.getInterpreter(), client.field_1690.field_1886, 1);
                break;
            }
            case "stop": {
                ClientScriptUtils.releaseKey(client.field_1690.field_1886);
                break;
            }
            case "once": {
                ((MinecraftClientInvoker)client).essentialclient$leftClick();
                break;
            }
            default: {
                throw new RuntimeError("Must pass 'hold', 'stop' or 'once' into attack()");
            }
        }
        return null;
    }

    @FunctionDoc(name="setSelectedSlot", desc={"This allows you to set the slot number your player is holding.", "If the number is not between 0 and 8 an error will be thrown"}, params={@ParameterDoc(type=NumberDef.class, name="slot", desc={"the slot number, must be between 0 - 8"})}, examples={"player.setSelectedSlot(0);"})
    private Void setSelectedSlot(Arguments arguments) {
        int index = ((Double)arguments.skip().nextPrimitive(NumberDef.class)).intValue();
        if (index < 0 || index > 8) {
            throw new RuntimeError("Number must be between 0 - 8");
        }
        ClientScriptUtils.ensureMainThread("setSelectedSlot", arguments.getInterpreter(), () -> {
            EssentialUtils.getPlayer().method_31548().field_7545 = index;
            EssentialUtils.getNetworkHandler().method_52787((class_2596)new class_2868(index));
        });
        return null;
    }

    @FunctionDoc(name="getSelectedSlot", desc={"This gets the current selected slot number your player is holding"}, returns=@ReturnDoc(type=NumberDef.class, desc={"the selected slot"}), examples={"player.getSelectedSlot"})
    private int getSelectedSlot(Arguments arguments) {
        return EssentialUtils.getPlayer().method_31548().field_7545;
    }

    @FunctionDoc(name="say", desc={"This allows you to make your player send a message in chat, this includes commands"}, params={@ParameterDoc(type=StringDef.class, name="message", desc={"the message to send"})}, examples={"player.say('/help');"})
    private Void say(Arguments arguments) {
        EssentialUtils.sendChatMessage(arguments.skip().next().toString(arguments.getInterpreter()));
        return null;
    }

    @FunctionDoc(name="message", desc={"This allows you to send a message to your player, only they will see this, purely client side"}, params={@ParameterDoc(type=TextDef.class, name="message", desc={"the message to send, can also be string"})}, examples={"player.message('Hello World!');"})
    private Void message(Arguments arguments) {
        ClassInstance value = arguments.skip().next();
        class_2561 text = ClientScriptUtils.instanceToText(value, arguments.getInterpreter());
        ClientScriptUtils.ensureMainThread("message", arguments.getInterpreter(), () -> EssentialUtils.getPlayer().method_7353(text, false));
        return null;
    }

    @FunctionDoc(name="messageActionBar", desc={"This allows you to set the current memssage displaying on the action bar"}, params={@ParameterDoc(type=TextDef.class, name="message", desc={"the message to send, can also be string"})}, examples={"player.messageActionBar('Hello World!');"})
    private Void messageActionBar(Arguments arguments) {
        ClassInstance value = arguments.skip().next();
        class_2561 text = ClientScriptUtils.instanceToText(value, arguments.getInterpreter());
        ClientScriptUtils.ensureMainThread("messageActionBar", arguments.getInterpreter(), () -> EssentialUtils.getPlayer().method_7353(text, true));
        return null;
    }

    @FunctionDoc(name="showTitle", desc={"THis allows you to show a title and subtitle to the player"}, params={@ParameterDoc(type=TextDef.class, name="title", desc={"the title to show, can be string or null"}), @ParameterDoc(type=TextDef.class, name="subtitle", desc={"the subtitle to show, can be string or null"})}, examples={"player.showTitle('Title!', 'Subtitle!');"})
    private Void showTitle(Arguments arguments) {
        ClassInstance titleInstance = arguments.skip().next();
        ClassInstance subTitleInstance = arguments.next();
        class_2561 title = ClientScriptUtils.instanceToText(titleInstance, arguments.getInterpreter());
        class_2561 subTitle = ClientScriptUtils.instanceToText(subTitleInstance, arguments.getInterpreter());
        ClientScriptUtils.ensureMainThread("showTitle", arguments.getInterpreter(), () -> {
            class_310 client = EssentialUtils.getClient();
            client.field_1705.method_34004(title);
            client.field_1705.method_34002(subTitle);
        });
        return null;
    }

    @FunctionDoc(name="openInventory", desc={"This opens the player's inventory"}, examples={"player.openInventory();"})
    private Void openInventory(Arguments arguments) {
        ClientScriptUtils.ensureMainThread("openInventory", arguments.getInterpreter(), () -> EssentialUtils.getClient().method_1507((class_437)new class_490((class_1657)EssentialUtils.getPlayer())));
        return null;
    }

    @FunctionDoc(name="openScreen", desc={"This opens a screen for the player, this cannot open server side screens.", "This will throw an error if you are trying to open a handled screen"}, params={@ParameterDoc(type=ScreenDef.class, name="screen", desc={"the screen to open"})}, examples={"player.openScreen(new FakeScreen('MyScreen', 4));"})
    private Void openScreen(Arguments arguments) {
        class_437 screen = (class_437)arguments.skip().nextPrimitive(ScreenDef.class);
        if (screen instanceof class_465 && !(screen instanceof FakeInventoryScreen)) {
            throw new RuntimeError("Opening handled screens is unsafe");
        }
        ClientScriptUtils.ensureMainThread("openScreen", arguments.getInterpreter(), () -> EssentialUtils.getClient().method_1507(screen));
        return null;
    }

    @FunctionDoc(name="closeScreen", desc={"This closes the current screen"}, examples={"player.closeScreen();"})
    private Void closeScreen(Arguments arguments) {
        ClientScriptUtils.ensureMainThread("closeScreen", arguments.getInterpreter(), () -> EssentialUtils.getPlayer().method_7346());
        return null;
    }

    @FunctionDoc(name="setWalking", desc={"This sets the player's walking state"}, params={@ParameterDoc(type=BooleanDef.class, name="walking", desc={"the walking state"})}, examples={"player.setWalking(true);"})
    private Void setWalking(Arguments arguments) {
        ClientScriptUtils.modifyKey(arguments.getInterpreter(), (Boolean)arguments.skip().nextPrimitive(BooleanDef.class), EssentialUtils.getClient().field_1690.field_1894);
        return null;
    }

    @FunctionDoc(name="setSneaking", desc={"This sets the player's sneaking state"}, params={@ParameterDoc(type=BooleanDef.class, name="sneaking", desc={"the sneaking state"})}, examples={"player.setSneaking(true);"})
    private Void setSneaking(Arguments arguments) {
        ClientScriptUtils.modifyKey(arguments.getInterpreter(), (Boolean)arguments.skip().nextPrimitive(BooleanDef.class), EssentialUtils.getClient().field_1690.field_1832);
        return null;
    }

    @FunctionDoc(name="setSprinting", desc={"This sets the player's sprinting state"}, params={@ParameterDoc(type=BooleanDef.class, name="sprinting", desc={"the sprinting state"})}, examples={"player.setSprinting(true);"})
    private Void setSprinting(Arguments arguments) {
        boolean shouldSprint = (Boolean)arguments.skip().nextPrimitive(BooleanDef.class);
        ClientScriptUtils.ensureMainThread("setSprinting", arguments.getInterpreter(), () -> EssentialUtils.getPlayer().method_5728(shouldSprint));
        return null;
    }

    @FunctionDoc(name="dropItemInHand", desc={"This drops the item(s) in the player's main hand"}, params={@ParameterDoc(type=BooleanDef.class, name="dropAll", desc={"if true, all items in the player's main hand will be dropped"})}, examples={"player.dropItemInHand(true);"})
    private Void dropItemInHand(Arguments arguments) {
        boolean dropAll = (Boolean)arguments.skip().nextPrimitive(BooleanDef.class);
        ClientScriptUtils.ensureMainThread("dropItemInHand", arguments.getInterpreter(), () -> EssentialUtils.getPlayer().method_7290(dropAll));
        return null;
    }

    @FunctionDoc(name="dropAll", desc={"This drops all items of a given type in the player's inventory"}, params={@ParameterDoc(type=MaterialDef.class, name="material", desc={"the item stack, or material type to drop"})}, examples={"player.dropAll(Material.DIRT.asItemStack());"})
    private Void dropAll(Arguments arguments) {
        class_1792 item = ((ScriptMaterial)arguments.skip().nextPrimitive(MaterialDef.class)).asItem();
        ClientScriptUtils.ensureMainThread("dropAll", arguments.getInterpreter(), () -> InventoryUtils.dropAllItemType(item));
        return null;
    }

    @FunctionDoc(name="dropAllExact", desc={"This drops all the items that have the same nbt as a given stack"}, params={@ParameterDoc(type=ItemStackDef.class, name="itemStack", desc={"the stack with nbt to drop"})}, examples={"player.dropAllExact(Material.GOLD_INGOT.asItemStack());"})
    private Void dropAllExact(Arguments arguments) {
        class_1799 stack = ((ScriptItemStack)arguments.skip().nextPrimitive(ItemStackDef.class)).stack;
        ClientScriptUtils.ensureMainThread("dropAllExact", arguments.getInterpreter(), () -> InventoryUtils.dropAllItemExact(stack));
        return null;
    }

    @FunctionDoc(name="look", desc={"This sets the player's look direction"}, params={@ParameterDoc(type=NumberDef.class, name="yaw", desc={"the yaw of the player's look direction"}), @ParameterDoc(type=NumberDef.class, name="pitch", desc={"the pitch of the player's look direction"})}, examples={"player.look(0, 0);"})
    private Void look(Arguments arguments) {
        float yaw = ((Double)arguments.skip().nextPrimitive(NumberDef.class)).floatValue();
        float pitch = ((Double)arguments.nextPrimitive(NumberDef.class)).floatValue();
        ClientScriptUtils.ensureMainThread("look", arguments.getInterpreter(), () -> {
            class_746 player = EssentialUtils.getPlayer();
            player.method_36456(yaw);
            player.method_36457(pitch);
        });
        return null;
    }

    @FunctionDoc(name="lookAtPos", desc={"This makes your player look towards a position"}, params={@ParameterDoc(type=NumberDef.class, name="x", desc={"the x coordinate of the position"}), @ParameterDoc(type=NumberDef.class, name="y", desc={"the y coordinate of the position"}), @ParameterDoc(type=NumberDef.class, name="z", desc={"the z coordinate of the position"})}, examples={"player.lookAtPos(0, 0, 0);"})
    private Void lookAtPos(Arguments arguments) {
        double x = (Double)arguments.skip().nextPrimitive(NumberDef.class);
        double y = (Double)arguments.nextPrimitive(NumberDef.class);
        double z = (Double)arguments.nextPrimitive(NumberDef.class);
        ClientScriptUtils.ensureMainThread("lookAtPos", arguments.getInterpreter(), () -> EssentialUtils.getPlayer().method_5702(class_2183.class_2184.field_9851, new class_243(x, y, z)));
        return null;
    }

    @FunctionDoc(name="lookAtPos", desc={"This makes your player look towards a position"}, params={@ParameterDoc(type=PosDef.class, name="pos", desc={"the position to look at"})}, examples={"player.lookAtPos(pos);"})
    private Void lookAtPosPos(Arguments arguments) {
        class_243 pos = ((ScriptPos)arguments.skip().nextPrimitive(PosDef.class)).getVec3d();
        ClientScriptUtils.ensureMainThread("lookAtPos", arguments.getInterpreter(), () -> EssentialUtils.getPlayer().method_5702(class_2183.class_2184.field_9851, pos));
        return null;
    }

    @FunctionDoc(name="canPlaceBlockAt", desc={"Checks block can be placed at given position"}, params={@ParameterDoc(type=BlockDef.class, name="block", desc={"the block to check for"}), @ParameterDoc(type=PosDef.class, name="pos", desc={"the position to check"})}, examples={"player.canPlaceBlockAt(block, pos);"})
    private boolean canPlaceBlockAtPos(Arguments arguments) {
        ClientScriptUtils.warnMainThread("canPlaceBlockAt", arguments.getInterpreter());
        class_2680 state = ((ScriptBlockState)arguments.skip().nextPrimitive(BlockDef.class)).state;
        class_2338 pos = ((ScriptPos)arguments.nextPrimitive(PosDef.class)).getBlockPos();
        boolean canPlace = state.method_26184((class_4538)EssentialUtils.getWorld(), pos);
        canPlace = canPlace && EssentialUtils.getWorld().method_8628(state, pos, class_3726.method_16195((class_1297)EssentialUtils.getPlayer()));
        return canPlace;
    }

    @FunctionDoc(name="canPlaceBlockAt", desc={"Checks block can be placed at given position"}, params={@ParameterDoc(type=BlockDef.class, name="block", desc={"the block to check for"}), @ParameterDoc(type=NumberDef.class, name="x", desc={"the x coordinate of the position"}), @ParameterDoc(type=NumberDef.class, name="y", desc={"the y coordinate of the position"}), @ParameterDoc(type=NumberDef.class, name="z", desc={"the z coordinate of the position"})}, examples={"player.canPlaceBlockAt(block, 0, 0, 0);"})
    private boolean canPlaceBlockAtPos1(Arguments arguments) {
        ClientScriptUtils.warnMainThread("canPlaceBlockAt", arguments.getInterpreter());
        class_2680 state = ((ScriptBlockState)arguments.skip().nextPrimitive(BlockDef.class)).state;
        int x = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        int y = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        int z = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        class_2338 pos = new class_2338(x, y, z);
        boolean canPlace = state.method_26184((class_4538)EssentialUtils.getWorld(), pos);
        canPlace = canPlace && EssentialUtils.getWorld().method_8628(state, pos, class_3726.method_16195((class_1297)EssentialUtils.getPlayer()));
        return canPlace;
    }

    @FunctionDoc(name="jump", desc={"This will make the player jump if they are on the ground"}, examples={"player.jump();"})
    private Void jump(Arguments arguments) {
        ClientScriptUtils.ensureMainThread("jump", arguments.getInterpreter(), () -> {
            class_746 player = EssentialUtils.getPlayer();
            if (player.method_24828()) {
                player.method_6043();
                player.method_24830(false);
            }
        });
        return null;
    }

    @FunctionDoc(name="getLookingAtEntity", desc={"This gets the entity that the player is currently looking at"}, returns=@ReturnDoc(type=EntityDef.class, desc={"the entity that the player is looking at"}), examples={"player.getLookingAtEntity();"})
    private class_1297 getLookingAtEntity(Arguments arguments) {
        ClientScriptUtils.warnMainThread("getLookingAtEntity", arguments.getInterpreter());
        class_239 class_2392 = EssentialUtils.getClient().field_1765;
        if (class_2392 instanceof class_3966) {
            class_3966 hitResult = (class_3966)class_2392;
            return hitResult.method_17782();
        }
        return null;
    }

    @FunctionDoc(name="swapSlots", desc={"The allows you to swap two slots with one another.", "A note about slot order is that slots go from top to bottom.", "This will throw an errof if the slots are out of bounds"}, params={@ParameterDoc(type=NumberDef.class, name="slot1", desc={"the slot to swap with slot2"}), @ParameterDoc(type=NumberDef.class, name="slot2", desc={"the slot to swap with slot1"})}, examples={"player.swapSlots(13, 14);"})
    private Void swapSlots(Arguments arguments) {
        class_746 player = EssentialUtils.getPlayer();
        int slot1 = ((Double)arguments.skip().nextPrimitive(NumberDef.class)).intValue();
        int slot2 = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        ClientScriptUtils.ensureMainThread("swapSlots", arguments.getInterpreter(), () -> {
            class_1703 screenHandler = player.field_7512;
            int size = screenHandler.field_7761.size();
            if (slot1 >= size || slot1 < 0 || slot2 >= size || slot2 < 0) {
                throw new RuntimeError("That slot is out of bounds");
            }
            int firstMapped = InventoryUtils.isSlotInHotbar(screenHandler, slot1);
            int secondMapped = InventoryUtils.isSlotInHotbar(screenHandler, slot2);
            if (firstMapped == -1) {
                if (secondMapped == -1) {
                    class_636 interactionManager = EssentialUtils.getInteractionManager();
                    interactionManager.method_2906(screenHandler.field_7763, slot1, 0, class_1713.field_7791, (class_1657)player);
                    interactionManager.method_2906(screenHandler.field_7763, slot2, 0, class_1713.field_7791, (class_1657)player);
                    interactionManager.method_2906(screenHandler.field_7763, slot1, 0, class_1713.field_7791, (class_1657)player);
                    player.method_31548().method_7381();
                } else {
                    InventoryUtils.swapSlot(screenHandler, slot1, secondMapped);
                }
            } else {
                InventoryUtils.swapSlot(screenHandler, slot2, firstMapped);
            }
        });
        return null;
    }

    @FunctionDoc(name="getSwappableHotbarSlot", desc={"This will get the next empty slot in the hotbar starting from the current slot", "going right, and if it reaches the end of the hotbar it will start from the beginning.", "If there is no empty slot it will return any slot that doesn't have an item with", "an enchantment that is in the hotbar, again going from the current slot", "if there is no such slot it will return the current selected slot"}, returns=@ReturnDoc(type=NumberDef.class, desc={"the slot that is swappable"}), examples={"player.getSwappableHotbarSlot();"})
    private int getSwappableHotbarSlot(Arguments arguments) {
        return EssentialUtils.getPlayer().method_31548().method_7386();
    }

    @FunctionDoc(name="spectatorTeleport", desc={"This allows you to teleport to any entity as long as you are in spectator mode"}, params={@ParameterDoc(type=EntityDef.class, name="entity", desc={"the entity to teleport to, this can also be a string (UUID of entity)"})}, examples={"player.spectatorTeleport(player.getLookingAtEntity());"})
    private boolean spectatorTeleport(Arguments arguments) {
        UUID uuid;
        class_746 player = EssentialUtils.getPlayer();
        if (!player.method_7325()) {
            return false;
        }
        arguments.skip();
        if (arguments.isNext(StringDef.class)) {
            String uuidAsString = (String)arguments.nextPrimitive(StringDef.class);
            uuid = (UUID)RuntimeError.wrap(() -> UUID.fromString(uuidAsString));
        } else {
            uuid = ((class_1297)arguments.nextPrimitive(EntityDef.class)).method_5667();
        }
        EssentialUtils.getNetworkHandler().method_52787((class_2596)new class_2884(uuid));
        return true;
    }

    @FunctionDoc(name="swapHands", desc={"This will swap the player's main hand with the off hand"}, examples={"player.swapHands();"})
    private boolean swapHands(Arguments arguments) {
        class_746 player = EssentialUtils.getPlayer();
        if (player.method_7325()) {
            return false;
        }
        ClientScriptUtils.ensureMainThread("swapHands", arguments.getInterpreter(), () -> EssentialUtils.getNetworkHandler().method_52787((class_2596)new class_2846(class_2846.class_2847.field_12969, class_2338.field_10980, class_2350.field_11033)));
        return true;
    }

    @FunctionDoc(name="swingHand", desc={"This will play the player's hand swing animation for a given hand"}, params={@ParameterDoc(type=StringDef.class, name="hand", desc={"the hand to swing, this should be either 'main_hand' or 'off_hand'"})}, examples={"player.swingHand('main_hand');"})
    private Void swingHand(Arguments arguments) {
        String handAsString = arguments.skip().nextConstant();
        class_1268 hand = ClientScriptUtils.stringToHand(handAsString);
        ClientScriptUtils.ensureMainThread("swingHand", arguments.getInterpreter(), () -> EssentialUtils.getPlayer().method_6104(hand));
        return null;
    }

    @FunctionDoc(name="clickSlot", desc={"This allows you to click a slot with either right or left click", "and a slot action, the click must be either 'left' or 'right' or a number (for swap).", "The action must be either 'click', 'shift_click', 'swap', 'middle_click',", "'throw', 'drag', or 'double_click' or an error will be thrown"}, params={@ParameterDoc(type=NumberDef.class, name="slot", desc={"the slot to click"}), @ParameterDoc(type=StringDef.class, name="click", desc={"the click type, this should be either 'left' or 'right'"}), @ParameterDoc(type=StringDef.class, name="action", desc={"the action to perform"})}, examples={"player.clickSlot(9, 'left', 'double_click');"})
    private Void clickSlot(Arguments arguments) {
        int clickData;
        int slot = ((Double)arguments.skip().nextPrimitive(NumberDef.class)).intValue();
        if (arguments.isNext(StringDef.class)) {
            clickData = switch (((String)arguments.nextPrimitive(StringDef.class)).toLowerCase()) {
                case "right" -> 1;
                case "left" -> 0;
                default -> throw new RuntimeError("Invalid clickData must be 'left' or 'right' or a number");
            };
        } else if (arguments.isNext(NumberDef.class)) {
            clickData = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        } else {
            throw new RuntimeError("Invalid clickData must be 'left' or 'right' or a number");
        }
        String action = arguments.nextConstant();
        class_1713 slotActionType = ClientScriptUtils.stringToSlotActionType(action);
        ClientScriptUtils.ensureMainThread("clickSlot", arguments.getInterpreter(), () -> {
            class_746 player = EssentialUtils.getPlayer();
            class_1703 screenHandler = player.field_7512;
            int size = screenHandler.field_7761.size();
            if (slot != -999 && slot >= size || slot < 0) {
                throw new RuntimeError("That slot is out of bounds");
            }
            EssentialUtils.getInteractionManager().method_2906(screenHandler.field_7763, slot, clickData, slotActionType, (class_1657)player);
        });
        return null;
    }

    @FunctionDoc(name="clickCreativeStack", desc={"This allows you to click Creative stack, but requires sync with server"}, params={@ParameterDoc(type=ItemStackDef.class, name="itemStack", desc={"Stack to click"}), @ParameterDoc(type=NumberDef.class, name="slot", desc={"the slot to click"})}, examples={"player.clickCreativeStack(Material.DIAMOND_SWORD.asItemStack(), 9);"})
    private Void clickCreativeStack(Arguments arguments) {
        ScriptItemStack stackValue = (ScriptItemStack)arguments.skip().nextPrimitive(ItemStackDef.class);
        int index = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        ClientScriptUtils.ensureMainThread("clickCreativeStack", arguments.getInterpreter(), () -> {
            class_746 player = EssentialUtils.getPlayer();
            class_1703 screenHandler = player.field_7512;
            int size = screenHandler.field_7761.size();
            if (index >= size || index < 0) {
                throw new RuntimeError("That slot is out of bounds");
            }
            EssentialUtils.getInteractionManager().method_2909(stackValue.stack, index);
        });
        return null;
    }

    @FunctionDoc(name="shiftClickSlot", desc={"This allows you to shift click a slot"}, params={@ParameterDoc(type=NumberDef.class, name="slot", desc={"the slot to click"})}, examples={"player.shiftClickSlot(9);"})
    private Void shiftClickSlot(Arguments arguments) {
        int index = ((Double)arguments.skip().nextPrimitive(NumberDef.class)).intValue();
        ClientScriptUtils.ensureMainThread("shiftClickSlot", arguments.getInterpreter(), () -> {
            class_746 player = EssentialUtils.getPlayer();
            class_1703 screenHandler = player.field_7512;
            int size = screenHandler.field_7761.size();
            if (index >= size || index < 0) {
                throw new RuntimeError("That slot is out of bounds");
            }
            InventoryUtils.shiftClickSlot(screenHandler, index);
        });
        return null;
    }

    @FunctionDoc(name="dropSlot", desc={"This allows you to drop the items in a slot"}, params={@ParameterDoc(type=NumberDef.class, name="slot", desc={"the slot to drop"})}, examples={"player.dropSlot(9);"})
    private Void dropSlot(Arguments arguments) {
        int index = ((Double)arguments.skip().nextPrimitive(NumberDef.class)).intValue();
        ClientScriptUtils.ensureMainThread("shiftClickSlot", arguments.getInterpreter(), () -> {
            class_746 player = EssentialUtils.getPlayer();
            class_1703 screenHandler = player.field_7512;
            int size = screenHandler.field_7761.size();
            if (index >= size || index < 0) {
                throw new RuntimeError("That slot is out of bounds");
            }
            EssentialUtils.getInteractionManager().method_2906(screenHandler.field_7763, index, 1, class_1713.field_7795, (class_1657)player);
        });
        return null;
    }

    @FunctionDoc(name="getCurrentScreen", desc={"This gets the current screen the player is in"}, returns=@ReturnDoc(type=ScreenDef.class, desc={"the screen the player is in, if the player is not in a screen it will return null"}), examples={"screen = player.getCurrentScreen();"})
    private class_437 getCurrentScreen(Arguments arguments) {
        ClientScriptUtils.warnMainThread("getCurrentScreen", arguments.getInterpreter());
        return EssentialUtils.getClient().field_1755;
    }

    @FunctionDoc(name="craft", desc={"This allows you to craft a recipe, this can be 2x2 or 3x3", "The list you pass in must contain Materials or ItemStacks", "Most of the time you should use craftRecipe instead. You must", "be in an appropriate gui for the crafting recipe or an error will be thrown"}, params={@ParameterDoc(type=ListDef.class, name="recipe", desc={"a list of materials making up the recipe you want to craft including air"})}, examples={"chestRecipe = [\n\tMaterial.OAK_PLANKS, Material.OAK_PLANKS, Material.OAK_PLANKS,\n\tMaterial.OAK_PLANKS,    Material.AIR    , Material.OAK_PLANKS,\n\tMaterial.OAK_PLANKS, Material.OAK_PLANKS, Material.OAK_PLANKS\n];\nplayer.craft(chestRecipe);\n"})
    private Void craft(Arguments arguments) {
        ArucasList listValue = (ArucasList)arguments.skip().nextPrimitive(ListDef.class);
        if (listValue.size() != 4 && listValue.size() != 9) {
            throw new RuntimeError("Recipe must either be 3x3 or 2x2");
        }
        class_1799[] itemStacks = new class_1799[listValue.size()];
        for (int i = 0; i < listValue.size(); ++i) {
            ScriptMaterial value = (ScriptMaterial)listValue.get(i).getPrimitive(MaterialDef.class);
            if (value == null) {
                throw new RuntimeError("The recipe must only include items or materials");
            }
            itemStacks[i] = value.asItemStack();
        }
        ClientScriptUtils.ensureMainThread("craft", arguments.getInterpreter(), () -> {
            class_310 client = EssentialUtils.getClient();
            class_437 patt0$temp = client.field_1755;
            if (!(patt0$temp instanceof class_465)) {
                throw new RuntimeError("Must be in a crafting GUI");
            }
            class_465 handledScreen = (class_465)patt0$temp;
            if (itemStacks.length == 9 && !(handledScreen instanceof class_479)) {
                throw new RuntimeError("3x3 recipes require crafting table GUI");
            }
            class_1703 handler = handledScreen.method_17577();
            InventoryUtils.tryMoveItemsToCraftingGridSlots(itemStacks, handler);
            InventoryUtils.shiftClickSlot(handler, 0);
        });
        return null;
    }

    @FunctionDoc(name="craftRecipe", desc={"This allows you to craft a predefined recipe"}, params={@ParameterDoc(type=RecipeDef.class, name="recipe", desc={"the recipe you want to craft"})}, examples={"player.craftRecipe(Recipe.CHEST);"})
    private Void craftRecipe(Arguments arguments) {
        class_8786 recipe = (class_8786)arguments.skip().nextPrimitive(RecipeDef.class);
        ClientScriptUtils.ensureMainThread("craftRecipe", arguments.getInterpreter(), () -> InventoryUtils.craftRecipe(recipe, false, true));
        return null;
    }

    @FunctionDoc(name="craftRecipe", desc={"This allows you to craft a predefined recipe"}, params={@ParameterDoc(type=RecipeDef.class, name="recipe", desc={"the recipe you want to craft"}), @ParameterDoc(type=BooleanDef.class, name="boolean", desc={"whether result should be dropped or not"})}, examples={"player.craftRecipe(Recipe.CHEST, true);"})
    private Void craftRecipeDrop(Arguments arguments) {
        class_8786 recipe = (class_8786)arguments.skip().nextPrimitive(RecipeDef.class);
        boolean shouldDrop = (Boolean)arguments.nextPrimitive(BooleanDef.class);
        ClientScriptUtils.ensureMainThread("craftRecipe", arguments.getInterpreter(), () -> InventoryUtils.craftRecipe(recipe, shouldDrop, true));
        return null;
    }

    @FunctionDoc(name="craftRecipe", desc={"This allows you to craft a predefined recipe"}, params={@ParameterDoc(type=RecipeDef.class, name="recipe", desc={"the recipe you want to craft"}), @ParameterDoc(type=BooleanDef.class, name="boolean", desc={"whether result should be dropped or not"}), @ParameterDoc(type=BooleanDef.class, name="boolean", desc={"whether whole stack should be crafted or not"})}, examples={"player.craftRecipe(Recipe.CHEST, true, false);"})
    private Void craftRecipeDropAll(Arguments arguments) {
        class_8786 recipe = (class_8786)arguments.skip().nextPrimitive(RecipeDef.class);
        boolean shouldDrop = (Boolean)arguments.nextPrimitive(BooleanDef.class);
        boolean shouldCraftAll = (Boolean)arguments.nextPrimitive(BooleanDef.class);
        ClientScriptUtils.ensureMainThread("craftRecipe", arguments.getInterpreter(), () -> InventoryUtils.craftRecipe(recipe, shouldDrop, shouldCraftAll));
        return null;
    }

    @FunctionDoc(name="clickRecipe", desc={"This allows you to click a predefined recipe"}, params={@ParameterDoc(type=RecipeDef.class, name="recipe", desc={"the recipe you want to select"})}, examples={"player.clickRecipe(Recipe.CHEST);"})
    private Void clickRecipe1(Arguments arguments) {
        class_8786 recipe = (class_8786)arguments.skip().nextPrimitive(RecipeDef.class);
        ClientScriptUtils.ensureMainThread("clickRecipe", arguments.getInterpreter(), () -> InventoryUtils.clickRecipe(recipe, false));
        return null;
    }

    @FunctionDoc(name="clickRecipe", desc={"This allows you to click a predefined recipe"}, params={@ParameterDoc(type=RecipeDef.class, name="recipe", desc={"the recipe you want to select"}), @ParameterDoc(type=BooleanDef.class, name="boolean", desc={"whether to shift click the recipe"})}, examples={"player.clickRecipe(Recipe.CHEST, true);"})
    private Void clickRecipe2(Arguments arguments) {
        class_8786 recipe = (class_8786)arguments.skip().nextPrimitive(RecipeDef.class);
        boolean craftAll = (Boolean)arguments.nextPrimitive(BooleanDef.class);
        ClientScriptUtils.ensureMainThread("clickRecipe", arguments.getInterpreter(), () -> InventoryUtils.clickRecipe(recipe, craftAll));
        return null;
    }

    @FunctionDoc(name="logout", desc={"This forces the player to leave the world"}, params={@ParameterDoc(type=StringDef.class, name="message", desc={"the message to display to the player on the logout screen"})}, examples={"player.logout('You've been lazy!');"})
    private Void logout(Arguments arguments) {
        String reason = (String)arguments.skip().nextPrimitive(StringDef.class);
        ClientScriptUtils.ensureMainThread("logout", arguments.getInterpreter(), () -> EssentialUtils.getNetworkHandler().method_10839(new class_9812((class_2561)class_2561.method_43470((String)reason))));
        return null;
    }

    @FunctionDoc(name="attackEntity", desc={"This makes your player attack an entity without", "having to be looking at it or clicking on the entity"}, params={@ParameterDoc(type=EntityDef.class, name="entity", desc={"the entity to attack"})}, examples={"allEntities = client.getWorld().getAllEntities();\nforeach (entity : allEntities) {\n\tif (entity.getId() == \"villager\" && player.getSquaredDistanceTo(entity) < 5) {\n\t\tplayer.attackEntity(entity);\n\t\tbreak;\n\t}\n}\n"})
    private Void attackEntity(Arguments arguments) {
        class_1297 entity = (class_1297)arguments.skip().nextPrimitive(EntityDef.class);
        ClientScriptUtils.ensureMainThread("interactWithEntity", arguments.getInterpreter(), () -> EssentialUtils.getInteractionManager().method_2918((class_1657)EssentialUtils.getPlayer(), entity));
        return null;
    }

    @FunctionDoc(name="interactWithEntity", desc={"This allows your player to interact with an entity without", "having to be looking at it or clicking on the entity"}, params={@ParameterDoc(type=EntityDef.class, name="entity", desc={"the entity to interact with"})}, examples={"allEntities = client.getWorld().getAllEntities();\nforeach (entity : allEntities) {\n\tif (entity.getId() == \"villager\" && player.getSquaredDistanceTo(entity) < 5) {\n\t\tplayer.interactWithEntity(entity);\n\t\tbreak;\n\t}\n}\n"})
    private Void interactWithEntity(Arguments arguments) {
        class_1297 entity = (class_1297)arguments.skip().nextPrimitive(EntityDef.class);
        ClientScriptUtils.ensureMainThread("interactWithEntity", arguments.getInterpreter(), () -> EssentialUtils.getInteractionManager().method_2905((class_1657)EssentialUtils.getPlayer(), entity, class_1268.field_5808));
        return null;
    }

    @FunctionDoc(name="anvil", desc={"This allows you to combine two items in an anvil"}, params={@ParameterDoc(type=FunctionDef.class, name="predicate1", desc={"a function determining whether the first ItemStack meets a criteria"}), @ParameterDoc(type=FunctionDef.class, name="predicate2", desc={"a function determining whether the second ItemStack meets a criteria"})}, returns=@ReturnDoc(type=FutureDef.class, desc={"whether the anvilling was successful, if the player doesn't have enough levels it will return the xp cost"}), examples={"// Enchant a pickaxe with mending\nplayer.anvil(\n\t// Predicate for pick\n\tfun(item) {\n\t\t// We want a netherite pickaxe without mending\n\t\tif (item.getItemId() == \"netherite_pickaxe\") {\n\t\t\thasMending = item.getEnchantments().getKeys().contains(\"mending\");\n\t\t\treturn !hasMending;\n\t\t}\n\t\treturn false;\n\t},\n\t// Predicate for book\n\tfun(item) {\n\t\t// We want a book with mending\n\t\tif (item.getItemId() == \"enchanted_book\") {\n\t\t\thasMending = item.getEnchantments().getKeys().contains(\"mending\");\n\t\t\treturn hasMending;\n\t\t}\n\t\treturn false;\n\t}\n);\n"})
    private Future<Object> anvil2(Arguments arguments) {
        ArucasFunction predicate1 = (ArucasFunction)arguments.skip().nextPrimitive(FunctionDef.class);
        ArucasFunction predicate2 = (ArucasFunction)arguments.nextPrimitive(FunctionDef.class);
        Interpreter interpreter = arguments.getInterpreter();
        return ClientScriptUtils.ensureMainThread("anvil", interpreter, () -> InventoryUtils.anvil(interpreter, predicate1, predicate2, false));
    }

    @FunctionDoc(name="anvil", desc={"This allows you to combine two items in an anvil"}, params={@ParameterDoc(type=FunctionDef.class, name="predicate1", desc={"a function determining whether the first ItemStack meets a criteria"}), @ParameterDoc(type=FunctionDef.class, name="predicate2", desc={"a function determining whether the second ItemStack meets a criteria"}), @ParameterDoc(type=BooleanDef.class, name="take", desc={"whether you should take the item after putting items in the anvil"})}, returns=@ReturnDoc(type=FutureDef.class, desc={"whether the anvilling was successful, if the player doesn't have enough levels it will return the xp cost"}), examples={"// Enchant a pickaxe with mending\nplayer.anvil(\n\t// Predicate for pick\n\tfun(item) {\n\t\t// We want a netherite pickaxe without mending\n\t\tif (item.getItemId() == \"netherite_pickaxe\") {\n\t\t\thasMending = item.getEnchantments().getKeys().contains(\"mending\");\n\t\t\treturn !hasMending;\n\t\t}\n\t\treturn false;\n\t},\n\t// Predicate for book\n\tfun(item) {\n\t\t// We want a book with mending\n\t\tif (item.getItemId() == \"enchanted_book\") {\n\t\t\thasMending = item.getEnchantments().getKeys().contains(\"mending\");\n\t\t\treturn hasMending;\n\t\t}\n\t\treturn false;\n\t},\n\tfalse\n);\n"})
    private Future<Object> anvil3(Arguments arguments) {
        ArucasFunction predicate1 = (ArucasFunction)arguments.skip().nextPrimitive(FunctionDef.class);
        ArucasFunction predicate2 = (ArucasFunction)arguments.nextPrimitive(FunctionDef.class);
        boolean take = (Boolean)arguments.nextPrimitive(BooleanDef.class);
        Interpreter interpreter = arguments.getInterpreter();
        return ClientScriptUtils.ensureMainThread("anvil", interpreter, () -> InventoryUtils.anvil(interpreter, predicate1, predicate2, take));
    }

    @FunctionDoc(name="anvilRename", desc={"This allows you to name an item in an anvil"}, params={@ParameterDoc(type=StringDef.class, name="name", desc={"the name you want to give the item"}), @ParameterDoc(type=FunctionDef.class, name="predicate", desc={"whether the ItemStack meets a certain criteria"})}, returns=@ReturnDoc(type=FutureDef.class, desc={"whether the anvilling was successful, if the player doesn't have enough levels it will return the xp cost"}), examples={"// Rename any shulker box\nplayer.anvilRename(\"Rocket Box\",\n\tfun(item) {\n\t\tisShulker = item.getItemId().containsString(\"shulker_box\"));\n\t\treturn isShulker;\n\t}\n);\n"})
    private Future<Object> anvilRename(Arguments arguments) {
        String newName = (String)arguments.skip().nextPrimitive(StringDef.class);
        ArucasFunction function = (ArucasFunction)arguments.nextPrimitive(FunctionDef.class);
        Interpreter interpreter = arguments.getInterpreter();
        return ClientScriptUtils.ensureMainThread("anvilRename", interpreter, () -> InventoryUtils.anvilRename(interpreter, newName, function));
    }

    @FunctionDoc(name="stonecutter", desc={"This allows you to use the stonecutter"}, params={@ParameterDoc(type=MaterialDef.class, name="itemInput", desc={"the item or material you want to input"}), @ParameterDoc(type=MaterialDef.class, name="itemOutput", desc={"the item or material you want to craft"})}, returns=@ReturnDoc(type=FutureDef.class, desc={"whether the result was successful"}), examples={"player.stonecutter(Material.STONE.asItemstack(), Material.STONE_BRICKS.asItemStack());"})
    private Future<Boolean> stonecutter(Arguments arguments) {
        class_1792 itemInput = ((ScriptMaterial)arguments.skip().nextPrimitive(MaterialDef.class)).asItem();
        class_1792 itemOutput = ((ScriptMaterial)arguments.nextPrimitive(MaterialDef.class)).asItem();
        return ClientScriptUtils.ensureMainThread("stonecutter", arguments.getInterpreter(), () -> InventoryUtils.stonecutter(itemInput, itemOutput));
    }

    @FunctionDoc(name="clickStonecuttingRecipe", desc={"This allows you to click the stonecutter recipe. Unlike clickRecipe, stonecutter wants you to manually send input items."}, params={@ParameterDoc(type=RecipeDef.class, name="cuttingRecipe", desc={"Stone cutting recipe"})}, examples={"player.clickCuttingRecipe(cuttingRecipe);"})
    private Void clickCuttingRecipe(Arguments arguments) {
        class_8786 recipe = (class_8786)arguments.skip().nextPrimitive(RecipeDef.class);
        class_1860 class_18602 = recipe.comp_1933();
        if (class_18602 instanceof class_3975) {
            class_3975 cuttingRecipe = (class_3975)class_18602;
            ClientScriptUtils.ensureMainThread("clickCuttingRecipe", arguments.getInterpreter(), () -> {
                InventoryUtils.clickCuttingRecipe(cuttingRecipe);
                return null;
            });
        }
        return null;
    }

    @FunctionDoc(name="clickStonecuttingRecipe", desc={"This allows you to click the stonecutter recipe. Unlike clickRecipe, stonecutter wants you to manually send input items."}, params={@ParameterDoc(type=MaterialDef.class, name="inputItem", desc={"Stone cutting recipe input item"}), @ParameterDoc(type=MaterialDef.class, name="outputItem", desc={"Stone cutting recipe output item"})}, examples={"player.clickCuttingRecipe(ItemStack.of('cobblestone'), ItemStack.of('cobblestone_slab');"})
    private Void clickCuttingRecipe2(Arguments arguments) {
        class_1792 inputItem = ((ScriptMaterial)arguments.skip().nextPrimitive(MaterialDef.class)).asItem();
        class_1792 outputItem = ((ScriptMaterial)arguments.nextPrimitive(MaterialDef.class)).asItem();
        ClientScriptUtils.ensureMainThread("clickCuttingRecipe", arguments.getInterpreter(), () -> {
            InventoryUtils.clickCuttingRecipe(inputItem, outputItem);
            return null;
        });
        return null;
    }

    @FunctionDoc(name="fakeLook", desc={"This makes the player 'fake' looking in a direction, this can be", "used to place blocks in unusual orientations without moving the camera"}, params={@ParameterDoc(type=NumberDef.class, name="yaw", desc={"the yaw to look at"}), @ParameterDoc(type=NumberDef.class, name="pitch", desc={"the pitch to look at"}), @ParameterDoc(type=StringDef.class, name="direction", desc={"the direction to look at"}), @ParameterDoc(type=NumberDef.class, name="duration", desc={"the duration of the look in ticks"})}, examples={"player.fakeLook(90, 0, 'up', 100);"})
    private Void fakeLook(Arguments arguments) {
        float yaw = ((Double)arguments.skip().nextPrimitive(NumberDef.class)).floatValue();
        float pitch = ((Double)arguments.nextPrimitive(NumberDef.class)).floatValue();
        String directionAsString = arguments.nextConstant();
        int ticks = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        class_2350 direction = ClientScriptUtils.stringToDirection(directionAsString, class_2350.field_11033);
        ClientScriptUtils.ensureMainThread("fakeLook", arguments.getInterpreter(), () -> {
            BetterAccurateBlockPlacement.fakeYaw = yaw;
            BetterAccurateBlockPlacement.fakePitch = pitch;
            BetterAccurateBlockPlacement.fakeDirection = direction;
            BetterAccurateBlockPlacement.requestedTicks = Math.max(20, ticks);
            BetterAccurateBlockPlacement.sendLookPacket(EssentialUtils.getPlayer());
        });
        return null;
    }

    @FunctionDoc(name="swapPlayerSlotWithHotbar", desc={"This allows you to swap a slot in the player's inventory with the hotbar"}, params={@ParameterDoc(type=NumberDef.class, name="slot", desc={"the slot to swap"})}, examples={"player.swapPlayerSlotWithHotbar(15);"})
    private Void swapPlayerSlotWithHotbar(Arguments arguments) {
        int slotToSwap = ((Double)arguments.skip().nextPrimitive(NumberDef.class)).intValue();
        ClientScriptUtils.ensureMainThread("swapPlayerSlotWithHotbar", arguments.getInterpreter(), () -> {
            class_1661 inventory = EssentialUtils.getPlayer().method_31548();
            if (slotToSwap < 0 || slotToSwap > inventory.field_7547.size()) {
                throw new RuntimeError("That slot is out of bounds");
            }
            class_634 networkHandler = EssentialUtils.getNetworkHandler();
            int prepareSlot = inventory.method_7386();
            networkHandler.method_52787((class_2596)new class_2868(prepareSlot));
            inventory.method_7365(slotToSwap);
            networkHandler.method_52787((class_2596)new class_2838(slotToSwap));
        });
        return null;
    }

    @FunctionDoc(name="breakBlock", desc={"This breaks a block at a given position, if it is able to be broken"}, params={@ParameterDoc(type=PosDef.class, name="pos", desc={"the position of the block"})}, returns=@ReturnDoc(type=FutureDef.class, desc={"the future will be completed when the block is broken"}), examples={"player.breakBlock(new Pos(0, 0, 0));"})
    private Future<Void> breakBlock(Arguments arguments) {
        class_2338 blockPos = ((ScriptPos)arguments.skip().nextPrimitive(PosDef.class)).getBlockPos();
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        ClientScriptUtils.ensureMainThread("breakBlock", arguments.getInterpreter(), () -> EssentialUtils.mineBlock(blockPos, () -> arguments.getInterpreter().isRunning(), future));
        return future;
    }

    @FunctionDoc(deprecated={"Consider using other alternatives for breaking blocks, e.g. <Player>.breakBlock"}, name="updateBreakingBlock", desc={"This allows you to update your block breaking progress at a position"}, params={@ParameterDoc(type=NumberDef.class, name="x", desc={"the x position"}), @ParameterDoc(type=NumberDef.class, name="y", desc={"the y position"}), @ParameterDoc(type=NumberDef.class, name="z", desc={"the z position"})}, examples={"player.updateBreakingBlock(0, 0, 0);"})
    private Void updateBreakingBlock(Arguments arguments) {
        double x = ((Double)arguments.skip().nextPrimitive(NumberDef.class)).intValue();
        double y = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        double z = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        class_2338 blockPos = EssentialUtils.vec3dToBlockPos(x, y, z);
        ClientScriptUtils.ensureMainThread("updateBreakingBlock", arguments.getInterpreter(), () -> {
            EssentialUtils.getInteractionManager().method_2902(blockPos, class_2350.field_11036);
            EssentialUtils.getPlayer().method_6104(class_1268.field_5808);
        });
        return null;
    }

    @FunctionDoc(deprecated={"Consider using other alternatives for breaking blocks, e.g. <Player>.breakBlock"}, name="updateBreakingBlock", desc={"This allows you to update your block breaking progress at a position"}, params={@ParameterDoc(type=PosDef.class, name="pos", desc={"the position of the block"})}, examples={"player.updateBreakingBlock(new Pos(0, 0, 0));"})
    private Void updateBreakingBlockPos(Arguments arguments) {
        class_2338 blockPos = ((ScriptPos)arguments.skip().nextPrimitive(PosDef.class)).getBlockPos();
        ClientScriptUtils.ensureMainThread("updateBreakingBlock", arguments.getInterpreter(), () -> {
            EssentialUtils.getInteractionManager().method_2902(blockPos, class_2350.field_11036);
            EssentialUtils.getPlayer().method_6104(class_1268.field_5808);
        });
        return null;
    }

    @FunctionDoc(name="attackBlock", desc={"This allows you to attack a block at a position and direction"}, params={@ParameterDoc(type=NumberDef.class, name="x", desc={"the x position"}), @ParameterDoc(type=NumberDef.class, name="y", desc={"the y position"}), @ParameterDoc(type=NumberDef.class, name="z", desc={"the z position"}), @ParameterDoc(type=StringDef.class, name="direction", desc={"the direction of the attack, e.g. 'up', 'north', 'east', etc."})}, examples={"player.attackBlock(0, 0, 0, 'up');"})
    private Void attackBlock(Arguments arguments) {
        double x = ((Double)arguments.skip().nextPrimitive(NumberDef.class)).intValue();
        double y = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        double z = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        String stringDirection = arguments.nextConstant();
        class_2350 direction = ClientScriptUtils.stringToDirection(stringDirection, class_2350.field_11033);
        ClientScriptUtils.ensureMainThread("attackBlock", arguments.getInterpreter(), () -> EssentialUtils.getInteractionManager().method_2910(EssentialUtils.vec3dToBlockPos(x, y, z), direction));
        return null;
    }

    @FunctionDoc(name="attackBlock", desc={"This allows you to attack a block at a position and direction"}, params={@ParameterDoc(type=PosDef.class, name="pos", desc={"the position of the block"}), @ParameterDoc(type=StringDef.class, name="direction", desc={"the direction of the attack, e.g. 'up', 'north', 'east', etc."})}, examples={"player.attackBlock(new Pos(0, 0, 0), 'up');"})
    private Void attackBlockPos(Arguments arguments) {
        class_2338 pos = ((ScriptPos)arguments.skip().nextPrimitive(PosDef.class)).getBlockPos();
        String stringDirection = arguments.nextConstant();
        class_2350 direction = ClientScriptUtils.stringToDirection(stringDirection, class_2350.field_11033);
        ClientScriptUtils.ensureMainThread("attackBlock", arguments.getInterpreter(), () -> EssentialUtils.getInteractionManager().method_2910(pos, direction));
        return null;
    }

    @FunctionDoc(name="interactItem", desc={"This allows you to interact item with given Hand"}, params={@ParameterDoc(type=StringDef.class, name="hand", desc={" Hand to use, either 'main' or 'offhand'"})}, examples={"player.interactItem('main');"})
    private Void interactItem(Arguments arguments) {
        String handAsString = arguments.skip().nextConstant();
        class_1268 hand = ClientScriptUtils.stringToHand(handAsString);
        ClientScriptUtils.ensureMainThread("interactItem", arguments.getInterpreter(), () -> EssentialUtils.getInteractionManager().method_2919((class_1657)EssentialUtils.getPlayer(), hand));
        return null;
    }

    @FunctionDoc(name="interactBlock", desc={"This allows you to interact with a block at a position and direction"}, params={@ParameterDoc(type=PosDef.class, name="pos", desc={"the position of the block"}), @ParameterDoc(type=StringDef.class, name="direction", desc={"the direction of the interaction, e.g. 'up', 'north', 'east', etc."})}, returns=@ReturnDoc(type=FutureDef.class, desc={"the result of the placement as a string; this can be: 'success', 'pass', 'fail'"}), examples={"player.interactBlock(new Pos(0, 0, 0), 'up');"})
    private Future<String> interactBlockPos(Arguments arguments) {
        ScriptPos pos = (ScriptPos)arguments.skip().nextPrimitive(PosDef.class);
        String direction = arguments.nextConstant();
        return this.interactInternal(arguments.getInterpreter(), direction, EssentialUtils.getPlayer().method_6058(), pos.getVec3d(), pos.getBlockPos(), false);
    }

    @FunctionDoc(name="interactBlock", desc={"This allows you to interact with a block at a position, direction, and hand"}, params={@ParameterDoc(type=PosDef.class, name="pos", desc={"the position of the block"}), @ParameterDoc(type=StringDef.class, name="direction", desc={"the direction of the interaction, e.g. 'up', 'north', 'east', etc."}), @ParameterDoc(type=StringDef.class, name="hand", desc={"the hand to use, e.g. 'main_hand', 'off_hand'"})}, returns=@ReturnDoc(type=FutureDef.class, desc={"the result of the placement as a string; this can be: 'success', 'pass', 'fail'"}), examples={"player.interactBlock(new Pos(0, 0, 0), 'up', 'off_hand');"})
    private Future<String> interactBlockPosHand(Arguments arguments) {
        ScriptPos pos = (ScriptPos)arguments.skip().nextPrimitive(PosDef.class);
        String direction = arguments.nextConstant();
        String handAsString = arguments.nextConstant();
        class_1268 hand = ClientScriptUtils.stringToHand(handAsString);
        return this.interactInternal(arguments.getInterpreter(), direction, hand, pos.getVec3d(), pos.getBlockPos(), false);
    }

    @FunctionDoc(name="interactBlock", desc={"This allows you to interact with a block at a position and direction", "This function is for very specific cases where there needs to be extra precision", "like when placing stairs or slabs in certain directions, so the first set of", "coords is the exact position of the block, and the second set of coords is the position"}, params={@ParameterDoc(type=NumberDef.class, name="x", desc={"the exact x position"}), @ParameterDoc(type=NumberDef.class, name="y", desc={"the exact y position"}), @ParameterDoc(type=NumberDef.class, name="z", desc={"the exact z position"}), @ParameterDoc(type=StringDef.class, name="direction", desc={"the direction of the interaction, e.g. 'up', 'north', 'east', etc."}), @ParameterDoc(type=NumberDef.class, name="blockX", desc={"the x position of the block"}), @ParameterDoc(type=NumberDef.class, name="blockY", desc={"the y position of the block"}), @ParameterDoc(type=NumberDef.class, name="blockZ", desc={"the z position of the block"}), @ParameterDoc(type=BooleanDef.class, name="insideBlock", desc={"whether the player is inside the block"})}, returns=@ReturnDoc(type=FutureDef.class, desc={"the result of the placement as a string; this can be: 'success', 'pass', 'fail'"}), examples={"player.interactBlock(0, 100.5, 0, 'up', 0, 100, 0, true);"})
    private Future<String> interactBlockFull(Arguments arguments) {
        double px = (Double)arguments.skip().nextPrimitive(NumberDef.class);
        double py = (Double)arguments.nextPrimitive(NumberDef.class);
        double pz = (Double)arguments.nextPrimitive(NumberDef.class);
        String direction = arguments.nextConstant();
        double bx = (Double)arguments.nextPrimitive(NumberDef.class);
        double by = (Double)arguments.nextPrimitive(NumberDef.class);
        double bz = (Double)arguments.nextPrimitive(NumberDef.class);
        boolean bool = (Boolean)arguments.nextPrimitive(BooleanDef.class);
        return this.interactInternal(arguments.getInterpreter(), direction, EssentialUtils.getPlayer().method_6058(), new class_243(px, py, pz), EssentialUtils.vec3dToBlockPos(bx, by, bz), bool);
    }

    @FunctionDoc(name="interactBlock", desc={"This allows you to interact with a block at a position and direction", "This function is for very specific cases where there needs to be extra precision", "like when placing stairs or slabs in certain directions, so the first set of", "coords is the exact position of the block, and the second set of coords is the position"}, params={@ParameterDoc(type=PosDef.class, name="pos", desc={"the exact position of the block"}), @ParameterDoc(type=StringDef.class, name="direction", desc={"the direction of the interaction, e.g. 'up', 'north', 'east', etc."}), @ParameterDoc(type=PosDef.class, name="blockPos", desc={"the position of the block"}), @ParameterDoc(type=BooleanDef.class, name="insideBlock", desc={"whether the player is inside the block"})}, returns=@ReturnDoc(type=FutureDef.class, desc={"the result of the placement as a string; this can be: 'success', 'pass', 'fail'"}), examples={"player.interactBlock(new Pos(0, 15.5, 0), 'up', new Pos(0, 15, 0), true);"})
    private Future<String> interactBlockFullPos(Arguments arguments) {
        class_243 pos = ((ScriptPos)arguments.skip().nextPrimitive(PosDef.class)).getVec3d();
        String direction = arguments.nextConstant();
        class_2338 blockPos = ((ScriptPos)arguments.nextPrimitive(PosDef.class)).getBlockPos();
        return this.interactInternal(arguments.getInterpreter(), direction, EssentialUtils.getPlayer().method_6058(), pos, blockPos, false);
    }

    @FunctionDoc(name="interactBlock", desc={"This allows you to interact with a block at a position and direction", "This function is for very specific cases where there needs to be extra precision", "like when placing stairs or slabs in certain directions, so the first set of", "coords is the exact position of the block, and the second set of coords is the position"}, params={@ParameterDoc(type=PosDef.class, name="pos", desc={"the exact position of the block"}), @ParameterDoc(type=StringDef.class, name="direction", desc={"the direction of the interaction, e.g. 'up', 'north', 'east', etc."}), @ParameterDoc(type=StringDef.class, name="hand", desc={"the hand to use, e.g. 'main_hand', 'off_hand'"}), @ParameterDoc(type=PosDef.class, name="blockPos", desc={"the position of the block"}), @ParameterDoc(type=BooleanDef.class, name="insideBlock", desc={"whether the player is inside the block"})}, returns=@ReturnDoc(type=FutureDef.class, desc={"the result of the placement as a string; this can be: 'success', 'pass', 'fail'"}), examples={"player.interactBlock(new Pos(0, 15.5, 0), 'up', new Pos(0, 15, 0), true, 'off_hand');"})
    private Future<String> interactBlockFullPosHand(Arguments arguments) {
        class_243 pos = ((ScriptPos)arguments.nextPrimitive(PosDef.class)).getVec3d();
        String direction = arguments.nextConstant();
        String handAsString = arguments.nextConstant();
        class_2338 blockPos = ((ScriptPos)arguments.nextPrimitive(PosDef.class)).getBlockPos();
        class_1268 hand = ClientScriptUtils.stringToHand(handAsString);
        return this.interactInternal(arguments.getInterpreter(), direction, hand, pos, blockPos, false);
    }

    @FunctionDoc(name="getBlockBreakingSpeed", desc={"This returns the block breaking speed of the player on a block including enchanements and effects"}, params={@ParameterDoc(type=ItemStackDef.class, name="itemStack", desc={"item to test with"}), @ParameterDoc(type=BlockDef.class, name="block", desc={"the block to get the speed of"})}, examples={"speed = player.getBlockBreakingSpeed(Material.NETHERITE_PICKAXE.asItem(), Material.GOLD_BLOCK.asBlock());"})
    private float getBlockBreakingSpeed(Arguments arguments) {
        class_746 player = EssentialUtils.getPlayer();
        class_1799 itemStack = ((ScriptItemStack)arguments.skip().nextPrimitive(ItemStackDef.class)).stack;
        class_2680 state = ((ScriptBlockState)arguments.nextPrimitive(BlockDef.class)).state;
        return EssentialUtils.getBlockBreakingSpeed(itemStack, state, (class_1657)player);
    }

    private Future<String> interactInternal(Interpreter interpreter, String directionAsString, class_1268 hand, class_243 pos, class_2338 blockPos, boolean insideBlock) {
        class_1268 finalHand = hand == null ? class_1268.field_5808 : hand;
        class_2350 direction = ClientScriptUtils.stringToDirection(directionAsString, class_2350.field_11033);
        class_3965 hitResult = new class_3965(pos, direction, blockPos, insideBlock);
        return ClientScriptUtils.ensureMainThread("interactBlock", interpreter, () -> EssentialUtils.getInteractionManager().method_2896(EssentialUtils.getPlayer(), finalHand, hitResult).toString().toLowerCase(Locale.ROOT));
    }
}

