/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.clientscript.definitions;

import java.util.List;
import me.senseiwells.arucas.api.docs.annotations.ClassDoc;
import me.senseiwells.arucas.api.docs.annotations.FunctionDoc;
import me.senseiwells.arucas.api.docs.annotations.ParameterDoc;
import me.senseiwells.arucas.api.docs.annotations.ReturnDoc;
import me.senseiwells.arucas.builtin.BooleanDef;
import me.senseiwells.arucas.builtin.ListDef;
import me.senseiwells.arucas.builtin.MapDef;
import me.senseiwells.arucas.builtin.NumberDef;
import me.senseiwells.arucas.builtin.StringDef;
import me.senseiwells.arucas.classes.PrimitiveDefinition;
import me.senseiwells.arucas.classes.instance.ClassInstance;
import me.senseiwells.arucas.compiler.LocatableTrace;
import me.senseiwells.arucas.exceptions.RuntimeError;
import me.senseiwells.arucas.functions.builtin.Arguments;
import me.senseiwells.arucas.functions.builtin.MemberFunction;
import me.senseiwells.arucas.interpreter.Interpreter;
import me.senseiwells.arucas.utils.impl.ArucasList;
import me.senseiwells.arucas.utils.impl.ArucasMap;
import me.senseiwells.arucas.utils.misc.Language;
import me.senseiwells.essentialclient.clientscript.definitions.EntityDef;
import me.senseiwells.essentialclient.clientscript.definitions.ItemStackDef;
import me.senseiwells.essentialclient.clientscript.definitions.LivingEntityDef;
import me.senseiwells.essentialclient.clientscript.definitions.MaterialDef;
import me.senseiwells.essentialclient.utils.EssentialUtils;
import me.senseiwells.essentialclient.utils.clientscript.impl.ScriptMaterial;
import net.minecraft.class_1536;
import net.minecraft.class_1656;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_640;
import net.minecraft.class_742;
import org.jetbrains.annotations.NotNull;

@ClassDoc(name="OtherPlayer", desc={"This class is used to represent all players, mainly other players,", "this class extends LivingEntity and so inherits all of their methods too"}, language=Language.Java)
public class OtherPlayerDef
extends PrimitiveDefinition<class_742> {
    public OtherPlayerDef(Interpreter interpreter) {
        super("OtherPlayer", interpreter);
    }

    @Deprecated
    @NotNull
    public ClassInstance create(@NotNull class_742 value) {
        return super.create((Object)value);
    }

    @NotNull
    public PrimitiveDefinition<? super class_742> superclass() {
        return this.getPrimitiveDef(LivingEntityDef.class);
    }

    @NotNull
    public String toString(@NotNull ClassInstance instance, @NotNull Interpreter interpreter, @NotNull LocatableTrace trace) {
        return "OtherPlayer{name=%s}".formatted(((class_742)instance.asPrimitive((PrimitiveDefinition)this)).method_5820());
    }

    public List<MemberFunction> defineMethods() {
        return List.of(MemberFunction.of((String)"getCurrentSlot", this::getCurrentSlot), MemberFunction.of((String)"getHeldItem", this::getHeldItem), MemberFunction.of((String)"isInventoryFull", this::isInventoryFull), MemberFunction.of((String)"getEmptySlots", this::getEmptySlots), MemberFunction.of((String)"getPlayerName", this::getPlayerName), MemberFunction.of((String)"getGamemode", this::getGamemode), MemberFunction.of((String)"getTotalSlots", this::getTotalSlots), MemberFunction.of((String)"isPlayerSlot", (int)1, this::isPlayerSlot), MemberFunction.of((String)"getItemForSlot", (int)1, this::getItemForSlot), MemberFunction.of((String)"getItemForPlayerSlot", (int)1, this::getItemForPlayerSlot), MemberFunction.of((String)"getSlotFor", (int)1, this::getSlotFor), MemberFunction.of((String)"getAllSlotsFor", (int)1, this::getAllSlotsFor), MemberFunction.of((String)"getAllSlotsFor", (int)2, this::getAllSlotsForWithOption), MemberFunction.of((String)"getAbilities", this::getAbilities), MemberFunction.of((String)"getLevels", this::getLevels), MemberFunction.of((String)"getXpProgress", this::getXpProgress), MemberFunction.of((String)"getNextLevelExperience", this::getNextLevelExperience), MemberFunction.of((String)"getHunger", this::getHunger), MemberFunction.of((String)"getSaturation", this::getSaturation), MemberFunction.of((String)"getFishingBobber", this::getFishingBobber));
    }

    @FunctionDoc(name="getCurrentSlot", desc={"This gets the players currently selected slot"}, returns=@ReturnDoc(type=NumberDef.class, desc={"the currently selected slot number"}), examples={"otherPlayer.getCurrentSlot();"})
    private double getCurrentSlot(Arguments arguments) {
        return ((class_742)arguments.nextPrimitive((PrimitiveDefinition)this)).method_31548().field_7545;
    }

    @FunctionDoc(name="getHeldItem", desc={"This gets the players currently selected item, in their main hand"}, returns=@ReturnDoc(type=ItemStackDef.class, desc={"the currently selected item"}), examples={"otherPlayer.getHeldItem();"})
    private class_1799 getHeldItem(Arguments arguments) {
        return ((class_742)arguments.nextPrimitive((PrimitiveDefinition)this)).method_31548().method_7391();
    }

    @FunctionDoc(name="isInventoryFull", desc={"This gets whether the players inventory is full.", "More specifically whether the player has no empty slots"}, returns=@ReturnDoc(type=BooleanDef.class, desc={"whether the inventory is full"}), examples={"otherPlayer.isInventoryFull();"})
    private boolean isInventoryFull(Arguments arguments) {
        return ((class_742)arguments.nextPrimitive((PrimitiveDefinition)this)).method_31548().method_7376() == -1;
    }

    @FunctionDoc(name="getEmptySlots", desc={"This gets all the empty slots in the player inventory"}, returns=@ReturnDoc(type=ListDef.class, desc={"a list of all the slot numbers that are empty"}), examples={"otherPlayer.getEmptySlots();"})
    private ArucasList getEmptySlots(Arguments arguments) {
        class_1661 inventory = ((class_742)arguments.nextPrimitive((PrimitiveDefinition)this)).method_31548();
        ArucasList list = new ArucasList();
        for (int i = 0; i < inventory.field_7547.size(); ++i) {
            if (!((class_1799)inventory.field_7547.get(i)).method_7960()) continue;
            list.add(arguments.getInterpreter().convertValue((Object)i));
        }
        return list;
    }

    @FunctionDoc(name="getPlayerName", desc={"This gets the players name"}, returns=@ReturnDoc(type=StringDef.class, desc={"the players name"}), examples={"otherPlayer.getPlayerName();"})
    private String getPlayerName(Arguments arguments) {
        return ((class_742)arguments.nextPrimitive((PrimitiveDefinition)this)).method_5820();
    }

    @FunctionDoc(name="getGamemode", desc={"This gets the players gamemode, may be null if not known"}, returns=@ReturnDoc(type=StringDef.class, desc={"the players gamemode as a string, for example 'creative', 'survival', 'spectator'"}), examples={"otherPlayer.getGamemode();"})
    private String getGamemode(Arguments arguments) {
        class_742 playerEntity = (class_742)arguments.nextPrimitive((PrimitiveDefinition)this);
        class_640 playerInfo = EssentialUtils.getNetworkHandler().method_2871(playerEntity.method_5667());
        if (playerInfo == null || playerInfo.method_2958() == null) {
            return null;
        }
        return playerInfo.method_2958().method_8381();
    }

    @FunctionDoc(name="getTotalSlots", desc={"This gets the players total inventory slots"}, returns=@ReturnDoc(type=NumberDef.class, desc={"the players total inventory slots"}), examples={"otherPlayer.getTotalSlots();"})
    private double getTotalSlots(Arguments arguments) {
        class_1703 screenHandler = ((class_742)arguments.nextPrimitive((PrimitiveDefinition)this)).field_7512;
        return screenHandler.field_7761.size();
    }

    @FunctionDoc(name="getItemForSlot", desc={"This gets the item in the specified slot, in the total players inventory, including inventories of open containers.", "This will throw an error if the index is out of bounds"}, params={@ParameterDoc(type=NumberDef.class, name="slotNum", desc={"the slot number you want to get"})}, returns=@ReturnDoc(type=ItemStackDef.class, desc={"the item in the specified slot"}), examples={"otherPlayer.getItemForSlot(0);"})
    private class_1799 getItemForSlot(Arguments arguments) {
        class_742 playerEntity = (class_742)arguments.nextPrimitive((PrimitiveDefinition)this);
        int index = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        class_1703 screenHandler = playerEntity.field_7512;
        if (index > screenHandler.field_7761.size() || index < 0) {
            throw new RuntimeError("That slot is out of bounds");
        }
        return ((class_1735)screenHandler.field_7761.get(index)).method_7677();
    }

    @FunctionDoc(name="isPlayerSlot", desc={"This gets inventory type (player / other) for given slot numbers.", "This will throw an error if the index is out of bounds"}, params={@ParameterDoc(type=NumberDef.class, name="slotNum", desc={"the slot number you want to get"})}, returns=@ReturnDoc(type=BooleanDef.class, desc={"whether slot was player inventory or not"}), examples={"otherPlayer.isPlayerSlot(0);"})
    private boolean isPlayerSlot(Arguments arguments) {
        class_742 playerEntity = (class_742)arguments.nextPrimitive((PrimitiveDefinition)this);
        int index = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        class_1703 screenHandler = playerEntity.field_7512;
        if (index > screenHandler.field_7761.size() || index < 0) {
            throw new RuntimeError("That slot is out of bounds");
        }
        class_1735 slot = (class_1735)screenHandler.field_7761.get(index);
        return slot.field_7871 instanceof class_1661;
    }

    @FunctionDoc(name="getItemForPlayerSlot", desc={"This gets the item in the specified slot, in the players inventory, not including inventories of open containers.", "This will throw an error if the slot is out of bounds"}, params={@ParameterDoc(type=NumberDef.class, name="slotNum", desc={"the slot number you want to get"})}, returns=@ReturnDoc(type=ItemStackDef.class, desc={"the item in the specified slot"}), examples={"otherPlayer.getItemForPlayerSlot(0);"})
    private class_1799 getItemForPlayerSlot(Arguments arguments) {
        class_742 player = (class_742)arguments.nextPrimitive((PrimitiveDefinition)this);
        class_1661 inventory = player.method_31548();
        int slot = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        if (slot < 0 || slot > inventory.field_7547.size()) {
            throw new RuntimeError("That slot is out of bounds");
        }
        return (class_1799)inventory.field_7547.get(slot);
    }

    @FunctionDoc(name="getSlotFor", desc={"This gets the slot number of the specified item in the players combined inventory"}, params={@ParameterDoc(type=MaterialDef.class, name="materialLike", desc={"the item or material you want to get the slot of"})}, returns=@ReturnDoc(type=NumberDef.class, desc={"the slot number of the item, null if not found"}), examples={"otherPlayer.getSlotFor(Material.DIAMOND.asItemStack());"})
    private Double getSlotFor(Arguments arguments) {
        class_742 playerEntity = (class_742)arguments.nextPrimitive((PrimitiveDefinition)this);
        ScriptMaterial materialLike = (ScriptMaterial)arguments.nextPrimitive(MaterialDef.class);
        class_1703 screenHandler = playerEntity.field_7512;
        for (class_1735 slot : screenHandler.field_7761) {
            if (slot.method_7677().method_7909() != materialLike.asItem()) continue;
            return slot.field_7874;
        }
        return null;
    }

    @FunctionDoc(name="getAllSlotsFor", desc={"This gets all the slot numbers of the specified item in the players combined inventory"}, params={@ParameterDoc(type=MaterialDef.class, name="materialLike", desc={"the item or material you want to get the slot of"})}, returns=@ReturnDoc(type=ListDef.class, desc={"the slot numbers of the item, empty list if not found"}), examples={"otherPlayer.getAllSlotsFor(Material.DIAMOND);"})
    private ArucasList getAllSlotsFor(Arguments arguments) {
        class_742 playerEntity = (class_742)arguments.nextPrimitive((PrimitiveDefinition)this);
        ScriptMaterial materialLike = (ScriptMaterial)arguments.nextPrimitive(MaterialDef.class);
        class_1703 screenHandler = playerEntity.field_7512;
        ArucasList slotList = new ArucasList();
        for (class_1735 slot : screenHandler.field_7761) {
            if (slot.method_7677().method_7909() != materialLike.asItem()) continue;
            slotList.add(arguments.getInterpreter().create(NumberDef.class, (Object)slot.field_7874));
        }
        return slotList;
    }

    @FunctionDoc(name="getAllSlotsFor", desc={"This gets all the slot numbers of the specified item in the players combined inventory"}, params={@ParameterDoc(type=MaterialDef.class, name="materialLike", desc={"the item or material you want to get the slot of"}), @ParameterDoc(type=StringDef.class, name="inventoryType", desc={"all/combined -> includes external, player/main -> player slots, external/other -> excludes player inventory"})}, returns=@ReturnDoc(type=ListDef.class, desc={"the slot numbers of the item, empty list if not found"}), examples={"otherPlayer.getAllSlotsFor(Material.DIAMOND, 'player');"})
    private ArucasList getAllSlotsForWithOption(Arguments arguments) {
        class_742 playerEntity = (class_742)arguments.nextPrimitive((PrimitiveDefinition)this);
        ScriptMaterial materialLike = (ScriptMaterial)arguments.nextPrimitive(MaterialDef.class);
        String inventoryArgument = (String)arguments.nextPrimitive(StringDef.class);
        class_1703 screenHandler = playerEntity.field_7512;
        ArucasList slotList = new ArucasList();
        block13: for (class_1735 slot : screenHandler.field_7761) {
            switch (inventoryArgument) {
                case "all": 
                case "combined": {
                    break;
                }
                case "player": 
                case "main": {
                    if (slot.field_7871 instanceof class_1661) break;
                    continue block13;
                }
                case "external": 
                case "other": {
                    if (!(slot.field_7871 instanceof class_1661)) break;
                    continue block13;
                }
                default: {
                    throw new RuntimeError("String argument was not either one of combined / player / other");
                }
            }
            if (slot.method_7677().method_7909() != materialLike.asItem()) continue;
            slotList.add(arguments.getInterpreter().create(NumberDef.class, (Object)slot.field_7874));
        }
        return slotList;
    }

    @FunctionDoc(name="getAbilities", desc={"This gets the abilities of the player in a map", "For example:", "`{\"invulnerable\": false, \"canFly\": true, \"canBreakBlocks\": true, \"isCreative\": true, \"walkSpeed\": 1.0, \"flySpeed\": 1.2}`"}, returns=@ReturnDoc(type=MapDef.class, desc={"the abilities of the player"}), examples={"otherPlayer.getAbilities();"})
    private ArucasMap getAbilities(Arguments arguments) {
        class_742 playerEntity = (class_742)arguments.nextPrimitive((PrimitiveDefinition)this);
        class_1656 playerAbilities = playerEntity.method_31549();
        Interpreter interpreter = arguments.getInterpreter();
        ArucasMap map = new ArucasMap();
        map.put(interpreter, interpreter.create(StringDef.class, (Object)"invulnerable"), interpreter.createBool(playerAbilities.field_7480));
        map.put(interpreter, interpreter.create(StringDef.class, (Object)"canFly"), interpreter.createBool(playerAbilities.field_7478));
        map.put(interpreter, interpreter.create(StringDef.class, (Object)"canBreakBlocks"), interpreter.createBool(playerAbilities.field_7476));
        map.put(interpreter, interpreter.create(StringDef.class, (Object)"isCreative"), interpreter.createBool(playerAbilities.field_7477));
        map.put(interpreter, interpreter.create(StringDef.class, (Object)"walkSpeed"), interpreter.create(NumberDef.class, (Object)playerAbilities.method_7253()));
        map.put(interpreter, interpreter.create(StringDef.class, (Object)"flySpeed"), interpreter.create(NumberDef.class, (Object)playerAbilities.method_7252()));
        return map;
    }

    @FunctionDoc(name="getLevels", desc={"This gets the number of experience levels the player has"}, returns=@ReturnDoc(type=NumberDef.class, desc={"the number of experience levels"}), examples={"otherPlayer.getLevels();"})
    private double getLevels(Arguments arguments) {
        class_742 playerEntity = (class_742)arguments.nextPrimitive((PrimitiveDefinition)this);
        return playerEntity.field_7520;
    }

    @FunctionDoc(name="getXpProgress", desc={"This gets the number of experience progress the player has"}, returns=@ReturnDoc(type=NumberDef.class, desc={"the number of experience progress"}), examples={"otherPlayer.getXpProgress();"})
    private double getXpProgress(Arguments arguments) {
        class_742 playerEntity = (class_742)arguments.nextPrimitive((PrimitiveDefinition)this);
        return playerEntity.field_7510;
    }

    @FunctionDoc(name="getNextLevelExperience", desc={"This gets the number of experience required to level up for the player"}, returns=@ReturnDoc(type=NumberDef.class, desc={"the number required to next level"}), examples={"otherPlayer.getNextLevelExperience();"})
    private double getNextLevelExperience(Arguments arguments) {
        class_742 playerEntity = (class_742)arguments.nextPrimitive((PrimitiveDefinition)this);
        return playerEntity.method_7349();
    }

    @FunctionDoc(name="getHunger", desc={"This gets the hunger level of the player"}, returns=@ReturnDoc(type=NumberDef.class, desc={"the hunger level"}), examples={"otherPlayer.getHunger();"})
    private double getHunger(Arguments arguments) {
        class_742 playerEntity = (class_742)arguments.nextPrimitive((PrimitiveDefinition)this);
        return playerEntity.method_7344().method_7586();
    }

    @FunctionDoc(name="getSaturation", desc={"This gets the saturation level of the player"}, returns=@ReturnDoc(type=NumberDef.class, desc={"the saturation level"}), examples={"otherPlayer.getSaturation();"})
    private double getSaturation(Arguments arguments) {
        class_742 playerEntity = (class_742)arguments.nextPrimitive((PrimitiveDefinition)this);
        return playerEntity.method_7344().method_7589();
    }

    @FunctionDoc(name="getFishingBobber", desc={"This gets the fishing bobber that the player has"}, returns=@ReturnDoc(type=EntityDef.class, desc={"the fishing bobber entity, null if the player isn't fishing"}), examples={"otherPlayer.getFishingBobber();"})
    private class_1536 getFishingBobber(Arguments arguments) {
        class_742 playerEntity = (class_742)arguments.nextPrimitive((PrimitiveDefinition)this);
        return playerEntity.field_7513;
    }
}

