/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.clientscript.definitions;

import java.util.List;
import me.senseiwells.arucas.api.docs.annotations.ClassDoc;
import me.senseiwells.arucas.api.docs.annotations.FunctionDoc;
import me.senseiwells.arucas.api.docs.annotations.ParameterDoc;
import me.senseiwells.arucas.api.docs.annotations.ReturnDoc;
import me.senseiwells.arucas.builtin.BooleanDef;
import me.senseiwells.arucas.builtin.ListDef;
import me.senseiwells.arucas.builtin.NumberDef;
import me.senseiwells.arucas.classes.CreatableDefinition;
import me.senseiwells.arucas.classes.PrimitiveDefinition;
import me.senseiwells.arucas.exceptions.RuntimeError;
import me.senseiwells.arucas.functions.builtin.Arguments;
import me.senseiwells.arucas.functions.builtin.MemberFunction;
import me.senseiwells.arucas.interpreter.Interpreter;
import me.senseiwells.arucas.utils.impl.ArucasList;
import me.senseiwells.arucas.utils.misc.Language;
import me.senseiwells.essentialclient.clientscript.definitions.ItemStackDef;
import me.senseiwells.essentialclient.clientscript.definitions.MaterialDef;
import me.senseiwells.essentialclient.clientscript.definitions.ScreenDef;
import me.senseiwells.essentialclient.utils.EssentialUtils;
import me.senseiwells.essentialclient.utils.clientscript.ClientScriptUtils;
import me.senseiwells.essentialclient.utils.clientscript.impl.ScriptItemStack;
import me.senseiwells.essentialclient.utils.clientscript.impl.ScriptMaterial;
import me.senseiwells.essentialclient.utils.inventory.InventoryUtils;
import net.minecraft.class_1728;
import net.minecraft.class_1914;
import net.minecraft.class_1916;
import net.minecraft.class_310;
import net.minecraft.class_492;
import org.jetbrains.annotations.NotNull;

@ClassDoc(name="MerchantScreen", desc={"This class extends Screen and so inherits all of their methods too,", "this class is used to add functionality to trading screens."}, superclass=ScreenDef.class, language=Language.Java)
public class MerchantScreenDef
extends CreatableDefinition<class_492> {
    public MerchantScreenDef(Interpreter interpreter) {
        super("MerchantScreen", interpreter);
    }

    @NotNull
    public PrimitiveDefinition<? super class_492> superclass() {
        return this.getPrimitiveDef(ScreenDef.class);
    }

    public List<MemberFunction> defineMethods() {
        return List.of(MemberFunction.of((String)"getTradeList", this::getTradeList), MemberFunction.of((String)"getTradeListSize", this::getTradeListSize), MemberFunction.of((String)"getVillagerLevel", this::getVillagerLevel), MemberFunction.of((String)"getVillagerXpBar", this::getVillagerXpBar), MemberFunction.of((String)"tradeIndex", (int)1, this::tradeIndex), MemberFunction.of((String)"getIndexOfTradeItem", (int)1, this::getIndexOfTradeItem), MemberFunction.of((String)"getTradeItemForIndex", (int)1, this::getTradeItemForIndex), MemberFunction.of((String)"doesVillagerHaveTrade", (int)1, this::doesVillagerHaveTrade), MemberFunction.of((String)"isTradeDisabled", (int)1, this::isTradeDisabled), MemberFunction.of((String)"getPriceForIndex", (int)1, this::getPriceForIndex), MemberFunction.of((String)"selectTrade", (int)1, this::selectTrade), MemberFunction.of((String)"clearTrade", this::clearTrade), MemberFunction.of((String)"isTradeSelected", this::isTradeSelected), MemberFunction.of((String)"tradeSelected", this::tradeSelected), MemberFunction.of((String)"tradeSelectedAndThrow", this::tradeSelectedAndThrow));
    }

    @FunctionDoc(name="getTradeListSize", desc={"This gets the size of all the trades available"}, returns=@ReturnDoc(type=NumberDef.class, desc={"the size of the trade list"}), examples={"screen.getTradeListSize();"})
    private int getTradeListSize(Arguments arguments) {
        class_492 merchantScreen = this.checkIsCurrentScreen(arguments);
        class_1916 tradeOfferList = ((class_1728)merchantScreen.method_17577()).method_17438();
        return tradeOfferList.size();
    }

    @FunctionDoc(name="getTradeList", desc={"This gets a list of all the merchant's trades"}, returns=@ReturnDoc(type=ListDef.class, desc={"the list of all the Trades"}), examples={"screen.getTradeList();"})
    private ArucasList getTradeList(Arguments arguments) {
        class_492 merchantScreen = this.checkIsCurrentScreen(arguments);
        ArucasList valueList = new ArucasList();
        class_1916 tradeOfferList = ((class_1728)merchantScreen.method_17577()).method_17438();
        for (class_1914 tradeOffers : tradeOfferList) {
            valueList.add(arguments.getInterpreter().convertValue((Object)tradeOffers));
        }
        return valueList;
    }

    @FunctionDoc(name="getVillagerLevel", desc={"This gets the level of the villager, this will", "throw an error if you are not trading with a villager.", "The level can be between 1 - 5 from Novice to Master"}, returns=@ReturnDoc(type=NumberDef.class, desc={"the level of the villager"}), examples={"screen.getVillagerLevel();"})
    private int getVillagerLevel(Arguments arguments) {
        class_1728 handler = (class_1728)this.checkIsCurrentScreen(arguments).method_17577();
        if (handler.method_19259()) {
            return handler.method_19258();
        }
        throw new RuntimeError("Merchant isn't a villager");
    }

    @FunctionDoc(name="getVillagerXp", desc={"This gets the amount of xp in the villagers xp bar,", "The total amount of xp is hardcoded for each level.", "Level 2 requires 10 xp, 3 requires 70 (60 xp from 2 -> 3),", "4 requires 150 (80 xp from 3 -> 4), 5 requires 250", "(100 xp from 4 -> 5). 250 is the max xp a villager can have"}, returns=@ReturnDoc(type=NumberDef.class, desc={"the amount of xp"}), examples={"screen.getVillagerXpBar"})
    private int getVillagerXpBar(Arguments arguments) {
        class_1728 handler = (class_1728)this.checkIsCurrentScreen(arguments).method_17577();
        if (handler.method_19259()) {
            return handler.method_19254();
        }
        throw new RuntimeError("Merchant isn't a villager");
    }

    @FunctionDoc(name="tradeIndex", desc={"This makes your player trade with the merchant at a certain index.", "You must be inside the merchant GUI or an error will be thrown"}, params={@ParameterDoc(type=NumberDef.class, name="index", desc={"the index of the trade"})}, examples={"screen.tradeIndex(0);"})
    private Void tradeIndex(Arguments arguments) {
        int index = ((Double)arguments.skip().nextPrimitive(NumberDef.class)).intValue();
        ClientScriptUtils.ensureMainThread("tradeIndex", arguments.getInterpreter(), () -> InventoryUtils.tradeAllItems(index, false));
        return null;
    }

    @FunctionDoc(name="getIndexOfTradeItem", desc={"This gets the index of a trade for a certain item.", "You must be inside the merchant GUI or an error will be thrown"}, params={@ParameterDoc(type=MaterialDef.class, name="material", desc={"the item to get the index of"})}, returns=@ReturnDoc(type=NumberDef.class, desc={"the index of the trade"}), examples={"screen.getIndexOfTradeItem(Material.DIAMOND_PICKAXE);"})
    private int getIndexOfTradeItem(Arguments arguments) {
        ClientScriptUtils.warnMainThread("getIndexOfTradeItem", arguments.getInterpreter());
        ScriptMaterial material = (ScriptMaterial)arguments.skip().nextPrimitive(MaterialDef.class);
        return InventoryUtils.getIndexOfItemInMerchant(material.asItem());
    }

    @FunctionDoc(name="getTradeItemForIndex", desc={"This gets the item stack of a trade at a certain index.", "You must be inside the merchant GUI or an error will be thrown"}, params={@ParameterDoc(type=NumberDef.class, name="index", desc={"the index of the trade"})}, returns=@ReturnDoc(type=ItemStackDef.class, desc={"the item stack of the trade"}), examples={"screen.getTradeItemForIndex(0);"})
    private ScriptItemStack getTradeItemForIndex(Arguments arguments) {
        ClientScriptUtils.warnMainThread("getTradeItemForIndex", arguments.getInterpreter());
        int index = ((Double)arguments.skip().nextPrimitive(NumberDef.class)).intValue();
        return new ScriptItemStack(InventoryUtils.getTrade(index));
    }

    @FunctionDoc(name="doesVillagerHaveTrade", desc={"This checks if the villager has a trade for a certain item.", "You must be inside the merchant GUI or an error will be thrown"}, params={@ParameterDoc(type=MaterialDef.class, name="materialLike", desc={"the item or material to check for"})}, returns=@ReturnDoc(type=BooleanDef.class, desc={"true if the villager has a trade for the item, false otherwise"}), examples={"screen.doesVillagerHaveTrade(Material.DIAMOND_PICKAXE);"})
    private boolean doesVillagerHaveTrade(Arguments arguments) {
        ClientScriptUtils.warnMainThread("doesVillagerHaveTrade", arguments.getInterpreter());
        ScriptMaterial material = (ScriptMaterial)arguments.skip().nextPrimitive(MaterialDef.class);
        return InventoryUtils.checkHasTrade(material.asItem());
    }

    @FunctionDoc(name="selectTrade", desc={"This selects the currently selected trade, as if you were to click it.", "You must be inside the merchant GUI or an error will be thrown"}, params={@ParameterDoc(type=NumberDef.class, name="index", desc={"the index of the trade"})}, examples={"screen.selectTrade(0);"})
    private Void selectTrade(Arguments arguments) {
        int index = ((Double)arguments.skip().nextPrimitive(NumberDef.class)).intValue();
        ClientScriptUtils.ensureMainThread("selectTrade", arguments.getInterpreter(), () -> InventoryUtils.selectTrade(index));
        return null;
    }

    @FunctionDoc(name="clearTrade", desc={"This clears the currently selected trade.", "You must be inside the merchant GUI or an error will be thrown"}, examples={"screen.clearTrade();"})
    private Void clearTrade(Arguments arguments) {
        ClientScriptUtils.ensureMainThread("clearTrade", arguments.getInterpreter(), InventoryUtils::clearTrade);
        return null;
    }

    @FunctionDoc(name="tradeSelected", desc={"This trades the currently selected trade.", "You must be inside the merchant GUI or an error will be thrown"}, examples={"screen.tradeSelected();"})
    private Void tradeSelected(Arguments arguments) {
        ClientScriptUtils.ensureMainThread("tradeSelected", arguments.getInterpreter(), () -> InventoryUtils.tradeSelectedRecipe(false));
        return null;
    }

    @FunctionDoc(name="tradeSelectedAndThrow", desc={"This trades the currently selected trade and throws the items that were traded.", "You must be inside the merchant GUI or an error will be thrown"}, examples={"screen.tradeSelectedAndThrow();"})
    private Void tradeSelectedAndThrow(Arguments arguments) {
        ClientScriptUtils.ensureMainThread("tradeSelectedAndThrow", arguments.getInterpreter(), () -> InventoryUtils.tradeSelectedRecipe(true));
        return null;
    }

    @FunctionDoc(name="isTradeSelected", desc={"This returns true if a trade is selected"}, returns=@ReturnDoc(type=BooleanDef.class, desc={"true if a trade is selected"}), examples={"screen.isTradeSelected();"})
    private boolean isTradeSelected(Arguments arguments) {
        ClientScriptUtils.warnMainThread("isTradeSelected", arguments.getInterpreter());
        return InventoryUtils.isTradeSelected();
    }

    @FunctionDoc(name="isTradeDisabled", desc={"This returns true if a trade is disabled at an index"}, params={@ParameterDoc(type=NumberDef.class, name="index", desc={"the index of the trade"})}, returns=@ReturnDoc(type=BooleanDef.class, desc={"true if a trade is disabled"}), examples={"screen.isTradeDisabled(1);"})
    private boolean isTradeDisabled(Arguments arguments) {
        ClientScriptUtils.warnMainThread("isTradeDisabled", arguments.getInterpreter());
        int index = ((Double)arguments.skip().nextPrimitive(NumberDef.class)).intValue();
        return InventoryUtils.checkTradeDisabled(index);
    }

    @FunctionDoc(name="getPriceForIndex", desc={"This gets the price of a trade at a certain index.", "You must be inside the merchant GUI or an error will be thrown"}, params={@ParameterDoc(type=NumberDef.class, name="index", desc={"the index of the trade"})}, returns=@ReturnDoc(type=NumberDef.class, desc={"the price of the trade"}), examples={"screen.getPriceForIndex(0);"})
    private int getPriceForIndex(Arguments arguments) {
        ClientScriptUtils.warnMainThread("getPriceForIndex", arguments.getInterpreter());
        int index = ((Double)arguments.skip().nextPrimitive(NumberDef.class)).intValue();
        return InventoryUtils.checkPriceForTrade(index);
    }

    public class_492 checkIsCurrentScreen(Arguments arguments) {
        class_310 client = EssentialUtils.getClient();
        class_492 screen = (class_492)arguments.nextPrimitive((PrimitiveDefinition)this);
        if (client.field_1755 != screen) {
            throw new RuntimeError("Currently not in that screen");
        }
        return screen;
    }
}

