/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.clientscript.definitions;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import me.senseiwells.arucas.api.docs.annotations.ClassDoc;
import me.senseiwells.arucas.api.docs.annotations.FunctionDoc;
import me.senseiwells.arucas.api.docs.annotations.ParameterDoc;
import me.senseiwells.arucas.api.docs.annotations.ReturnDoc;
import me.senseiwells.arucas.builtin.StringDef;
import me.senseiwells.arucas.classes.CreatableDefinition;
import me.senseiwells.arucas.classes.PrimitiveDefinition;
import me.senseiwells.arucas.classes.instance.ClassInstance;
import me.senseiwells.arucas.compiler.LocatableTrace;
import me.senseiwells.arucas.exceptions.RuntimeError;
import me.senseiwells.arucas.functions.builtin.Arguments;
import me.senseiwells.arucas.functions.builtin.BuiltInFunction;
import me.senseiwells.arucas.functions.builtin.MemberFunction;
import me.senseiwells.arucas.interpreter.Interpreter;
import me.senseiwells.arucas.utils.misc.Language;
import me.senseiwells.essentialclient.clientscript.definitions.BlockDef;
import me.senseiwells.essentialclient.clientscript.definitions.ItemStackDef;
import me.senseiwells.essentialclient.utils.clientscript.ClientScriptUtils;
import me.senseiwells.essentialclient.utils.clientscript.impl.ScriptMaterial;
import net.minecraft.class_1074;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

@ClassDoc(name="Material", desc={"This class represents all possible item and block types", "and allows you to convert them into instances of ItemStacks and Blocks"}, language=Language.Java)
public class MaterialDef
extends CreatableDefinition<ScriptMaterial> {
    public MaterialDef(Interpreter interpreter) {
        super("Material", interpreter);
    }

    public Object asJavaValue(ClassInstance instance) {
        return ((ScriptMaterial)instance.asPrimitive((PrimitiveDefinition)this)).asDefault();
    }

    public boolean equals(@NotNull ClassInstance instance, @NotNull Interpreter interpreter, @NotNull ClassInstance other, @NotNull LocatableTrace trace) {
        ScriptMaterial material = (ScriptMaterial)other.getPrimitive((PrimitiveDefinition)this);
        return material != null && ((ScriptMaterial)instance.asPrimitive((PrimitiveDefinition)this)).asDefault().equals(material.asDefault());
    }

    public int hashCode(@NotNull ClassInstance instance, @NotNull Interpreter interpreter, @NotNull LocatableTrace trace) {
        return ((ScriptMaterial)instance.asPrimitive((PrimitiveDefinition)this)).asDefault().hashCode();
    }

    @NotNull
    public String toString(@NotNull ClassInstance instance, @NotNull Interpreter interpreter, @NotNull LocatableTrace trace) {
        return ((ScriptMaterial)instance.asPrimitive((PrimitiveDefinition)this)).asString();
    }

    public List<PrimitiveDefinition.PrimitiveField> defineStaticFields() {
        TreeMap<String, ClassInstance> map = new TreeMap<String, ClassInstance>();
        for (class_1792 item : class_7923.field_41178) {
            map.put(item.toString().toUpperCase(), this.create(ScriptMaterial.materialOf(item)));
        }
        for (class_2248 block : class_7923.field_41175) {
            class_2960 identifier = class_7923.field_41175.method_10221((Object)block);
            map.computeIfAbsent(identifier.method_12832().toUpperCase(), s -> this.create(ScriptMaterial.materialOf(block)));
        }
        ArrayList<PrimitiveDefinition.PrimitiveField> fields = new ArrayList<PrimitiveDefinition.PrimitiveField>(map.size());
        map.forEach((key, value) -> fields.add(new PrimitiveDefinition.PrimitiveField(key, value, false)));
        fields.add(new PrimitiveDefinition.PrimitiveField("ALL", map.values().stream().toList(), false));
        return fields;
    }

    public List<BuiltInFunction> defineStaticMethods() {
        return List.of(BuiltInFunction.of((String)"of", (int)1, this::of));
    }

    @FunctionDoc(isStatic=true, name="of", desc={"This converts a block or item id into a Material.", "This method will throw an error if the id is invalid"}, params={@ParameterDoc(type=StringDef.class, name="id", desc={"the id of the block or item"})}, returns=@ReturnDoc(type=MaterialDef.class, desc={"the material instance from the id"}), examples={"Material.of('diamond');"})
    private Object of(Arguments arguments) {
        Optional block;
        String id = (String)arguments.nextPrimitive(StringDef.class);
        class_2960 identifier = ClientScriptUtils.stringToIdentifier(id);
        Optional item = class_7923.field_41178.method_17966(identifier);
        if (item.isEmpty() && (block = class_7923.field_41175.method_17966(identifier)).isPresent()) {
            return block.get();
        }
        return item.orElseThrow(() -> new RuntimeError("'%s' is not a valid Material".formatted(id)));
    }

    public List<MemberFunction> defineMethods() {
        return List.of(MemberFunction.of((String)"getFullId", this::getFullId), MemberFunction.of((String)"getId", this::getId), MemberFunction.of((String)"asItemStack", this::asItemStack), MemberFunction.of((String)"asBlock", this::asBlock), MemberFunction.of((String)"getTranslatedName", this::getTranslatedName));
    }

    @FunctionDoc(name="getFullId", desc={"This returns the full id of the material, for example: 'minecraft:diamond'"}, returns=@ReturnDoc(type=StringDef.class, desc={"the full id representation of the material"}), examples={"material.getFullId();"})
    private Object getFullId(Arguments arguments) {
        ScriptMaterial material = (ScriptMaterial)arguments.nextPrimitive((PrimitiveDefinition)this);
        return material.getId().toString();
    }

    @FunctionDoc(name="getId", desc={"This returns the id of the material, for example: 'diamond'"}, returns=@ReturnDoc(type=StringDef.class, desc={"the id representation of the material"}), examples={"material.getId();"})
    private Object getId(Arguments arguments) {
        ScriptMaterial material = (ScriptMaterial)arguments.nextPrimitive((PrimitiveDefinition)this);
        return material.getId().method_12832();
    }

    @FunctionDoc(name="asItemStack", desc={"This converts the material into an ItemStack.", "If it cannot be converted an error will be thrown"}, returns=@ReturnDoc(type=ItemStackDef.class, desc={"the ItemStack representation of the material"}), examples={"material.asItemStack();"})
    private Object asItemStack(Arguments arguments) {
        ScriptMaterial material = (ScriptMaterial)arguments.nextPrimitive((PrimitiveDefinition)this);
        return material.asItemStack();
    }

    @FunctionDoc(name="asBlock", desc={"This converts the material into a Block.", "If it cannot be converted an error will be thrown"}, returns=@ReturnDoc(type=BlockDef.class, desc={"the Block representation of the material"}), examples={"material.asBlock();"})
    private Object asBlock(Arguments arguments) {
        ScriptMaterial material = (ScriptMaterial)arguments.nextPrimitive((PrimitiveDefinition)this);
        return material.asBlockState();
    }

    @FunctionDoc(name="getTranslatedName", desc={"This gets the translated name of the ItemStack, for example: ", "Material.DIAMOND_SWORD would return 'Diamond Sword' if your language is English"}, returns=@ReturnDoc(type=StringDef.class, desc={"the translated name of the Material"}), examples={"material.getTranslatedName();"})
    private Object getTranslatedName(Arguments arguments) {
        ScriptMaterial material = (ScriptMaterial)arguments.nextPrimitive((PrimitiveDefinition)this);
        return class_1074.method_4662((String)material.getTranslationKey(), (Object[])new Object[0]);
    }
}

