/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.clientscript.definitions;

import java.util.List;
import me.senseiwells.arucas.api.docs.annotations.ClassDoc;
import me.senseiwells.arucas.api.docs.annotations.FunctionDoc;
import me.senseiwells.arucas.api.docs.annotations.ReturnDoc;
import me.senseiwells.arucas.builtin.BooleanDef;
import me.senseiwells.arucas.builtin.ListDef;
import me.senseiwells.arucas.builtin.NumberDef;
import me.senseiwells.arucas.classes.PrimitiveDefinition;
import me.senseiwells.arucas.classes.instance.ClassInstance;
import me.senseiwells.arucas.compiler.LocatableTrace;
import me.senseiwells.arucas.functions.builtin.Arguments;
import me.senseiwells.arucas.functions.builtin.MemberFunction;
import me.senseiwells.arucas.interpreter.Interpreter;
import me.senseiwells.arucas.utils.impl.ArucasList;
import me.senseiwells.arucas.utils.misc.Language;
import me.senseiwells.essentialclient.clientscript.definitions.EntityDef;
import net.minecraft.class_1291;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

@ClassDoc(name="LivingEntity", desc={"This class extends Entity and so inherits all of their methods too,", "LivingEntities are any entities that are alive, so all mobs"}, superclass=EntityDef.class, language=Language.Java)
public class LivingEntityDef
extends PrimitiveDefinition<class_1309> {
    public LivingEntityDef(Interpreter interpreter) {
        super("LivingEntity", interpreter);
    }

    @Deprecated
    @NotNull
    public ClassInstance create(@NotNull class_1309 value) {
        return super.create((Object)value);
    }

    @NotNull
    public PrimitiveDefinition<? super class_1309> superclass() {
        return this.getInterpreter().getPrimitive(EntityDef.class);
    }

    @NotNull
    public String toString(@NotNull ClassInstance instance, @NotNull Interpreter interpreter, @NotNull LocatableTrace trace) {
        return "LivingEntity{id=%s}".formatted(class_7923.field_41177.method_10221((Object)((class_1309)instance.asPrimitive((PrimitiveDefinition)this)).method_5864()).method_12832());
    }

    public List<MemberFunction> defineMethods() {
        return List.of(MemberFunction.of((String)"getStatusEffects", this::getStatusEffects), MemberFunction.of((String)"getHealth", this::getHealth), MemberFunction.of((String)"isFlyFalling", this::isFlyFalling));
    }

    @FunctionDoc(name="getStatusEffects", desc={"This gets the LivingEntity's status effects, you can find", "a list of all the ids of the status effects", "[here](https://minecraft.fandom.com/wiki/Java_Edition_data_values#Effects)"}, returns=@ReturnDoc(type=ListDef.class, desc={"a list of status effects, may be empty"}), examples={"livingEntity.getStatusEffects();"})
    private ArucasList getStatusEffects(Arguments arguments) {
        class_1309 livingEntity = (class_1309)arguments.nextPrimitive((PrimitiveDefinition)this);
        ArucasList potionList = new ArucasList();
        Interpreter interpreter = arguments.getInterpreter();
        livingEntity.method_6026().forEach(s -> {
            class_2960 effectId = class_7923.field_41174.method_10221((Object)((class_1291)s.method_5579().comp_349()));
            potionList.add(effectId == null ? interpreter.getNull() : interpreter.convertValue((Object)effectId.method_12832()));
        });
        return potionList;
    }

    @FunctionDoc(name="getHealth", desc={"This gets the LivingEntity's current health"}, returns=@ReturnDoc(type=NumberDef.class, desc={"the LivingEntity's health"}), examples={"livingEntity.getHealth();"})
    private double getHealth(Arguments arguments) {
        return ((class_1309)arguments.nextPrimitive((PrimitiveDefinition)this)).method_6032();
    }

    @FunctionDoc(name="isFlyFalling", desc={"This checks if the LivingEntity is fly falling (gliding with elytra)"}, returns=@ReturnDoc(type=BooleanDef.class, desc={"true if the LivingEntity is fly falling"}), examples={"livingEntity.isFlyFalling();"})
    private boolean isFlyFalling(Arguments arguments) {
        return ((class_1309)arguments.nextPrimitive((PrimitiveDefinition)this)).method_6128();
    }
}

