/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.clientscript.definitions;

import java.util.List;
import kotlin.Unit;
import me.senseiwells.arucas.api.docs.annotations.ClassDoc;
import me.senseiwells.arucas.api.docs.annotations.ConstructorDoc;
import me.senseiwells.arucas.api.docs.annotations.FunctionDoc;
import me.senseiwells.arucas.api.docs.annotations.ParameterDoc;
import me.senseiwells.arucas.api.docs.annotations.ReturnDoc;
import me.senseiwells.arucas.builtin.FunctionDef;
import me.senseiwells.arucas.builtin.ListDef;
import me.senseiwells.arucas.builtin.StringDef;
import me.senseiwells.arucas.classes.CreatableDefinition;
import me.senseiwells.arucas.classes.PrimitiveDefinition;
import me.senseiwells.arucas.classes.instance.ClassInstance;
import me.senseiwells.arucas.exceptions.RuntimeError;
import me.senseiwells.arucas.functions.ArucasFunction;
import me.senseiwells.arucas.functions.builtin.Arguments;
import me.senseiwells.arucas.functions.builtin.ConstructorFunction;
import me.senseiwells.arucas.functions.builtin.MemberFunction;
import me.senseiwells.arucas.interpreter.Interpreter;
import me.senseiwells.arucas.utils.impl.ArucasList;
import me.senseiwells.arucas.utils.misc.Language;
import me.senseiwells.essentialclient.feature.keybinds.MultiKeyBind;
import me.senseiwells.essentialclient.utils.clientscript.impl.ScriptKeyBind;
import me.senseiwells.essentialclient.utils.keyboard.KeyboardHelper;
import net.minecraft.class_3675;

@ClassDoc(name="KeyBind", desc={"This class allows you to create key binds that can be used, everything is", "handled for you internally so you just need to regers the key bind and", "the function you want to run when it is pressed."}, language=Language.Java)
public class KeyBindDef
extends CreatableDefinition<ScriptKeyBind> {
    public KeyBindDef(Interpreter interpreter) {
        super("KeyBind", interpreter);
    }

    public Object asJavaValue(ClassInstance instance) {
        return ((ScriptKeyBind)instance.asPrimitive((PrimitiveDefinition)this)).getKeyBind();
    }

    public List<ConstructorFunction> defineConstructors() {
        return List.of(ConstructorFunction.of((int)1, this::construct));
    }

    @ConstructorDoc(desc={"Creates a new key bind"}, params={@ParameterDoc(type=StringDef.class, name="keyName", desc={"the name of the key"})}, examples={"new KeyBind('MyKey');"})
    private Unit construct(Arguments arguments) {
        ClassInstance instance = arguments.next();
        String keyName = (String)arguments.nextPrimitive(StringDef.class);
        instance.setPrimitive((PrimitiveDefinition)this, (Object)new ScriptKeyBind(arguments.getInterpreter(), keyName));
        return null;
    }

    public List<MemberFunction> defineMethods() {
        return List.of(MemberFunction.of((String)"setKey", (int)1, this::setKey), MemberFunction.arb((String)"setKeys", this::setKeys), MemberFunction.of((String)"getKey", this::getKey), MemberFunction.of((String)"getKeys", this::getKeys), MemberFunction.of((String)"setCallback", (int)1, this::setCallback));
    }

    @FunctionDoc(name="setKey", desc={"Sets the key bind to a new key"}, params={@ParameterDoc(type=StringDef.class, name="keyName", desc={"the name of the key"})}, examples={"keyBind.setKey('f');"})
    private Void setKey(Arguments arguments) {
        MultiKeyBind keyBind = ((ScriptKeyBind)arguments.nextPrimitive((PrimitiveDefinition)this)).getKeyBind();
        int keyCode = KeyboardHelper.translateStringToKey((String)arguments.nextPrimitive(StringDef.class));
        keyBind.clearKey();
        keyBind.addKeys(keyCode);
        return null;
    }

    @FunctionDoc(name="setKeys", desc={"Sets the key bind to new keys, you may also pass", "in a list as the parameter, this is to keep compatability"}, params={@ParameterDoc(type=StringDef.class, name="keyNames...", desc={"the names of keys"}, isVarargs=true)}, examples={"keyBind.setKeys('control', 'f');"})
    private Void setKeys(Arguments arguments) {
        MultiKeyBind keyBind = ((ScriptKeyBind)arguments.nextPrimitive((PrimitiveDefinition)this)).getKeyBind();
        List keys = arguments.size() == 2 && arguments.isNext(ListDef.class) ? (List)arguments.nextPrimitive(ListDef.class) : arguments.getRemaining();
        int[] inputKeys = new int[keys.size()];
        for (int i = 0; i < keys.size(); ++i) {
            String keyAsString = ((ClassInstance)keys.get(i)).toString(arguments.getInterpreter());
            int key = KeyboardHelper.translateStringToKey(keyAsString);
            if (key < 0) {
                throw new RuntimeError("Invalid key: " + keyAsString);
            }
            inputKeys[i] = key;
        }
        keyBind.clearKey();
        keyBind.addKeys(inputKeys);
        return null;
    }

    @FunctionDoc(name="getKey", desc={"Gets the key bind's first key"}, returns=@ReturnDoc(type=StringDef.class, desc={"the key bind's key"}), examples={"keyBind.getKey();"})
    private String getKey(Arguments arguments) {
        MultiKeyBind keyBind = ((ScriptKeyBind)arguments.nextPrimitive((PrimitiveDefinition)this)).getKeyBind();
        return KeyboardHelper.translateKeyToString(keyBind.getFirstKey().method_1444());
    }

    @FunctionDoc(name="getKeys", desc={"Gets the all of the keys in the key bind"}, returns=@ReturnDoc(type=ListDef.class, desc={"list of strings of all the keys"}), examples={"keybind.getKeys();"})
    private ArucasList getKeys(Arguments arguments) {
        MultiKeyBind keyBind = ((ScriptKeyBind)arguments.nextPrimitive((PrimitiveDefinition)this)).getKeyBind();
        ArucasList list = new ArucasList();
        for (class_3675.class_306 key : keyBind.getKeys()) {
            list.add(arguments.getInterpreter().create(StringDef.class, (Object)KeyboardHelper.translateKeyToString(key.method_1444())));
        }
        return list;
    }

    @FunctionDoc(name="setCallback", desc={"Sets the callback function for the key bind"}, params={@ParameterDoc(type=FunctionDef.class, name="callback", desc={"the callback function"})}, examples={"keyBind.setCallback(fun() { print('My key was pressed'); });"})
    private Void setCallback(Arguments arguments) {
        ScriptKeyBind keyBind = (ScriptKeyBind)arguments.nextPrimitive((PrimitiveDefinition)this);
        keyBind.setFunction((ArucasFunction)arguments.nextPrimitive(FunctionDef.class));
        return null;
    }
}

