/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.clientscript.definitions;

import java.util.List;
import me.senseiwells.arucas.api.docs.annotations.ClassDoc;
import me.senseiwells.arucas.api.docs.annotations.FunctionDoc;
import me.senseiwells.arucas.api.docs.annotations.ParameterDoc;
import me.senseiwells.arucas.api.docs.annotations.ReturnDoc;
import me.senseiwells.arucas.builtin.BooleanDef;
import me.senseiwells.arucas.builtin.NumberDef;
import me.senseiwells.arucas.builtin.StringDef;
import me.senseiwells.arucas.classes.ClassDefinition;
import me.senseiwells.arucas.classes.CreatableDefinition;
import me.senseiwells.arucas.classes.PrimitiveDefinition;
import me.senseiwells.arucas.classes.instance.ClassInstance;
import me.senseiwells.arucas.compiler.LocatableTrace;
import me.senseiwells.arucas.exceptions.RuntimeError;
import me.senseiwells.arucas.functions.builtin.Arguments;
import me.senseiwells.arucas.functions.builtin.BuiltInFunction;
import me.senseiwells.arucas.functions.builtin.MemberFunction;
import me.senseiwells.arucas.interpreter.Interpreter;
import me.senseiwells.arucas.utils.misc.Language;
import me.senseiwells.essentialclient.clientscript.definitions.BlockDef;
import me.senseiwells.essentialclient.clientscript.definitions.ItemEntityDef;
import me.senseiwells.essentialclient.clientscript.definitions.MaterialDef;
import me.senseiwells.essentialclient.utils.EssentialUtils;
import me.senseiwells.essentialclient.utils.clientscript.ClientScriptUtils;
import me.senseiwells.essentialclient.utils.clientscript.impl.ScriptBlockState;
import me.senseiwells.essentialclient.utils.clientscript.impl.ScriptItemStack;
import me.senseiwells.essentialclient.utils.clientscript.impl.ScriptMaterial;
import net.minecraft.class_1074;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_638;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

@ClassDoc(name="ItemStack", desc={"This class represents an item stack. It can be used to create new item stacks, or to modify existing ones."}, superclass=MaterialDef.class, language=Language.Java)
public class ItemStackDef
extends CreatableDefinition<ScriptItemStack> {
    public ItemStackDef(Interpreter interpreter) {
        super("ItemStack", interpreter);
    }

    @NotNull
    public PrimitiveDefinition<? super ScriptItemStack> superclass() {
        return this.getPrimitiveDef(MaterialDef.class);
    }

    public Object asJavaValue(ClassInstance instance) {
        return ((ScriptItemStack)instance.asPrimitive((PrimitiveDefinition)this)).asDefault();
    }

    public boolean equals(@NotNull ClassInstance instance, @NotNull Interpreter interpreter, @NotNull ClassInstance other, @NotNull LocatableTrace trace) {
        ScriptItemStack stack = (ScriptItemStack)other.getPrimitive((PrimitiveDefinition)this);
        return stack != null && ((ScriptItemStack)instance.asPrimitive((PrimitiveDefinition)this)).stack.method_7909() == stack.stack.method_7909();
    }

    public int hashCode(@NotNull ClassInstance instance, @NotNull Interpreter interpreter, @NotNull LocatableTrace trace) {
        return this.toString(instance, interpreter, trace).hashCode();
    }

    @NotNull
    public String toString(@NotNull ClassInstance instance, @NotNull Interpreter interpreter, @NotNull LocatableTrace trace) {
        ScriptItemStack stack = (ScriptItemStack)instance.asPrimitive((PrimitiveDefinition)this);
        return "ItemStack{id=" + String.valueOf(stack.getId()) + ", count=" + stack.stack.method_7947() + "}";
    }

    @NotNull
    public ClassInstance copy(@NotNull ClassInstance instance, @NotNull Interpreter interpreter, @NotNull LocatableTrace trace) {
        return this.create(new ScriptItemStack(((ScriptItemStack)instance.asPrimitive((PrimitiveDefinition)this)).stack.method_7972()));
    }

    public List<BuiltInFunction> defineStaticMethods() {
        return List.of(BuiltInFunction.of((String)"of", (int)1, this::of));
    }

    @FunctionDoc(isStatic=true, name="of", desc={"This creates an ItemStack from a material or a string"}, params={@ParameterDoc(type=MaterialDef.class, name="material", desc={"the material, item stack, block, or string to create the ItemStack from"})}, returns=@ReturnDoc(type=ItemStackDef.class, desc={"the new ItemStack instance"}), examples={"ItemStack.of('dirt');"})
    private class_1799 of(Arguments arguments) {
        if (arguments.isNext(StringDef.class)) {
            String id = (String)arguments.nextPrimitive(StringDef.class);
            class_2960 identifier = ClientScriptUtils.stringToIdentifier(id);
            return ((class_1792)class_7923.field_41178.method_17966(identifier).orElseThrow(() -> new RuntimeError("'%s' is not a valid item stack".formatted(id)))).method_7854();
        }
        if (arguments.isNext(MaterialDef.class)) {
            ScriptMaterial material = (ScriptMaterial)arguments.nextPrimitive(MaterialDef.class);
            return material.asItemStack();
        }
        throw new RuntimeError("Parameter must be of type String or Material");
    }

    public List<MemberFunction> defineMethods() {
        return List.of(MemberFunction.of((String)"getMaterial", this::getMaterial), MemberFunction.of((String)"getCount", this::getCount), MemberFunction.of((String)"getDurability", this::getDurability), MemberFunction.of((String)"getMaxDurability", this::getMaxDurability), MemberFunction.of((String)"isBlockItem", this::isBlockItem), MemberFunction.of((String)"isStackable", this::isStackable), MemberFunction.of((String)"getMaxCount", this::getMaxCount), MemberFunction.of((String)"asEntity", this::asEntity), MemberFunction.of((String)"getCustomName", this::getCustomName), MemberFunction.of((String)"getTranslatedName", this::getTranslatedName), MemberFunction.of((String)"getMiningSpeedMultiplier", (int)1, this::getMiningSpeedMultiplier), MemberFunction.of((String)"setStackSize", (int)1, this::setStackSize), MemberFunction.of((String)"increment", (int)1, this::increment), MemberFunction.of((String)"decrement", (int)1, this::decrement));
    }

    @FunctionDoc(name="getMaterial", desc={"This gets the material of the ItemStack"}, returns=@ReturnDoc(type=MaterialDef.class, desc={"the material of the ItemStack"}), examples={"itemStack.getMaterial();"})
    private class_1792 getMaterial(Arguments arguments) {
        return ((ScriptItemStack)arguments.nextPrimitive((PrimitiveDefinition)this)).asItem();
    }

    @FunctionDoc(name="getCount", desc={"This gets the count of the ItemStack, the amount of items in the stack"}, returns=@ReturnDoc(type=NumberDef.class, desc={"the count of the ItemStack"}), examples={"itemStack.getCount();"})
    private double getCount(Arguments arguments) {
        return ((ScriptItemStack)arguments.nextPrimitive((PrimitiveDefinition)this)).stack.method_7947();
    }

    @FunctionDoc(name="getDurability", desc={"This gets the durability of the item"}, returns=@ReturnDoc(type=NumberDef.class, desc={"the durability of the item"}), examples={"itemStack.getDurability();"})
    private double getDurability(Arguments arguments) {
        class_1799 stack = ((ScriptItemStack)arguments.nextPrimitive((PrimitiveDefinition)this)).stack;
        return stack.method_7936() - stack.method_7919();
    }

    @FunctionDoc(name="getMaxDurability", desc={"This gets the max durability of the item"}, returns=@ReturnDoc(type=NumberDef.class, desc={"the max durability of the item"}), examples={"itemStack.getMaxDurability();"})
    private double getMaxDurability(Arguments arguments) {
        return ((ScriptItemStack)arguments.nextPrimitive((PrimitiveDefinition)this)).stack.method_7936();
    }

    @FunctionDoc(name="isBlockItem", desc={"This checks if the ItemStack can be placed as a block"}, returns=@ReturnDoc(type=BooleanDef.class, desc={"true if the ItemStack can be placed as a block, false otherwise"}), examples={"itemStack.isBlockItem();"})
    private boolean isBlockItem(Arguments arguments) {
        return ((ScriptItemStack)arguments.nextPrimitive((PrimitiveDefinition)this)).asItem() instanceof class_1747;
    }

    @FunctionDoc(name="isStackable", desc={"This checks if the ItemStack is stackable"}, returns=@ReturnDoc(type=BooleanDef.class, desc={"true if the ItemStack is stackable, false otherwise"}), examples={"itemStack.isStackable();"})
    private boolean isStackable(Arguments arguments) {
        return ((ScriptItemStack)arguments.nextPrimitive((PrimitiveDefinition)this)).stack.method_7946();
    }

    @FunctionDoc(name="getMaxCount", desc={"This gets the max stack size of the ItemStack"}, returns=@ReturnDoc(type=NumberDef.class, desc={"the max stack size of the ItemStack"}), examples={"itemStack.getMaxCount();"})
    private double getMaxCount(Arguments arguments) {
        return ((ScriptItemStack)arguments.nextPrimitive((PrimitiveDefinition)this)).stack.method_7914();
    }

    @FunctionDoc(name="asEntity", desc={"This creates an item entity with the item"}, returns=@ReturnDoc(type=ItemEntityDef.class, desc={"the entity of the ItemStack"}), examples={"itemStack.asEntity();"})
    private class_1542 asEntity(Arguments arguments) {
        class_1799 itemStack = ((ScriptItemStack)arguments.nextPrimitive((PrimitiveDefinition)this)).stack;
        class_638 world = EssentialUtils.getWorld();
        class_1542 itemEntity = (class_1542)class_1299.field_6052.method_5883((class_1937)world);
        if (itemEntity == null) {
            throw new RuntimeError("'%s' cannot be converted into ItemEntity".formatted(itemStack));
        }
        itemEntity.method_6979(itemStack);
        return itemEntity;
    }

    @FunctionDoc(name="getCustomName", desc={"This gets the custom name of the ItemStack"}, returns=@ReturnDoc(type=StringDef.class, desc={"the custom name of the ItemStack"}), examples={"itemStack.getCustomName();"})
    private String getCustomName(Arguments arguments) {
        return ((ScriptItemStack)arguments.nextPrimitive((PrimitiveDefinition)this)).stack.method_7964().getString();
    }

    @FunctionDoc(name="getTranslatedName", desc={"This gets the translated name of the ItemStack, for example", "'diamond_sword' would return 'Diamond Sword' if your language is English"}, returns=@ReturnDoc(type=StringDef.class, desc={"the translated name of the ItemStack"}), examples={"itemStack.getTranslatedName();"})
    private String getTranslatedName(Arguments arguments) {
        class_1799 itemStack = ((ScriptItemStack)arguments.nextPrimitive((PrimitiveDefinition)this)).stack;
        return class_1074.method_4662((String)itemStack.method_7909().method_7876(), (Object[])new Object[0]);
    }

    @FunctionDoc(name="getMiningSpeedMultiplier", desc={"This gets the mining speed multiplier of the ItemStack for the given Block,", "for example a diamond pickaxe on stone would have a higher multiplier than air on stone"}, params={@ParameterDoc(type=BlockDef.class, name="block", desc={"the Block to get the mining speed multiplier for"})}, returns=@ReturnDoc(type=NumberDef.class, desc={"the mining speed multiplier of the ItemStack for the given Block"}), examples={"pickaxe = Material.DIAMOND_PICKAXE.asItemStack();\ngoldBlock = Material.GOLD_BLOCK.asBlock();\n\npickaxe.getMiningSpeedMultiplier(goldBlock);\n"})
    private double getMiningSpeedMultiplier(Arguments arguments) {
        class_1799 itemStack = ((ScriptItemStack)arguments.nextPrimitive((PrimitiveDefinition)this)).stack;
        ScriptBlockState blockState = (ScriptBlockState)arguments.nextPrimitive(BlockDef.class);
        return itemStack.method_7924(blockState.state);
    }

    @FunctionDoc(name="setStackSize", desc={"This sets the stack size of the ItemStack"}, params={@ParameterDoc(type=NumberDef.class, name="stackSize", desc={"the stack size of the ItemStack"})}, returns=@ReturnDoc(type=ItemStackDef.class, desc={"the ItemStack with the new stack size"}), examples={"itemStack.setStackSize(5);"})
    private ClassInstance setStackSize(Arguments arguments) {
        ClassInstance instance = arguments.next((ClassDefinition)this);
        class_1799 itemStack = ((ScriptItemStack)instance.asPrimitive((PrimitiveDefinition)this)).stack;
        double count = (Double)arguments.nextPrimitive(NumberDef.class);
        itemStack.method_7939((int)count);
        return instance;
    }

    @FunctionDoc(name="increment", desc={"This increments the stack size of the ItemStack by number"}, params={@ParameterDoc(type=NumberDef.class, name="count", desc={"number to increase"})}, returns=@ReturnDoc(type=ItemStackDef.class, desc={"the ItemStack with the new stack size"}), examples={"itemStack.increment(5);"})
    private ClassInstance increment(Arguments arguments) {
        ClassInstance instance = arguments.next((ClassDefinition)this);
        class_1799 itemStack = ((ScriptItemStack)instance.asPrimitive((PrimitiveDefinition)this)).stack;
        double count = (Double)arguments.nextPrimitive(NumberDef.class);
        itemStack.method_7933((int)count);
        return instance;
    }

    @FunctionDoc(name="decrement", desc={"This decrements the stack size of the ItemStack by number"}, params={@ParameterDoc(type=NumberDef.class, name="count", desc={"number to decrease"})}, returns=@ReturnDoc(type=ItemStackDef.class, desc={"the ItemStack with the new stack size"}), examples={"itemStack.decrement(5);"})
    private ClassInstance decrement(Arguments arguments) {
        ClassInstance instance = arguments.next((ClassDefinition)this);
        class_1799 itemStack = ((ScriptItemStack)instance.asPrimitive((PrimitiveDefinition)this)).stack;
        double count = (Double)arguments.nextPrimitive(NumberDef.class);
        itemStack.method_7934((int)count);
        return instance;
    }
}

