/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.clientscript.definitions;

import java.util.List;
import java.util.UUID;
import me.senseiwells.arucas.api.docs.annotations.ClassDoc;
import me.senseiwells.arucas.api.docs.annotations.FunctionDoc;
import me.senseiwells.arucas.api.docs.annotations.ReturnDoc;
import me.senseiwells.arucas.builtin.NumberDef;
import me.senseiwells.arucas.builtin.StringDef;
import me.senseiwells.arucas.classes.CreatableDefinition;
import me.senseiwells.arucas.classes.PrimitiveDefinition;
import me.senseiwells.arucas.classes.instance.ClassInstance;
import me.senseiwells.arucas.compiler.LocatableTrace;
import me.senseiwells.arucas.functions.builtin.Arguments;
import me.senseiwells.arucas.functions.builtin.MemberFunction;
import me.senseiwells.arucas.interpreter.Interpreter;
import me.senseiwells.arucas.utils.misc.Language;
import me.senseiwells.essentialclient.clientscript.definitions.EntityDef;
import me.senseiwells.essentialclient.clientscript.definitions.ItemStackDef;
import me.senseiwells.essentialclient.clientscript.definitions.PlayerDef;
import me.senseiwells.essentialclient.mixins.clientScript.ItemEntityAccessor;
import me.senseiwells.essentialclient.utils.EssentialUtils;
import me.senseiwells.essentialclient.utils.clientscript.ThreadSafeUtils;
import me.senseiwells.essentialclient.utils.clientscript.impl.ScriptItemStack;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import org.jetbrains.annotations.NotNull;

@ClassDoc(name="ItemEntity", desc={"This class extends Entity and so inherits all of their methods too,", "ItemEntities are entities that are dropped items."}, superclass=EntityDef.class, language=Language.Java)
public class ItemEntityDef
extends CreatableDefinition<class_1542> {
    public ItemEntityDef(Interpreter interpreter) {
        super("ItemEntity", interpreter);
    }

    @NotNull
    public PrimitiveDefinition<? super class_1542> superclass() {
        return this.getPrimitiveDef(EntityDef.class);
    }

    @NotNull
    public String toString(@NotNull ClassInstance instance, @NotNull Interpreter interpreter, @NotNull LocatableTrace trace) {
        class_1799 stack = ((class_1542)instance.asPrimitive((PrimitiveDefinition)this)).method_6983();
        return "ItemEntity{id=" + stack.method_7909().toString() + ", count=" + stack.method_7947() + "}";
    }

    public List<MemberFunction> defineMethods() {
        return List.of(MemberFunction.of((String)"getItemStack", this::getItemStack), MemberFunction.of((String)"getCustomName", this::getCustomName), MemberFunction.of((String)"getItemAge", this::getItemAge), MemberFunction.of((String)"getThrower", this::getThrower));
    }

    @FunctionDoc(name="getItemStack", desc={"This method returns the ItemStack that is held in the ItemEntity"}, returns=@ReturnDoc(type=ItemStackDef.class, desc={"the ItemStack that the entity holds"}), examples={"itemEntity.getItemStack();"})
    private ScriptItemStack getItemStack(Arguments arguments) {
        return new ScriptItemStack(((class_1542)arguments.nextPrimitive((PrimitiveDefinition)this)).method_6983());
    }

    @FunctionDoc(name="getCustomName", desc={"This method returns the custom name of the ItemEntity"}, returns=@ReturnDoc(type=StringDef.class, desc={"the custom name of the entity"}), examples={"itemEntity.getCustomName();"})
    private String getCustomName(Arguments arguments) {
        return ((class_1542)arguments.nextPrimitive((PrimitiveDefinition)this)).method_5477().getString();
    }

    @FunctionDoc(name="getItemAge", desc={"This method returns the age of the ItemEntity", "this is increased every tick and the item entity despawns after 6000 ticks"}, returns=@ReturnDoc(type=NumberDef.class, desc={"the age of the entity"}), examples={"itemEntity.getItemAge();"})
    private double getItemAge(Arguments arguments) {
        return ((class_1542)arguments.nextPrimitive((PrimitiveDefinition)this)).method_6985();
    }

    @FunctionDoc(name="getThrower", desc={"This method returns the player that threw the ItemEntity, null if not thrown by a player or player not found"}, returns=@ReturnDoc(type=PlayerDef.class, desc={"the player that threw the entity"}), examples={"itemEntity.getThrower();"})
    private Object getThrower(Arguments arguments) {
        UUID throwerUuid = ((ItemEntityAccessor)arguments.nextPrimitive((PrimitiveDefinition)this)).getThrower();
        return throwerUuid == null ? null : ThreadSafeUtils.getPlayerByUuid((class_1937)EssentialUtils.getWorld(), throwerUuid);
    }
}

