/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.clientscript.definitions;

import java.util.List;
import kotlin.Unit;
import me.senseiwells.arucas.api.docs.annotations.ClassDoc;
import me.senseiwells.arucas.api.docs.annotations.ConstructorDoc;
import me.senseiwells.arucas.api.docs.annotations.FunctionDoc;
import me.senseiwells.arucas.api.docs.annotations.ParameterDoc;
import me.senseiwells.arucas.api.docs.annotations.ReturnDoc;
import me.senseiwells.arucas.builtin.FunctionDef;
import me.senseiwells.arucas.builtin.NumberDef;
import me.senseiwells.arucas.builtin.StringDef;
import me.senseiwells.arucas.classes.CreatableDefinition;
import me.senseiwells.arucas.classes.PrimitiveDefinition;
import me.senseiwells.arucas.classes.instance.ClassInstance;
import me.senseiwells.arucas.exceptions.RuntimeError;
import me.senseiwells.arucas.functions.ArucasFunction;
import me.senseiwells.arucas.functions.builtin.Arguments;
import me.senseiwells.arucas.functions.builtin.ConstructorFunction;
import me.senseiwells.arucas.functions.builtin.MemberFunction;
import me.senseiwells.arucas.interpreter.Interpreter;
import me.senseiwells.arucas.utils.misc.Language;
import me.senseiwells.essentialclient.clientscript.definitions.ItemStackDef;
import me.senseiwells.essentialclient.clientscript.definitions.ScreenDef;
import me.senseiwells.essentialclient.utils.EssentialUtils;
import me.senseiwells.essentialclient.utils.clientscript.ClientScriptUtils;
import me.senseiwells.essentialclient.utils.clientscript.impl.ScriptItemStack;
import me.senseiwells.essentialclient.utils.render.FakeInventoryScreen;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;

@ClassDoc(name="FakeScreen", desc={"This class extends Screen and so inherits all of their methods too,", "this class is used to create client side inventory screens."}, superclass=ScreenDef.class, language=Language.Java)
public class FakeScreenDef
extends CreatableDefinition<FakeInventoryScreen> {
    public FakeScreenDef(Interpreter interpreter) {
        super("FakeScreen", interpreter);
    }

    @NotNull
    public PrimitiveDefinition<? super FakeInventoryScreen> superclass() {
        return this.getPrimitiveDef(ScreenDef.class);
    }

    public List<ConstructorFunction> defineConstructors() {
        return List.of(ConstructorFunction.of((int)2, this::construct));
    }

    @ConstructorDoc(desc={"Creates a FakeScreen instance with given name and given amount of rows,", "this will throw an error if the rows are not between 1 and 6"}, params={@ParameterDoc(type=StringDef.class, name="name", desc={"the name of the screen"}), @ParameterDoc(type=NumberDef.class, name="rows", desc={"the number of rows between 1 - 6"})}, examples={"new FakeScreen('MyScreen', 6);"})
    private Unit construct(Arguments arguments) {
        ClassInstance instance = arguments.next();
        String name = (String)arguments.nextPrimitive(StringDef.class);
        int rows = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        if (rows < 1 || rows > 6) {
            throw new RuntimeError("Rows must be between 1 and 6");
        }
        FakeInventoryScreen screen = new FakeInventoryScreen(arguments.getInterpreter(), EssentialUtils.getPlayer().method_31548(), name, rows);
        instance.setPrimitive((PrimitiveDefinition)this, (Object)screen);
        return null;
    }

    public List<MemberFunction> defineMethods() {
        return List.of(MemberFunction.of((String)"onClick", (int)1, this::onClick), MemberFunction.of((String)"setStackForSlot", (int)2, this::setStackForSlot), MemberFunction.of((String)"getStackForSlot", (int)1, this::getStackForSlot));
    }

    @FunctionDoc(name="onClick", desc={"This sets the callback for when a slot is clicked in the inventory.", "The callback must have 3 parameters, the first is the item stack that was clicked,", "then second is the slot number, third is the action as a string, fourth is the", "button string: right, left, middle."}, params={@ParameterDoc(type=FunctionDef.class, name="function", desc={"the callback function"})}, examples={"fakeScreen.onClick(fun(item, slotNum, action, button) {\n\t// Action can be any of the following:\n\t// 'PICKUP', 'QUICK_MOVE', 'SWAP', 'CLONE', 'THROW', 'QUICK_CRAFT', or 'PICKUP_ALL'\n\t// Button can be any of the follinwg:\n\t// 'right', 'left', 'middle', or 'unknown'\n\tprint(action);\n});\n"})
    private Void onClick(Arguments arguments) {
        FakeInventoryScreen fakeScreen = (FakeInventoryScreen)((Object)arguments.nextPrimitive(FakeScreenDef.class));
        ArucasFunction function = (ArucasFunction)arguments.nextPrimitive(FunctionDef.class);
        fakeScreen.setFunctionValue(arguments.getInterpreter(), function);
        return null;
    }

    @FunctionDoc(name="setStackForSlot", desc={"Sets the stack for the given slot, if the slot is out of bounds it won't be set"}, params={@ParameterDoc(type=NumberDef.class, name="slotNum", desc={"the slot number"}), @ParameterDoc(type=ItemStackDef.class, name="stack", desc={"the stack to set"})}, examples={"fakeScreen.setStackForSlot(0, Material.DIAMOND_BLOCK.asItemStack());"})
    private Void setStackForSlot(Arguments arguments) {
        FakeInventoryScreen fakeScreen = (FakeInventoryScreen)((Object)arguments.nextPrimitive(FakeScreenDef.class));
        int slotNum = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        ScriptItemStack itemStack = (ScriptItemStack)arguments.nextPrimitive(ItemStackDef.class);
        ClientScriptUtils.ensureMainThread("setStackForSlot", arguments.getInterpreter(), () -> fakeScreen.setStack(slotNum, itemStack.stack));
        return null;
    }

    @FunctionDoc(name="getStackForSlot", desc={"Gets the stack for the given slot, if the slot is out of bounds it returns null"}, params={@ParameterDoc(type=NumberDef.class, name="slotNum", desc={"the slot number"})}, returns=@ReturnDoc(type=ItemStackDef.class, desc={"the stack for the given slot"}), examples={"fakeScreen.getStackForSlot(0);"})
    private ScriptItemStack getStackForSlot(Arguments arguments) {
        int slotNum;
        FakeInventoryScreen fakeScreen = (FakeInventoryScreen)((Object)arguments.nextPrimitive(FakeScreenDef.class));
        class_1799 stack = fakeScreen.getStack(slotNum = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue());
        return stack == null ? null : new ScriptItemStack(stack);
    }
}

