/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.clientscript.definitions;

import java.util.List;
import kotlin.Unit;
import me.senseiwells.arucas.api.docs.annotations.ClassDoc;
import me.senseiwells.arucas.api.docs.annotations.ConstructorDoc;
import me.senseiwells.arucas.api.docs.annotations.FunctionDoc;
import me.senseiwells.arucas.api.docs.annotations.ParameterDoc;
import me.senseiwells.arucas.api.docs.annotations.ReturnDoc;
import me.senseiwells.arucas.builtin.NumberDef;
import me.senseiwells.arucas.classes.CreatableDefinition;
import me.senseiwells.arucas.classes.PrimitiveDefinition;
import me.senseiwells.arucas.classes.instance.ClassInstance;
import me.senseiwells.arucas.exceptions.RuntimeError;
import me.senseiwells.arucas.functions.builtin.Arguments;
import me.senseiwells.arucas.functions.builtin.ConstructorFunction;
import me.senseiwells.arucas.functions.builtin.MemberFunction;
import me.senseiwells.arucas.interpreter.Interpreter;
import me.senseiwells.arucas.utils.misc.Language;
import me.senseiwells.essentialclient.clientscript.definitions.EntityDef;
import me.senseiwells.essentialclient.clientscript.definitions.PosDef;
import me.senseiwells.essentialclient.clientscript.definitions.WorldDef;
import me.senseiwells.essentialclient.utils.clientscript.impl.ScriptFakeEntity;
import me.senseiwells.essentialclient.utils.clientscript.impl.ScriptPos;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_638;

@ClassDoc(name="FakeEntity", desc={"This allows you to create a fake entity which can be rendered in the world."}, language=Language.Java)
public class FakeEntityDef
extends CreatableDefinition<ScriptFakeEntity> {
    public FakeEntityDef(Interpreter interpreter) {
        super("FakeEntity", interpreter);
    }

    public List<ConstructorFunction> defineConstructors() {
        return List.of(ConstructorFunction.of((int)2, this::construct));
    }

    @ConstructorDoc(desc={"Creates a new fake entity"}, params={@ParameterDoc(type=EntityDef.class, name="entity", desc={"The entity that you want to create into a fake entity"}), @ParameterDoc(type=WorldDef.class, name="world", desc={"The world that the entity is being rendered in"})}, examples={"fakeEntity = new FakeEntity();"})
    private Unit construct(Arguments arguments) {
        ClassInstance instance = arguments.next();
        class_1297 entity = (class_1297)arguments.nextPrimitive(EntityDef.class);
        class_1937 world = (class_1937)arguments.nextPrimitive(WorldDef.class);
        if (!(world instanceof class_638)) {
            throw new RuntimeError("World must be a client world");
        }
        class_638 clientWorld = (class_638)world;
        instance.setPrimitive((PrimitiveDefinition)this, (Object)new ScriptFakeEntity(arguments.getInterpreter(), entity, clientWorld));
        return null;
    }

    public List<MemberFunction> defineMethods() {
        return List.of(MemberFunction.of((String)"setWorld", (int)1, this::setWorld), MemberFunction.of((String)"getWorld", this::getWorld), MemberFunction.of((String)"setPos", (int)1, this::setPos1), MemberFunction.of((String)"setPos", (int)2, this::setPos2), MemberFunction.of((String)"getPos", this::getPos), MemberFunction.of((String)"setYaw", (int)1, this::setYaw1), MemberFunction.of((String)"setYaw", (int)2, this::setYaw2), MemberFunction.of((String)"getYaw", this::getYaw), MemberFunction.of((String)"setBodyYaw", (int)1, this::setBodyYaw1), MemberFunction.of((String)"setBodyYaw", (int)2, this::setBodyYaw2), MemberFunction.of((String)"getBodyYaw", this::getBodyYaw), MemberFunction.of((String)"setPitch", (int)1, this::setPitch1), MemberFunction.of((String)"setPitch", (int)2, this::setPitch2), MemberFunction.of((String)"getPitch", this::getPitch), MemberFunction.of((String)"updatePosAndRotation", (int)3, this::updatePosAndRotation3), MemberFunction.of((String)"updatePosAndRotation", (int)4, this::updatePosAndRotation4), MemberFunction.of((String)"spawn", this::spawn), MemberFunction.of((String)"despawn", this::despawn));
    }

    @FunctionDoc(name="setWorld", desc={"Sets the world that the entity is being rendered in"}, params={@ParameterDoc(type=WorldDef.class, name="world", desc={"The world that the entity is being rendered in"})}, examples={"fakeEntity.setWorld(MinecraftClient.getClient().getWorld());"})
    private Void setWorld(Arguments arguments) {
        ScriptFakeEntity entity = (ScriptFakeEntity)arguments.nextPrimitive((PrimitiveDefinition)this);
        class_1937 world = (class_1937)arguments.nextPrimitive(WorldDef.class);
        if (!(world instanceof class_638)) {
            throw new RuntimeError("World must be a client world");
        }
        class_638 clientWorld = (class_638)world;
        entity.setWorld(clientWorld);
        return null;
    }

    @FunctionDoc(name="getWorld", desc={"Gets the world that the entity is being rendered in"}, returns=@ReturnDoc(type=WorldDef.class, desc={"The world that the entity is being rendered in"}), examples={"world = fakeEntity.getWorld();"})
    private class_1937 getWorld(Arguments arguments) {
        ScriptFakeEntity entity = (ScriptFakeEntity)arguments.nextPrimitive((PrimitiveDefinition)this);
        return entity.getWorld();
    }

    @FunctionDoc(name="setPos", desc={"Sets the position of the entity with no interpolation"}, params={@ParameterDoc(type=PosDef.class, name="pos", desc={"The new position of the entity"})}, examples={"fakeEntity.setPos(new Pos(0, 0, 0));"})
    private Void setPos1(Arguments arguments) {
        ScriptFakeEntity entity = (ScriptFakeEntity)arguments.nextPrimitive((PrimitiveDefinition)this);
        ScriptPos pos = (ScriptPos)arguments.nextPrimitive(PosDef.class);
        entity.setPos(pos.getVec3d());
        return null;
    }

    @FunctionDoc(name="setPos", desc={"Sets the position of the entity"}, params={@ParameterDoc(type=PosDef.class, name="pos", desc={"The new position of the entity"}), @ParameterDoc(type=NumberDef.class, name="interpolationSteps", desc={"The number of interpolation steps to take"})}, examples={"fakeEntity.setPos(new Pos(0, 0, 0), 0);"})
    private Void setPos2(Arguments arguments) {
        ScriptFakeEntity entity = (ScriptFakeEntity)arguments.nextPrimitive((PrimitiveDefinition)this);
        int interpolationSteps = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        ScriptPos pos = (ScriptPos)arguments.nextPrimitive(PosDef.class);
        entity.setPos(pos.getVec3d(), interpolationSteps);
        return null;
    }

    @FunctionDoc(name="getPos", desc={"Gets the position of the entity"}, returns=@ReturnDoc(type=PosDef.class, desc={"The position of the entity"}), examples={"pos = fakeEntity.getPos();"})
    private ScriptPos getPos(Arguments arguments) {
        ScriptFakeEntity entity = (ScriptFakeEntity)arguments.nextPrimitive((PrimitiveDefinition)this);
        return new ScriptPos(entity.getPos());
    }

    @FunctionDoc(name="setYaw", desc={"Sets the yaw of the entity with no interpolation"}, params={@ParameterDoc(type=NumberDef.class, name="yaw", desc={"The new yaw of the entity"})}, examples={"fakeEntity.setYaw(0);"})
    private Void setYaw1(Arguments arguments) {
        ScriptFakeEntity entity = (ScriptFakeEntity)arguments.nextPrimitive((PrimitiveDefinition)this);
        float yaw = ((Double)arguments.nextPrimitive(NumberDef.class)).floatValue();
        entity.setYaw(yaw);
        return null;
    }

    @FunctionDoc(name="setYaw", desc={"Sets the yaw of the entity"}, params={@ParameterDoc(type=NumberDef.class, name="yaw", desc={"The new yaw of the entity"}), @ParameterDoc(type=NumberDef.class, name="interpolationSteps", desc={"The number of interpolation steps to take"})}, examples={"fakeEntity.setYaw(0, 10);"})
    private Void setYaw2(Arguments arguments) {
        ScriptFakeEntity entity = (ScriptFakeEntity)arguments.nextPrimitive((PrimitiveDefinition)this);
        int interpolationSteps = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        float yaw = ((Double)arguments.nextPrimitive(NumberDef.class)).floatValue();
        entity.setYaw(yaw, interpolationSteps);
        return null;
    }

    @FunctionDoc(name="getYaw", desc={"Gets the yaw of the entity"}, returns=@ReturnDoc(type=NumberDef.class, desc={"The yaw of the entity"}), examples={"yaw = fakeEntity.getYaw();"})
    private float getYaw(Arguments arguments) {
        ScriptFakeEntity entity = (ScriptFakeEntity)arguments.nextPrimitive((PrimitiveDefinition)this);
        return entity.getYaw();
    }

    @FunctionDoc(name="setBodyYaw", desc={"Sets the body yaw of the entity with no interpolation"}, params={@ParameterDoc(type=NumberDef.class, name="bodyYaw", desc={"The new body yaw of the entity"})}, examples={"fakeEntity.setBodyYaw(0);"})
    private Void setBodyYaw1(Arguments arguments) {
        ScriptFakeEntity entity = (ScriptFakeEntity)arguments.nextPrimitive((PrimitiveDefinition)this);
        float bodyYaw = ((Double)arguments.nextPrimitive(NumberDef.class)).floatValue();
        entity.setBodyYaw(bodyYaw);
        return null;
    }

    @FunctionDoc(name="setBodyYaw", desc={"Sets the body yaw of the entity"}, params={@ParameterDoc(type=NumberDef.class, name="bodyYaw", desc={"The new body yaw of the entity"}), @ParameterDoc(type=NumberDef.class, name="interpolationSteps", desc={"The number of interpolation steps to take"})}, examples={"fakeEntity.setBodyYaw(0, 10);"})
    private Void setBodyYaw2(Arguments arguments) {
        ScriptFakeEntity entity = (ScriptFakeEntity)arguments.nextPrimitive((PrimitiveDefinition)this);
        int interpolationSteps = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        float bodyYaw = ((Double)arguments.nextPrimitive(NumberDef.class)).floatValue();
        entity.setBodyYaw(bodyYaw, interpolationSteps);
        return null;
    }

    @FunctionDoc(name="getBodyYaw", desc={"Gets the body yaw of the entity"}, returns=@ReturnDoc(type=NumberDef.class, desc={"The body yaw of the entity"}), examples={"bodyYaw = fakeEntity.getBodyYaw();"})
    private float getBodyYaw(Arguments arguments) {
        ScriptFakeEntity entity = (ScriptFakeEntity)arguments.nextPrimitive((PrimitiveDefinition)this);
        return entity.getBodyYaw();
    }

    @FunctionDoc(name="setPitch", desc={"Sets the pitch of the entity with no interpolation"}, params={@ParameterDoc(type=NumberDef.class, name="pitch", desc={"The new pitch of the entity"})}, examples={"fakeEntity.setPitch(0);"})
    private Void setPitch1(Arguments arguments) {
        ScriptFakeEntity entity = (ScriptFakeEntity)arguments.nextPrimitive((PrimitiveDefinition)this);
        float pitch = ((Double)arguments.nextPrimitive(NumberDef.class)).floatValue();
        entity.setPitch(pitch);
        return null;
    }

    @FunctionDoc(name="setPitch", desc={"Sets the pitch of the entity"}, params={@ParameterDoc(type=NumberDef.class, name="pitch", desc={"The new pitch of the entity"}), @ParameterDoc(type=NumberDef.class, name="interpolationSteps", desc={"The number of interpolation steps to take"})}, examples={"fakeEntity.setPitch(0, 10);"})
    private Void setPitch2(Arguments arguments) {
        ScriptFakeEntity entity = (ScriptFakeEntity)arguments.nextPrimitive((PrimitiveDefinition)this);
        int interpolationSteps = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        float pitch = ((Double)arguments.nextPrimitive(NumberDef.class)).floatValue();
        entity.setPitch(pitch, interpolationSteps);
        return null;
    }

    @FunctionDoc(name="getPitch", desc={"Gets the pitch of the entity"}, returns=@ReturnDoc(type=NumberDef.class, desc={"The pitch of the entity"}), examples={"pitch = fakeEntity.getPitch();"})
    private float getPitch(Arguments arguments) {
        ScriptFakeEntity entity = (ScriptFakeEntity)arguments.nextPrimitive((PrimitiveDefinition)this);
        return entity.getPitch();
    }

    @FunctionDoc(name="updatePosAndRotation", desc={"Updates the position and rotation of the entity with no interpolation"}, params={@ParameterDoc(type=PosDef.class, name="pos", desc={"The new position of the entity"}), @ParameterDoc(type=NumberDef.class, name="yaw", desc={"The new yaw of the entity"}), @ParameterDoc(type=NumberDef.class, name="pitch", desc={"The new pitch of the entity"})}, examples={"fakeEntity.updatePosAndRotation(new Pos(100, 0, 100), 0, 0);"})
    private Void updatePosAndRotation3(Arguments arguments) {
        ScriptFakeEntity entity = (ScriptFakeEntity)arguments.nextPrimitive((PrimitiveDefinition)this);
        ScriptPos pos = (ScriptPos)arguments.nextPrimitive(PosDef.class);
        float yaw = ((Double)arguments.nextPrimitive(NumberDef.class)).floatValue();
        float pitch = ((Double)arguments.nextPrimitive(NumberDef.class)).floatValue();
        entity.updatePosAndRotation(pos.getVec3d(), yaw, pitch);
        return null;
    }

    @FunctionDoc(name="updatePosAndRotation", desc={"Updates the position and rotation of the entity"}, params={@ParameterDoc(type=PosDef.class, name="pos", desc={"The new position of the entity"}), @ParameterDoc(type=NumberDef.class, name="yaw", desc={"The new yaw of the entity"}), @ParameterDoc(type=NumberDef.class, name="pitch", desc={"The new pitch of the entity"}), @ParameterDoc(type=NumberDef.class, name="interpolationSteps", desc={"The number of interpolation steps to take"})}, examples={"fakeEntity.updatePosAndRotation(new Pos(100, 0, 100), 0, 0, 10);"})
    private Void updatePosAndRotation4(Arguments arguments) {
        ScriptFakeEntity entity = (ScriptFakeEntity)arguments.nextPrimitive((PrimitiveDefinition)this);
        ScriptPos pos = (ScriptPos)arguments.nextPrimitive(PosDef.class);
        float yaw = ((Double)arguments.nextPrimitive(NumberDef.class)).floatValue();
        float pitch = ((Double)arguments.nextPrimitive(NumberDef.class)).floatValue();
        int interpolationSteps = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        entity.updatePosAndRotation(pos.getVec3d(), yaw, pitch, interpolationSteps);
        return null;
    }

    @FunctionDoc(name="spawn", desc={"Spawns the entity (makes it render in the world)"}, examples={"fakeEntity.spawn();"})
    private Void spawn(Arguments arguments) {
        ((ScriptFakeEntity)arguments.nextPrimitive((PrimitiveDefinition)this)).spawn();
        return null;
    }

    @FunctionDoc(name="despawn", desc={"Despawns the entity (makes it not render in the world)"}, examples={"fakeEntity.despawn();"})
    private Void despawn(Arguments arguments) {
        ((ScriptFakeEntity)arguments.nextPrimitive((PrimitiveDefinition)this)).despawn();
        return null;
    }
}

