/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.clientscript.definitions;

import java.util.List;
import me.senseiwells.arucas.api.docs.annotations.ClassDoc;
import me.senseiwells.arucas.api.docs.annotations.FunctionDoc;
import me.senseiwells.arucas.api.docs.annotations.ParameterDoc;
import me.senseiwells.arucas.api.docs.annotations.ReturnDoc;
import me.senseiwells.arucas.builtin.BooleanDef;
import me.senseiwells.arucas.builtin.ListDef;
import me.senseiwells.arucas.builtin.MapDef;
import me.senseiwells.arucas.builtin.NumberDef;
import me.senseiwells.arucas.builtin.StringDef;
import me.senseiwells.arucas.classes.PrimitiveDefinition;
import me.senseiwells.arucas.classes.instance.ClassInstance;
import me.senseiwells.arucas.compiler.LocatableTrace;
import me.senseiwells.arucas.exceptions.RuntimeError;
import me.senseiwells.arucas.functions.builtin.Arguments;
import me.senseiwells.arucas.functions.builtin.BuiltInFunction;
import me.senseiwells.arucas.functions.builtin.MemberFunction;
import me.senseiwells.arucas.interpreter.Interpreter;
import me.senseiwells.arucas.utils.impl.ArucasList;
import me.senseiwells.arucas.utils.impl.ArucasMap;
import me.senseiwells.arucas.utils.misc.Language;
import me.senseiwells.essentialclient.clientscript.definitions.BiomeDef;
import me.senseiwells.essentialclient.clientscript.definitions.BlockDef;
import me.senseiwells.essentialclient.clientscript.definitions.PosDef;
import me.senseiwells.essentialclient.clientscript.definitions.WorldDef;
import me.senseiwells.essentialclient.utils.EssentialUtils;
import me.senseiwells.essentialclient.utils.clientscript.ClientScriptUtils;
import me.senseiwells.essentialclient.utils.clientscript.impl.ScriptBlockState;
import me.senseiwells.essentialclient.utils.clientscript.impl.ScriptPos;
import net.minecraft.class_1074;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_638;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

@ClassDoc(name="Entity", desc={"This class is mostly used to get data about entities."}, language=Language.Java)
public class EntityDef
extends PrimitiveDefinition<class_1297> {
    public EntityDef(Interpreter interpreter) {
        super("Entity", interpreter);
    }

    @Deprecated
    @NotNull
    public ClassInstance create(@NotNull class_1297 value) {
        return super.create((Object)value);
    }

    @NotNull
    public String toString(@NotNull ClassInstance instance, @NotNull Interpreter interpreter, @NotNull LocatableTrace trace) {
        return "Entity{id=%s}".formatted(class_7923.field_41177.method_10221((Object)((class_1297)instance.asPrimitive((PrimitiveDefinition)this)).method_5864()));
    }

    public List<BuiltInFunction> defineStaticMethods() {
        return List.of(BuiltInFunction.of((String)"of", (int)1, this::of));
    }

    @FunctionDoc(isStatic=true, name="of", desc={"This converts an entityId into an entity instance.", "This will throw an error if the id is not valid."}, params={@ParameterDoc(type=StringDef.class, name="entityId", desc={"the entityId to convert to an entity"})}, returns=@ReturnDoc(type=EntityDef.class, desc={"the entity instance from the id"}), examples={"Entity.of('minecraft:pig');"})
    private ClassInstance of(Arguments arguments) {
        class_638 world = EssentialUtils.getWorld();
        String string = (String)arguments.nextPrimitive(StringDef.class);
        return arguments.getInterpreter().convertValue((Object)((class_1299)class_7923.field_41177.method_17966(ClientScriptUtils.stringToIdentifier(string)).orElseThrow(() -> new RuntimeError("'%s' is not a valid entity".formatted(string)))).method_5883((class_1937)world));
    }

    public List<MemberFunction> defineMethods() {
        return List.of(MemberFunction.of((String)"isSneaking", this::isSneaking), MemberFunction.of((String)"isSprinting", this::isSprinting), MemberFunction.of((String)"isFalling", this::isFalling), MemberFunction.of((String)"isOnGround", this::isOnGround), MemberFunction.of((String)"isTouchingWater", this::isTouchingWater), MemberFunction.of((String)"isTouchingWaterOrRain", this::isTouchingWaterOrRain), MemberFunction.of((String)"isSubmergedInWater", this::isSubmergedInWater), MemberFunction.of((String)"isInLava", this::isInLava), MemberFunction.of((String)"isOnFire", this::isOnFire), MemberFunction.of((String)"isGlowing", this::isGlowing), MemberFunction.of((String)"getLookingAtBlock", this::getLookingAtBlock), MemberFunction.of((String)"getLookingAtBlock", (int)1, this::getLookingAtBlock1), MemberFunction.of((String)"getLookingAtBlock", (int)2, this::getLookingAtBlock2), MemberFunction.of((String)"getLookingAtPos", (int)1, this::getLookingAtPos), MemberFunction.of((String)"getEntityIdNumber", this::getEntityIdNumber), MemberFunction.of((String)"getVelocity", this::getVelocity), MemberFunction.of((String)"getPos", this::getPos), MemberFunction.of((String)"getX", this::getX), MemberFunction.of((String)"getY", this::getY), MemberFunction.of((String)"getZ", this::getZ), MemberFunction.of((String)"getYaw", this::getYaw), MemberFunction.of((String)"getPitch", this::getPitch), MemberFunction.of((String)"getDimension", this::getDimension), MemberFunction.of((String)"getWorld", this::getWorld), MemberFunction.of((String)"getBiome", this::getBiome), MemberFunction.of((String)"getFullId", this::getFullId), MemberFunction.of((String)"getId", this::getId), MemberFunction.of((String)"isOf", (int)1, this::isOf), MemberFunction.of((String)"getAge", this::getAge), MemberFunction.of((String)"getCustomName", this::getCustomName), MemberFunction.of((String)"getEntityUuid", this::getEntityUuid), MemberFunction.of((String)"setGlowing", (int)1, this::setGlowing), MemberFunction.of((String)"getDistanceTo", (int)1, this::getDistanceTo), MemberFunction.of((String)"getSquaredDistanceTo", (int)1, this::getSquaredDistanceTo), MemberFunction.of((String)"getNbt", this::getNbt), MemberFunction.of((String)"getTranslatedName", this::getTranslatedName), MemberFunction.of((String)"getHitbox", this::getHitbox), MemberFunction.of((String)"collidesWith", (int)2, this::collidesWithBlockAtPos));
    }

    @FunctionDoc(name="isSneaking", desc={"Returns true if the player is sneaking"}, returns=@ReturnDoc(type=BooleanDef.class, desc={"true if the player is sneaking, false if not"}), examples={"entity.isSneaking();"})
    private boolean isSneaking(Arguments arguments) {
        return ((class_1297)arguments.nextPrimitive((PrimitiveDefinition)this)).method_5715();
    }

    @FunctionDoc(name="isSprinting", desc={"Returns true if the player is sprinting"}, returns=@ReturnDoc(type=BooleanDef.class, desc={"true if the player is sprinting, false if not"}), examples={"entity.isSprinting();"})
    private boolean isSprinting(Arguments arguments) {
        return ((class_1297)arguments.nextPrimitive((PrimitiveDefinition)this)).method_5624();
    }

    @FunctionDoc(name="isFalling", desc={"Returns true if the entity is falling"}, returns=@ReturnDoc(type=BooleanDef.class, desc={"true if the entity is falling, false if not"}), examples={"entity.isFalling();"})
    private boolean isFalling(Arguments arguments) {
        return ((class_1297)arguments.nextPrimitive((PrimitiveDefinition)this)).field_6017 > 0.0f;
    }

    @FunctionDoc(name="isOnGround", desc={"Returns true if the entity is on the ground"}, returns=@ReturnDoc(type=BooleanDef.class, desc={"true if the entity is on the ground, false if not"}), examples={"entity.isOnGround();"})
    private boolean isOnGround(Arguments arguments) {
        return ((class_1297)arguments.nextPrimitive((PrimitiveDefinition)this)).method_24828();
    }

    @FunctionDoc(name="isTouchingWater", desc={"Returns true if the entity is touching water"}, returns=@ReturnDoc(type=BooleanDef.class, desc={"true if the entity is touching water, false if not"}), examples={"entity.isTouchingWater();"})
    private boolean isTouchingWater(Arguments arguments) {
        return ((class_1297)arguments.nextPrimitive((PrimitiveDefinition)this)).method_5799();
    }

    @FunctionDoc(name="isTouchingWaterOrRain", desc={"Returns true if the entity is touching water or rain"}, returns=@ReturnDoc(type=BooleanDef.class, desc={"true if the entity is touching water or rain, false if not"}), examples={"entity.isTouchingWaterOrRain();"})
    private boolean isTouchingWaterOrRain(Arguments arguments) {
        return ((class_1297)arguments.nextPrimitive((PrimitiveDefinition)this)).method_5721();
    }

    @FunctionDoc(name="isSubmergedInWater", desc={"Returns true if the entity is submerged in water"}, returns=@ReturnDoc(type=BooleanDef.class, desc={"true if the entity is submerged in water, false if not"}), examples={"entity.isSubmergedInWater();"})
    private boolean isSubmergedInWater(Arguments arguments) {
        return ((class_1297)arguments.nextPrimitive((PrimitiveDefinition)this)).method_5869();
    }

    @FunctionDoc(name="isInLava", desc={"Returns true if the entity is in lava"}, returns=@ReturnDoc(type=BooleanDef.class, desc={"true if the entity is in lava, false if not"}), examples={"entity.isInLava();"})
    private boolean isInLava(Arguments arguments) {
        return ((class_1297)arguments.nextPrimitive((PrimitiveDefinition)this)).method_5771();
    }

    @FunctionDoc(name="isOnFire", desc={"Returns true if the entity is on fire"}, returns=@ReturnDoc(type=BooleanDef.class, desc={"true if the entity is on fire, false if not"}), examples={"entity.isOnFire();"})
    private boolean isOnFire(Arguments arguments) {
        return ((class_1297)arguments.nextPrimitive((PrimitiveDefinition)this)).method_5809();
    }

    @FunctionDoc(name="isGlowing", desc={"Returns true if the entity is glowing"}, returns=@ReturnDoc(type=BooleanDef.class, desc={"true if the entity is glowing, false if not"}), examples={"entity.isGlowing();"})
    private boolean isGlowing(Arguments arguments) {
        return ((class_1297)arguments.nextPrimitive((PrimitiveDefinition)this)).method_5851();
    }

    @FunctionDoc(name="getLookingAtBlock", desc={"This gets the block that the entity is currently looking at", "with a max range of 20 blocks, if there is no block then it will return air"}, returns=@ReturnDoc(type=BlockDef.class, desc={"the block that the entity is looking at, containing the position"}), examples={"entity.getLookingAtBlock();"})
    private ScriptBlockState getLookingAtBlock(Arguments arguments) {
        class_1297 entity = (class_1297)arguments.nextPrimitive((PrimitiveDefinition)this);
        class_239 result = entity.method_5745(20.0, 0.0f, true);
        if (result.method_17783() == class_239.class_240.field_1332) {
            class_2338 blockPos = ((class_3965)result).method_17777();
            return new ScriptBlockState(entity.method_5770().method_8320(blockPos), blockPos);
        }
        return new ScriptBlockState(class_2246.field_10124.method_9564(), EssentialUtils.vec3dToBlockPos(result.method_17784()));
    }

    @FunctionDoc(name="getLookingAtBlock", desc={"This gets the block that the entity is currently looking at", "with a specific max range, if there is no block then it will return air"}, params={@ParameterDoc(type=NumberDef.class, name="maxDistance", desc={"the max range to ray cast"})}, returns=@ReturnDoc(type=BlockDef.class, desc={"the block that the entity is looking at, containing the position"}), examples={"entity.getLookingAtBlock(10);"})
    private ScriptBlockState getLookingAtBlock1(Arguments arguments) {
        double maxDistance;
        class_1297 entity = (class_1297)arguments.nextPrimitive((PrimitiveDefinition)this);
        class_239 result = entity.method_5745(maxDistance = ((Double)arguments.nextPrimitive(NumberDef.class)).doubleValue(), 0.0f, true);
        if (result.method_17783() == class_239.class_240.field_1332) {
            class_2338 blockPos = ((class_3965)result).method_17777();
            return new ScriptBlockState(entity.method_5770().method_8320(blockPos), blockPos);
        }
        return new ScriptBlockState(class_2246.field_10124.method_9564(), EssentialUtils.vec3dToBlockPos(result.method_17784()));
    }

    @FunctionDoc(name="getLookingAtBlock", desc={"This gets the block that the entity is currently looking at", "with a specific max range, and optionally whether fluids should", "be included, if there is no block then it will return air"}, params={@ParameterDoc(type=NumberDef.class, name="maxDistance", desc={"the max range to ray cast"}), @ParameterDoc(type=StringDef.class, name="fluidType", desc={"the types of fluids to include, either 'none', 'sources', or 'all'"})}, returns=@ReturnDoc(type=BlockDef.class, desc={"the block that the entity is looking at, containing the position"}), examples={"entity.getLookingAtBlock(10, 'sources');"})
    private ScriptBlockState getLookingAtBlock2(Arguments arguments) {
        class_1297 entity = (class_1297)arguments.nextPrimitive((PrimitiveDefinition)this);
        double maxDistance = (Double)arguments.nextPrimitive(NumberDef.class);
        String fluidString = arguments.nextConstant();
        class_3959.class_242 fluidType = ClientScriptUtils.stringToFluidType(fluidString);
        class_243 camera = entity.method_5836(0.0f);
        class_243 rotation = entity.method_5828(0.0f);
        class_243 end = camera.method_1031(rotation.field_1352 * maxDistance, rotation.field_1351 * maxDistance, rotation.field_1350 * maxDistance);
        class_3965 result = entity.method_5770().method_17742(new class_3959(camera, end, class_3959.class_3960.field_17559, fluidType, entity));
        if (result.method_17783() == class_239.class_240.field_1332) {
            class_2338 blockPos = result.method_17777();
            return new ScriptBlockState(entity.method_5770().method_8320(blockPos), blockPos);
        }
        return new ScriptBlockState(class_2246.field_10124.method_9564(), EssentialUtils.vec3dToBlockPos(result.method_17784()));
    }

    @FunctionDoc(name="getLookingAtPos", desc={"This gets the position that the entity is currently looking at with a specific max range"}, params={@ParameterDoc(type=NumberDef.class, name="maxDistance", desc={"the max range to ray cast"})}, returns=@ReturnDoc(type=PosDef.class, desc={"the position that the entity is looking at, containing the x, y, and z"}), examples={"entity.getLookingAtPos(10);"})
    private class_243 getLookingAtPos(Arguments arguments) {
        class_1297 entity = (class_1297)arguments.nextPrimitive((PrimitiveDefinition)this);
        double maxDistance = (Double)arguments.nextPrimitive(NumberDef.class);
        return entity.method_5745(maxDistance, 0.0f, true).method_17784();
    }

    @FunctionDoc(name="getEntityIdNumber", desc={"This gets the entity id number of the entity"}, returns=@ReturnDoc(type=NumberDef.class, desc={"the entity id number"}), examples={"entity.getEntityIdNumber();"})
    private int getEntityIdNumber(Arguments arguments) {
        return ((class_1297)arguments.nextPrimitive((PrimitiveDefinition)this)).method_5628();
    }

    @FunctionDoc(name="getVelocity", desc={"This gets the velocity of the entity in a list in the form [x, y, z]"}, returns=@ReturnDoc(type=ListDef.class, desc={"the velocity of the entity"}), examples={"entity.getVelocity();"})
    private ArucasList getVelocity(Arguments arguments) {
        class_1297 entity = (class_1297)arguments.nextPrimitive((PrimitiveDefinition)this);
        class_243 velocity = entity.method_18798();
        NumberDef numberDef = (NumberDef)arguments.getInterpreter().getPrimitive(NumberDef.class);
        return ArucasList.of((ClassInstance[])new ClassInstance[]{numberDef.create((Object)velocity.field_1352), numberDef.create((Object)velocity.field_1351), numberDef.create((Object)velocity.field_1350)});
    }

    @FunctionDoc(name="getPos", desc={"This gets the position of the entity"}, returns=@ReturnDoc(type=PosDef.class, desc={"the position of the entity"}), examples={"entity.getPos();"})
    private class_243 getPos(Arguments arguments) {
        return ((class_1297)arguments.nextPrimitive((PrimitiveDefinition)this)).method_19538();
    }

    @FunctionDoc(name="getX", desc={"This gets the x position of the entity"}, returns=@ReturnDoc(type=NumberDef.class, desc={"the x position of the entity"}), examples={"entity.getX();"})
    private double getX(Arguments arguments) {
        return ((class_1297)arguments.nextPrimitive((PrimitiveDefinition)this)).method_23317();
    }

    @FunctionDoc(name="getY", desc={"This gets the y position of the entity"}, returns=@ReturnDoc(type=NumberDef.class, desc={"the y position of the entity"}), examples={"entity.getY();"})
    private double getY(Arguments arguments) {
        return ((class_1297)arguments.nextPrimitive((PrimitiveDefinition)this)).method_23318();
    }

    @FunctionDoc(name="getZ", desc={"This gets the z position of the entity"}, returns=@ReturnDoc(type=NumberDef.class, desc={"the z position of the entity"}), examples={"entity.getZ();"})
    private double getZ(Arguments arguments) {
        return ((class_1297)arguments.nextPrimitive((PrimitiveDefinition)this)).method_23321();
    }

    @FunctionDoc(name="getYaw", desc={"This gets the yaw of the entity (horizontal head rotation)"}, returns=@ReturnDoc(type=NumberDef.class, desc={"the yaw of the entity, between -180 and 180"}), examples={"entity.getYaw();"})
    private float getYaw(Arguments arguments) {
        class_1297 entity = (class_1297)arguments.nextPrimitive((PrimitiveDefinition)this);
        float yaw = entity.method_36454() % 360.0f;
        return yaw < -180.0f ? 360.0f + yaw : yaw;
    }

    @FunctionDoc(name="getPitch", desc={"This gets the pitch of the entity (vertical head rotation)"}, returns=@ReturnDoc(type=NumberDef.class, desc={"the pitch of the entity, between -90 and 90"}), examples={"entity.getPitch();"})
    private float getPitch(Arguments arguments) {
        return ((class_1297)arguments.nextPrimitive((PrimitiveDefinition)this)).method_36455();
    }

    @FunctionDoc(name="getDimension", desc={"This gets the dimension of the entity"}, returns=@ReturnDoc(type=StringDef.class, desc={"the dimension id of dimension the entity is in"}), examples={"entity.getDimension();"})
    private String getDimension(Arguments arguments) {
        return ((class_1297)arguments.nextPrimitive((PrimitiveDefinition)this)).method_5770().method_27983().method_29177().method_12832();
    }

    @FunctionDoc(name="getWorld", desc={"This gets the world the entity is in"}, returns=@ReturnDoc(type=WorldDef.class, desc={"the world the entity is in"}), examples={"entity.getWorld();"})
    private class_638 getWorld(Arguments arguments) {
        class_1297 entity = (class_1297)arguments.nextPrimitive((PrimitiveDefinition)this);
        class_1937 class_19372 = entity.method_5770();
        if (class_19372 instanceof class_638) {
            class_638 world = (class_638)class_19372;
            return world;
        }
        throw new RuntimeError("Could not get entity '%s's world".formatted(entity));
    }

    @FunctionDoc(name="getBiome", desc={"This gets the biome of the entity"}, returns=@ReturnDoc(type=BiomeDef.class, desc={"the biome the entity is in"}), examples={"entity.getBiome();"})
    private class_1959 getBiome(Arguments arguments) {
        class_1297 entity = (class_1297)arguments.nextPrimitive((PrimitiveDefinition)this);
        return (class_1959)entity.method_5770().method_23753(entity.method_24515()).comp_349();
    }

    @FunctionDoc(name="getFullId", desc={"This gets the full id of the entity, this returns the full id, so for example", "'minecraft:cow' you can find all entityNames on", "[Joa's Entity Property Encyclopedia](https://joakimthorsen.github.io/MCPropertyEncyclopedia/entities.html)"}, returns=@ReturnDoc(type=StringDef.class, desc={"the full id of the entity"}), examples={"entity.getFullId();"})
    private String getFullId(Arguments arguments) {
        return class_7923.field_41177.method_10221((Object)((class_1297)arguments.nextPrimitive((PrimitiveDefinition)this)).method_5864()).toString();
    }

    @FunctionDoc(name="getId", desc={"This gets the id of the entity, this returns the id, so for examples 'cow'"}, returns=@ReturnDoc(type=StringDef.class, desc={"the id of the entity"}), examples={"entity.getId();"})
    private String getId(Arguments arguments) {
        return class_7923.field_41177.method_10221((Object)((class_1297)arguments.nextPrimitive((PrimitiveDefinition)this)).method_5864()).method_12832();
    }

    @FunctionDoc(name="isOf", desc={"This checks if the entity is of the given entity id"}, params={@ParameterDoc(type=StringDef.class, name="entityId", desc={"the entity id to check"})}, returns=@ReturnDoc(type=BooleanDef.class, desc={"true if the entity is of the given entity id"}), examples={"entity.isOf('cow');"})
    private boolean isOf(Arguments arguments) {
        class_1297 entity = (class_1297)arguments.nextPrimitive((PrimitiveDefinition)this);
        String id = (String)arguments.nextPrimitive(StringDef.class);
        class_1299 type = class_7923.field_41177.method_17966(ClientScriptUtils.stringToIdentifier(id)).orElse(null);
        return entity.method_5864() == type;
    }

    @FunctionDoc(name="getAge", desc={"This gets the age of the entity in ticks"}, returns=@ReturnDoc(type=NumberDef.class, desc={"the age of the entity in ticks"}), examples={"entity.getAge();"})
    private int getAge(Arguments arguments) {
        return ((class_1297)arguments.nextPrimitive((PrimitiveDefinition)this)).field_6012;
    }

    @FunctionDoc(name="getCustomName", desc={"This gets the custom name of the entity if it has one"}, returns=@ReturnDoc(type=StringDef.class, desc={"the custom name of the entity if it has one, otherwise null"}), examples={"entity.getCustomName();"})
    private String getCustomName(Arguments arguments) {
        class_1297 entity = (class_1297)arguments.nextPrimitive((PrimitiveDefinition)this);
        class_2561 customName = entity.method_5797();
        return customName == null ? null : customName.getString();
    }

    @FunctionDoc(name="getEntityUuid", desc={"This gets the uuid of the entity"}, returns=@ReturnDoc(type=StringDef.class, desc={"the uuid of the entity"}), examples={"entity.getEntityUuid();"})
    private String getEntityUuid(Arguments arguments) {
        return ((class_1297)arguments.nextPrimitive((PrimitiveDefinition)this)).method_5845();
    }

    @FunctionDoc(name="setGlowing", desc={"This sets the entity to either start glowing or stop glowing on the client"}, params={@ParameterDoc(type=BooleanDef.class, name="glowing", desc={"the glowing state"})}, examples={"entity.setGlowing(true);"})
    private Void setGlowing(Arguments arguments) {
        class_1297 entity = (class_1297)arguments.nextPrimitive((PrimitiveDefinition)this);
        entity.method_5834(((Boolean)arguments.nextPrimitive(BooleanDef.class)).booleanValue());
        return null;
    }

    @FunctionDoc(name="getDistanceTo", desc={"This gets the distance between the entity and the other entity"}, params={@ParameterDoc(type=EntityDef.class, name="otherEntity", desc={"the other entity"})}, returns=@ReturnDoc(type=NumberDef.class, desc={"the distance between the entities"}), examples={"entity.getDistanceTo(Player.get());"})
    private double getDistanceTo(Arguments arguments) {
        class_1297 entity = (class_1297)arguments.nextPrimitive((PrimitiveDefinition)this);
        return entity.method_5739((class_1297)arguments.nextPrimitive((PrimitiveDefinition)this));
    }

    @FunctionDoc(name="getSquaredDistanceTo", desc={"This gets the squared distance between the entity and the other entity"}, params={@ParameterDoc(type=EntityDef.class, name="otherEntity", desc={"the other entity"})}, returns=@ReturnDoc(type=NumberDef.class, desc={"the squared distance between the entities"}), examples={"entity.getSquaredDistanceTo(Player.get());"})
    private double getSquaredDistanceTo(Arguments arguments) {
        class_1297 entity = (class_1297)arguments.nextPrimitive((PrimitiveDefinition)this);
        return entity.method_5858((class_1297)arguments.nextPrimitive((PrimitiveDefinition)this));
    }

    @FunctionDoc(name="getNbt", desc={"This gets the nbt of the entity as a map"}, returns=@ReturnDoc(type=MapDef.class, desc={"the nbt of the entity"}), examples={"entity.getNbt();"})
    private ArucasMap getNbt(Arguments arguments) {
        class_1297 entity = (class_1297)arguments.nextPrimitive((PrimitiveDefinition)this);
        class_2487 nbtCompound = entity.method_5647(new class_2487());
        return ClientScriptUtils.nbtToMap(arguments.getInterpreter(), nbtCompound, 10);
    }

    @FunctionDoc(name="getTranslatedName", desc={"This gets the translated name of the entity, for examples 'minecraft:pig' would return 'Pig' if your language is in english"}, returns=@ReturnDoc(type=StringDef.class, desc={"the translated name of the entity"}), examples={"entity.getTranslatedName();"})
    private String getTranslatedName(Arguments arguments) {
        class_1297 entity = (class_1297)arguments.nextPrimitive((PrimitiveDefinition)this);
        return class_1074.method_4662((String)entity.method_5864().method_5882(), (Object[])new Object[0]);
    }

    @FunctionDoc(name="getHitbox", desc={"This gets the hitbox of the entity in a list containing the two corners of the hitbox, the minimum point and the maximum point"}, returns=@ReturnDoc(type=ListDef.class, desc={"the hitbox of the entity"}), examples={"entity.getHitbox();"})
    private ArucasList getHitbox(Arguments arguments) {
        class_1297 entity = (class_1297)arguments.nextPrimitive((PrimitiveDefinition)this);
        class_238 box = entity.method_5829();
        PosDef posDef = (PosDef)arguments.getInterpreter().getPrimitive(PosDef.class);
        return ArucasList.of((ClassInstance[])new ClassInstance[]{posDef.create(new ScriptPos(box.field_1323, box.field_1322, box.field_1321)), posDef.create(new ScriptPos(box.field_1320, box.field_1325, box.field_1324))});
    }

    @FunctionDoc(name="collidesWith", desc={"This checks whether the entity collides with a block at a given position"}, params={@ParameterDoc(type=PosDef.class, name="pos", desc={"the position to check"}), @ParameterDoc(type=BlockDef.class, name="block", desc={"the block to check"})}, returns=@ReturnDoc(type=BooleanDef.class, desc={"whether the entity collides with the block"}), examples={"entity.collidesWith(Pos.get(0, 0, 0), Block.of('minecraft:stone'));"})
    private boolean collidesWithBlockAtPos(Arguments arguments) {
        class_1297 entity = (class_1297)arguments.nextPrimitive((PrimitiveDefinition)this);
        ScriptPos pos = (ScriptPos)arguments.nextPrimitive(PosDef.class);
        ScriptBlockState block = (ScriptBlockState)arguments.nextPrimitive(BlockDef.class);
        return entity.method_30632(pos.getBlockPos(), block.state);
    }
}

