/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.clientscript.definitions;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedArgument;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.senseiwells.arucas.api.docs.annotations.ClassDoc;
import me.senseiwells.arucas.api.docs.annotations.FunctionDoc;
import me.senseiwells.arucas.api.docs.annotations.ParameterDoc;
import me.senseiwells.arucas.api.docs.annotations.ReturnDoc;
import me.senseiwells.arucas.builtin.FunctionDef;
import me.senseiwells.arucas.builtin.ListDef;
import me.senseiwells.arucas.builtin.MapDef;
import me.senseiwells.arucas.builtin.StringDef;
import me.senseiwells.arucas.classes.ClassDefinition;
import me.senseiwells.arucas.classes.CreatableDefinition;
import me.senseiwells.arucas.classes.PrimitiveDefinition;
import me.senseiwells.arucas.classes.instance.ClassInstance;
import me.senseiwells.arucas.functions.ArucasFunction;
import me.senseiwells.arucas.functions.builtin.Arguments;
import me.senseiwells.arucas.functions.builtin.BuiltInFunction;
import me.senseiwells.arucas.functions.builtin.MemberFunction;
import me.senseiwells.arucas.interpreter.Interpreter;
import me.senseiwells.arucas.utils.impl.ArucasList;
import me.senseiwells.arucas.utils.impl.ArucasMap;
import me.senseiwells.arucas.utils.misc.Language;
import me.senseiwells.essentialclient.utils.clientscript.ClientScriptUtils;
import me.senseiwells.essentialclient.utils.command.CommandHelper;
import net.minecraft.class_2168;
import net.minecraft.class_2170;

@ClassDoc(name="CommandBuilder", desc={"This class allows you to build commands for Minecraft."}, language=Language.Java)
public class CommandBuilderDef
extends CreatableDefinition<ArgumentBuilder<class_2168, ?>> {
    public CommandBuilderDef(Interpreter interpreter) {
        super("CommandBuilder", interpreter);
    }

    public List<BuiltInFunction> defineStaticMethods() {
        return List.of(BuiltInFunction.of((String)"literal", (int)1, this::literal), BuiltInFunction.of((String)"argument", (int)2, this::argument2), BuiltInFunction.of((String)"argument", (int)3, this::argument3), BuiltInFunction.of((String)"fromMap", (int)1, this::fromMap));
    }

    @FunctionDoc(isStatic=true, name="literal", desc={"Creates a literal argument with just a string"}, params={@ParameterDoc(type=StringDef.class, name="argument", desc={"the literal argument"})}, returns=@ReturnDoc(type=CommandBuilderDef.class, desc={"the argument builder"}), examples={"CommandBuilder.literal('test');"})
    private LiteralArgumentBuilder<class_2168> literal(Arguments arguments) {
        String name = (String)arguments.nextPrimitive(StringDef.class);
        return class_2170.method_9247((String)name);
    }

    @FunctionDoc(isStatic=true, name="argument", desc={"Creates an argument builder with a specific argument type, and a name", "to see all the different types refer to CommandBuilder.fromMap(...)"}, params={@ParameterDoc(type=StringDef.class, name="argumentName", desc={"the name of the argument"}), @ParameterDoc(type=StringDef.class, name="argumentType", desc={"the type of the argument"})}, returns=@ReturnDoc(type=CommandBuilderDef.class, desc={"the argument builder"}), examples={"CommandBuilder.argument('test', 'entityid');"})
    private RequiredArgumentBuilder<class_2168, ?> argument2(Arguments arguments) {
        String name = (String)arguments.nextPrimitive(StringDef.class);
        String type = (String)arguments.nextPrimitive(StringDef.class);
        return this.argument(arguments.getInterpreter(), name, type, null);
    }

    @FunctionDoc(isStatic=true, name="argument", desc={"Creates an argument builder with a specific argument type, a name, and a default value", "to see all the different types refer to CommandBuilder.fromMap(...)"}, params={@ParameterDoc(type=StringDef.class, name="argumentName", desc={"the name of the argument"}), @ParameterDoc(type=StringDef.class, name="argumentType", desc={"the type of the argument"}), @ParameterDoc(type=ListDef.class, name="suggestions", desc={"a list of strings for the suggestions for the argument"})}, returns=@ReturnDoc(type=CommandBuilderDef.class, desc={"the argument builder"}), examples={"CommandBuilder.argument('test', 'word', ['wow', 'suggestion']);"})
    private RequiredArgumentBuilder<class_2168, ?> argument3(Arguments arguments) {
        String name = (String)arguments.nextPrimitive(StringDef.class);
        String type = (String)arguments.nextPrimitive(StringDef.class);
        ArucasList suggestions = (ArucasList)arguments.nextPrimitive(ListDef.class);
        return this.argument(arguments.getInterpreter(), name, type, suggestions);
    }

    @FunctionDoc(isStatic=true, name="fromMap", desc={"Creates an argument builder from a map.", "The map must contain a 'name' key as a String that is the name of the command,", "the map then can contain 'subcommands' as a map which contains the subcommands,", "the key of the subcommands is the name of the subcommand, and the value is a map,", "if the name is encased in '<' and '>' it will be treated as an argument, otherwise it will be treated as a literal.", "You can chain arguments by leaving a space in the name like: 'literal <arg>'.", "If the key has no name and is just an empty string the value will be used as the function", "which will be executed when the command is executed, the function should have the appropriate", "number of parameters, the number of parameters is determined by the number of arguments.", "Argument types are defined in the main map under the key 'arguments' with the value of a map", "the keys of this map should be the names of your arguments used in your subcommands,", "this should be a map and must have the key 'type' which should be a string that is the type of the argument.", "Optionally if the type is of 'integer' or 'double' you can also have the key 'min' and 'max' with numbers as the value,", "and if the type is of 'enum' you must have the key 'enum' with the enum class type as the value: 'enum': MyEnum.type.", "You can also optionally have 'suggests' which has the value of a list of strings that are suggestions for the argument.", "You can also optionally have 'suggester' which has the value of a function that will be called to get suggestions for the argument,", "this function should have arbitrary number of parameters which will be the arguments that the user has entered so far.", "The possible argument types are: 'PlayerName', 'Word' 'String', 'GreedyString', 'Double', 'Integer', 'Boolean', 'Enum',", "'ItemStack', 'Block', 'Particle', 'RecipeId', 'EntityId', 'EnchantmentId', 'Entity', 'Entities', 'BlockPos', 'Pos', 'Effect',", "'BiomeId'."}, params={@ParameterDoc(type=MapDef.class, name="argumentMap", desc={"the map of arguments"})}, returns=@ReturnDoc(type=CommandBuilderDef.class, desc={"the argument builder"}), examples={"effectCommandMap = {\n\t\"name\" : \"effect\",\n\t\"subcommands\" : {\n\t\t\"give\" : {\n\t\t\t\"<targets> <effect>\" : {\n\t\t\t\t\"\" : fun(target, effect) {\n\t\t\t\t\t// do something\n\t\t\t\t},\n\t\t\t\t\"<seconds>\" : {\n\t\t\t\t\t\"\" : fun(target, effect, second) {\n\t\t\t\t\t\t// do something\n\t\t\t\t\t},\n\t\t\t\t\t\"<amplifier>\" : {\n\t\t\t\t\t\t\"\" : fun(target, effect, second, amplifier) {\n\t\t\t\t\t\t\t// do something\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"<hideParticle>\" : {\n\t\t\t\t\t\t\t\"\" : fun(target, effect, second, amplifier, hideParticle) {\n\t\t\t\t\t\t\t\t// do something\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"clear\" : {\n\t\t\t\"\" : fun() {\n\t\t\t\t// do something\n\t\t\t},\n\t\t\t\"<targets>\" : {\n\t\t\t\t\"\" : fun(target) {\n\t\t\t\t\t// do something\n\t\t\t\t},\n\t\t\t\t\"<effect>\" : {\n\t\t\t\t\t\"\" : fun(target, effect) {\n\t\t\t\t\t\t// do something\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t},\n\t\"arguments\" : {\n\t\t\"targets\" : { \"type\" : \"Entity\" },\n\t\t\"effect\" : { \"type\" : \"Effect\", \"suggests\" : [\"effect1\", \"effect2\"] },\n\t\t\"seconds\" : { \"type\" : \"Integer\", \"min\" : 0, \"max\" : 1000000 },\n\t\t\"amplifier\" : { \"type\" : \"Integer\", \"min\" : 0, \"max\" : 255 },\n\t\t\"hideParticle\" : { \"type\" : \"Boolean\" }\n\t}\n};\neffectCommand = CommandBuilder.fromMap(effectCommandMap);\n"})
    private ArgumentBuilder<class_2168, ?> fromMap(Arguments arguments) {
        return ClientScriptUtils.mapToCommand((ArucasMap)arguments.nextPrimitive(MapDef.class), arguments.getInterpreter());
    }

    private RequiredArgumentBuilder<class_2168, ?> argument(Interpreter interpreter, String name, String stringArgType, ArucasList suggestions) {
        List<String> suggests = suggestions == null ? null : suggestions.stream().map(i -> i.toString(interpreter)).toList();
        return ClientScriptUtils.parseArgument(name, stringArgType, suggests, null);
    }

    public List<MemberFunction> defineMethods() {
        return List.of(MemberFunction.of((String)"then", (int)1, this::then), MemberFunction.of((String)"executes", (int)1, this::executes));
    }

    @FunctionDoc(name="then", desc={"This adds a child CommandBuilder to your command builder"}, params={@ParameterDoc(type=CommandBuilderDef.class, name="childBuilder", desc={"the child command builder to add"})}, returns=@ReturnDoc(type=CommandBuilderDef.class, desc={"the parent command builder"}), examples={"commandBuilder.then(CommandBuilder.literal('subcommand'));"})
    private ClassInstance then(Arguments arguments) {
        ClassInstance instance = arguments.next((ClassDefinition)this);
        ((ArgumentBuilder)instance.asPrimitive((PrimitiveDefinition)this)).then((ArgumentBuilder)arguments.nextPrimitive((PrimitiveDefinition)this));
        return instance;
    }

    @FunctionDoc(name="executes", desc={"This sets the function to be executed when the command is executed,", "this should have the correct amount of parameters for the command"}, params={@ParameterDoc(type=CommandBuilderDef.class, name="function", desc={"the function to execute"})}, returns=@ReturnDoc(type=CommandBuilderDef.class, desc={"the parent command builder"}), examples={"commandBuilder.executes(fun() { });"})
    private ClassInstance executes(Arguments arguments) {
        ClassInstance instance = arguments.next((ClassDefinition)this);
        ArucasFunction function = (ArucasFunction)arguments.nextPrimitive(FunctionDef.class);
        Interpreter interpreter = arguments.getInterpreter().branch();
        ((ArgumentBuilder)instance.asPrimitive((PrimitiveDefinition)this)).executes(c -> {
            Collection<ParsedArgument<?, ?>> args = CommandHelper.getArguments((CommandContext<class_2168>)c);
            if (args == null) {
                throw ClientScriptUtils.CommandParser.NO_ARGS.create();
            }
            ArrayList<ClassInstance> list = new ArrayList<ClassInstance>(args.size());
            for (ParsedArgument<?, ?> argument : args) {
                list.add(ClientScriptUtils.commandArgumentToValue(argument.getResult(), interpreter));
            }
            interpreter.runAsync(() -> {
                function.invoke(interpreter.branch(), list);
                return null;
            });
            return 1;
        });
        return instance;
    }
}

