/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.clientscript.definitions;

import java.util.List;
import java.util.Optional;
import me.senseiwells.arucas.api.docs.annotations.ClassDoc;
import me.senseiwells.arucas.api.docs.annotations.FunctionDoc;
import me.senseiwells.arucas.api.docs.annotations.ParameterDoc;
import me.senseiwells.arucas.api.docs.annotations.ReturnDoc;
import me.senseiwells.arucas.builtin.BooleanDef;
import me.senseiwells.arucas.builtin.ListDef;
import me.senseiwells.arucas.builtin.MapDef;
import me.senseiwells.arucas.builtin.NumberDef;
import me.senseiwells.arucas.builtin.StringDef;
import me.senseiwells.arucas.classes.CreatableDefinition;
import me.senseiwells.arucas.classes.PrimitiveDefinition;
import me.senseiwells.arucas.classes.instance.ClassInstance;
import me.senseiwells.arucas.compiler.LocatableTrace;
import me.senseiwells.arucas.exceptions.RuntimeError;
import me.senseiwells.arucas.functions.builtin.Arguments;
import me.senseiwells.arucas.functions.builtin.BuiltInFunction;
import me.senseiwells.arucas.functions.builtin.MemberFunction;
import me.senseiwells.arucas.interpreter.Interpreter;
import me.senseiwells.arucas.utils.impl.ArucasList;
import me.senseiwells.arucas.utils.impl.ArucasMap;
import me.senseiwells.arucas.utils.misc.Language;
import me.senseiwells.essentialclient.clientscript.definitions.EntityDef;
import me.senseiwells.essentialclient.clientscript.definitions.MaterialDef;
import me.senseiwells.essentialclient.clientscript.definitions.PosDef;
import me.senseiwells.essentialclient.utils.EssentialUtils;
import me.senseiwells.essentialclient.utils.clientscript.ClientScriptUtils;
import me.senseiwells.essentialclient.utils.clientscript.impl.ScriptBlockState;
import me.senseiwells.essentialclient.utils.clientscript.impl.ScriptMaterial;
import me.senseiwells.essentialclient.utils.clientscript.impl.ScriptPos;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2682;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3481;
import net.minecraft.class_3542;
import net.minecraft.class_5431;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

@ClassDoc(name="Block", desc={"This class allows interactions with blocks in Minecraft."}, superclass=MaterialDef.class, language=Language.Java)
public class BlockDef
extends CreatableDefinition<ScriptBlockState> {
    public BlockDef(Interpreter interpreter) {
        super("Block", interpreter);
    }

    @NotNull
    public PrimitiveDefinition<? super ScriptBlockState> superclass() {
        return this.getPrimitiveDef(MaterialDef.class);
    }

    public Object asJavaValue(ClassInstance instance) {
        return ((ScriptBlockState)instance.asPrimitive((PrimitiveDefinition)this)).asDefault();
    }

    public boolean equals(@NotNull ClassInstance instance, @NotNull Interpreter interpreter, @NotNull ClassInstance other, @NotNull LocatableTrace trace) {
        ScriptBlockState state = (ScriptBlockState)other.getPrimitive((PrimitiveDefinition)this);
        return state != null && ((ScriptBlockState)instance.asPrimitive((PrimitiveDefinition)this)).state.equals(state.state);
    }

    public int hashCode(@NotNull ClassInstance instance, @NotNull Interpreter interpreter, @NotNull LocatableTrace trace) {
        return ((ScriptBlockState)instance.asPrimitive((PrimitiveDefinition)this)).state.hashCode();
    }

    @NotNull
    public String toString(@NotNull ClassInstance instance, @NotNull Interpreter interpreter, @NotNull LocatableTrace trace) {
        return "Block{id=" + ((ScriptBlockState)instance.asPrimitive((PrimitiveDefinition)this)).getId().method_12832() + "}";
    }

    public List<BuiltInFunction> defineStaticMethods() {
        return List.of(BuiltInFunction.of((String)"of", (int)1, this::of));
    }

    @FunctionDoc(isStatic=true, name="of", desc={"This creates a Block from a material or string"}, params={@ParameterDoc(type=MaterialDef.class, name="material", desc={"the material, item stack, block, or string to create the Block from"})}, returns=@ReturnDoc(type=BlockDef.class, desc={"the Block created from the material or string"}), examples={"Block.of(Material.STONE);"})
    private class_2680 of(Arguments arguments) {
        if (arguments.isNext(StringDef.class)) {
            String id = (String)arguments.nextPrimitive(StringDef.class);
            return ((class_2248)class_7923.field_41175.method_17966(ClientScriptUtils.stringToIdentifier(id)).orElseThrow(() -> new RuntimeError("'%s' is not a value block".formatted(id)))).method_9564();
        }
        if (arguments.isNext(MaterialDef.class)) {
            ScriptMaterial material = (ScriptMaterial)arguments.nextPrimitive(MaterialDef.class);
            return material.asBlockState();
        }
        throw new RuntimeError("Parameter must be of type String or Material");
    }

    public List<MemberFunction> defineMethods() {
        return List.of(MemberFunction.of((String)"getMaterial", this::getMaterial), MemberFunction.of((String)"getDefaultState", this::getDefaultState), MemberFunction.of((String)"with", (int)2, this::with), MemberFunction.of((String)"isBlockEntity", this::isBlockEntity), MemberFunction.of((String)"isTransparent", this::isTransparent), MemberFunction.of((String)"getBlastResistance", this::getBlastResistance), MemberFunction.of((String)"getBlockProperties", this::getBlockProperties), MemberFunction.of((String)"hasBlockPosition", this::hasBlockPosition), MemberFunction.of((String)"getPos", this::getPos), MemberFunction.of((String)"getX", this::getBlockX), MemberFunction.of((String)"getZ", this::getBlockZ), MemberFunction.of((String)"getY", this::getBlockY), MemberFunction.of((String)"offset", (int)1, this::offset), MemberFunction.of((String)"offset", (int)2, this::offset2), MemberFunction.of((String)"isSolidBlock", this::isSolidBlock), MemberFunction.of((String)"rotateYClockwise", this::rotateYClockwise), MemberFunction.of((String)"rotateYCounterClockwise", this::rotateYCounterClockwise), MemberFunction.of((String)"mirrorFrontBack", this::mirrorFrontBack), MemberFunction.of((String)"mirrorLeftRight", this::mirrorLeftRight), MemberFunction.of((String)"isFluid", this::isFluid), MemberFunction.of((String)"isFluidSource", this::isFluidSource), MemberFunction.of((String)"isReplaceable", this::isReplaceable), MemberFunction.of((String)"getHardness", this::getHardness), MemberFunction.of((String)"sideCoversSmallSquare", (int)1, this::sideCoversSmallSquare), MemberFunction.of((String)"isSideSolidFullSquare", (int)1, this::isSideSolidFullSquare), MemberFunction.of((String)"isSpawnable", this::allowsSpawning), MemberFunction.of((String)"isSpawnable", (int)1, this::allowsSpawningType), MemberFunction.of((String)"getLuminance", this::getLuminance), MemberFunction.of((String)"getMapColour", this::getMapColour), MemberFunction.of((String)"getMapColor", this::getMapColour), MemberFunction.of((String)"getBlockEntityNbt", this::getBlockNbt));
    }

    @FunctionDoc(name="getMaterial", desc={"This gets the material of the Block"}, returns=@ReturnDoc(type=MaterialDef.class, desc={"the material of the Block"}), examples={"block.getMaterial();"})
    private Object getMaterial(Arguments arguments) {
        ScriptBlockState blockState = (ScriptBlockState)arguments.nextPrimitive((PrimitiveDefinition)this);
        class_1792 item = (class_1792)class_1792.field_8003.get(blockState.asBlock());
        return item == null ? blockState.asBlock() : item;
    }

    @FunctionDoc(name="getDefaultState", desc={"This gets the default state of the block, it will conserve any positions"}, returns=@ReturnDoc(type=BlockDef.class, desc={"default state of the Block"}), examples={"block.getDefaultState();"})
    private Object getDefaultState(Arguments arguments) {
        ScriptBlockState blockState = (ScriptBlockState)arguments.nextPrimitive((PrimitiveDefinition)this);
        return new ScriptBlockState(blockState.asBlock().method_9564(), blockState.pos);
    }

    @FunctionDoc(name="with", desc={"This gets modified block with a property value, conserving positions"}, params={@ParameterDoc(type=StringDef.class, name="property", desc={"property name, such as 'facing', 'extended'"}), @ParameterDoc(type=StringDef.class, name="value", desc={"value name, such as 'north', 'true'"})}, returns=@ReturnDoc(type=BlockDef.class, desc={"new state of the Block"}), examples={"block.with('facing', 'north');"})
    private Object with(Arguments arguments) {
        ScriptBlockState blockState = (ScriptBlockState)arguments.nextPrimitive((PrimitiveDefinition)this);
        String propertyAsString = (String)arguments.nextPrimitive(StringDef.class);
        class_2769 property = blockState.asBlock().method_9595().method_11663(propertyAsString);
        if (property == null) {
            throw new RuntimeError("Property %s is not defined in block".formatted(propertyAsString));
        }
        String value = (String)arguments.nextPrimitive(StringDef.class);
        class_2680 state = this.getStateWith(blockState.state, property, value);
        if (state == null) {
            throw new RuntimeError("Property %s with value %s is not defined in block".formatted(propertyAsString, value));
        }
        return new ScriptBlockState(state, blockState.pos);
    }

    @FunctionDoc(name="isBlockEntity", desc={"This checks if the Block is a BlockEntity"}, returns=@ReturnDoc(type=BooleanDef.class, desc={"true if the Block is a BlockEntity"}), examples={"block.isBlockEntity();"})
    private Object isBlockEntity(Arguments arguments) {
        return ((ScriptBlockState)arguments.nextPrimitive((PrimitiveDefinition)this)).asBlock() instanceof class_2343;
    }

    @FunctionDoc(name="isTransparent", desc={"This checks if the Block is transparent"}, returns=@ReturnDoc(type=BooleanDef.class, desc={"true if the Block is transparent"}), examples={"block.isTransparent();"})
    private Object isTransparent(Arguments arguments) {
        return !((ScriptBlockState)arguments.nextPrimitive((PrimitiveDefinition)this)).state.method_26225();
    }

    @FunctionDoc(name="getBlastResistance", desc={"This gets the blast resistance of the Block"}, returns=@ReturnDoc(type=NumberDef.class, desc={"the blast resistance of the Block"}), examples={"block.getBlastResistance();"})
    private Object getBlastResistance(Arguments arguments) {
        return Float.valueOf(((ScriptBlockState)arguments.nextPrimitive((PrimitiveDefinition)this)).asBlock().method_9520());
    }

    @FunctionDoc(name="getBlockProperties", desc={"This gets the properties of the Block", "You can find a list of all block properties", "[here](https://minecraft.fandom.com/wiki/Java_Edition_data_values#Block_states)"}, returns=@ReturnDoc(type=MapDef.class, desc={"the properties of the Block, may be empty if there are no properties"}), examples={"block.getBlockProperties();"})
    private Object getBlockProperties(Arguments arguments) {
        ScriptBlockState blockState = (ScriptBlockState)arguments.nextPrimitive((PrimitiveDefinition)this);
        ArucasMap propertyMap = new ArucasMap();
        Interpreter interpreter = arguments.getInterpreter();
        blockState.state.method_11656().forEach((p, c) -> {
            Comparable value = p instanceof class_2754 ? ((class_3542)c).method_15434() : c;
            propertyMap.put(interpreter, interpreter.create(StringDef.class, (Object)p.method_11899()), interpreter.convertValue((Object)value));
        });
        return propertyMap;
    }

    @FunctionDoc(name="hasBlockPosition", desc={"This checks if the Block has a position or not"}, returns=@ReturnDoc(type=BooleanDef.class, desc={"true if the Block has a position"}), examples={"block.hasBlockPosition();"})
    private Object hasBlockPosition(Arguments arguments) {
        return ((ScriptBlockState)arguments.nextPrimitive((PrimitiveDefinition)this)).pos != null;
    }

    @FunctionDoc(name="getPos", desc={"This gets the position of the Block"}, returns=@ReturnDoc(type=PosDef.class, desc={"the position of the Block, may be null if the Block has no position"}), examples={"block.getPos();"})
    private Object getPos(Arguments arguments) {
        return ((ScriptBlockState)arguments.nextPrimitive((PrimitiveDefinition)this)).pos;
    }

    @FunctionDoc(name="getX", desc={"This gets the X position of the Block"}, returns=@ReturnDoc(type=NumberDef.class, desc={"the X position of the Block, may be null if the Block has no position"}), examples={"block.getX();"})
    private Object getBlockX(Arguments arguments) {
        class_2338 pos = ((ScriptBlockState)arguments.nextPrimitive((PrimitiveDefinition)this)).pos;
        return pos == null ? null : Integer.valueOf(pos.method_10263());
    }

    @FunctionDoc(name="getY", desc={"This gets the Y position of the Block"}, returns=@ReturnDoc(type=NumberDef.class, desc={"the Y position of the Block, may be null if the Block has no position"}), examples={"block.getY();"})
    private Object getBlockY(Arguments arguments) {
        class_2338 pos = ((ScriptBlockState)arguments.nextPrimitive((PrimitiveDefinition)this)).pos;
        return pos == null ? null : Integer.valueOf(pos.method_10264());
    }

    @FunctionDoc(name="offset", desc={"This gets a block with a given offset, this will throw if the block has no position"}, params={@ParameterDoc(type=PosDef.class, name="offset", desc={"the position offset to add to the block's current position"})}, returns=@ReturnDoc(type=BlockDef.class, desc={"the block at the offset position"}), examples={"block.offset(new Pos(0, 1, 0));"})
    private Object offset(Arguments arguments) {
        ClientScriptUtils.warnMainThread("offset", arguments.getInterpreter());
        ScriptBlockState state = this.ensurePosition(arguments);
        class_2338 offset = ((ScriptPos)arguments.nextPrimitive(PosDef.class)).getBlockPos();
        class_2338 newPos = state.pos.method_10081((class_2382)offset);
        return new ScriptBlockState(EssentialUtils.getWorld().method_8320(newPos), newPos);
    }

    @FunctionDoc(name="offset", desc={"This gets a block with a given offset, this will throw if the block has no position"}, params={@ParameterDoc(type=StringDef.class, name="direction", desc={"the direction of the offset"}), @ParameterDoc(type=NumberDef.class, name="distance", desc={"the distance of the offset"})}, returns=@ReturnDoc(type=BlockDef.class, desc={"the block at the offset position"}), examples={"block.offset('north', 5);"})
    private Object offset2(Arguments arguments) {
        ClientScriptUtils.warnMainThread("offset", arguments.getInterpreter());
        ScriptBlockState state = this.ensurePosition(arguments);
        class_2350 direction = ClientScriptUtils.stringToDirection(arguments.nextConstant(), null);
        int amount = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        class_2338 newPos = state.pos.method_10079(direction, amount);
        return new ScriptBlockState(EssentialUtils.getWorld().method_8320(newPos), newPos);
    }

    @FunctionDoc(name="getZ", desc={"This gets the Z position of the Block"}, returns=@ReturnDoc(type=NumberDef.class, desc={"the Z position of the Block, may be null if the Block has no position"}), examples={"block.getZ();"})
    private Object getBlockZ(Arguments arguments) {
        class_2338 pos = ((ScriptBlockState)arguments.nextPrimitive((PrimitiveDefinition)this)).pos;
        return pos == null ? null : Integer.valueOf(pos.method_10260());
    }

    @FunctionDoc(name="isSolidBlock", desc={"This checks if the Block is a solid block"}, returns=@ReturnDoc(type=BooleanDef.class, desc={"true if the Block is a solid block"}), examples={"block.isSolidBlock();"})
    private Object isSolidBlock(Arguments arguments) {
        ScriptBlockState blockState = this.ensurePosition(arguments);
        return blockState.state.method_26212((class_1922)class_2682.field_12294, class_2338.field_10980);
    }

    @FunctionDoc(name="rotateYClockwise", desc={"This rotates the Block 90 degrees clockwise"}, returns=@ReturnDoc(type=BlockDef.class, desc={"the rotated Block"}), examples={"block.rotateYClockwise();"})
    private Object rotateYClockwise(Arguments arguments) {
        ScriptBlockState blockState = (ScriptBlockState)arguments.nextPrimitive((PrimitiveDefinition)this);
        return blockState.state.method_26186(class_2470.field_11463);
    }

    @FunctionDoc(name="rotateYCounterClockwise", desc={"This rotates the Block 90 degrees counter-clockwise"}, returns=@ReturnDoc(type=BlockDef.class, desc={"the rotated Block"}), examples={"block.rotateYCounterClockwise();"})
    private Object rotateYCounterClockwise(Arguments arguments) {
        ScriptBlockState blockState = (ScriptBlockState)arguments.nextPrimitive((PrimitiveDefinition)this);
        return blockState.state.method_26186(class_2470.field_11465);
    }

    @FunctionDoc(name="mirrorFrontBack", desc={"This mirrors the Block around the front and back"}, returns=@ReturnDoc(type=BlockDef.class, desc={"the mirrored Block"}), examples={"block.mirrorFrontBack();"})
    private Object mirrorFrontBack(Arguments arguments) {
        ScriptBlockState blockState = (ScriptBlockState)arguments.nextPrimitive((PrimitiveDefinition)this);
        return blockState.state.method_26185(class_2415.field_11301);
    }

    @FunctionDoc(name="mirrorLeftRight", desc={"This mirrors the Block around the left and right"}, returns=@ReturnDoc(type=BlockDef.class, desc={"the mirrored Block"}), examples={"block.mirrorLeftRight();"})
    private Object mirrorLeftRight(Arguments arguments) {
        ScriptBlockState blockState = (ScriptBlockState)arguments.nextPrimitive((PrimitiveDefinition)this);
        return blockState.state.method_26185(class_2415.field_11300);
    }

    @FunctionDoc(name="isFluid", desc={"This checks if the Block is a fluid"}, returns=@ReturnDoc(type=BooleanDef.class, desc={"true if the Block is a fluid"}), examples={"block.isFluid();"})
    private Object isFluid(Arguments arguments) {
        ScriptBlockState blockState = (ScriptBlockState)arguments.nextPrimitive((PrimitiveDefinition)this);
        return !blockState.state.method_26227().method_15769();
    }

    @FunctionDoc(name="isFluidSource", desc={"This checks if the Block is a fluid source"}, returns=@ReturnDoc(type=BooleanDef.class, desc={"true if the Block is a fluid source"}), examples={"block.isFluidSource();"})
    private Object isFluidSource(Arguments arguments) {
        ScriptBlockState blockState = (ScriptBlockState)arguments.nextPrimitive((PrimitiveDefinition)this);
        return blockState.state.method_26227().method_15771();
    }

    @FunctionDoc(name="isReplaceable", desc={"This checks if the Block is replaceable"}, returns=@ReturnDoc(type=BooleanDef.class, desc={"true if the Block is replaceable"}), examples={"block.isReplaceable();"})
    private Object isReplaceable(Arguments arguments) {
        ScriptBlockState blockState = (ScriptBlockState)arguments.nextPrimitive((PrimitiveDefinition)this);
        return blockState.state.method_45474();
    }

    @FunctionDoc(name="getHardness", desc={"This gets the hardness of the Block"}, returns=@ReturnDoc(type=NumberDef.class, desc={"the hardness of the Block"}), examples={"block.getHardness();"})
    private Object getHardness(Arguments arguments) {
        ScriptBlockState blockState = (ScriptBlockState)arguments.nextPrimitive((PrimitiveDefinition)this);
        return Float.valueOf(blockState.state.method_26214((class_1922)class_2682.field_12294, class_2338.field_10980));
    }

    @FunctionDoc(name="sideCoversSmallSquare", desc={"This checks if the Block covers a small square"}, params={@ParameterDoc(type=StringDef.class, name="side", desc={"the side to check, for example: 'north', 'south', 'east', 'west', 'up', 'down'"})}, returns=@ReturnDoc(type=BooleanDef.class, desc={"true if the Block covers a small square"}), examples={"block.sideCoversSmallSquare('north');"})
    private Object sideCoversSmallSquare(Arguments arguments) {
        ScriptBlockState state = (ScriptBlockState)arguments.nextPrimitive((PrimitiveDefinition)this);
        String stringDirection = arguments.nextConstant();
        class_2350 direction = ClientScriptUtils.stringToDirection(stringDirection, class_2350.field_11033);
        boolean isSmallSquare = direction != class_2350.field_11033 || !state.state.method_26164(class_3481.field_25148);
        return isSmallSquare && state.state.method_30368((class_1922)class_2682.field_12294, class_2338.field_10980, direction, class_5431.field_25823);
    }

    @FunctionDoc(name="isSideSolidFullSquare", desc={"This checks if the Block is solid on the full square"}, params={@ParameterDoc(type=StringDef.class, name="side", desc={"the side to check, for example: 'north', 'south', 'east', 'west', 'up', 'down'"})}, returns=@ReturnDoc(type=BooleanDef.class, desc={"true if the Block is solid on the full square"}), examples={"block.isSideSolidFullSquare('north');"})
    private Object isSideSolidFullSquare(Arguments arguments) {
        ScriptBlockState state = (ScriptBlockState)arguments.nextPrimitive((PrimitiveDefinition)this);
        String stringDirection = arguments.nextConstant();
        class_2350 direction = ClientScriptUtils.stringToDirection(stringDirection, class_2350.field_11033);
        return state.state.method_26206((class_1922)class_2682.field_12294, class_2338.field_10980, direction);
    }

    @FunctionDoc(name="isSpawnable", desc={"This checks if the Block is spawnable in the case of zombies"}, returns=@ReturnDoc(type=BooleanDef.class, desc={"true if the Block is spawnable in the case of zombies"}), examples={"block.isSpawnable();"})
    private Object allowsSpawning(Arguments arguments) {
        ScriptBlockState state = (ScriptBlockState)arguments.nextPrimitive((PrimitiveDefinition)this);
        return state.state.method_26170((class_1922)class_2682.field_12294, class_2338.field_10980, class_1299.field_6051);
    }

    @FunctionDoc(name="isSpawnable", desc={"This checks if the Block allows spawning for given entity"}, params={@ParameterDoc(type=EntityDef.class, name="entity", desc={"the entity to check"})}, returns=@ReturnDoc(type=BooleanDef.class, desc={"true if the Block allows spawning for given entity"}), examples={"block.isSpawnable(zombie);"})
    private Object allowsSpawningType(Arguments arguments) {
        ScriptBlockState state = (ScriptBlockState)arguments.nextPrimitive((PrimitiveDefinition)this);
        class_1297 entity = (class_1297)arguments.nextPrimitive(EntityDef.class);
        return state.state.method_26170((class_1922)class_2682.field_12294, class_2338.field_10980, entity.method_5864());
    }

    @FunctionDoc(name="getLuminance", desc={"This gets the luminance of the Block"}, returns=@ReturnDoc(type=NumberDef.class, desc={"the luminance of the Block"}), examples={"block.getLuminance();"})
    private Object getLuminance(Arguments arguments) {
        ScriptBlockState blockState = (ScriptBlockState)arguments.nextPrimitive((PrimitiveDefinition)this);
        return blockState.state.method_26213();
    }

    @FunctionDoc(name="getMapColour", desc={"This gets the map colour of the Block, can also be called with 'getMapColor'"}, returns=@ReturnDoc(type=ListDef.class, desc={"a list with the map colour of the Block as RGB values"}), examples={"block.getMapColour();"})
    private Object getMapColour(Arguments arguments) {
        ScriptBlockState blockState = (ScriptBlockState)arguments.nextPrimitive((PrimitiveDefinition)this);
        int colour = blockState.state.method_26205((class_1922)class_2682.field_12294, (class_2338)class_2338.field_10980).field_16011;
        Interpreter interpreter = arguments.getInterpreter();
        return ArucasList.of((ClassInstance[])new ClassInstance[]{interpreter.create(NumberDef.class, (Object)((colour & 0xFF0000) >> 16)), interpreter.create(NumberDef.class, (Object)((colour & 0xFF00) >> 8)), interpreter.create(NumberDef.class, (Object)(colour & 0xFF))});
    }

    @FunctionDoc(name="getBlockEntityNbt", desc={"This gets the NBT of a block entity"}, returns=@ReturnDoc(type=MapDef.class, desc={"the NBT of a block entity, may be null if the block entity has no NBT"}), examples={"block.getBlockEntityNbt();"})
    private Object getBlockNbt(Arguments arguments) {
        ScriptBlockState blockState = this.ensurePosition(arguments);
        class_2586 blockEntity = EssentialUtils.getWorld().method_8321(blockState.pos);
        if (blockEntity != null) {
            class_2487 compound = blockEntity.method_38244((class_7225.class_7874)EssentialUtils.getWorld().method_30349());
            return ClientScriptUtils.nbtToMap(arguments.getInterpreter(), compound, 10);
        }
        return null;
    }

    private ScriptBlockState ensurePosition(Arguments arguments) {
        ScriptBlockState blockState = (ScriptBlockState)arguments.nextPrimitive((PrimitiveDefinition)this);
        if (blockState.pos == null) {
            throw new RuntimeError("Block does not have position");
        }
        return blockState;
    }

    private <T extends Comparable<T>> class_2680 getStateWith(class_2680 blockState, class_2769<T> property, String value) {
        Optional optional = property.method_11900(value);
        return optional.map(t -> (class_2680)blockState.method_11657(property, t)).orElse(null);
    }
}

