/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.clientscript.definitions;

import java.util.List;
import me.senseiwells.arucas.api.docs.annotations.ClassDoc;
import me.senseiwells.arucas.api.docs.annotations.FunctionDoc;
import me.senseiwells.arucas.api.docs.annotations.ParameterDoc;
import me.senseiwells.arucas.api.docs.annotations.ReturnDoc;
import me.senseiwells.arucas.builtin.BooleanDef;
import me.senseiwells.arucas.builtin.NumberDef;
import me.senseiwells.arucas.builtin.StringDef;
import me.senseiwells.arucas.classes.CreatableDefinition;
import me.senseiwells.arucas.classes.PrimitiveDefinition;
import me.senseiwells.arucas.classes.instance.ClassInstance;
import me.senseiwells.arucas.compiler.LocatableTrace;
import me.senseiwells.arucas.functions.builtin.Arguments;
import me.senseiwells.arucas.functions.builtin.MemberFunction;
import me.senseiwells.arucas.interpreter.Interpreter;
import me.senseiwells.arucas.utils.misc.Language;
import me.senseiwells.essentialclient.clientscript.definitions.PosDef;
import me.senseiwells.essentialclient.utils.EssentialUtils;
import me.senseiwells.essentialclient.utils.clientscript.impl.ScriptPos;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;

@ClassDoc(name="Biome", desc={"This class represents biomes, and allows you to interact with things inside of them."}, language=Language.Java)
public class BiomeDef
extends CreatableDefinition<class_1959> {
    public BiomeDef(Interpreter interpreter) {
        super("Biome", interpreter);
    }

    @NotNull
    public String toString(@NotNull ClassInstance instance, @NotNull Interpreter interpreter, @NotNull LocatableTrace trace) {
        class_2960 id = EssentialUtils.getRegistryManager().method_30530(class_7924.field_41236).method_10221((Object)((class_1959)instance.asPrimitive((PrimitiveDefinition)this)));
        return "Biome{id=" + (id == null ? "plains" : id.method_12832()) + "}";
    }

    public List<MemberFunction> defineMethods() {
        return List.of(MemberFunction.of((String)"canSnow", (int)3, this::canSnowFull), MemberFunction.of((String)"canSnow", (int)1, this::canSnowPos), MemberFunction.of((String)"isHot", (int)3, this::isHotFull), MemberFunction.of((String)"isHot", (int)1, this::isHotPos), MemberFunction.of((String)"getFogColor", this::getFogColor), MemberFunction.of((String)"getTemperature", this::getTemperature), MemberFunction.of((String)"getWaterColor", this::getWaterColor), MemberFunction.of((String)"getWaterFogColor", this::getWaterFogColor), MemberFunction.of((String)"isCold", (int)1, this::isColdPos), MemberFunction.of((String)"isCold", (int)3, this::isColdFull), MemberFunction.of((String)"getId", this::getId), MemberFunction.of((String)"getSkyColor", this::getSkyColor));
    }

    @FunctionDoc(name="canSnow", desc={"This function calculates whether snow will fall at given coordinates"}, params={@ParameterDoc(type=NumberDef.class, name="x", desc={"the x coordinate"}), @ParameterDoc(type=NumberDef.class, name="y", desc={"the y coordinate"}), @ParameterDoc(type=NumberDef.class, name="z", desc={"the z coordinate"})}, returns=@ReturnDoc(type=BooleanDef.class, desc={"whether snow will fall at given position"}), examples={"biome.canSnow(0, 100, 0);"})
    private boolean canSnowFull(Arguments arguments) {
        class_1959 biome = (class_1959)arguments.nextPrimitive((PrimitiveDefinition)this);
        int x = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        int y = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        int z = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        class_2338 blockPos = new class_2338(x, y, z);
        return BiomeDef.isCold(biome, blockPos);
    }

    @FunctionDoc(name="canSnow", desc={"This function calculates whether snow will fall at given coordinates"}, params={@ParameterDoc(type=PosDef.class, name="pos", desc={"the position"})}, returns=@ReturnDoc(type=BooleanDef.class, desc={"whether snow will fall at given position"}), examples={"biome.canSnow(new Pos(0, 100, 0));"})
    private boolean canSnowPos(Arguments arguments) {
        class_1959 biome = (class_1959)arguments.nextPrimitive((PrimitiveDefinition)this);
        ScriptPos pos = (ScriptPos)arguments.nextPrimitive(PosDef.class);
        return BiomeDef.isCold(biome, pos.getBlockPos());
    }

    @FunctionDoc(name="isHot", desc={"This function calculates whether a biome is hot at given position"}, params={@ParameterDoc(type=NumberDef.class, name="x", desc={"the x coordinate"}), @ParameterDoc(type=NumberDef.class, name="y", desc={"the y coordinate"}), @ParameterDoc(type=NumberDef.class, name="z", desc={"the z coordinate"})}, returns=@ReturnDoc(type=BooleanDef.class, desc={"whether temperature is hot at given position"}), examples={"biome.isHot(0, 100, 0);"})
    private boolean isHotFull(Arguments arguments) {
        class_1959 biome = (class_1959)arguments.nextPrimitive((PrimitiveDefinition)this);
        int x = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        int y = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        int z = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        return BiomeDef.isHot(biome, new class_2338(x, y, z));
    }

    @FunctionDoc(name="isHot", desc={"This function calculates whether a biome is hot at given position"}, params={@ParameterDoc(type=PosDef.class, name="pos", desc={"the position"})}, returns=@ReturnDoc(type=BooleanDef.class, desc={"whether temperature is hot at given position"}), examples={"biome.isHot(0, 100, 0);"})
    private boolean isHotPos(Arguments arguments) {
        class_1959 biome = (class_1959)arguments.nextPrimitive((PrimitiveDefinition)this);
        ScriptPos pos = (ScriptPos)arguments.nextPrimitive(PosDef.class);
        return BiomeDef.isHot(biome, pos.getBlockPos());
    }

    @FunctionDoc(name="isCold", desc={"This function calculates whether biome is cold at given position"}, params={@ParameterDoc(type=PosDef.class, name="pos", desc={"the position"})}, returns=@ReturnDoc(type=BooleanDef.class, desc={"whether temperature is cold at given position"}), examples={"biome.isCold(0, 100, 0);"})
    private boolean isColdPos(Arguments arguments) {
        class_1959 biome = (class_1959)arguments.nextPrimitive((PrimitiveDefinition)this);
        ScriptPos pos = (ScriptPos)arguments.nextPrimitive(PosDef.class);
        return BiomeDef.isCold(biome, pos.getBlockPos());
    }

    @FunctionDoc(name="isCold", desc={"This function calculates whether biome is cold at given position"}, params={@ParameterDoc(type=NumberDef.class, name="x", desc={"the x coordinate"}), @ParameterDoc(type=NumberDef.class, name="y", desc={"the y coordinate"}), @ParameterDoc(type=NumberDef.class, name="z", desc={"the z coordinate"})}, returns=@ReturnDoc(type=BooleanDef.class, desc={"whether temperature is cold at given position"}), examples={"biome.isCold(0, 100, 0);"})
    private boolean isColdFull(Arguments arguments) {
        class_1959 biome = (class_1959)arguments.nextPrimitive((PrimitiveDefinition)this);
        int x = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        int y = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        int z = ((Double)arguments.nextPrimitive(NumberDef.class)).intValue();
        return BiomeDef.isCold(biome, new class_2338(x, y, z));
    }

    @FunctionDoc(name="getFogColor", desc={"This function returns fog color of the biome"}, returns=@ReturnDoc(type=NumberDef.class, desc={"fog color of the biome"}), examples={"biome.getFogColor();"})
    private int getFogColor(Arguments arguments) {
        class_1959 biome = (class_1959)arguments.nextPrimitive((PrimitiveDefinition)this);
        return biome.method_24376();
    }

    @FunctionDoc(name="getTemperature", desc={"This function returns temperature of the biome"}, returns=@ReturnDoc(type=NumberDef.class, desc={"temperature of the biome"}), examples={"biome.getTemperature();"})
    private float getTemperature(Arguments arguments) {
        class_1959 biome = (class_1959)arguments.nextPrimitive((PrimitiveDefinition)this);
        return biome.method_8712();
    }

    @FunctionDoc(name="getWaterColor", desc={"This function returns Fog color of the biome"}, returns=@ReturnDoc(type=NumberDef.class, desc={"fog color of the biome"}), examples={"biome.getWaterColor();"})
    private int getWaterColor(Arguments arguments) {
        class_1959 biome = (class_1959)arguments.nextPrimitive((PrimitiveDefinition)this);
        return biome.method_8687();
    }

    @FunctionDoc(name="getWaterFogColor", desc={"This function returns water fog color of the biome"}, returns=@ReturnDoc(type=NumberDef.class, desc={"water fog color of the biome"}), examples={"biome.getWaterFogColor();"})
    private int getWaterFogColor(Arguments arguments) {
        class_1959 biome = (class_1959)arguments.nextPrimitive((PrimitiveDefinition)this);
        return biome.method_8713();
    }

    @FunctionDoc(name="getId", desc={"This function returns the path id of the biome, e.g. 'plains'"}, returns=@ReturnDoc(type=StringDef.class, desc={"id of the biome"}), examples={"biome.getId();"})
    private String getId(Arguments arguments) {
        class_1959 biome = (class_1959)arguments.nextPrimitive((PrimitiveDefinition)this);
        class_2960 id = EssentialUtils.getRegistryManager().method_30530(class_7924.field_41236).method_10221((Object)biome);
        return id == null ? "plains" : id.method_12832();
    }

    @FunctionDoc(name="getSkyColor", desc={"This function returns sky color of the biome"}, returns=@ReturnDoc(type=NumberDef.class, desc={"sky color of the biome"}), examples={"biome.getSkyColor();"})
    private int getSkyColor(Arguments arguments) {
        class_1959 biome = (class_1959)arguments.nextPrimitive((PrimitiveDefinition)this);
        return biome.method_8697();
    }

    private static boolean isCold(class_1959 biome, class_2338 pos) {
        return biome.method_33599(pos);
    }

    private static boolean isHot(class_1959 biome, class_2338 pos) {
        return biome.method_8712() > 1.0f;
    }
}

