/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.clientscript.core;

import java.util.Objects;
import me.senseiwells.arucas.api.ArucasObfuscator;
import me.senseiwells.essentialclient.utils.EssentialUtils;
import me.senseiwells.essentialclient.utils.clientscript.MinecraftDeobfuscator;
import org.jetbrains.annotations.NotNull;

public class ClientScriptObfuscator
implements ArucasObfuscator {
    public boolean shouldObfuscate() {
        return !EssentialUtils.isDev();
    }

    @NotNull
    public String obfuscateClassName(@NotNull String s) {
        return this.shouldObfuscate() ? MinecraftDeobfuscator.obfuscate(s) : s;
    }

    @NotNull
    public String obfuscateMethodName(@NotNull Class<?> clazz, @NotNull String name) {
        if (this.shouldObfuscate()) {
            for (Class<?> k = clazz; k != Object.class; k = k.getSuperclass()) {
                String result = ClientScriptObfuscator.obfuscateMethod(k, name);
                if (result == null) continue;
                return result;
            }
            for (Class<?> k : clazz.getInterfaces()) {
                String result = ClientScriptObfuscator.obfuscateMethod(k, name);
                if (result == null) continue;
                return result;
            }
        }
        return name;
    }

    @NotNull
    public String obfuscateFieldName(@NotNull Class<?> clazz, @NotNull String name) {
        if (this.shouldObfuscate()) {
            for (Class<?> k = clazz; k != Object.class; k = k.getSuperclass()) {
                String result = ClientScriptObfuscator.obfuscateField(k, name);
                if (result == null) continue;
                return result;
            }
            for (Class<?> k : clazz.getInterfaces()) {
                String result = ClientScriptObfuscator.obfuscateField(k, name);
                if (result == null) continue;
                return result;
            }
        }
        return name;
    }

    @NotNull
    public String deobfuscateClass(@NotNull Class<?> aClass) {
        return this.shouldObfuscate() ? MinecraftDeobfuscator.deobfuscateClass(aClass.getName()) : aClass.getName();
    }

    private static String obfuscateMethod(Class<?> clazz, String name) {
        String deobfuscatedClass = MinecraftDeobfuscator.deobfuscateClass(clazz.getName());
        String deobfuscatedMethod = deobfuscatedClass + "#" + name + "()";
        String obfuscatedMethod = MinecraftDeobfuscator.obfuscate(deobfuscatedMethod);
        if (!Objects.equals(obfuscatedMethod, deobfuscatedMethod)) {
            return obfuscatedMethod.substring(obfuscatedMethod.lastIndexOf(35) + 1, obfuscatedMethod.length() - 2);
        }
        return null;
    }

    private static String obfuscateField(Class<?> clazz, String name) {
        String deobfuscatedClass = MinecraftDeobfuscator.deobfuscateClass(clazz.getName());
        String deobfuscatedMethod = deobfuscatedClass + "#" + name;
        String obfuscatedMethod = MinecraftDeobfuscator.obfuscate(deobfuscatedMethod);
        if (!Objects.equals(obfuscatedMethod, deobfuscatedMethod)) {
            return obfuscatedMethod.substring(obfuscatedMethod.lastIndexOf(35) + 1);
        }
        return null;
    }
}

