/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.clientscript.core;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.List;
import me.senseiwells.arucas.api.ArucasAPI;
import me.senseiwells.arucas.api.ArucasErrorHandler;
import me.senseiwells.arucas.api.ArucasFileHandler;
import me.senseiwells.arucas.api.ArucasInput;
import me.senseiwells.arucas.api.ArucasLibrary;
import me.senseiwells.arucas.api.ArucasObfuscator;
import me.senseiwells.arucas.api.ArucasOutput;
import me.senseiwells.arucas.api.impl.GitHubArucasLibrary;
import me.senseiwells.arucas.classes.instance.ClassInstance;
import me.senseiwells.arucas.interpreter.Interpreter;
import me.senseiwells.arucas.interpreter.Properties;
import me.senseiwells.essentialclient.EssentialClient;
import me.senseiwells.essentialclient.clientscript.api.ClientScriptAPI;
import me.senseiwells.essentialclient.clientscript.core.ClientScript;
import me.senseiwells.essentialclient.clientscript.core.ClientScriptErrorHandler;
import me.senseiwells.essentialclient.clientscript.core.ClientScriptIO;
import me.senseiwells.essentialclient.clientscript.core.ClientScriptObfuscator;
import me.senseiwells.essentialclient.clientscript.core.MinecraftAPI;
import me.senseiwells.essentialclient.clientscript.events.MinecraftScriptEvents;
import me.senseiwells.essentialclient.feature.keybinds.ClientKeyBind;
import me.senseiwells.essentialclient.feature.keybinds.ClientKeyBinds;
import me.senseiwells.essentialclient.feature.keybinds.MultiKeyBind;
import me.senseiwells.essentialclient.rule.ClientRules;
import me.senseiwells.essentialclient.utils.EssentialUtils;
import me.senseiwells.essentialclient.utils.command.CommandHelper;
import me.senseiwells.essentialclient.utils.render.Texts;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_634;

public class ClientScriptInstance {
    private static List<ClientScriptAPI> APIS = new LinkedList<ClientScriptAPI>();
    private static ArucasAPI API;
    private final String content;
    private Path fileLocation;
    private String scriptName;
    private MultiKeyBind keyBind;
    private Interpreter interpreter;
    private boolean isStopping;

    private ClientScriptInstance(String scriptName, String content, Path fileLocation) {
        this.scriptName = scriptName;
        this.content = content;
        this.fileLocation = fileLocation;
        this.keyBind = ClientKeyBinds.registerMulti(scriptName, "Script Toggles", client -> this.toggleScript(), new int[0]);
        ClientScript.INSTANCE.addInstance(this);
    }

    public ClientScriptInstance(String scriptName, Path fileLocation) {
        this(scriptName, null, fileLocation);
    }

    public Path getFileLocation() {
        return this.fileLocation;
    }

    public MultiKeyBind getKeyBind() {
        return this.keyBind;
    }

    public boolean isTemporary() {
        return this.fileLocation == null;
    }

    public void renameScript(String newName, Path newLocation) {
        ClientScript.INSTANCE.replaceSelectedInstance(this.scriptName, newName);
        ClientKeyBind old = ClientKeyBinds.unregisterKeyBind(this.scriptName);
        List<class_3675.class_306> keys = old != null ? old.getKeys() : List.of();
        this.keyBind = ClientKeyBinds.registerMulti(newName, "Script Toggles", client -> this.toggleScript(), keys);
        this.scriptName = newName;
        this.fileLocation = newLocation;
    }

    public void delete() throws IOException {
        this.stopScript();
        Files.delete(this.fileLocation);
        ClientScript.INSTANCE.removeInstance(this);
        ClientKeyBinds.unregisterKeyBind(this.scriptName);
    }

    public boolean isScriptRunning() {
        return this.interpreter != null;
    }

    public synchronized void toggleScript() {
        if (EssentialUtils.getClient().field_1724 == null || this.isScriptRunning()) {
            this.stopScript();
            return;
        }
        this.executeScript();
    }

    public synchronized void stopScript() {
        if (!this.isScriptRunning() || this.isStopping) {
            return;
        }
        this.isStopping = true;
        MinecraftScriptEvents.ON_SCRIPT_END.run(this.interpreter.getProperties().getId(), new ClassInstance[0]);
        this.interpreter.stop();
        class_310 client = EssentialUtils.getClient();
        if (CommandHelper.getCommandPacket() != null) {
            client.execute(() -> {
                class_634 networkHandler = EssentialUtils.getNetworkHandler();
                if (networkHandler != null) {
                    networkHandler.method_11145(CommandHelper.getCommandPacket());
                }
            });
        }
        if (((Boolean)ClientRules.CLIENT_SCRIPT_ANNOUNCEMENTS.getValue()).booleanValue()) {
            EssentialUtils.sendMessage((class_2561)Texts.SCRIPT_STATUS.generate(this.scriptName, Texts.FINISHED));
        }
        this.interpreter = null;
        this.isStopping = false;
    }

    private synchronized void executeScript() {
        String fileContent;
        try {
            String string = fileContent = this.fileLocation == null ? this.content : Files.readString(this.fileLocation);
            if (fileContent == null) {
                throw new IOException("File content was null!");
            }
        }
        catch (IOException e) {
            EssentialUtils.sendMessage((class_2561)Texts.READ_ERROR.generate(this.scriptName));
            e.printStackTrace();
            return;
        }
        this.interpreter = Interpreter.of((String)fileContent, (String)this.scriptName, (ArucasAPI)ClientScriptInstance.getApi());
        this.interpreter.addStopEvent(this::stopScript);
        this.interpreter.executeAsync();
        if (((Boolean)ClientRules.CLIENT_SCRIPT_ANNOUNCEMENTS.getValue()).booleanValue()) {
            EssentialUtils.sendMessage((class_2561)Texts.SCRIPT_STATUS.generate(this.scriptName, Texts.STARTED));
        }
    }

    public String getName() {
        return this.scriptName;
    }

    public static ArucasAPI getApi() {
        if (API == null) {
            ClientScriptInstance.load();
        }
        return API;
    }

    public static void addApi(ClientScriptAPI api) {
        if (APIS == null) {
            throw new IllegalStateException("ClientScript API has been locked, register your api earlier");
        }
        APIS.add(api);
    }

    public static void runFromContent(String scriptName, String scriptContent) {
        ClientScriptInstance instance = new ClientScriptInstance(scriptName, scriptContent, null);
        instance.toggleScript();
    }

    private static void load() {
        ArucasAPI.Builder builder = new ArucasAPI.Builder().addDefault().addArucasLibrary("ArucasLibraries", (ArucasLibrary)new GitHubArucasLibrary(ClientScript.INSTANCE.getLibraryDirectory())).setObfuscator((ArucasObfuscator)new ClientScriptObfuscator()).setInput((ArucasInput)ClientScriptIO.INSTANCE).setOutput((ArucasOutput)ClientScriptIO.INSTANCE).setErrorHandler((ArucasErrorHandler)ClientScriptErrorHandler.INSTANCE).setFileHandler((ArucasFileHandler)ClientScriptIO.INSTANCE).setInterpreterProperties(() -> {
            Properties properties = new Properties();
            properties.setErrorMaxLength(40);
            properties.setLogDeprecated(true);
            return properties;
        });
        MinecraftAPI.addMinecraftAPI(builder);
        APIS.forEach(a -> a.apply(builder));
        APIS = null;
        try {
            API = builder.build();
        }
        catch (Exception e) {
            EssentialClient.LOGGER.error("Failed to load Script API", (Throwable)e);
            EssentialUtils.getClient().method_1592();
            throw e;
        }
        new Thread(() -> {
            try {
                API.generateNativeFiles(ClientScript.INSTANCE.getLibraryDirectory());
            }
            catch (Exception e) {
                EssentialClient.LOGGER.error("Failed to generate native files", (Throwable)e);
            }
        }).start();
    }
}

