/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.clientscript.core;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import me.senseiwells.arucas.api.ArucasErrorHandler;
import me.senseiwells.arucas.exceptions.ArucasError;
import me.senseiwells.arucas.exceptions.FatalError;
import me.senseiwells.arucas.exceptions.Propagator;
import me.senseiwells.arucas.interpreter.Interpreter;
import me.senseiwells.arucas.utils.FileUtils;
import me.senseiwells.essentialclient.EssentialClient;
import me.senseiwells.essentialclient.rule.ClientRules;
import me.senseiwells.essentialclient.utils.EssentialUtils;
import me.senseiwells.essentialclient.utils.render.Texts;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jetbrains.annotations.NotNull;

public enum ClientScriptErrorHandler implements ArucasErrorHandler
{
    INSTANCE;

    private static final String ISSUE_TRACKER = "https://github.com/senseiwells/EssentialClient/issues/new";

    public void handleArucasError(@NotNull ArucasError arucasError, @NotNull Interpreter interpreter) {
        class_2960 identifier = switch ((String)ClientRules.CLIENT_SCRIPT_FONT.getValue()) {
            case "Minecraft" -> Texts.MINECRAFT_MONO;
            case "Jetbrains" -> Texts.JETBRAINS_MONO;
            default -> null;
        };
        EssentialUtils.sendMessage((class_2561)class_2561.method_43470((String)arucasError.format(interpreter)).method_27694(s -> s.method_27704(identifier).method_10977(class_124.field_1061)));
    }

    public void handleInvalidPropagator(@NotNull Propagator propagator, @NotNull Interpreter interpreter) {
        ArucasErrorHandler.getDefault().handleInvalidPropagator(propagator, interpreter);
    }

    public void handleFatalError(@NotNull FatalError fatalError, @NotNull Interpreter interpreter) {
        this.handleFatalError((Throwable)fatalError, interpreter);
    }

    public void handleFatalError(@NotNull Throwable throwable, @NotNull Interpreter interpreter) {
        class_5250 error = class_2561.method_43470((String)"\n").method_27692(class_124.field_1061).method_10852((class_2561)Texts.FATAL_ERROR.generate(interpreter.getName()));
        EssentialUtils.sendMessage((class_2561)error);
        String path = this.writeCrashReport(interpreter, throwable).toAbsolutePath().toString();
        class_5250 crashReport = Texts.CRASH_REPORT.generate(class_2561.method_43470((String)("\n" + path + "\n")).method_27692(class_124.field_1073).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11746, path)))).method_27692(class_124.field_1061);
        EssentialUtils.sendMessage((class_2561)crashReport);
        EssentialUtils.sendMessage(Texts.CRASH_BUG);
        class_5250 issueTracker = class_2561.method_43470((String)"https://github.com/senseiwells/EssentialClient/issues/new\n").method_27692(class_124.field_1073).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11749, ISSUE_TRACKER)));
        EssentialUtils.sendMessage((class_2561)issueTracker);
    }

    private Path writeCrashReport(Interpreter interpreter, Throwable throwable) {
        String stacktrace = ExceptionUtils.getStackTrace((Throwable)throwable);
        String scriptTrace = "";
        if (throwable instanceof FatalError) {
            FatalError error = (FatalError)throwable;
            scriptTrace = "### StackTrace:\n```\n%s\n```\n".formatted(error.format(interpreter));
        }
        String report = "### Minecraft Version: `%s`\n### Essential Client Version: `%s`\n### Arucas Version: `%s`\n### Script:\n```kt\n// %s\n%s\n```\n%s### Crash:\n```\n%s\n```\n".formatted(EssentialUtils.getMinecraftVersion(), EssentialClient.VERSION, "2.3.0", interpreter.getName(), interpreter.getContent(), scriptTrace, stacktrace);
        String date = new SimpleDateFormat("dd-MM-yyyy_HH-mm-ss").format(new Date());
        Path crashPath = EssentialUtils.getEssentialConfigFile().resolve("script-crashes").resolve("crash-" + date + ".txt");
        try {
            Files.writeString(FileUtils.ensureParentExists((Path)crashPath), (CharSequence)report, new OpenOption[0]);
        }
        catch (IOException e) {
            EssentialClient.LOGGER.error("Failed to write script crash report:\n{}\n\n{}", (Object)report, (Object)e);
        }
        return crashPath;
    }
}

