/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.util.io;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import io.github.thecsdev.betterstats.BetterStats;
import io.github.thecsdev.betterstats.BetterStatsProperties;
import io.github.thecsdev.betterstats.client.BetterStatsClient;
import io.github.thecsdev.tcdcommons.api.util.io.HttpUtils;
import io.github.thecsdev.tcdcommons.api.util.io.cache.CachedResource;
import io.github.thecsdev.tcdcommons.api.util.io.cache.CachedResourceManager;
import io.github.thecsdev.tcdcommons.api.util.io.cache.IResourceFetchTask;
import java.io.Closeable;
import java.time.Duration;
import java.time.Instant;
import java.util.function.Consumer;
import net.minecraft.class_1255;
import net.minecraft.class_2960;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class BetterStatsWebApiUtils {
    @ApiStatus.Internal
    public static final Gson GSON = new Gson();

    private BetterStatsWebApiUtils() {
    }

    public static final void fetchBssApiLinksAsync(class_1255<?> minecraftClientOrServer, Consumer<JsonObject> onReady, Consumer<Exception> onError) throws NullPointerException {
        BetterStatsWebApiUtils.fetchBssApiLinks(true, minecraftClientOrServer, onReady, onError);
    }

    public static final void fetchBssApiLinks(boolean isAsync, class_1255<?> minecraftClientOrServer, final Consumer<JsonObject> onReady, final Consumer<Exception> onError) throws NullPointerException {
        class_2960 crId = class_2960.method_60655((String)BetterStats.getModID(), (String)"links.json");
        IResourceFetchTask<JsonObject> irft = new IResourceFetchTask<JsonObject>(){

            public final class_1255<?> getMinecraftClientOrServer() {
                return BetterStatsClient.MC_CLIENT;
            }

            public final Class<JsonObject> getResourceType() {
                return JsonObject.class;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final CachedResource<JsonObject> fetchResourceSync() throws Exception {
                CloseableHttpResponse httpResult = HttpUtils.fetchSync((String)BetterStatsProperties.URL_REMOTE_APIS);
                @Nullable String httpResultStr = null;
                try {
                    int statusCode = httpResult.getStatusLine().getStatusCode();
                    if (statusCode != 200) {
                        throw new HttpResponseException(statusCode, httpResult.getStatusLine().getReasonPhrase());
                    }
                    HttpEntity httpResultEntity = httpResult.getEntity();
                    if (httpResultEntity == null) {
                        throw new HttpException("Missing HTTP response body.");
                    }
                    httpResultStr = EntityUtils.toString((HttpEntity)httpResultEntity);
                }
                finally {
                    IOUtils.closeQuietly((Closeable)httpResult);
                }
                return new CachedResource((Object)((JsonObject)GSON.fromJson(httpResultStr, JsonObject.class)), (long)httpResultStr.length(), Instant.now().plus(Duration.ofMinutes(42L)));
            }

            public final void onReady(JsonObject result) {
                onReady.accept(result);
            }

            public final void onError(Exception error) {
                onError.accept(error);
            }
        };
        if (isAsync) {
            CachedResourceManager.getResourceAsync((class_2960)crId, (IResourceFetchTask)irft);
        } else {
            CachedResourceManager.getResourceSync((class_2960)crId, (IResourceFetchTask)irft);
        }
    }
}

