/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.api.util.io;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.serialization.DynamicOps;
import io.github.thecsdev.betterstats.api.util.io.IEditableStatsProvider;
import io.github.thecsdev.betterstats.api.util.io.IStatsProvider;
import io.github.thecsdev.betterstats.api.util.io.IllegalHeaderException;
import io.github.thecsdev.betterstats.api.util.stats.SUItemStat;
import io.github.thecsdev.betterstats.api.util.stats.SUMobStat;
import io.github.thecsdev.betterstats.api.util.stats.SUPlayerBadgeStat;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import io.github.thecsdev.tcdcommons.api.util.exceptions.UnsupportedFileVersionException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2505;
import net.minecraft.class_2509;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3445;
import net.minecraft.class_3468;
import net.minecraft.class_7923;
import net.minecraft.class_8824;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class StatsProviderIO_fv2 {
    static final void write_fileChunks(class_2540 buffer_file, IStatsProvider statsProvider) {
        StatsProviderIO_fv2.write_fileChunk("metadata", buffer_file, statsProvider);
        StatsProviderIO_fv2.write_fileChunk("general", buffer_file, statsProvider);
        StatsProviderIO_fv2.write_fileChunk("item", buffer_file, statsProvider);
        StatsProviderIO_fv2.write_fileChunk("mob", buffer_file, statsProvider);
        StatsProviderIO_fv2.write_fileChunk("player_badge", buffer_file, statsProvider);
    }

    private static final void write_fileChunk(String chunkId, class_2540 buffer_file, IStatsProvider statsProvider) {
        class_2540 buffer_chunk = new class_2540(Unpooled.buffer());
        buffer_chunk.method_10814(chunkId);
        switch (chunkId) {
            case "metadata": {
                StatsProviderIO_fv2.write_fileChunk_meta(buffer_chunk, statsProvider);
                break;
            }
            case "general": {
                StatsProviderIO_fv2.write_fileChunk_general(buffer_chunk, statsProvider);
                break;
            }
            case "item": {
                StatsProviderIO_fv2.write_fileChunk_item(buffer_chunk, statsProvider);
                break;
            }
            case "mob": {
                StatsProviderIO_fv2.write_fileChunk_mob(buffer_chunk, statsProvider);
                break;
            }
            case "player_badge": {
                StatsProviderIO_fv2.write_fileChunk_playerBadge(buffer_chunk, statsProvider);
                break;
            }
        }
        buffer_file.method_53003(buffer_chunk.readableBytes());
        buffer_file.method_52975((ByteBuf)buffer_chunk);
        buffer_chunk.release();
    }

    private static final void write_fileChunk_meta(class_2540 buffer_chunk, IStatsProvider statsProvider) {
        @Nullable class_2561 displayName = statsProvider.getDisplayName();
        if (displayName == null) {
            displayName = TextUtils.literal((String)"-");
        }
        buffer_chunk.method_29172((DynamicOps)class_2509.field_11560, class_8824.field_46597, (Object)displayName);
        StatsProviderIO_fv2.writeGameProfile(buffer_chunk, statsProvider.getGameProfile());
    }

    private static final void write_fileChunk_general(class_2540 buffer_chunk, IStatsProvider statsProvider) {
        ArrayList customStats = Lists.newArrayList((Iterator)class_7923.field_41183.iterator());
        Map<String, List<class_2960>> customStatsMap = customStats.stream().filter(stat -> class_7923.field_41183.method_10221(stat) != null).filter(stat -> statsProvider.getStatValue(class_3468.field_15419.method_14956(stat)) != 0).collect(Collectors.groupingBy(stat -> class_7923.field_41183.method_10221(stat).method_12836()));
        for (Map.Entry<String, List<class_2960>> entry : customStatsMap.entrySet()) {
            String groupModId = entry.getKey();
            List<class_2960> groupStats = entry.getValue();
            buffer_chunk.method_10814(groupModId);
            buffer_chunk.method_10804(groupStats.size());
            for (class_2960 customStatAsIdentifier : groupStats) {
                class_3445 customStat = class_3468.field_15419.method_14956((Object)customStatAsIdentifier);
                int customStatValue = statsProvider.getStatValue(customStat);
                buffer_chunk.method_10814(customStatAsIdentifier.method_12832());
                buffer_chunk.method_10804(customStatValue);
            }
        }
    }

    private static final void write_fileChunk_item(class_2540 buffer_chunk, IStatsProvider statsProvider) {
        Map<String, List<SUItemStat>> stats = SUItemStat.getItemStatsByModGroups(statsProvider, stat -> !stat.isEmpty());
        for (Map.Entry<String, List<SUItemStat>> entry : stats.entrySet()) {
            String groupModId = entry.getKey();
            List<SUItemStat> groupStats = entry.getValue();
            buffer_chunk.method_10814(groupModId);
            buffer_chunk.method_10804(groupStats.size());
            for (SUItemStat stat2 : groupStats) {
                buffer_chunk.method_10814(stat2.getStatID().method_12832());
                buffer_chunk.method_10804(stat2.mined);
                buffer_chunk.method_10804(stat2.crafted);
                buffer_chunk.method_10804(stat2.used);
                buffer_chunk.method_10804(stat2.broken);
                buffer_chunk.method_10804(stat2.pickedUp);
                buffer_chunk.method_10804(stat2.dropped);
            }
        }
    }

    private static final void write_fileChunk_mob(class_2540 buffer_chunk, IStatsProvider statsProvider) {
        Map<String, List<SUMobStat>> stats = SUMobStat.getMobStatsByModGroups(statsProvider, stat -> !stat.isEmpty());
        for (Map.Entry<String, List<SUMobStat>> entry : stats.entrySet()) {
            String groupModId = entry.getKey();
            List<SUMobStat> groupStats = entry.getValue();
            buffer_chunk.method_10814(groupModId);
            buffer_chunk.method_10804(groupStats.size());
            for (SUMobStat stat2 : groupStats) {
                buffer_chunk.method_10814(stat2.getStatID().method_12832());
                buffer_chunk.method_10804(stat2.kills);
                buffer_chunk.method_10804(stat2.deaths);
            }
        }
    }

    private static final void write_fileChunk_playerBadge(class_2540 buffer_chunk, IStatsProvider statsProvider) {
        Map<String, List<SUPlayerBadgeStat>> stats = SUPlayerBadgeStat.getPlayerBadgeStatsByModGroups(statsProvider, stat -> !stat.isEmpty());
        for (Map.Entry<String, List<SUPlayerBadgeStat>> entry : stats.entrySet()) {
            String groupModId = entry.getKey();
            List<SUPlayerBadgeStat> groupStats = entry.getValue();
            buffer_chunk.method_10814(groupModId);
            buffer_chunk.method_10804(groupStats.size());
            for (SUPlayerBadgeStat stat2 : groupStats) {
                buffer_chunk.method_10814(stat2.getStatID().method_12832());
                buffer_chunk.method_10804(stat2.value);
            }
        }
    }

    static final void read_fileChunks(class_2540 buffer_file, IEditableStatsProvider statsProvider) throws IllegalHeaderException, UnsupportedFileVersionException {
        while (buffer_file.readableBytes() > 0) {
            String chunkId;
            int chunkSize = buffer_file.readIntLE();
            if (buffer_file.readableBytes() < chunkSize) {
                throw new IllegalHeaderException("chunk size >= " + chunkSize, "chunk size == " + buffer_file.readableBytes());
            }
            class_2540 buffer_chunk = new class_2540(buffer_file.readSlice(chunkSize));
            switch (chunkId = buffer_chunk.method_19772()) {
                case "metadata": {
                    StatsProviderIO_fv2.read_fileChunk_meta(buffer_chunk, statsProvider);
                    break;
                }
                case "general": {
                    StatsProviderIO_fv2.read_fileChunk_general(buffer_chunk, statsProvider);
                    break;
                }
                case "item": {
                    StatsProviderIO_fv2.read_fileChunk_item(buffer_chunk, statsProvider);
                    break;
                }
                case "mob": {
                    StatsProviderIO_fv2.read_fileChunk_mob(buffer_chunk, statsProvider);
                    break;
                }
                case "player_badge": {
                    StatsProviderIO_fv2.read_fileChunk_playerBadge(buffer_chunk, statsProvider);
                    break;
                }
            }
        }
    }

    private static final void read_fileChunk_meta(class_2540 buffer_chunk, IEditableStatsProvider statsProvider) {
        class_2561 displayName = (class_2561)buffer_chunk.method_29171((DynamicOps)class_2509.field_11560, class_8824.field_46597, class_2505.method_53899((long)0x200000L));
        statsProvider.setDisplayName(displayName);
        if (buffer_chunk.readableBytes() < 2) {
            return;
        }
        @Nullable GameProfile gameProfile = StatsProviderIO_fv2.readGameProfile(buffer_chunk);
        statsProvider.setGameProfile(gameProfile);
    }

    private static final void read_fileChunk_general(class_2540 buffer_chunk, IEditableStatsProvider statsProvider) {
        while (buffer_chunk.readableBytes() > 0) {
            String modId = buffer_chunk.method_19772();
            int entryCount = buffer_chunk.method_10816();
            for (int i = 0; i < entryCount; ++i) {
                String customStatIdPath = buffer_chunk.method_19772();
                int customStatValue = buffer_chunk.method_10816();
                class_2960 customStatId = class_2960.method_60655((String)modId, (String)customStatIdPath);
                class_2960 customStat = (class_2960)class_7923.field_41183.method_10223(customStatId);
                if (customStat == null) continue;
                statsProvider.setStatValue(class_3468.field_15419.method_14956((Object)customStat), customStatValue);
            }
        }
    }

    private static final void read_fileChunk_item(class_2540 buffer_chunk, IEditableStatsProvider statsProvider) {
        while (buffer_chunk.readableBytes() > 0) {
            String modId = buffer_chunk.method_19772();
            int entryCount = buffer_chunk.method_10816();
            for (int i = 0; i < entryCount; ++i) {
                class_2248 block;
                String itemIdPath = buffer_chunk.method_19772();
                int mined = buffer_chunk.method_10816();
                int crafted = buffer_chunk.method_10816();
                int used = buffer_chunk.method_10816();
                int broken = buffer_chunk.method_10816();
                int pickedUp = buffer_chunk.method_10816();
                int dropped = buffer_chunk.method_10816();
                class_2960 itemId = class_2960.method_60655((String)modId, (String)itemIdPath);
                @Nullable class_1792 item = (class_1792)class_7923.field_41178.method_10223(itemId);
                class_2248 class_22482 = block = item != null ? class_2248.method_9503((class_1792)item) : null;
                if (item == null) continue;
                if (block != null) {
                    statsProvider.setStatValue(class_3468.field_15427, block, mined);
                }
                statsProvider.setStatValue(class_3468.field_15370, item, crafted);
                statsProvider.setStatValue(class_3468.field_15372, item, used);
                statsProvider.setStatValue(class_3468.field_15383, item, broken);
                statsProvider.setStatValue(class_3468.field_15392, item, pickedUp);
                statsProvider.setStatValue(class_3468.field_15405, item, dropped);
            }
        }
    }

    private static final void read_fileChunk_mob(class_2540 buffer_chunk, IEditableStatsProvider statsProvider) {
        while (buffer_chunk.readableBytes() > 0) {
            String modId = buffer_chunk.method_19772();
            int entryCount = buffer_chunk.method_10816();
            for (int i = 0; i < entryCount; ++i) {
                String mobIdPath = buffer_chunk.method_19772();
                int kills = buffer_chunk.method_10816();
                int deaths = buffer_chunk.method_10816();
                class_2960 mobId = class_2960.method_60655((String)modId, (String)mobIdPath);
                @Nullable class_1299 entityType = (class_1299)class_7923.field_41177.method_10223(mobId);
                if (entityType == null) continue;
                statsProvider.setStatValue(class_3468.field_15403, entityType, kills);
                statsProvider.setStatValue(class_3468.field_15411, entityType, deaths);
            }
        }
    }

    private static final void read_fileChunk_playerBadge(class_2540 buffer_chunk, IEditableStatsProvider statsProvider) {
        while (buffer_chunk.readableBytes() > 0) {
            String modId = buffer_chunk.method_19772();
            int entryCount = buffer_chunk.method_10816();
            for (int i = 0; i < entryCount; ++i) {
                String playerBadgeIdPath = buffer_chunk.method_19772();
                int value = buffer_chunk.method_10816();
                class_2960 playerBadgeId = class_2960.method_60655((String)modId, (String)playerBadgeIdPath);
                statsProvider.setPlayerBadgeValue(playerBadgeId, value);
            }
        }
    }

    private static final void writeGameProfile(class_2540 buffer, @Nullable GameProfile gameProfile) {
        if (gameProfile == null) {
            buffer.method_52964(false);
            buffer.method_52964(false);
            return;
        }
        UUID uuid = gameProfile.getId();
        String name = gameProfile.getName();
        if (uuid != null) {
            buffer.method_52964(true);
            buffer.method_10797(uuid);
        } else {
            buffer.method_52964(false);
        }
        if (name != null) {
            buffer.method_52964(true);
            buffer.method_10814(name);
        } else {
            buffer.method_52964(false);
        }
    }

    @Nullable
    private static final GameProfile readGameProfile(class_2540 buffer) {
        String name;
        UUID uuid = buffer.readBoolean() ? buffer.method_10790() : null;
        String string = name = buffer.readBoolean() ? buffer.method_19772() : null;
        if (name == null && uuid == null) {
            return null;
        }
        return new GameProfile(uuid, name);
    }
}

