/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.util.render;

import java.util.function.Consumer;

public class ColorHolder {
    public int red;
    public int green;
    public int blue;
    public int alpha;

    private ColorHolder(int red, int green, int blue, int alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
    }

    public static ColorHolder of(int color) {
        return new ColorHolder(color >> 16 & 0xFF, color >> 8 & 0xFF, color >> 0 & 0xFF, color >> 24 & 0xFF);
    }

    public static ColorHolder of(int red, int green, int blue, int alpha) {
        return new ColorHolder(red, green, blue, alpha);
    }

    public int pack() {
        int color = 0;
        color |= (this.alpha & 0xFF) << 24;
        color |= (this.red & 0xFF) << 16;
        color |= (this.green & 0xFF) << 8;
        return color |= (this.blue & 0xFF) << 0;
    }

    public ColorHolder modify(Consumer<ColorHolder> modifier) {
        modifier.accept(this);
        return this;
    }
}

