/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.util.doc;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import me.fallenbreath.tweakermore.TweakerMoreMod;
import me.fallenbreath.tweakermore.util.FabricUtil;
import me.fallenbreath.tweakermore.util.doc.DocumentPrinter;
import net.minecraft.class_1076;
import net.minecraft.class_1077;
import net.minecraft.class_310;

public class DocumentGenerator {
    private static CompletableFuture<Void> completableFuture = null;
    private static final List<String> LANGS = ImmutableList.of((Object)"en_us", (Object)"zh_cn");

    private static CompletableFuture<Void> setLanguage(String lang) {
        TweakerMoreMod.LOGGER.info("Setting client language to {}", (Object)lang);
        class_1076 languageManager = class_310.method_1551().method_1526();
        class_1077 languageDefinition = languageManager.method_4668(lang);
        if (languageDefinition != languageManager.method_4668(languageManager.method_4669())) {
            languageManager.method_4667(lang);
            return class_310.method_1551().method_1521();
        }
        return CompletableFuture.allOf(new CompletableFuture[0]);
    }

    private static CompletableFuture<Void> generateDoc(String lang) {
        return DocumentGenerator.setLanguage(lang).thenRun(() -> DocumentPrinter.printDoc(lang));
    }

    private static void generateDoc(boolean exit) {
        if (completableFuture == null) {
            int i;
            completableFuture = new CompletableFuture();
            TweakerMoreMod.LOGGER.info("Generating doc...");
            String prevLang = class_310.method_1551().field_1690.field_1883;
            CompletableFuture[] futures = new CompletableFuture[LANGS.size() + 1];
            for (i = 0; i < futures.length; ++i) {
                futures[i] = new CompletableFuture();
            }
            for (i = 0; i < LANGS.size(); ++i) {
                int finalI = i;
                futures[i].thenRun(() -> DocumentGenerator.generateDoc(LANGS.get(finalI)).thenRun(() -> futures[finalI + 1].complete(null)));
            }
            futures[LANGS.size()].thenRun(() -> {
                TweakerMoreMod.LOGGER.info("Restoring language back to {}", (Object)prevLang);
                DocumentGenerator.setLanguage(prevLang).thenRun(() -> {
                    completableFuture.complete(null);
                    completableFuture = null;
                    TweakerMoreMod.LOGGER.info("Doc generating done");
                    if (exit) {
                        TweakerMoreMod.LOGGER.info("Stopping Minecraft client");
                        class_310.method_1551().method_1592();
                    }
                });
            });
            futures[0].complete(null);
        }
    }

    public static void onHotKey() {
        DocumentGenerator.generateDoc(false);
    }

    public static void onClientInitFinished() {
        if (FabricUtil.isDevelopmentEnvironment() && "true".equals(System.getProperty("tweakermore.gen_doc"))) {
            TweakerMoreMod.LOGGER.info("Starting Tweakermore automatic doc generating");
            DocumentGenerator.generateDoc(true);
        }
    }
}

