/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.mod_tweaks.serverDataSyncer;

import com.google.common.collect.Maps;
import fi.dy.masa.malilib.interfaces.IClientTickHandler;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import me.fallenbreath.tweakermore.TweakerMoreMod;
import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;
import me.fallenbreath.tweakermore.impl.mod_tweaks.serverDataSyncer.DataQueryHandlerPro;
import me.fallenbreath.tweakermore.impl.mod_tweaks.serverDataSyncer.EntityMotionStateRestorer;
import me.fallenbreath.tweakermore.impl.mod_tweaks.serverDataSyncer.LimitedTaskRunner;
import me.fallenbreath.tweakermore.impl.mod_tweaks.serverDataSyncer.TargetPair;
import me.fallenbreath.tweakermore.mixins.tweaks.mod_tweaks.serverDataSyncer.DoubleInventoryAccessor;
import me.fallenbreath.tweakermore.util.compat.carpettisaddition.CarpetTISAdditionAccess;
import me.fallenbreath.tweakermore.util.event.TweakerMoreEvents;
import net.minecraft.class_1258;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class ServerDataSyncer
extends LimitedTaskRunner
implements IClientTickHandler {
    private static final ServerDataSyncer INSTANCE = new ServerDataSyncer();
    private final Map<class_2338, CompletableFuture<class_2487>> syncBlockEntityPos = Maps.newHashMap();
    private final Map<Integer, CompletableFuture<class_2487>> syncedEntityId = Maps.newHashMap();
    private final DataQueryHandlerPro queryHandler = new DataQueryHandlerPro();

    private ServerDataSyncer() {
        TweakerMoreEvents.registerDimensionChangedCallback(this::onDimensionChanged);
    }

    @Override
    protected int getMaxTaskPerTick() {
        return TweakerMoreConfigs.SERVER_DATA_SYNCER_QUERY_LIMIT.getIntegerValue();
    }

    @Override
    protected int getTaskExecuteCooldown() {
        return TweakerMoreConfigs.SERVER_DATA_SYNCER_QUERY_INTERVAL.getIntegerValue() - 1;
    }

    public static ServerDataSyncer getInstance() {
        return INSTANCE;
    }

    public DataQueryHandlerPro getQueryHandler() {
        return this.queryHandler;
    }

    public static boolean hasEnoughPermission() {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 != null && mc.field_1724.method_5687(2)) {
            return true;
        }
        return CarpetTISAdditionAccess.getBooleanRule("debugNbtQueryNoPermission").orElse(false);
    }

    public void resetSyncLimiter() {
        this.syncBlockEntityPos.clear();
        this.syncedEntityId.clear();
    }

    public void onClientTick(class_310 mc) {
        this.resetSyncLimiter();
        this.tickTask();
    }

    public void onDimensionChanged() {
        this.resetSyncLimiter();
        this.queryHandler.clearCallbacks();
    }

    public Optional<CompletableFuture<@Nullable class_2487>> fetchEntity(class_1297 entity) {
        if (ServerDataSyncer.hasEnoughPermission()) {
            return Optional.of(this.syncedEntityId.computeIfAbsent(entity.method_5628(), entityId -> {
                CompletableFuture future = new CompletableFuture();
                this.runOrEnqueueTask(() -> {
                    TweakerMoreMod.LOGGER.debug("Fetching entity data of {}", (Object)entity);
                    this.queryHandler.queryEntityNbt((int)entityId, future::complete);
                });
                return future;
            }));
        }
        return Optional.empty();
    }

    public Optional<CompletableFuture<@Nullable class_2487>> fetchBlockEntity(class_2586 blockEntity) {
        if (ServerDataSyncer.hasEnoughPermission()) {
            return Optional.of(this.syncBlockEntityPos.computeIfAbsent(blockEntity.method_11016(), pos -> {
                CompletableFuture future = new CompletableFuture();
                this.runOrEnqueueTask(() -> {
                    TweakerMoreMod.LOGGER.debug("Syncing block entity data at {}", pos);
                    this.queryHandler.queryBlockNbt(blockEntity.method_11016(), future::complete);
                });
                return future;
            }));
        }
        return Optional.empty();
    }

    public CompletableFuture<Void> syncEntity(class_1297 entity, boolean syncMotionState) {
        Optional<CompletableFuture<class_2487>> opt = this.fetchEntity(entity);
        if (opt.isPresent()) {
            return opt.get().thenAccept(nbt -> {
                block5: {
                    if (nbt != null) {
                        EntityMotionStateRestorer restorer = null;
                        if (!syncMotionState) {
                            restorer = new EntityMotionStateRestorer(entity);
                        }
                        try {
                            entity.method_5651(nbt);
                            if (restorer != null) {
                                restorer.restore();
                            }
                            TweakerMoreMod.LOGGER.debug("Synced entity data of {}", (Object)entity);
                        }
                        catch (Exception exception) {
                            TweakerMoreMod.LOGGER.warn("Failed to sync entity data of {}: {}", (Object)entity, (Object)exception);
                            if (!TweakerMoreConfigs.TWEAKERMORE_DEBUG_MODE.getBooleanValue()) break block5;
                            TweakerMoreMod.LOGGER.warn("[TweakerMore Debug] ServerDataSyncer#syncEntity", (Throwable)exception);
                        }
                    }
                }
            });
        }
        return CompletableFuture.allOf(new CompletableFuture[0]);
    }

    public CompletableFuture<Void> syncEntity(class_1297 entity) {
        return this.syncEntity(entity, true);
    }

    public CompletableFuture<Void> syncBlockEntity(class_2586 blockEntity) {
        if (ServerDataSyncer.hasEnoughPermission()) {
            Optional<CompletableFuture<class_2487>> opt = this.fetchBlockEntity(blockEntity);
            class_1937 world = blockEntity.method_10997();
            if (opt.isPresent() && world != null) {
                return opt.get().thenAccept(nbt -> {
                    block3: {
                        if (nbt != null) {
                            class_2338 pos = blockEntity.method_11016();
                            try {
                                blockEntity.method_58690(nbt, (class_7225.class_7874)blockEntity.method_10997().method_30349());
                                TweakerMoreMod.LOGGER.debug("Synced block entity data at {}", (Object)pos);
                            }
                            catch (Exception exception) {
                                TweakerMoreMod.LOGGER.warn("Failed to sync block entity data at {}: {}", (Object)pos, (Object)exception);
                                if (!TweakerMoreConfigs.TWEAKERMORE_DEBUG_MODE.getBooleanValue()) break block3;
                                TweakerMoreMod.LOGGER.warn("[TweakerMore Debug] ServerDataSyncer#syncBlockEntity", (Throwable)exception);
                            }
                        }
                    }
                });
            }
        }
        return CompletableFuture.allOf(new CompletableFuture[0]);
    }

    public CompletableFuture<Void> syncBlockEntityAt(class_2338 pos) {
        class_638 world;
        class_2586 blockEntity;
        class_310 mc = class_310.method_1551();
        if (ServerDataSyncer.hasEnoughPermission() && mc.field_1724 != null && (blockEntity = (world = mc.field_1724.field_17892).method_8321(pos)) != null && pos.equals((Object)blockEntity.method_11016())) {
            return this.syncBlockEntity(blockEntity);
        }
        return CompletableFuture.allOf(new CompletableFuture[0]);
    }

    public CompletableFuture<Void> syncBlockInventory(class_1263 inventory) {
        if (inventory instanceof class_2586) {
            return this.syncBlockEntity((class_2586)inventory);
        }
        if (inventory instanceof class_1258) {
            DoubleInventoryAccessor accessor = (DoubleInventoryAccessor)inventory;
            return CompletableFuture.allOf(this.syncBlockInventory(accessor.getFirst()), this.syncBlockInventory(accessor.getSecond()));
        }
        return CompletableFuture.allOf(new CompletableFuture[0]);
    }

    public CompletableFuture<Void> syncEverything(TargetPair pair, ProgressCallback callback) {
        AtomicInteger beCounter = new AtomicInteger(0);
        AtomicInteger entityCounter = new AtomicInteger(0);
        CompletableFuture<Void> beSynced = CompletableFuture.allOf((CompletableFuture[])pair.getBlockEntityPositions().stream().map(this::syncBlockEntityAt).map(f -> f.thenRun(() -> callback.apply(beCounter.addAndGet(1), entityCounter.get()))).toArray(CompletableFuture[]::new));
        CompletableFuture<Void> entitySynced = CompletableFuture.allOf((CompletableFuture[])pair.getEntities().stream().map(this::syncEntity).map(f -> f.thenRun(() -> callback.apply(beCounter.get(), entityCounter.addAndGet(1)))).toArray(CompletableFuture[]::new));
        return CompletableFuture.allOf(beSynced, entitySynced);
    }

    @FunctionalInterface
    public static interface ProgressCallback {
        public void apply(int var1, int var2);
    }
}

