/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.mc_tweaks.shulkerBoxItemContentHint;

import java.util.Optional;
import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;
import me.fallenbreath.tweakermore.impl.mc_tweaks.shulkerBoxItemContentHint.ShulkerBoxItemContentHintRenderer;
import me.fallenbreath.tweakermore.util.InventoryUtil;
import me.fallenbreath.tweakermore.util.ItemUtil;
import net.minecraft.class_1799;
import net.minecraft.class_2371;

public class ShulkerBoxItemContentHintCommon {
    public static Info prepareInformation(class_1799 itemStack) {
        Info info = new Info();
        info.enabled = false;
        if (!TweakerMoreConfigs.SHULKER_BOX_ITEM_CONTENT_HINT.getBooleanValue()) {
            return info;
        }
        if (ShulkerBoxItemContentHintRenderer.isRendering.get().booleanValue()) {
            return info;
        }
        if (!ItemUtil.isShulkerBox(itemStack.method_7909())) {
            return info;
        }
        Optional<class_2371<class_1799>> stackList = InventoryUtil.getStoredItems(itemStack);
        if (!stackList.isPresent()) {
            return info;
        }
        class_1799 std = null;
        info.allItemSame = true;
        info.allItemSameIgnoreNbt = true;
        for (class_1799 stack : stackList.get()) {
            if (stack.method_7960()) continue;
            if (std == null) {
                std = stack;
                continue;
            }
            boolean itemEqual = class_1799.method_7984((class_1799)stack, (class_1799)std);
            boolean itemAndNbtEqual = class_1799.method_31577((class_1799)stack, (class_1799)std);
            if (!itemAndNbtEqual) {
                info.allItemSame = false;
            }
            if (itemEqual) continue;
            info.allItemSameIgnoreNbt = false;
        }
        if (std == null) {
            return info;
        }
        info.stack = std;
        info.scale = TweakerMoreConfigs.SHULKER_BOX_ITEM_CONTENT_HINT_SCALE.getDoubleValue();
        if (info.scale <= 0.0) {
            return info;
        }
        info.enabled = true;
        info.fillRatio = -1.0;
        int slotAmount = InventoryUtil.getInventorySlotAmount(itemStack);
        if (slotAmount != -1) {
            double sum = 0.0;
            for (class_1799 stack : stackList.get()) {
                sum += 1.0 * (double)stack.method_7947() / (double)stack.method_7914();
            }
            double ratio = sum / (double)slotAmount;
            if (ratio >= 0.0 && ratio <= 1.0) {
                info.fillRatio = ratio;
            }
        }
        return info;
    }

    public static class Info {
        public boolean enabled;
        public boolean allItemSame;
        public boolean allItemSameIgnoreNbt;
        public double scale;
        public class_1799 stack;
        public double fillRatio;
    }
}

