/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.features.infoView.cache;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import me.fallenbreath.tweakermore.util.PositionUtil;
import me.fallenbreath.tweakermore.util.render.RenderUtil;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;

public class ScanningCache {
    private final Map<Double, class_239> rayTraceCache = Maps.newHashMap();
    private final Map<BeamKey, Collection<class_2338>> beamCache = Maps.newHashMap();
    private final Map<Pair<class_243, class_243>, Collection<class_2338>> boxCache = Maps.newHashMap();
    private final Map<Pair<class_243, Double>, Collection<class_2338>> sphereCache = Maps.newHashMap();

    @Nullable
    public class_239 crossHairTarget(double reach) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null) {
            return null;
        }
        return this.rayTraceCache.computeIfAbsent(reach, k -> mc.field_1724.method_5745(reach, RenderUtil.tickDelta, false));
    }

    @Nullable
    public class_2338 crossHairTargetBlock(double reach) {
        class_239 hitResult = this.crossHairTarget(reach);
        return hitResult instanceof class_3965 ? ((class_3965)hitResult).method_17777() : null;
    }

    public Collection<class_2338> beam(class_243 startPos, class_243 endPos, double coneAngle, PositionUtil.BeamMode mode) {
        BeamKey key = new BeamKey(startPos, endPos, coneAngle, mode);
        return this.beamCache.computeIfAbsent(key, k -> PositionUtil.beam(startPos, endPos, coneAngle, mode));
    }

    public Collection<class_2338> box(class_243 center, double radius) {
        return this.box(center.method_1031(-radius, -radius, -radius), center.method_1031(radius, radius, radius));
    }

    public Collection<class_2338> box(class_243 pos1, class_243 pos2) {
        return this.boxCache.computeIfAbsent((Pair<class_243, class_243>)Pair.of((Object)pos1, (Object)pos2), k -> {
            ArrayList result = Lists.newArrayList();
            for (class_2338 pos : class_2338.method_10097((class_2338)PositionUtil.floored(pos1), (class_2338)PositionUtil.floored(pos2))) {
                result.add(pos.method_10062());
            }
            return result;
        });
    }

    public Collection<class_2338> sphere(class_243 center, double radius) {
        return this.sphereCache.computeIfAbsent((Pair<class_243, Double>)Pair.of((Object)center, (Object)radius), k -> this.box(center, radius).stream().filter(pos -> PositionUtil.centerOf(pos).method_1025(center) <= radius * radius).collect(Collectors.toList()));
    }

    private static class BeamKey {
        private final class_243 startPos;
        private final class_243 endPos;
        private final double coneAngle;
        private final PositionUtil.BeamMode mode;

        private BeamKey(class_243 startPos, class_243 endPos, double coneAngle, PositionUtil.BeamMode mode) {
            this.startPos = startPos;
            this.endPos = endPos;
            this.coneAngle = coneAngle;
            this.mode = mode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BeamKey key = (BeamKey)o;
            return Double.compare(this.coneAngle, key.coneAngle) == 0 && Objects.equals(this.startPos, key.startPos) && Objects.equals(this.endPos, key.endPos) && this.mode == key.mode;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.startPos, this.endPos, this.coneAngle, this.mode});
        }
    }
}

