/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.features.infoView;

import com.google.common.collect.Maps;
import fi.dy.masa.malilib.config.IConfigBoolean;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;
import me.fallenbreath.tweakermore.config.options.TweakerMoreConfigOptionList;
import me.fallenbreath.tweakermore.config.options.listentries.InfoViewRenderStrategy;
import me.fallenbreath.tweakermore.config.options.listentries.InfoViewTargetStrategy;
import me.fallenbreath.tweakermore.impl.features.infoView.AbstractInfoViewer;
import me.fallenbreath.tweakermore.impl.features.infoView.InfoViewer;
import me.fallenbreath.tweakermore.impl.features.infoView.cache.RenderVisitorWorldView;
import me.fallenbreath.tweakermore.impl.features.infoView.cache.ScanningCache;
import me.fallenbreath.tweakermore.util.PositionUtil;
import me.fallenbreath.tweakermore.util.render.context.RenderContext;
import net.minecraft.class_2338;
import net.minecraft.class_243;

public abstract class CommonScannerInfoViewer
extends AbstractInfoViewer {
    protected final Supplier<InfoViewTargetStrategy> targetStrategySupplier;

    public CommonScannerInfoViewer(IConfigBoolean switchConfig, Supplier<InfoViewRenderStrategy> renderStrategySupplier, Supplier<InfoViewTargetStrategy> targetStrategySupplier) {
        super(switchConfig, renderStrategySupplier);
        this.targetStrategySupplier = targetStrategySupplier;
    }

    public CommonScannerInfoViewer(IConfigBoolean switchConfig, TweakerMoreConfigOptionList renderStrategyOption, TweakerMoreConfigOptionList targetStrategyOption) {
        this(switchConfig, renderStrategyOption, () -> (InfoViewTargetStrategy)targetStrategyOption.getOptionListValue());
    }

    public CommonScannerInfoViewer(IConfigBoolean switchConfig, TweakerMoreConfigOptionList renderStrategyOption, Supplier<InfoViewTargetStrategy> targetStrategySupplier) {
        super(switchConfig, renderStrategyOption);
        this.targetStrategySupplier = targetStrategySupplier;
    }

    @Override
    public Map<class_2338, InfoViewer.Renderer> scanForRender(ScanningCache cache, class_243 camPos, class_243 camVec) {
        double reach = TweakerMoreConfigs.INFO_VIEW_TARGET_DISTANCE.getDoubleValue();
        double angle = Math.PI * TweakerMoreConfigs.INFO_VIEW_BEAM_ANGLE.getDoubleValue() / 2.0 / 180.0;
        class_2338 crossHairPos = cache.crossHairTargetBlock(reach);
        HashMap result = Maps.newHashMap();
        Runnable addCrossHair = () -> {
            if (crossHairPos != null) {
                result.put(crossHairPos, this.getRendererFor(true));
            }
        };
        switch (this.targetStrategySupplier.get()) {
            case POINTED: {
                addCrossHair.run();
                break;
            }
            case BEAM: {
                class_243 beamEnd = camPos.method_1019(camVec.method_1029().method_1021(reach));
                for (class_2338 blockPos : cache.beam(camPos, beamEnd, angle, PositionUtil.BeamMode.BEAM)) {
                    result.put(blockPos, this.getRendererFor(false));
                }
                addCrossHair.run();
                break;
            }
            case RANGE: {
                for (class_2338 pos : cache.sphere(camPos, reach)) {
                    if (!(PositionUtil.centerOf(pos).method_1019(camPos.method_22882()).method_1026(camVec) > 0.0)) continue;
                    result.put(pos, this.getRendererFor(pos.equals((Object)crossHairPos)));
                }
                break;
            }
        }
        return result;
    }

    private InfoViewer.Renderer getRendererFor(boolean isCrossHairPos) {
        return (context, world, pos) -> this.render(context, world, pos, isCrossHairPos);
    }

    protected abstract void render(RenderContext var1, RenderVisitorWorldView var2, class_2338 var3, boolean var4);
}

