/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.config.migration;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import fi.dy.masa.malilib.util.JsonUtils;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_156;

public class ConfigRenameMigration {
    private static final BiMap<String, String> CONFIG_NAME_MAPPER = (BiMap)class_156.method_654((Object)HashBiMap.create(), map -> {
        Lists.newArrayList((Object[])new String[]{"tweakmAutoCleanContainer", "tweakmAutoCleanContainerListType", "tweakmAutoCleanContainerWhiteList", "tweakmAutoCleanContainerBlackList", "tweakmAutoCollectMaterialListItem", "tweakmAutoFillContainer", "tweakmAutoPickSchematicBlock", "tweakmAutoPutBackExistedItem", "tweakmAutoVillagerTradeFavorites", "tweakmContainerProcessorHint", "tweakmContainerProcessorHintPos", "tweakmContainerProcessorHintScale", "tweakmInfoView", "tweakmSchematicProPlace", "tweakmSafeAfk", "tweakmSchematicBlockPlacementRestriction", "tweakmSchematicBlockPlacementRestrictionHint", "tweakmSchematicBlockPlacementRestrictionItemWhitelist", "tweakmSchematicBlockPlacementRestrictionMargin", "tweakmSchematicBlockPlacementRestrictionCheckFacing", "tweakmSchematicBlockPlacementRestrictionCheckSlab", "tweakmSchematicBlockPlacementRestrictionStrict", "tweakmDaytimeOverride", "tweakmFakeNightVision", "tweakmFlawlessFrames", "tweakmUnlimitedBlockEntityRenderDistance", "tweakmUnlimitedEntityRenderDistance", "tweakmWeatherOverride"}).forEach(oldName -> {
            Object newName = oldName.replaceFirst("^tweakm", "");
            newName = ((String)newName).substring(0, 1).toLowerCase() + ((String)newName).substring(1);
            map.put(oldName, newName);
        });
        Lists.newArrayList((Object[])new String[]{"shulkerItemContentHint", "shulkerItemContentHintScale", "shulkerTooltipEnchantmentHint", "shulkerTooltipFillLevelHint", "shulkerTooltipHintLengthLimit", "shulkerTooltipPotionInfoHint"}).forEach(oldName -> {
            String newName = oldName.replaceFirst("^shulker", "shulkerBox");
            map.put(oldName, (Object)newName);
        });
    });

    public static Optional<String> oldToNew(String oldConfigName) {
        return Optional.ofNullable((String)CONFIG_NAME_MAPPER.get((Object)oldConfigName));
    }

    public static Optional<String> newToOld(String newConfigName) {
        return Optional.ofNullable((String)CONFIG_NAME_MAPPER.inverse().get((Object)newConfigName));
    }

    public static void patchConfig(JsonObject root, List<String> keys) {
        for (String key : keys) {
            JsonObject obj = JsonUtils.getNestedObject((JsonObject)root, (String)key, (boolean)false);
            if (obj == null) continue;
            CONFIG_NAME_MAPPER.forEach((oldName, newName) -> {
                if (obj.has(oldName) && !obj.has(newName)) {
                    obj.add(newName, obj.get(oldName));
                }
            });
        }
    }
}

