/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.util;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.EncoderException;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCounted;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.UUID;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_4076;

public class GSEncodeBuffer
implements ReferenceCounted {
    static final int BIT_SIZE_X = 26;
    static final int BIT_SIZE_Z = 26;
    static final int BIT_SIZE_Y = 12;
    static final int BIT_SHIFT_Y = 0;
    static final int BIT_SHIFT_Z = 12;
    static final int BIT_SHIFT_X = 38;
    private static final long BIT_MASK_X = 0x3FFFFFFL;
    private static final long BIT_MASK_Y = 4095L;
    private static final long BIT_MASK_Z = 0x3FFFFFFL;
    static final int BIT_SIZE_SECTION_X = 22;
    static final int BIT_SIZE_SECTION_Z = 22;
    static final int BIT_SIZE_SECTION_Y = 20;
    static final int BIT_SHIFT_SECTION_Y = 0;
    static final int BIT_SHIFT_SECTION_Z = 20;
    static final int BIT_SHIFT_SECTION_X = 42;
    private static final long BIT_MASK_SECTION_X = 0x3FFFFFL;
    private static final long BIT_MASK_SECTION_Y = 1048575L;
    private static final long BIT_MASK_SECTION_Z = 0x3FFFFFL;
    private final ByteBuf buffer;

    private GSEncodeBuffer(ByteBuf buffer) {
        this.buffer = buffer;
    }

    public void writeBoolean(boolean value) {
        this.buffer.writeBoolean(value);
    }

    public void writeByte(byte value) {
        this.buffer.writeByte((int)value);
    }

    public void writeBytes(byte[] src) {
        this.writeBytes(src, src.length);
    }

    public void writeBytes(byte[] src, int length) {
        this.writeBytes(src, 0, length);
    }

    public void writeBytes(byte[] src, int srcOffset, int length) {
        this.buffer.writeBytes(src, srcOffset, length);
    }

    public void writeBytes(ByteBuf src) {
        this.buffer.writeBytes(src);
    }

    public void writeBytes(ByteBuffer src) {
        this.buffer.writeBytes(src);
    }

    public void writeZero(int length) {
        this.buffer.writeZero(length);
    }

    public void writeShort(short value) {
        this.buffer.writeShort((int)value);
    }

    public void writeMedium(int value) {
        this.buffer.writeMedium(value);
    }

    public void writeInt(int value) {
        this.buffer.writeInt(value);
    }

    public void writeLong(long value) {
        this.buffer.writeLong(value);
    }

    public void writeFloat(float value) {
        this.buffer.writeFloat(value);
    }

    public void writeDouble(double value) {
        this.buffer.writeDouble(value);
    }

    public void writeUnsignedByte(short value) {
        this.buffer.writeByte((int)value);
    }

    public void writeUnsignedShort(int value) {
        this.buffer.writeShort(value);
    }

    public void writeUnsignedMedium(int value) {
        this.buffer.writeMedium(value);
    }

    public void writeUnsignedInt(long value) {
        this.buffer.writeInt((int)value);
    }

    private void writeVarInt(int value) {
        while (true) {
            if ((value & 0xFFFFFF80) == 0) {
                this.writeByte((byte)value);
                return;
            }
            this.writeByte((byte)(value & 0x7F | 0x80));
            value >>>= 7;
        }
    }

    public void writeByteArray(byte[] arr) {
        this.writeVarInt(arr.length);
        this.writeBytes(arr);
    }

    public void writeShortArray(short[] arr) {
        this.writeVarInt(arr.length);
        for (int i = 0; i < arr.length; ++i) {
            this.writeShort(arr[i]);
        }
    }

    public void writeIntArray(int[] arr) {
        this.writeVarInt(arr.length);
        for (int i = 0; i < arr.length; ++i) {
            this.writeInt(arr[i]);
        }
    }

    public void writeLongArray(long[] arr) {
        this.writeVarInt(arr.length);
        for (int i = 0; i < arr.length; ++i) {
            this.writeLong(arr[i]);
        }
    }

    public void writeString(String str) {
        this.writeString(str, Short.MAX_VALUE);
    }

    public void writeString(String str, int lengthLimit) {
        this.writeString(str, CharsetUtil.UTF_8, lengthLimit);
    }

    public void writeString(String str, Charset charset) {
        this.writeString(str, charset, Short.MAX_VALUE);
    }

    public void writeString(String str, Charset charset, int encodedLimit) {
        byte[] buf = str.getBytes(charset);
        if (buf.length > encodedLimit) {
            throw new EncoderException("encoded length exceeds limit");
        }
        this.writeVarInt(buf.length);
        this.writeBytes(buf);
    }

    public void writeIdentifier(class_2960 value) {
        this.writeString(value.toString());
    }

    public void writeUUID(UUID value) {
        this.writeLong(value.getMostSignificantBits());
        this.writeLong(value.getLeastSignificantBits());
    }

    public void writeBlockPos(class_2338 value) {
        this.writeBlockPos(value.method_10263(), value.method_10264(), value.method_10260());
    }

    private void writeBlockPos(int x, int y, int z) {
        long value = 0L;
        value |= ((long)x & 0x3FFFFFFL) << 38;
        value |= ((long)y & 0xFFFL) << 0;
        this.writeLong(value |= ((long)z & 0x3FFFFFFL) << 12);
    }

    public void writeChunkPos(class_1923 value) {
        this.writeInt(value.field_9180);
        this.writeInt(value.field_9181);
    }

    public void writeChunkSectionPos(class_4076 value) {
        this.writeChunkSectionPos(value.method_18674(), value.method_18683(), value.method_18687());
    }

    private void writeChunkSectionPos(int x, int y, int z) {
        long value = 0L;
        value |= ((long)x & 0x3FFFFFL) << 42;
        value |= ((long)y & 0xFFFFFL) << 0;
        this.writeLong(value |= ((long)z & 0x3FFFFFL) << 20);
    }

    public void setBoolean(int location, boolean value) {
        this.buffer.setBoolean(location, value);
    }

    public void setByte(int location, byte value) {
        this.buffer.setByte(location, (int)value);
    }

    public void setBytes(int location, byte[] src) {
        this.setBytes(location, src, src.length);
    }

    public void setBytes(int location, byte[] src, int length) {
        this.setBytes(location, src, 0, length);
    }

    public void setBytes(int location, byte[] src, int srcOffset, int length) {
        this.buffer.setBytes(location, src, srcOffset, length);
    }

    public void setShort(int location, short value) {
        this.buffer.setShort(location, (int)value);
    }

    public void setMedium(int location, int value) {
        this.buffer.setMedium(location, value);
    }

    public void setInt(int location, int value) {
        this.buffer.setInt(location, value);
    }

    public void setLong(int location, long value) {
        this.buffer.setLong(location, value);
    }

    public void setFloat(int location, float value) {
        this.buffer.setFloat(location, value);
    }

    public void setDouble(int location, double value) {
        this.buffer.setDouble(location, value);
    }

    public void setUnsignedByte(int location, short value) {
        this.buffer.setByte(location, (int)value);
    }

    public void setUnsignedShort(int location, int value) {
        this.buffer.setShort(location, value);
    }

    public void setUnsignedMedium(int location, int value) {
        this.buffer.setMedium(location, value);
    }

    public void setUnsignedInt(int location, long value) {
        this.buffer.setInt(location, (int)value);
    }

    public int writableBytes() {
        return this.buffer.writableBytes();
    }

    public boolean isWritable() {
        return this.buffer.isWritable();
    }

    public boolean isWritable(int size) {
        return this.buffer.isWritable(size);
    }

    public int getLocation() {
        return this.buffer.writerIndex();
    }

    public void setLocation(int location) {
        this.buffer.writerIndex(location);
    }

    public void markLocation() {
        this.buffer.markWriterIndex();
    }

    public void resetLocation() {
        this.buffer.resetWriterIndex();
    }

    public int refCnt() {
        return this.buffer.refCnt();
    }

    public GSEncodeBuffer retain() {
        return new GSEncodeBuffer(this.buffer.retain());
    }

    public GSEncodeBuffer retain(int increment) {
        return new GSEncodeBuffer(this.buffer.retain(increment));
    }

    public GSEncodeBuffer touch() {
        this.buffer.touch();
        return this;
    }

    public GSEncodeBuffer touch(Object hint) {
        this.buffer.touch(hint);
        return this;
    }

    public boolean release() {
        return this.buffer.release();
    }

    public boolean release(int decrement) {
        return this.buffer.release(decrement);
    }

    public ByteBuf getBuffer() {
        return this.buffer;
    }

    public static GSEncodeBuffer wrap(ByteBuf buffer) {
        return new GSEncodeBuffer(buffer);
    }
}

