/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.setting;

import com.g4mesoft.G4mespeedMod;
import com.g4mesoft.gui.setting.GSBooleanSettingPanel;
import com.g4mesoft.gui.setting.GSFloatSettingPanel;
import com.g4mesoft.gui.setting.GSIntegerSettingPanel;
import com.g4mesoft.setting.GSISettingChangeListener;
import com.g4mesoft.setting.GSISettingDecoder;
import com.g4mesoft.setting.GSISettingPanelSupplier;
import com.g4mesoft.setting.GSSetting;
import com.g4mesoft.setting.GSSettingCategory;
import com.g4mesoft.setting.GSSettingMap;
import com.g4mesoft.setting.decoder.GSBooleanSettingDecoder;
import com.g4mesoft.setting.decoder.GSFloatSettingDecoder;
import com.g4mesoft.setting.decoder.GSIntegerSettingDecoder;
import com.g4mesoft.setting.decoder.GSStringSettingDecoder;
import com.g4mesoft.setting.types.GSUnknownSetting;
import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import com.g4mesoft.util.GSFileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class GSSettingManager {
    static final String UNKNOWN_SETTING_TYPE = "UNKN";
    private static final byte CATEGORY_ENTRY_CODE = 85;
    protected final Map<GSSettingCategory, GSSettingMap> settings = new LinkedHashMap<GSSettingCategory, GSSettingMap>();
    private final List<GSISettingChangeListener> listeners = new ArrayList<GSISettingChangeListener>();
    private static final Map<String, GSISettingDecoder<?>> typeToDecoder = Collections.synchronizedMap(new HashMap());
    private static final Map<Class<? extends GSSetting<?>>, GSISettingDecoder<?>> clazzToDecoder = Collections.synchronizedMap(new IdentityHashMap());
    private static final Map<Class<? extends GSSetting<?>>, GSISettingPanelSupplier<?>> panelSuppliers = Collections.synchronizedMap(new HashMap());

    private static void registerDefaultTypes() {
        GSSettingManager.registerType(new GSBooleanSettingDecoder(), GSBooleanSettingPanel::new);
        GSSettingManager.registerType(new GSFloatSettingDecoder(), GSFloatSettingPanel::new);
        GSSettingManager.registerType(new GSIntegerSettingDecoder(), GSIntegerSettingPanel::new);
        GSSettingManager.registerDecoder(new GSStringSettingDecoder());
    }

    public static <T extends GSSetting<?>> void registerType(GSISettingDecoder<T> decoder, GSISettingPanelSupplier<T> panelSupplier) {
        if (panelSupplier == null) {
            throw new IllegalArgumentException("panelSupplier is null");
        }
        GSSettingManager.registerDecoder(decoder);
        panelSuppliers.put(decoder.getSettingClass(), panelSupplier);
    }

    public static <T extends GSSetting<?>> void registerDecoder(GSISettingDecoder<T> decoder) {
        String type = decoder.getTypeString();
        Class<T> clazz = decoder.getSettingClass();
        if (type == null || clazz == null) {
            throw new NullPointerException("Decoder type-name or setting class is null");
        }
        if (UNKNOWN_SETTING_TYPE.equals(type) || typeToDecoder.containsKey(type)) {
            throw new RuntimeException("A decoder with type-name \"" + type + "\" already exists.");
        }
        if (clazz == GSUnknownSetting.class || clazzToDecoder.containsKey(clazz)) {
            throw new RuntimeException("A decoder for setting class \"" + String.valueOf(clazz) + "\" already exists.");
        }
        typeToDecoder.put(type, decoder);
        clazzToDecoder.put(clazz, decoder);
    }

    public static GSISettingDecoder<?> getDecoder(String type) {
        return typeToDecoder.get(type);
    }

    public static <T extends GSSetting<?>> GSISettingDecoder<T> getDecoder(T setting) {
        GSISettingDecoder<?> decoder = clazzToDecoder.get(setting.getClass());
        return decoder;
    }

    public static <T extends GSSetting<?>> GSISettingPanelSupplier<T> getPanelSupplier(T setting) {
        GSISettingPanelSupplier<?> supplier = panelSuppliers.get(setting.getClass());
        return supplier;
    }

    public void loadSettings(File settingsFile) {
        try {
            GSFileUtil.readFile(settingsFile, buf -> {
                this.readSettings(buf);
                return GSFileUtil.IGNORE;
            });
        }
        catch (IOException e) {
            G4mespeedMod.GS_LOGGER.warn("Unable to load settings file '{}'", (Object)e.getMessage());
        }
    }

    public void saveSettings(File settingsFile) {
        try {
            GSFileUtil.writeFile(settingsFile, GSFileUtil.IGNORE, (buf, ignore) -> this.writeSettings(buf));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void readSettings(GSDecodeBuffer buf) throws IOException {
        while (buf.isReadable()) {
            if (buf.readByte() != 85) continue;
            GSSettingCategory category = new GSSettingCategory(buf.readString());
            GSSettingMap map = this.settings.get(category);
            if (map == null) {
                map = new GSSettingMap(category, this);
                this.settings.put(category, map);
            }
            map.readSettings(buf);
        }
    }

    public void writeSettings(GSEncodeBuffer buf) throws IOException {
        for (GSSettingMap map : this.settings.values()) {
            GSSettingCategory category = map.getCategory();
            buf.writeByte((byte)85);
            buf.writeString(category.getName());
            map.writeSettings(buf);
        }
    }

    public boolean isRegistered(GSSettingCategory category, String name) {
        GSSettingMap categorySettings = this.settings.get(category);
        return categorySettings != null && categorySettings.isRegistered(name);
    }

    public GSSetting<?> getSetting(GSSettingCategory category, String name) {
        GSSettingMap categorySettings = this.settings.get(category);
        return categorySettings != null ? categorySettings.getSetting(name) : null;
    }

    public void registerSetting(GSSettingCategory category, GSSetting<?> setting) {
        if (setting == null) {
            throw new IllegalArgumentException("setting is null");
        }
        GSSettingMap categorySettings = this.settings.get(category);
        if (categorySettings == null) {
            categorySettings = new GSSettingMap(category, this);
            this.settings.put(category, categorySettings);
        }
        categorySettings.registerSetting(setting);
    }

    public void registerSettings(GSSettingCategory category, GSSetting<?> ... settingArgs) {
        GSSettingMap categorySettings = this.settings.get(category);
        if (categorySettings == null) {
            categorySettings = new GSSettingMap(category, this);
            this.settings.put(category, categorySettings);
        }
        for (GSSetting<?> setting : settingArgs) {
            if (setting == null) continue;
            categorySettings.registerSetting(setting);
        }
    }

    public void removeSetting(GSSettingCategory category, String name) {
        GSSettingMap categorySettings = this.settings.get(category);
        if (categorySettings != null) {
            categorySettings.removeSetting(name);
        }
    }

    public GSSettingMap getSettings(GSSettingCategory category) {
        return this.settings.get(category);
    }

    public Collection<GSSettingMap> getSettings() {
        return Collections.unmodifiableCollection(this.settings.values());
    }

    public boolean hasCategory(GSSettingCategory category) {
        return this.settings.containsKey(category);
    }

    public void clearSettings() {
        for (GSSettingMap settingMap : this.settings.values()) {
            settingMap.clearSettings();
        }
        this.settings.clear();
    }

    public void resetSettings() {
        for (GSSettingMap settingMap : this.settings.values()) {
            settingMap.resetSettings();
        }
    }

    public boolean isDisjoint(GSSettingManager other) {
        for (Map.Entry<GSSettingCategory, GSSettingMap> entry : this.settings.entrySet()) {
            GSSettingMap settingMap = other.getSettings(entry.getKey());
            if (settingMap == null || entry.getValue().isDisjoint(settingMap)) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        for (GSSettingMap settingMap : this.settings.values()) {
            if (settingMap.isEmpty()) continue;
            return false;
        }
        return true;
    }

    void settingChanged(GSSettingCategory category, GSSetting<?> setting) {
        for (GSISettingChangeListener listener : this.listeners) {
            listener.onSettingChanged(category, setting);
        }
    }

    void settingAdded(GSSettingCategory category, GSSetting<?> setting) {
        for (GSISettingChangeListener listener : this.listeners) {
            listener.onSettingAdded(category, setting);
        }
    }

    void settingRemoved(GSSettingCategory category, GSSetting<?> setting) {
        for (GSISettingChangeListener listener : this.listeners) {
            listener.onSettingRemoved(category, setting);
        }
    }

    public void addChangeListener(GSISettingChangeListener changeListener) {
        if (changeListener == null) {
            throw new IllegalArgumentException("changeListener is null!");
        }
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(GSISettingChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    static {
        GSSettingManager.registerDefaultTypes();
    }
}

