/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.setting;

import com.g4mesoft.core.client.GSClientController;
import com.g4mesoft.core.server.GSServerController;
import com.g4mesoft.packet.GSIPacket;
import com.g4mesoft.setting.GSISettingDecoder;
import com.g4mesoft.setting.GSRemoteSettingManager;
import com.g4mesoft.setting.GSSetting;
import com.g4mesoft.setting.GSSettingCategory;
import com.g4mesoft.setting.GSSettingManager;
import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import java.io.IOException;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3222;

public class GSSettingChangePacket
implements GSIPacket {
    private GSSettingCategory category;
    private GSSetting<?> setting;
    private GSESettingChangeType type;

    public GSSettingChangePacket() {
    }

    public GSSettingChangePacket(GSSettingCategory category, GSSetting<?> setting, GSESettingChangeType type) {
        this.category = category;
        this.setting = setting;
        this.type = type;
    }

    @Override
    public void read(GSDecodeBuffer buf) throws IOException {
        this.category = GSSettingCategory.read(buf);
        this.type = GSESettingChangeType.fromIndex(buf.readUnsignedByte());
        String decoderType = buf.readString(16);
        String settingName = buf.readString();
        GSISettingDecoder<String> decoder = GSSettingManager.getDecoder(decoderType);
        if (decoder == null) {
            throw new IOException("No valid decoder found");
        }
        this.setting = decoder.decodeSetting(settingName, buf);
    }

    @Override
    public void write(GSEncodeBuffer buf) throws IOException {
        GSISettingDecoder<GSSetting<?>> decoder = GSSettingManager.getDecoder(this.setting);
        if (decoder == null) {
            throw new IOException("No valid decoder found");
        }
        this.category.write(buf);
        buf.writeUnsignedByte((short)this.type.getIndex());
        buf.writeString(decoder.getTypeString(), 16);
        buf.writeString(this.setting.getName());
        decoder.encodeSetting(buf, this.setting);
    }

    @Override
    public void handleOnServer(GSServerController controller, class_3222 player) {
        if (this.type != GSESettingChangeType.SETTING_CHANGED) {
            return;
        }
        if (controller.isAllowedSettingChange(player)) {
            GSSetting<?> currentSetting;
            GSSettingManager settingManager = controller.getGlobalSettingManager();
            if (!settingManager.isRegistered(this.category, this.setting.getName())) {
                settingManager = controller.getWorldSettingManager();
            }
            if ((currentSetting = settingManager.getSetting(this.category, this.setting.getName())) != null && currentSetting.isActive() && currentSetting.isVisibleInGui() && currentSetting.isEnabledInGui()) {
                currentSetting.setIfSameType(this.setting);
            }
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void handleOnClient(GSClientController controller) {
        GSRemoteSettingManager remoteSettings = controller.getServerSettings();
        switch (this.type.ordinal()) {
            case 0: {
                remoteSettings.onRemoteSettingChanged(this.category, this.setting);
                break;
            }
            case 1: {
                remoteSettings.onRemoteSettingAdded(this.category, this.setting);
                break;
            }
            case 2: {
                remoteSettings.onRemoteSettingRemoved(this.category, this.setting);
            }
        }
    }

    public static enum GSESettingChangeType {
        SETTING_CHANGED(0),
        SETTING_ADDED(1),
        SETTING_REMOVED(2);

        private final int index;

        private GSESettingChangeType(int index) {
            this.index = index;
        }

        public static GSESettingChangeType fromIndex(int index) {
            switch (index) {
                case 0: {
                    return SETTING_CHANGED;
                }
                case 1: {
                    return SETTING_ADDED;
                }
                case 2: {
                    return SETTING_REMOVED;
                }
            }
            return null;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

