/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.setting;

import com.g4mesoft.setting.GSSettingMap;
import java.util.Objects;

public abstract class GSSetting<T> {
    protected final String name;
    protected final T defaultValue;
    protected final boolean visibleInGui;
    private GSSettingMap settingOwner;
    private boolean active;
    private boolean enabledInGui;
    private boolean allowedChange;

    public GSSetting(String name, T defaultValue, boolean visibleInGui) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        this.name = name;
        this.defaultValue = defaultValue;
        this.visibleInGui = visibleInGui;
        this.settingOwner = null;
        this.active = true;
        this.enabledInGui = true;
        this.allowedChange = true;
    }

    public String getName() {
        return this.name;
    }

    void setSettingOwner(GSSettingMap changeListener) {
        if (changeListener != null && this.settingOwner != null) {
            throw new IllegalStateException("Change listener already set!");
        }
        this.settingOwner = changeListener;
    }

    protected void notifyOwnerChange() {
        if (this.settingOwner != null) {
            this.settingOwner.settingChanged(this);
        }
    }

    public abstract T get();

    public abstract GSSetting<T> set(T var1);

    public abstract boolean isDefault();

    public abstract boolean isSameType(GSSetting<?> var1);

    public boolean isSameSetting(GSSetting<?> other) {
        return this.isSameType(other) && Objects.equals(this.defaultValue, other.getDefault());
    }

    public abstract GSSetting<T> copySetting();

    public void reset() {
        this.set(this.defaultValue);
    }

    void setIfSameType(GSSetting<?> other) {
        if (this.isSameType(other)) {
            Object otherValue = other.get();
            this.set(otherValue);
        }
    }

    public T getDefault() {
        return this.defaultValue;
    }

    void setActive(boolean active) {
        this.active = active;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isVisibleInGui() {
        return this.visibleInGui;
    }

    public GSSetting<T> setEnabledInGui(boolean enabledInGui) {
        if (enabledInGui != this.enabledInGui) {
            this.enabledInGui = enabledInGui;
            this.notifyOwnerChange();
        }
        return this;
    }

    public boolean isEnabledInGui() {
        return this.enabledInGui;
    }

    public GSSetting<T> setAllowedChange(boolean allowedChange) {
        if (allowedChange != this.allowedChange) {
            this.allowedChange = allowedChange;
            this.notifyOwnerChange();
        }
        return this;
    }

    public boolean isAllowedChange() {
        return this.allowedChange;
    }
}

