/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.setting;

import com.g4mesoft.core.client.GSClientController;
import com.g4mesoft.setting.GSISettingChangeListener;
import com.g4mesoft.setting.GSSetting;
import com.g4mesoft.setting.GSSettingCategory;
import com.g4mesoft.setting.GSSettingChangePacket;
import com.g4mesoft.setting.GSSettingManager;
import com.g4mesoft.setting.GSSettingMap;

public class GSRemoteSettingManager
extends GSSettingManager {
    private final GSClientController controllerClient;
    private final GSSettingManager shadowSettings;
    private boolean shadowSettingChanging;
    private boolean remoteSettingChanging;
    private boolean allowedSettingChange;

    public GSRemoteSettingManager(GSClientController controllerClient) {
        this.controllerClient = controllerClient;
        this.shadowSettings = new GSSettingManager();
        this.shadowSettingChanging = false;
        this.remoteSettingChanging = false;
        this.allowedSettingChange = false;
        this.shadowSettings.addChangeListener(new GSISettingChangeListener(){

            @Override
            public void onSettingChanged(GSSettingCategory category, GSSetting<?> setting) {
                GSSetting<?> currentSetting;
                if (!GSRemoteSettingManager.this.shadowSettingChanging && (currentSetting = GSRemoteSettingManager.this.getSetting(category, setting.getName())) != null) {
                    currentSetting.setIfSameType(setting);
                }
            }
        });
    }

    @Override
    public void registerSetting(GSSettingCategory category, GSSetting<?> setting) {
        this.shadowSettings.registerSetting(category, setting);
    }

    @Override
    public void registerSettings(GSSettingCategory category, GSSetting<?> ... settingArgs) {
        this.shadowSettings.registerSettings(category, settingArgs);
    }

    @Override
    public void removeSetting(GSSettingCategory category, String name) {
        this.shadowSettings.removeSetting(category, name);
    }

    public GSSetting<?> getShadowSetting(GSSettingCategory category, String name) {
        return this.shadowSettings.getSetting(category, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateShadowValue(GSSettingCategory category, GSSetting<?> setting) {
        GSSetting<?> shadowSetting = this.getShadowSetting(category, setting.getName());
        if (shadowSetting != null) {
            this.shadowSettingChanging = true;
            try {
                shadowSetting.setIfSameType(setting);
                shadowSetting.setEnabledInGui(setting.isEnabledInGui());
                shadowSetting.setAllowedChange(setting.isAllowedChange());
            }
            finally {
                this.shadowSettingChanging = false;
            }
        }
    }

    public void resetRemoteSettings() {
        for (GSSettingMap settingMap : this.settings.values()) {
            settingMap.resetSettings();
        }
    }

    @Override
    void settingChanged(GSSettingCategory category, GSSetting<?> setting) {
        super.settingChanged(category, setting);
        this.updateShadowValue(category, setting);
        if (!this.remoteSettingChanging && this.allowedSettingChange) {
            this.controllerClient.sendPacket(new GSSettingChangePacket(category, setting, GSSettingChangePacket.GSESettingChangeType.SETTING_CHANGED));
        }
    }

    @Override
    void settingAdded(GSSettingCategory category, GSSetting<?> setting) {
        super.settingAdded(category, setting);
        this.updateShadowValue(category, setting);
    }

    @Override
    void settingRemoved(GSSettingCategory category, GSSetting<?> setting) {
        super.settingRemoved(category, setting);
        GSSetting<?> shadowSetting = this.getShadowSetting(category, setting.getName());
        if (shadowSetting != null) {
            shadowSetting.reset();
        }
    }

    public void onRemoteSettingMapReceived(GSSettingMap settingMap) {
        GSSettingCategory category = settingMap.getCategory();
        for (GSSetting<?> setting : settingMap.getSettings()) {
            this.onRemoteSettingAdded(category, setting);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRemoteSettingChanged(GSSettingCategory category, GSSetting<?> setting) {
        GSSetting<?> currentSetting = this.getSetting(category, setting.getName());
        if (currentSetting != null) {
            this.remoteSettingChanging = true;
            try {
                currentSetting.setIfSameType(setting);
                currentSetting.setEnabledInGui(setting.isEnabledInGui());
            }
            finally {
                this.remoteSettingChanging = false;
            }
        }
    }

    public void onRemoteSettingAdded(GSSettingCategory category, GSSetting<?> setting) {
        GSSetting<?> copiedSetting = setting.copySetting();
        copiedSetting.setEnabledInGui(setting.isEnabledInGui());
        copiedSetting.setAllowedChange(this.allowedSettingChange);
        super.registerSetting(category, copiedSetting);
    }

    public void onRemoteSettingRemoved(GSSettingCategory category, GSSetting<?> setting) {
        super.removeSetting(category, setting.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllowedSettingChange(boolean allowedSettingChange) {
        if (allowedSettingChange != this.allowedSettingChange) {
            this.allowedSettingChange = allowedSettingChange;
            this.remoteSettingChanging = true;
            try {
                for (GSSettingMap settingMap : this.settings.values()) {
                    for (GSSetting<?> setting : settingMap.getSettings()) {
                        setting.setAllowedChange(allowedSettingChange);
                    }
                }
            }
            finally {
                this.remoteSettingChanging = false;
            }
        }
    }

    public boolean isAllowedSettingChange() {
        return this.allowedSettingChange;
    }
}

