/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.packet;

import com.g4mesoft.GSExtensionUID;
import com.g4mesoft.packet.GSIPacket;
import com.g4mesoft.registry.GSSupplierRegistry;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;

public class GSPacketRegistryList {
    private final Map<GSExtensionUID, GSSupplierRegistry<Integer, GSIPacket>> uidToRegistry = new HashMap<GSExtensionUID, GSSupplierRegistry<Integer, GSIPacket>>();
    private final Map<Class<? extends GSIPacket>, GSExtensionUID> uidCache = new IdentityHashMap<Class<? extends GSIPacket>, GSExtensionUID>();
    private final Map<Class<? extends GSIPacket>, Long> idCache = new IdentityHashMap<Class<? extends GSIPacket>, Long>();

    public GSExtensionUID getPacketExtensionUID(Class<? extends GSIPacket> packetClazz) {
        return this.uidCache.computeIfAbsent(packetClazz, k -> {
            for (Map.Entry<GSExtensionUID, GSSupplierRegistry<Integer, GSIPacket>> entry : this.uidToRegistry.entrySet()) {
                GSSupplierRegistry<Integer, GSIPacket> registry = entry.getValue();
                if (!registry.containsElement(packetClazz)) continue;
                return entry.getKey();
            }
            return null;
        });
    }

    public long getPacketId(Class<? extends GSIPacket> packetClazz) {
        Long packetId = this.idCache.computeIfAbsent(packetClazz, k -> {
            GSExtensionUID extensionUid = this.getPacketExtensionUID((Class<? extends GSIPacket>)k);
            if (extensionUid != null) {
                GSSupplierRegistry<Integer, GSIPacket> registry = this.uidToRegistry.get(extensionUid);
                int uid = extensionUid.getValue();
                int id = registry.getIdentifier(k);
                return (long)uid << 32 | (long)id;
            }
            return null;
        });
        return packetId == null ? -1L : packetId;
    }

    public GSIPacket createNewPacket(long packetId) {
        GSExtensionUID extensionUid = new GSExtensionUID((int)(packetId >> 32));
        GSSupplierRegistry<Integer, GSIPacket> registry = this.uidToRegistry.get(extensionUid);
        return registry != null ? registry.createNewElement((int)packetId) : null;
    }

    public void addPacketRegistry(GSExtensionUID uid, GSSupplierRegistry<Integer, GSIPacket> registry) {
        if (this.uidToRegistry.containsKey(uid)) {
            throw new IllegalStateException("The UID is already registered!");
        }
        if (registry == null) {
            throw new NullPointerException("registry is null!");
        }
        this.uidToRegistry.put(uid, registry);
    }
}

