/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.packet;

import com.g4mesoft.G4mespeedMod;
import com.g4mesoft.GSExtensionInfo;
import com.g4mesoft.GSExtensionInfoList;
import com.g4mesoft.GSExtensionUID;
import com.g4mesoft.GSIExtension;
import com.g4mesoft.core.GSController;
import com.g4mesoft.packet.GSCustomPayload;
import com.g4mesoft.packet.GSIPacket;
import com.g4mesoft.packet.GSPacketRegistryList;
import com.g4mesoft.registry.GSSupplierRegistry;
import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.function.Consumer;
import net.minecraft.class_1255;
import net.minecraft.class_148;
import net.minecraft.class_2547;
import net.minecraft.class_2596;
import net.minecraft.class_8710;

public class GSPacketManager {
    private final GSPacketRegistryList registryList = new GSPacketRegistryList();
    private boolean initialized = false;

    public void init() {
        if (this.initialized) {
            throw new IllegalStateException("Already initialized");
        }
        G4mespeedMod.getExtensions().forEach(this::registerPackets);
        G4mespeedMod.addExtensionListener(this::registerPackets);
        this.initialized = true;
    }

    public GSExtensionUID getPacketExtensionUniqueId(GSIPacket packet) {
        return this.registryList.getPacketExtensionUID(packet.getClass());
    }

    public class_2596<?> encodePacket(GSIPacket packet, GSController controller) {
        long packetId = this.registryList.getPacketId(packet.getClass());
        if (packetId == -1L) {
            return null;
        }
        ByteBuf buf = Unpooled.buffer();
        buf.writeLong(packetId);
        try {
            packet.write(GSEncodeBuffer.wrap(buf));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return controller.createCustomPayload(buf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends class_2547> GSIPacket decodePacket(class_8710 payload, GSExtensionInfoList extensionInfoList) {
        if (!(payload instanceof GSCustomPayload)) {
            return null;
        }
        ByteBuf buffer = ((GSCustomPayload)payload).getBuffer();
        GSIPacket packet = this.registryList.createNewPacket(buffer.readLong());
        if (packet == null) {
            buffer.release();
            return null;
        }
        GSExtensionUID extensionUid = this.getPacketExtensionUniqueId(packet);
        GSExtensionInfo extensionInfo = extensionInfoList.getInfo(extensionUid);
        try {
            packet.read(GSDecodeBuffer.wrap(buffer), extensionInfo);
        }
        catch (IOException e) {
            GSIPacket gSIPacket = null;
            return gSIPacket;
        }
        finally {
            buffer.release();
        }
        return packet;
    }

    public <T extends class_2547> void handlePacket(GSIPacket packet, T packetListener, class_1255<?> executor, Consumer<GSIPacket> handler) {
        if (packet.shouldForceMainThread() && !executor.method_18854()) {
            executor.method_40000(() -> {
                if (packetListener.method_48106()) {
                    try {
                        handler.accept(packet);
                    }
                    catch (Exception e) {
                        if (e instanceof class_148 && ((class_148)e).getCause() instanceof OutOfMemoryError) {
                            throw e;
                        }
                        G4mespeedMod.GS_LOGGER.error("Failed to handle packet {}, suppressing error", (Object)packet, (Object)e);
                    }
                } else {
                    G4mespeedMod.GS_LOGGER.debug("Ignoring packet due to disconnection: {}", (Object)packet);
                }
            });
        } else {
            handler.accept(packet);
        }
    }

    private void registerPackets(GSIExtension extension) {
        GSSupplierRegistry<Integer, GSIPacket> registry = new GSSupplierRegistry<Integer, GSIPacket>();
        extension.registerPackets(registry);
        this.registryList.addPacketRegistry(extension.getInfo().getUniqueId(), registry);
    }
}

